/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;

public class ComponentPlacementDialog {
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private transient Component m_comp = null;
    private transient AffineTransform m_trf = new AffineTransform();
    private transient Object m_input = null;

    public ComponentPlacementDialog(Component comp) {
        this.m_comp = comp;
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws CmdAbortedException {
        krnl = Kernel.getInstance();
        ui = krnl.getUserInterface();
        dragPos = new Point2D.Double(0.0, 0.0);
        dragTrf = new AffineTransform();
        mml = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this._transform(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void _transform(MouseEvent e) {
                AffineTransform affineTransform = ComponentPlacementDialog.this.m_trf;
                synchronized (affineTransform) {
                    Object src = e.getSource();
                    if (src instanceof DrawPanel) {
                        DrawPanel dp = (DrawPanel)src;
                        try {
                            dragTrf.invert();
                        }
                        catch (NoninvertibleTransformException x) {
                            throw new InternalError();
                        }
                        ComponentPlacementDialog.this.m_comp.transformBy(dragTrf);
                        dragPos.setLocation(dp.ungriddedModelPoint(e.getX(), e.getY()));
                        dragTrf.setToTranslation(dragPos.getX(), dragPos.getY());
                        dragTrf.concatenate(ComponentPlacementDialog.this.m_trf);
                        ComponentPlacementDialog.this.m_comp.transformBy(dragTrf);
                        ui.updateUserInterface();
                    }
                }
            }
        };
        pit = ui.geometryPanelIterator();
        while (pit.hasNext()) {
            gp = pit.next();
            if (!(gp instanceof DrawPanel)) continue;
            ((DrawPanel)gp).addMouseMotionListener(mml);
        }
        try {
            this._placementDialog();
            plp = new Point2D.Double();
            conPoint = new ConPoint2D(krnl);
            conPoint.setPrompt(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.17"));
            conPoint.setFilter(new ConObject.Filter(){

                @Override
                public boolean accept(Component comp, int chain, int name) {
                    return ComponentPlacementDialog.this.m_comp != comp;
                }
            });
            conPoint.addListener(new ConPoint2D.Listener(){

                @Override
                public void pointConstructed(Point2D p) {
                    plp.setLocation(p);
                    conPoint.dispose();
                }

                @Override
                public void dialogAborted() {
                    plp.setLocation(Double.NaN, 0.0);
                    conPoint.dispose();
                }
            });
            conPoint.show();
            if (Double.isNaN(plp.getX())) {
                throw new CmdAbortedException();
            }
            trf = AffineTransform.getTranslateInstance(-dragPos.getX(), -dragPos.getY());
            trf.translate(plp.getX(), plp.getY());
            this.m_comp.transformBy(trf);
        }
        finally {
            pit = ui.geometryPanelIterator();
            ** while (pit.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            gp = pit.next();
            if (!(gp instanceof DrawPanel)) continue;
            ((DrawPanel)gp).removeMouseMotionListener(mml);
            continue;
        }
lbl37:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _placementDialog() throws CmdAbortedException {
        final Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        double angle = 0.0;
        boolean flipx = false;
        boolean flipy = false;
        double scale = 1.0;
        block10: while (true) {
            AffineTransform affineTransform = this.m_trf;
            synchronized (affineTransform) {
                this.m_trf.setToIdentity();
                this.m_trf.rotate(angle);
                if (flipx) {
                    this.m_trf.concatenate(FLIP_X);
                }
                if (flipy) {
                    this.m_trf.concatenate(FLIP_X);
                    this.m_trf.rotate(Math.PI);
                }
                this.m_trf.scale(scale, scale);
            }
            final CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.util.ComponentPlacementDialog-menu0");
            final ConPoint2D conPoint = new ConPoint2D(krnl);
            dlg.setPrompt(String.valueOf(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.21")) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.util.ComponentPlacementDialog.22") : ""));
            dlg.enableTextInput(true);
            dlg.enableDigitize(-1);
            dlg.addChoice("Angle");
            dlg.setChoiceChecked(0, angle < -Geo2D.getEps() || angle > Geo2D.getEps());
            dlg.addChoice("Mirror x");
            dlg.setChoiceChecked(1, flipx);
            dlg.addChoice("Mirror y");
            dlg.setChoiceChecked(2, flipy);
            dlg.addChoice("Scale");
            dlg.setChoiceChecked(3, scale < 1.0 - Geo2D.getEps() || scale > 1.0 + Geo2D.getEps());
            dlg.addSeparator();
            dlg.addChoice("Placement");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    ComponentPlacementDialog.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ComponentPlacementDialog.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ComponentPlacementDialog.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    ComponentPlacementDialog.this.m_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    conPoint.showRelativeCoordinatesAid(false);
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    conPoint.showRelativeCoordinatesAid(true);
                }
            });
            dlg.addListener(new CmdLineDialog.ContextMenuListener(){

                @Override
                public void extendContextMenu(JPopupMenu m) {
                    m.addSeparator();
                    JRadioButtonMenuItem angleRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.29"));
                    JRadioButtonMenuItem mirrorXRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.30"));
                    JRadioButtonMenuItem mirrorYRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.31"));
                    JRadioButtonMenuItem scaleRB = new JRadioButtonMenuItem(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.32"));
                    m.add(angleRB);
                    m.add(mirrorXRB);
                    m.add(mirrorYRB);
                    m.add(scaleRB);
                    angleRB.setSelected(dlg.isChoiceChecked(0));
                    mirrorXRB.setSelected(dlg.isChoiceChecked(1));
                    mirrorYRB.setSelected(dlg.isChoiceChecked(2));
                    scaleRB.setSelected(dlg.isChoiceChecked(3));
                    angleRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Angle"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    mirrorXRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Mirror x"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    mirrorYRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Mirror y"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    scaleRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Scale"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    m.addSeparator();
                    JMenuItem placementItem = new JMenuItem(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.37"));
                    placementItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Placement"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    m.add(placementItem);
                }
            });
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            ui.showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        angle = krnl.getConstruction().angle2D(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.39"), 0.0, new ConObject.Filter(){

                            @Override
                            public boolean accept(Component comp, int chain, int name) {
                                return ComponentPlacementDialog.this.m_comp != comp;
                            }
                        });
                        continue block10;
                    }
                    case 1: {
                        flipx = !flipx;
                        continue block10;
                    }
                    case 2: {
                        flipy = !flipy;
                        continue block10;
                    }
                    case 3: {
                        scale = krnl.readDouble(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.40"), 1.0);
                        continue block10;
                    }
                    case 4: {
                        return;
                    }
                }
                System.err.println(Messages.getString("kernel.cmds.util.ComponentPlacementDialog.41"));
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (this.m_input instanceof DigitizeToken) {
                krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                return;
            }
            if (this.m_input instanceof TextToken) break;
        }
        krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
    }
}

