/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.MouseInputAdapter;

public class WinMoveByMouseDrag
implements Cmd {
    private Vector2D m_vec = null;
    private GeometryPanel m_panel = null;
    private Rectangle2D m_vp = null;
    private Point m_startLoc = null;
    private Point m_endLoc = null;
    private static final int WAIT = 300;
    private long m_timer = 0L;
    private String m_toString = null;
    private static boolean s_entered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        try {
            Kernel krnl = (Kernel)context;
            WinMoveByMouseDrag winMoveByMouseDrag = this;
            synchronized (winMoveByMouseDrag) {
                if (s_entered) {
                    if (!krnl.hasArgument()) return;
                    krnl.consumeArgument();
                    return;
                }
                s_entered = true;
            }
            DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("kernel.cmds.WinMoveByMouseDrag.0"));
            this.m_panel = dig.getGeometryPanel();
            this.m_vp = this.m_panel.getProjection().getViewPort();
            this.m_vec = new Vector2D(dig.getPoint(), dig.getPoint());
            if (!(this.m_panel instanceof DrawPanel)) return;
            DrawPanel dp = (DrawPanel)this.m_panel;
            this.m_startLoc = dig.getPoint();
            boolean microscopeEnabled = dp.microscopeEnabled();
            if (microscopeEnabled) {
                dp.enableMicroscope(false);
            }
            MouseInputAdapter mml = new MouseInputAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    WinMoveByMouseDrag.this.m_timer = System.currentTimeMillis();
                    WinMoveByMouseDrag.this.m_endLoc = e.getPoint();
                    WinMoveByMouseDrag.this.m_vec = new Vector2D(WinMoveByMouseDrag.this.m_startLoc, WinMoveByMouseDrag.this.m_endLoc);
                    WinMoveByMouseDrag.this.move(WinMoveByMouseDrag.this.m_vec);
                }
            };
            dp.addMouseMotionListener(mml);
            dp.setCursor(Cursor.getPredefinedCursor(13));
            this.m_timer = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(60L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - this.m_timer <= 300L);
            dp.removeMouseMotionListener(mml);
            if (this.m_endLoc != null) {
                Projection2D prj = this.m_panel.getProjection();
                AffineTransform v2m = prj.getViewToModel();
                Point2D.Double oldM = new Point2D.Double();
                Point2D.Double newM = new Point2D.Double();
                v2m.transform(this.m_startLoc, oldM);
                v2m.transform(this.m_endLoc, newM);
                double dx = ((Point2D)newM).getX() - ((Point2D)oldM).getX();
                double dy = ((Point2D)newM).getY() - ((Point2D)oldM).getY();
                double minU = prj.getMinU();
                double minV = prj.getMinV();
                double maxU = prj.getMaxU();
                double maxV = prj.getMaxV();
                if (!prj.setViewPort(minU - dx, minV - dy, maxU - minU, maxV - minV)) {
                    this.m_toString = Messages.getString("kernel.cmds.WinMoveByMouseDrag.1");
                } else {
                    this.m_panel.setProjection(prj);
                    this.m_toString = Messages.getString("kernel.cmds.WinMoveByMouseDrag.2");
                }
                System.out.println(this);
            }
            if (microscopeEnabled) {
                dp.enableMicroscope(true);
            }
            dp.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        finally {
            s_entered = false;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Projection2D proj = this.m_panel.getProjection();
        Rectangle2D _vp = (Rectangle2D)proj.getViewPort().clone();
        proj.setViewPort(this.m_vp);
        this.m_panel.setProjection(proj);
        this.m_vp = _vp;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean changesState() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void move(Vector2D vec) {
        DrawPanel drawPanel = (DrawPanel)this.m_panel;
        AffineTransform trf = AffineTransform.getTranslateInstance(vec.x, vec.y);
        drawPanel.transformPanelImmediately(trf);
    }
}

