/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.view.Projection2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SetViewport
implements Cmd {
    private Map<DrawPanel, Projection2D> m_drawPanelProjections = new HashMap<DrawPanel, Projection2D>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        Point2D p1 = krnl.readPoint(Messages.getString("kernel.cmds.SetViewport.0"));
        Point2D p2 = krnl.readPoint(Messages.getString("kernel.cmds.SetViewport.1"));
        Rectangle2D.Double viewPort = new Rectangle2D.Double();
        viewPort.setFrameFromDiagonal(p1, p2);
        int winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.SetViewport.2"));
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)it.next();
            if ((drawPanel.getId() & winMask) == 0) continue;
            this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
            this.zoom(drawPanel, viewPort);
        }
        this.m_toString = Messages.getString("kernel.cmds.SetViewport.3");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Set<DrawPanel> set = this.m_drawPanelProjections.keySet();
        for (DrawPanel drawPanel : set) {
            Projection2D projection = this.m_drawPanelProjections.get(drawPanel);
            this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
            drawPanel.setProjection(projection);
            drawPanel.repaint();
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_drawPanelProjections.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void zoom(DrawPanel drawPanel, Rectangle2D viewPort) {
        Projection2D projection = drawPanel.getProjection();
        projection.setViewPort(viewPort);
        drawPanel.setProjection(projection);
        drawPanel.repaint();
    }
}

