/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class SetUserCoordinateSystem
implements Cmd {
    protected AffineTransform m_svUserCrdTransform = null;
    private String m_toString = null;
    private transient Object t_input = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        this.m_svUserCrdTransform = cs.getUserCrdTransform();
        while (true) {
            double offx = 0.0;
            double offy = 0.0;
            double angle = 0.0;
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.SetUserCoordinateSystem-menu0");
            dlg.setPrompt(String.valueOf(Messages.getString("kernel.cmds.SetUserCoordinateSystem.1")) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.cmds.SetUserCoordinateSystem.1a") : ""));
            dlg.setDefaultChoice(dlg.addChoice("Reset"));
            dlg.addSeparator();
            dlg.setChoiceChecked(dlg.addChoice("Origin"));
            dlg.addChoice("Angle");
            dlg.addSeparator();
            dlg.addChoice("Done");
            dlg.enableTextInput(true);
            dlg.enableDigitize(-1);
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void textEntered(String text) {
                    SetUserCoordinateSystem.this.t_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void choiceSelected(int iChoice) {
                    SetUserCoordinateSystem.this.t_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    SetUserCoordinateSystem.this.t_input = new DigitizeToken(x, y, gp.getId());
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    SetUserCoordinateSystem.this.t_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }
            });
            ConPoint2D conPoint = new ConPoint2D(krnl);
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            ui.showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            try {
                block13: {
                    block14: {
                        block12: {
                            if (!(this.t_input instanceof TextToken)) break block12;
                            krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Origin"), (TextToken)this.t_input});
                            break block13;
                        }
                        if (!(this.t_input instanceof Integer)) break block14;
                        int iChoice = (Integer)this.t_input;
                        switch (iChoice) {
                            case 0: {
                                cs.setUserCrdTransform(new AffineTransform());
                                this.m_toString = Messages.getString("kernel.cmds.SetUserCoordinateSystem.1b");
                                System.out.println(this);
                                ui.repaintUserInterface();
                                return;
                            }
                            case 1: {
                                Point2D.Double origin = new Point2D.Double();
                                krnl.getConstruction().point2D(Messages.getString("kernel.cmds.SetUserCoordinateSystem.1c"), origin, origin);
                                offx = ((Point2D)origin).getX();
                                offy = ((Point2D)origin).getY();
                                break block13;
                            }
                            case 2: {
                                angle = krnl.getConstruction().angle2D(Messages.getString("kernel.cmds.SetUserCoordinateSystem.1d"), 0.0);
                                break block13;
                            }
                            case 3: {
                                System.out.println(this);
                                return;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    if (this.t_input instanceof DigitizeToken) {
                        krnl.pushBackArguments(new CmdLineToken[]{new MenuItemToken("Origin"), (DigitizeToken)this.t_input});
                    } else if (this.t_input instanceof CmdAbortedException) {
                        throw (CmdAbortedException)this.t_input;
                    }
                }
                AffineTransform trf = cs.getUserCrdTransform();
                double currentAngle = this._currentAngle(trf);
                angle += currentAngle;
                Point2D.Double origin = new Point2D.Double(offx, offy);
                AffineTransform u2w = cs.getUserToWorldTransform();
                u2w.transform(origin, origin);
                cs.setUserCrdTransform(new AffineTransform());
                AffineTransform w2u = cs.getWorldToUserTransform();
                w2u.transform(origin, origin);
                offx = ((Point2D)origin).getX();
                offy = ((Point2D)origin).getY();
                AffineTransform at = AffineTransform.getRotateInstance(angle);
                at.preConcatenate(AffineTransform.getTranslateInstance(offx, offy));
                cs.setUserCrdTransform(at);
                this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SetUserCoordinateSystem.2")) + Geo2D.formatCoordinate(offx) + Messages.getString("kernel.cmds.SetUserCoordinateSystem.3") + Geo2D.formatCoordinate(offx) + Messages.getString("kernel.cmds.SetUserCoordinateSystem.4") + Geo2D.formatDegrees(Math.toDegrees(angle)) + Messages.getString("kernel.cmds.SetUserCoordinateSystem.5");
                ui.repaintUserInterface();
            }
            catch (CmdAbortedException e) {
                cs.setUserCrdTransform(this.m_svUserCrdTransform);
                this.m_svUserCrdTransform = null;
                ui.repaintUserInterface();
                throw e;
            }
        }
    }

    private double _currentAngle(AffineTransform trf) {
        Point2D.Double o = new Point2D.Double();
        Point2D.Double x = new Point2D.Double(1.0, 0.0);
        Point2D ot = trf.transform(o, null);
        Point2D xt = trf.transform(x, null);
        return Math.atan2(xt.getY() - ot.getY(), xt.getX() - ot.getX());
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        AffineTransform svTrf = this.m_svUserCrdTransform;
        this.m_svUserCrdTransform = cs.getUserCrdTransform();
        cs.setUserCrdTransform(svTrf);
        UserInterface ui = krnl.getUserInterface();
        ui.repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_svUserCrdTransform != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

