/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.Grid;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SetGridParam
implements Cmd {
    private Map<GeometryPanel, Grid> m_grid = new HashMap<GeometryPanel, Grid>();
    private Map<GeometryPanel, Integer> m_flags = new HashMap<GeometryPanel, Integer>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        int winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.SetGridParam.0"));
        Point2D.Double origin = new Point2D.Double();
        krnl.getConstruction().point2D(Messages.getString("kernel.cmds.SetGridParam.1"), origin);
        double dx = krnl.getConstruction().distance2D(Messages.getString("kernel.cmds.SetGridParam.2"), 1.0);
        double dy = krnl.getConstruction().distance2D(Messages.getString("kernel.cmds.SetGridParam.3"), 1.0);
        Grid grid = new Grid(dx, dy);
        grid.setOrigin(origin);
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel geometryPanel = it.next();
            if ((geometryPanel.getId() & winMask) == 0) continue;
            this.m_grid.put(geometryPanel, geometryPanel.getGrid());
            this.m_flags.put(geometryPanel, geometryPanel.getFlags());
            geometryPanel.setGrid(grid, true);
        }
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SetGridParam.4")) + Geo2D.formatCoordinate(((Point2D)origin).getX()) + Messages.getString("kernel.cmds.SetGridParam.5") + Geo2D.formatCoordinate(((Point2D)origin).getY()) + Messages.getString("kernel.cmds.SetGridParam.6") + Geo2D.formatCoordinate(dx) + Messages.getString("kernel.cmds.SetGridParam.7") + Geo2D.formatCoordinate(dy) + Messages.getString("kernel.cmds.SetGridParam.8");
        System.out.println(this);
        ui.repaintUserInterface();
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        Set<GeometryPanel> gps = this.m_grid.keySet();
        for (GeometryPanel geometryPanel : gps) {
            Grid grid = this.m_grid.get(geometryPanel);
            int flags = this.m_flags.get(geometryPanel);
            this.m_grid.put(geometryPanel, geometryPanel.getGrid());
            this.m_flags.put(geometryPanel, geometryPanel.getFlags());
            geometryPanel.setGrid(grid, (flags & 0x200) != 0);
        }
        ui.repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_grid.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

