/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.feature.Feature;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.ObservableSet;
import java.util.Iterator;

public class SetDimMaster
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        ComponentDimSingle dimMaster = null;
        if (selSet.size() != 1) {
            System.err.println(Messages.getString("kernel.cmds.SetDimMaster.0"));
            return;
        }
        for (Component comp : selSet) {
            if (!(comp instanceof ComponentDimSingle)) {
                System.err.println(Messages.getString("kernel.cmds.SetDimMaster.0"));
                return;
            }
            dimMaster = (ComponentDimSingle)comp;
        }
        Iterator<Feature> fit = dimMaster.featureIterator();
        while (fit.hasNext()) {
            Feature f = fit.next();
            String name = f.getName();
            if (!name.startsWith("DIM.") && !name.startsWith("DIM_TEXT.")) continue;
            krnl.setProperty("FEATURE_VALUE." + name, f.valueToString());
        }
        krnl.readOK(Messages.getString("kernel.cmds.SetDimMaster.5"), "CADEMIA", Messages.getString("kernel.cmds.SetDimMaster.7"), 2);
    }
}

