/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class SetConSettings
implements Cmd {
    private boolean m_isRelMode;
    private boolean m_isOrthoMode;
    private transient Object m_input = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        boolean isRelMode = ConPoint2D.getRelCoordFlag();
        boolean isOrthoMode = ConLineSeg2D.isOrthogonalMode();
        this.m_isRelMode = isRelMode;
        this.m_isOrthoMode = isOrthoMode;
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("kernel.cmds.SetConSettings-menu0");
        dlg.setPrompt(Messages.getString("kernel.cmds.SetConSettings.1"));
        dlg.enableTextInput(false);
        int i = dlg.addChoice("Absolute");
        dlg.setChoiceHints(i, Messages.getString("kernel.cmds.SetConSettings.3"));
        dlg.setChoiceChecked(i, !this.m_isRelMode);
        i = dlg.addChoice("Relative");
        dlg.setChoiceHints(i, Messages.getString("kernel.cmds.SetConSettings.5"));
        dlg.setChoiceChecked(i, this.m_isRelMode);
        dlg.addSeparator();
        i = dlg.addChoice("Angular");
        dlg.setChoiceHints(i, Messages.getString("kernel.cmds.SetConSettings.15"));
        dlg.setChoiceChecked(i, !this.m_isOrthoMode);
        i = dlg.addChoice("Orthogonal");
        dlg.setChoiceHints(i, Messages.getString("kernel.cmds.SetConSettings.17"));
        dlg.setChoiceChecked(i, this.m_isOrthoMode);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                switch (iChoice) {
                    case 0: {
                        SetConSettings.this.m_isRelMode = false;
                        break;
                    }
                    case 1: {
                        SetConSettings.this.m_isRelMode = true;
                        break;
                    }
                    case 2: {
                        SetConSettings.this.m_isOrthoMode = false;
                        break;
                    }
                    case 3: {
                        SetConSettings.this.m_isOrthoMode = true;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)Messages.getString("kernel.cmds.SetConSettings.18"));
                    }
                }
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                SetConSettings.this.m_input = new CmdAbortedException();
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.m_input instanceof CmdAbortedException) {
            throw (CmdAbortedException)this.m_input;
        }
        ConPoint2D.setRelCoordFlag(this.m_isRelMode);
        ConLineSeg2D.setOrthogonalMode(this.m_isOrthoMode);
        this.m_isRelMode = isRelMode;
        this.m_isOrthoMode = isOrthoMode;
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        boolean isRelMode = ConPoint2D.getRelCoordFlag();
        boolean isOrthoMode = ConLineSeg2D.isOrthogonalMode();
        ConPoint2D.setRelCoordFlag(this.m_isRelMode);
        ConLineSeg2D.setOrthogonalMode(this.m_isOrthoMode);
        this.m_isRelMode = isRelMode;
        this.m_isOrthoMode = isOrthoMode;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_isRelMode != ConPoint2D.getRelCoordFlag() || this.m_isOrthoMode != ConLineSeg2D.isOrthogonalMode();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("kernel.cmds.SetConSettings.19");
    }
}

