/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RemoveControlPoints
extends UndoableCmd {
    private int m_nRemovedControlPoints = 0;
    private int m_nComponentsWithRemovedControlPoints = 0;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        boolean unsupportedOperation = false;
        for (Component comp : selSet) {
            if (!mm.hasMarkedPrimitives(comp, 2)) continue;
            this._saveState(comp);
            HashSet<Integer> pointNames = new HashSet<Integer>();
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                int name = lit.previousName();
                if (!mm.primitiveMarked(comp, 2, index)) continue;
                pointNames.add(name);
                mm.markPrimitive(comp, 2, index, false);
            }
            HashSet<Integer> children = new HashSet<Integer>();
            Iterator pit = pointNames.iterator();
            while (pit.hasNext()) {
                int parent = (Integer)pit.next();
                this._collectChildren(comp, parent, children);
            }
            pointNames.removeAll(children);
            int nRemovedControlPoints = this.m_nRemovedControlPoints;
            pit = pointNames.iterator();
            comp.removeControlPointStarts();
            while (pit.hasNext()) {
                int pointName = (Integer)pit.next();
                try {
                    comp.removeControlPoint(pointName);
                    ++this.m_nRemovedControlPoints;
                }
                catch (UnsupportedOperationException e) {
                    unsupportedOperation = true;
                }
            }
            comp.removeControlPointEnds();
            if (nRemovedControlPoints == this.m_nRemovedControlPoints) continue;
            ++this.m_nComponentsWithRemovedControlPoints;
        }
        if (unsupportedOperation) {
            try {
                krnl.readOK(Messages.getString("kernel.cmds.RemoveControlPoints.0"), 2);
            }
            catch (CmdAbortedException e) {
                this.undoCmd(context);
                throw e;
            }
        }
    }

    public int getNumberOfRemovedControlPoints() {
        return this.m_nRemovedControlPoints;
    }

    public int getNumberOfComponentsWithRemovedControlPoints() {
        return this.m_nComponentsWithRemovedControlPoints;
    }

    private void _collectChildren(Component comp, int parent, Set<Integer> set) {
        int n = comp.getControlPointChildrenCount(parent);
        int i = 0;
        while (i < n) {
            int child = comp.getControlPointChild(parent, i);
            set.add(child);
            this._collectChildren(comp, child, set);
            ++i;
        }
    }
}

