/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.util.RectangleRubberBand;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPrinter;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.SwappableList;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterResolution;

public class PrintDefault
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Projection2D printProjection;
        Point2D p2;
        Point2D p1;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        if (cmpList.isEmpty()) {
            System.out.println(Messages.getString("kernel.cmds.PrintDefault.0"));
            return;
        }
        RectangleRubberBand rb = null;
        try {
            p1 = krnl.readPoint(Messages.getString("kernel.cmds.PrintDefault.1"));
            rb = new RectangleRubberBand(krnl, p1);
            p2 = krnl.readPoint(Messages.getString("kernel.cmds.PrintDefault.2"));
        }
        finally {
            if (rb != null) {
                rb.close();
            }
            rb = null;
        }
        double defmx = 0.0;
        double defmy = 0.0;
        try {
            String _x = krnl.getProperty("Print.OffsetX");
            String _y = krnl.getProperty("Print.OffsetY");
            if (_x != null) {
                defmx = Double.parseDouble(_x);
            }
            if (_y != null) {
                defmy = Double.parseDouble(_y);
            }
        }
        catch (NumberFormatException e) {
            defmx = 0.0;
            defmy = 0.0;
        }
        double mx = krnl.readDouble(Messages.getString("kernel.cmds.PrintDefault.5"), defmx);
        double my = krnl.readDouble(Messages.getString("kernel.cmds.PrintDefault.6"), defmy);
        krnl.setProperty("Print.OffsetX", String.valueOf(mx));
        krnl.setProperty("Print.OffsetY", String.valueOf(my));
        Rectangle2D.Double printRect = new Rectangle2D.Double();
        p1.setLocation(p1.getX() - (mx *= 0.001 * CoordSpace.getCoordSpace().getScale()), p1.getY() - (my *= -0.001 * CoordSpace.getCoordSpace().getScale()));
        printRect.setFrameFromDiagonal(p1, p2);
        try {
            printProjection = new Projection2D(printRect, 100.0, 100.0);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println(e);
            return;
        }
        System.out.println(Messages.getString("kernel.cmds.PrintDefault.9"));
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        PrintService printService = printerJob.getPrintService();
        String printerName = Messages.getString("kernel.cmds.PrintDefault.10");
        int crossfeed = 600;
        int feed = 600;
        if (printService != null) {
            printerName = printService.getName();
            Object obj = printService.getDefaultAttributeValue(PrinterResolution.class);
            if (obj instanceof PrinterResolution) {
                PrinterResolution prres = (PrinterResolution)obj;
                int[] ires = prres.getResolution(100);
                crossfeed = ires[0];
                feed = ires[1];
            }
        }
        krnl.readOK(Messages.getString("kernel.cmds.PrintDefault.11"), Messages.getString("kernel.cmds.PrintDefault.12"), String.valueOf(Messages.getString("kernel.cmds.PrintDefault.13")) + printerName + Messages.getString("kernel.cmds.PrintDefault.14"), 18);
        double scale = db.getCoordSpace().getScale();
        DrawPrinter printable = new DrawPrinter(printProjection, scale, crossfeed, feed);
        printerJob.setPrintable(printable, pageFormat);
        AttributeManager atm = AttributeManager.getAttributeManager();
        for (Component c : cmpList) {
            if (!atm.getVisibility(c.getAttributes().getVisibility())) continue;
            NamedListIterator<AttributedShape> chainIt = c.shapeIterator();
            while (chainIt.hasNext()) {
                printable.addShape((AttributedShape)chainIt.next());
            }
            NamedListIterator<AttributedText> textIt = c.textIterator();
            while (textIt.hasNext()) {
                printable.addText((AttributedText)textIt.next());
            }
            NamedListIterator<AttributedImage> imageIt = c.imageIterator();
            while (imageIt.hasNext()) {
                printable.addImage((AttributedImage)imageIt.next());
            }
        }
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.PrintDefault.15")) + Geo2D.formatCoordinate(((RectangularShape)printRect).getX()) + Messages.getString("kernel.cmds.PrintDefault.16") + Geo2D.formatCoordinate(((RectangularShape)printRect).getY()) + Messages.getString("kernel.cmds.PrintDefault.17") + Geo2D.formatCoordinate(((RectangularShape)printRect).getWidth()) + Messages.getString("kernel.cmds.PrintDefault.18") + Geo2D.formatCoordinate(((RectangularShape)printRect).getHeight()) + Messages.getString("kernel.cmds.PrintDefault.19") + printerName + Messages.getString("kernel.cmds.PrintDefault.20") + feed + Messages.getString("kernel.cmds.PrintDefault.21") + crossfeed + Messages.getString("kernel.cmds.PrintDefault.22") + scale + Messages.getString("kernel.cmds.PrintDefault.23"));
        try {
            printerJob.print();
        }
        catch (PrinterException e) {
            System.err.println(e);
        }
    }
}

