/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.util.RectangleRubberBand;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPrinter;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.SwappableList;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterResolution;

public class Print
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Projection2D printProjection;
        Point2D p2;
        Point2D p1;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        if (cmpList.isEmpty()) {
            krnl.readOK(Messages.getString("kernel.cmds.Print.0"), 10);
            return;
        }
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        double mmPerNU = cs.getMillimetersPerNaturalUnit();
        RectangleRubberBand rb = null;
        try {
            p1 = krnl.readPoint(Messages.getString("kernel.cmds.Print.1"));
            rb = new RectangleRubberBand(krnl, p1);
            while (true) {
                p2 = krnl.readPoint(Messages.getString("kernel.cmds.Print.2"));
                if (Math.abs(p1.getX() - p2.getX()) > Geo2D.getEps() && Math.abs(p1.getY() - p2.getY()) > Geo2D.getEps()) {
                    break;
                }
                System.err.println(Messages.getString("kernel.cmds.Print.3"));
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
            rb = null;
        }
        System.out.println(Messages.getString("kernel.cmds.Print.4"));
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        PageFormat changedPageFormat = printerJob.pageDialog(pageFormat);
        if (changedPageFormat == pageFormat) {
            return;
        }
        pageFormat = changedPageFormat;
        if (!printerJob.printDialog()) {
            return;
        }
        double mt = pageFormat.getImageableY() * 25.4 / 72.0;
        double ml = pageFormat.getImageableX() * 25.4 / 72.0;
        double mr = (pageFormat.getWidth() - pageFormat.getImageableX() - pageFormat.getImageableWidth()) * 25.4 / 72.0;
        double mb = (pageFormat.getHeight() - pageFormat.getImageableY() - pageFormat.getImageableHeight()) * 25.4 / 72.0;
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern("0.00");
        boolean translateToUpperLeftCorner = krnl.readYesNo(Messages.getString("kernel.cmds.Print.6"), "CADEMIA", String.valueOf(Messages.getString("kernel.cmds.Print.8")) + Messages.getString("kernel.cmds.Print.10") + nf.format(mt) + Messages.getString("kernel.cmds.Print.11") + Messages.getString("kernel.cmds.Print.12") + nf.format(ml) + Messages.getString("kernel.cmds.Print.13") + Messages.getString("kernel.cmds.Print.14") + nf.format(mr) + Messages.getString("kernel.cmds.Print.15") + Messages.getString("kernel.cmds.Print.16") + nf.format(mb) + Messages.getString("kernel.cmds.Print.17") + Messages.getString("kernel.cmds.Print.18") + Messages.getString("kernel.cmds.Print.19") + Messages.getString("kernel.cmds.Print.20"), 18);
        Rectangle2D.Double printRect = new Rectangle2D.Double();
        double minX = Math.min(p1.getX(), p2.getX());
        double minY = Math.min(p1.getY(), p2.getY());
        double maxX = Math.max(p1.getX(), p2.getX());
        double maxY = Math.max(p1.getY(), p2.getY());
        double paperWidth = translateToUpperLeftCorner ? pageFormat.getWidth() : pageFormat.getImageableWidth();
        double paperHeight = translateToUpperLeftCorner ? pageFormat.getHeight() : pageFormat.getImageableHeight();
        double modelWidth = maxX - minX;
        double modelHeight = maxY - minY;
        double intersectWidth = Math.min(paperWidth *= scale * 25.4 / (mmPerNU * 72.0), modelWidth);
        double intersectHeight = Math.min(paperHeight *= scale * 25.4 / (mmPerNU * 72.0), modelHeight);
        double modelArea = modelWidth * modelHeight;
        double intersectArea = intersectWidth * intersectHeight;
        double containment = intersectArea / modelArea;
        if (containment < 0.99) {
            krnl.readOK(String.valueOf(Messages.getString("kernel.cmds.Print.21")) + Math.round(containment * 100.0) + Messages.getString("kernel.cmds.Print.22") + Messages.getString("kernel.cmds.Print.23"), 11);
        }
        double mx = 0.0;
        double my = 0.0;
        if (translateToUpperLeftCorner) {
            double imgXmm = pageFormat.getImageableX() * 25.4 / 72.0;
            double imgYmm = pageFormat.getImageableY() * 25.4 / 72.0;
            mx = imgXmm * scale / mmPerNU;
            my = -imgYmm * scale / mmPerNU;
        }
        printRect.setFrameFromDiagonal(minX + mx, minY + my, maxX + mx, maxY + my);
        try {
            printProjection = new Projection2D(printRect, 100.0, 100.0);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println(e);
            return;
        }
        PrintService printService = printerJob.getPrintService();
        String printerName = "Null Printer";
        int crossfeed = 600;
        int feed = 600;
        if (printService != null) {
            printerName = printService.getName();
            Object obj = printService.getDefaultAttributeValue(PrinterResolution.class);
            if (obj instanceof PrinterResolution) {
                PrinterResolution prres = (PrinterResolution)obj;
                int[] ires = prres.getResolution(100);
                crossfeed = ires[0];
                feed = ires[1];
            }
        }
        DrawPrinter printable = new DrawPrinter(printProjection, scale, crossfeed, feed);
        printerJob.setPrintable(printable, pageFormat);
        AttributeManager atm = AttributeManager.getAttributeManager();
        for (Component c : cmpList) {
            if (!atm.getVisibility(c.getAttributes().getVisibility())) continue;
            NamedListIterator<AttributedShape> chainIt = c.shapeIterator();
            while (chainIt.hasNext()) {
                printable.addShape((AttributedShape)chainIt.next());
            }
            NamedListIterator<AttributedText> textIt = c.textIterator();
            while (textIt.hasNext()) {
                printable.addText((AttributedText)textIt.next());
            }
            NamedListIterator<AttributedImage> imageIt = c.imageIterator();
            while (imageIt.hasNext()) {
                printable.addImage((AttributedImage)imageIt.next());
            }
        }
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.Print.25")) + Geo2D.formatCoordinate(((RectangularShape)printRect).getX()) + Messages.getString("kernel.cmds.Print.26") + Geo2D.formatCoordinate(((RectangularShape)printRect).getY()) + Messages.getString("kernel.cmds.Print.27") + Geo2D.formatCoordinate(((RectangularShape)printRect).getWidth()) + Messages.getString("kernel.cmds.Print.28") + Geo2D.formatCoordinate(((RectangularShape)printRect).getHeight()) + Messages.getString("kernel.cmds.Print.29") + printerName + Messages.getString("kernel.cmds.Print.30") + feed + Messages.getString("kernel.cmds.Print.31") + crossfeed + Messages.getString("kernel.cmds.Print.32") + scale + Messages.getString("kernel.cmds.Print.33"));
        try {
            printerJob.print();
        }
        catch (PrinterException e) {
            System.err.println(e);
        }
    }
}

