/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.AddableFeatures;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentText2D;
import cib.cad.db.comp.ComponentText2DFeature;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.AddText;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;

public class AddTextFeature
implements Cmd {
    public static final String FEATURE_NAME_PREFIX = "USER_TEXT.";
    private ComponentText2DFeature m_feature = null;
    private AddableFeatures m_operand = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            Group comp = krnl.getOpenGroup();
            return comp instanceof AddableFeatures;
        }
        return selSet.size() == 1 && selSet.iterator().next() instanceof AddableFeatures;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        if (!AddTextFeature.isDoable()) {
            krnl.readOK(Messages.getString("kernel.cmds.AddTextFeature.0"), Messages.getString("kernel.cmds.AddTextFeature.1"), Messages.getString("kernel.cmds.AddTextFeature.2"), 6);
            return;
        }
        this.m_operand = selSet.isEmpty() ? (AddableFeatures)((Object)krnl.getOpenGroup()) : (AddableFeatures)selSet.iterator().next();
        String featureName = FEATURE_NAME_PREFIX + krnl.readString(Messages.getString("kernel.cmds.AddTextFeature.6"));
        if (this.m_operand.hasFeature(featureName)) {
            krnl.readOK(Messages.getString("kernel.cmds.AddTextFeature.7"), Messages.getString("kernel.cmds.AddTextFeature.8"), Messages.getString("kernel.cmds.AddTextFeature.9"), 6);
            return;
        }
        boolean featureChangeable = krnl.readYesNo(Messages.getString("kernel.cmds.AddTextFeature.10"), 2);
        AddText addTextCmd = new AddText();
        addTextCmd.doCmd(context);
        ComponentText2D textComp = addTextCmd.getComponent();
        ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
        Layer layer = (Layer)lm.get(textComp);
        cmpSet.remove(textComp);
        this.m_feature = new ComponentText2DFeature(featureName, textComp.getAttributedString(), textComp.getTransform());
        this.m_feature.setChangeable(featureChangeable);
        this.m_feature.setAttributes(textComp.getAttributes());
        lm.put(this.m_feature, layer);
        this.m_operand.addFeature(this.m_feature);
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        this.m_operand.removeFeature(this.m_feature.getName());
    }

    @Override
    public void redoCmd(Object context) {
        this.m_operand.addFeature(this.m_feature);
    }

    @Override
    public boolean changesState() {
        return this.m_feature != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("kernel.cmds.AddTextFeature.11");
    }
}

