/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class AddResourceDir
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String dir;
        Kernel krnl = (Kernel)context;
        if (krnl.hasArgument()) {
            CmdLineToken token = krnl.consumeArgument();
            if (token instanceof TextToken) {
                dir = ((TextToken)token).toString();
                File file = new File(dir);
                if (!file.isAbsolute()) {
                    File userDir = krnl.getUserDir("");
                    dir = String.valueOf(userDir.getAbsolutePath()) + File.separator + dir;
                }
                token = new TextToken(dir);
            }
            krnl.pushBackArguments(new CmdLineToken[]{token});
        }
        URL url = null;
        while (url == null) {
            File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public boolean isDirectorySelectionEnabled() {
                    return true;
                }

                @Override
                public boolean isFileSelectionEnabled() {
                    return false;
                }

                @Override
                public String getPrompt() {
                    return Messages.getString("kernel.cmds.AddResourceDir.0");
                }
            });
            try {
                URI uri = file.toURI();
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                krnl.readOK(e.getMessage(), 2);
                url = null;
            }
        }
        dir = url.toString();
        Messages.addResourceDirectory(dir);
    }
}

