/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.util.RectangleRubberBand;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;

public class AddRectangle
implements Cmd {
    private ComponentPath2D m_comp = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        RectangleRubberBand rb = null;
        try {
            Point2D sp = krnl.readPoint(Messages.getString("kernel.cmds.AddRectangle.0"));
            rb = new RectangleRubberBand(krnl, sp);
            Point2D ep = krnl.readPoint(Messages.getString("kernel.cmds.AddRectangle.1"));
            this.m_comp = new ComponentPath2D();
            this.m_comp.moveTo(sp.getX(), sp.getY());
            this.m_comp.lineTo(ep.getX(), sp.getY());
            this.m_comp.lineTo(ep.getX(), ep.getY());
            this.m_comp.lineTo(sp.getX(), ep.getY());
            this.m_comp.lineTo(sp.getX(), sp.getY());
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            cmpSet.add(this.m_comp);
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddRectangle.2")) + Geo2D.formatCoordinate(sp.getX()) + Messages.getString("kernel.cmds.AddRectangle.3") + Geo2D.formatCoordinate(sp.getY()) + Messages.getString("kernel.cmds.AddRectangle.4") + Geo2D.formatCoordinate(ep.getX()) + Messages.getString("kernel.cmds.AddRectangle.5") + Geo2D.formatCoordinate(ep.getY()) + Messages.getString("kernel.cmds.AddRectangle.6");
            System.out.println(this);
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

