/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.bnd.BindingDimCtrlPoints;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.AddDimAngle;
import cib.cad.lang.Messages;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;

public class AddDimParallel
implements Cmd {
    private ComponentDimSingle m_dim = null;
    private Binding<Component> m_clonedBinding = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        int nPnt = 0;
        Point2D[] pnts = new Point2D[2];
        Component[] comps = new Component[2];
        int[] pntNames = new int[]{-1, -1};
        for (Component comp : selSet) {
            if (!mm.hasMarkedPrimitives(comp, 2)) continue;
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                Point2D pnt = (Point2D)lit.next();
                int index = lit.previousIndex();
                if (!mm.primitiveMarked(comp, 2, index) || pnts[0] != null && Geo2D.equality(pnts[0], pnt) || pnts[1] != null && Geo2D.equality(pnts[1], pnt)) continue;
                if (nPnt >= 2) {
                    System.err.println(Messages.getString("kernel.cmds.AddDimParallel.0"));
                    return;
                }
                pnts[nPnt] = pnt;
                comps[nPnt] = comp;
                pntNames[nPnt] = lit.previousName();
                ++nPnt;
            }
        }
        Point2D pd = krnl.readPoint(Messages.getString("kernel.cmds.AddDimParallel.1"));
        if (nPnt == 0) {
            pnts[nPnt++] = krnl.readPoint(Messages.getString("kernel.cmds.AddDimParallel.2"));
        }
        if (nPnt == 1) {
            pnts[nPnt++] = krnl.readPoint(Messages.getString("kernel.cmds.AddDimParallel.3"));
        }
        this.m_dim = new ComponentDimSingle(pnts[0], pnts[1], pd);
        AddDimAngle.setDefaultFeatures(krnl, this.m_dim);
        cmpSet.add(this.m_dim);
        if (comps[0] != null || comps[1] != null) {
            BindingModel<Component> bindingModel = db.getBindingModel();
            BindingDimCtrlPoints binding = new BindingDimCtrlPoints();
            bindingModel.put(this.m_dim, binding);
            if (comps[0] != null) {
                bindingModel.addBindingObject(binding, comps[0]);
                binding.setBindingControlPoint1(comps[0], pntNames[0]);
            } else {
                binding.setLocation1(pnts[0]);
            }
            if (comps[1] != null) {
                bindingModel.addBindingObject(binding, comps[1]);
                binding.setBindingControlPoint2(comps[1], pntNames[1]);
            } else {
                binding.setLocation2(pnts[1]);
            }
            this.m_clonedBinding = (Binding)binding.clone();
        }
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddDimParallel.4")) + Geo2D.formatCoordinate(pnts[0].getX()) + Messages.getString("kernel.cmds.AddDimParallel.5") + Geo2D.formatCoordinate(pnts[0].getY()) + Messages.getString("kernel.cmds.AddDimParallel.6") + Messages.getString("kernel.cmds.AddDimParallel.7") + Geo2D.formatCoordinate(pnts[1].getX()) + Messages.getString("kernel.cmds.AddDimParallel.8") + Geo2D.formatCoordinate(pnts[1].getY()) + Messages.getString("kernel.cmds.AddDimParallel.9");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_dim);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        BindingModel<Component> bindingModel = db.getBindingModel();
        cmpSet.add(this.m_dim);
        if (this.m_clonedBinding != null) {
            bindingModel.put(this.m_dim, (Binding)this.m_clonedBinding.clone());
        }
    }

    @Override
    public boolean changesState() {
        return this.m_dim != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

