/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.RuntimeExtensionClassLoader;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class AddClasspath
extends CmdAdapter {
    public static final String JAR_FILE_EXTENSION = "jar";

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        URL url = null;
        while (url == null) {
            File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fileName = f.getName();
                    if (!fileName.endsWith(".jar")) {
                        return false;
                    }
                    if (!f.exists()) {
                        System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddClasspath.2"));
                        return false;
                    }
                    if (!f.canRead()) {
                        System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddClasspath.3"));
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean isDirectorySelectionEnabled() {
                    return true;
                }

                @Override
                public boolean isFileSelectionEnabled() {
                    return true;
                }

                @Override
                public String[] getExtensions() {
                    return new String[]{"", AddClasspath.JAR_FILE_EXTENSION};
                }

                @Override
                public String getPrompt() {
                    return Messages.getString("kernel.cmds.AddClasspath.5");
                }

                @Override
                public String getFileFormatDescription() {
                    return String.valueOf(Messages.getString("kernel.cmds.AddClasspath.6")) + " (*." + AddClasspath.JAR_FILE_EXTENSION + ")";
                }
            });
            try {
                URI uri = file.toURI();
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                krnl.readOK(e.getMessage(), 2);
                url = null;
            }
        }
        RuntimeExtensionClassLoader cl = krnl.getClassLoader();
        cl.addURL(url);
        System.out.println(url + Messages.getString("kernel.cmds.AddClasspath.9"));
    }
}

