/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.kernel.Kernel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UndoableCmd
implements Cmd {
    protected Map<Component, Component> m_cmp2clone = new HashMap<Component, Component>();
    protected Map<Group, List<Component>> m_groupComponentList = new HashMap<Group, List<Component>>();
    protected Map<Component, BitSet> m_ctrlPointMap = new HashMap<Component, BitSet>();
    protected Map<Component, Boolean> m_objectSelectState = new HashMap<Component, Boolean>();

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        throw new InternalError("Please implement the doCmd() method");
    }

    @Override
    public void undoCmd(Object context) {
        this._undoOrRedoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        this._undoOrRedoCmd(context);
    }

    private void _undoOrRedoCmd(Object context) {
        Set<Component> comps = this.m_cmp2clone.keySet();
        for (Component comp : comps) {
            Component oldClone = this.m_cmp2clone.get(comp);
            if (comp instanceof Group) {
                Group group = (Group)comp;
                List<Component> oldPartList = this.m_groupComponentList.get(group);
                this.__saveObjectState(comp);
                ObservableSet<Component> partSet = group.getComponentSet();
                partSet.retainAll(oldPartList);
                partSet.addAll(oldPartList);
                if (partSet.size() != oldPartList.size()) {
                    throw new InternalError();
                }
                SwappableList<Component> partList = group.getComponentList();
                int n = partList.size();
                int i = 0;
                while (i < n - 1) {
                    Component part = oldPartList.get(i);
                    if (part != partList.get(i)) {
                        partList.swap(i, partList.indexOf(part));
                    }
                    ++i;
                }
            } else {
                this.__saveObjectState(comp);
            }
            comp.assign(oldClone);
        }
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        Set<Component> keySet = this.m_ctrlPointMap.keySet();
        for (Component c : keySet) {
            BitSet markers = this.m_ctrlPointMap.get(c);
            if (markers != null) {
                markers = (BitSet)markers.clone();
            }
            this.__saveSelectState(c);
            if (markers == null) {
                selSet.remove(c);
                continue;
            }
            selSet.add(c);
            NamedListIterator<Point2D> lit = c.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                mm.markPrimitive(c, 2, index, markers.get(index));
            }
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_cmp2clone.isEmpty() || !this.m_ctrlPointMap.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    protected void _saveState(Component comp) {
        this._saveObjectState(comp);
        this._saveSelectState(comp);
    }

    protected void _saveObjectState(Component comp) {
        if (!this._hasSavedObjectState(comp)) {
            this.__saveObjectState(comp);
        }
    }

    private void __saveObjectState(Component comp) {
        this.m_cmp2clone.put(comp, (Component)comp.clone());
        if (comp instanceof Group) {
            Group group = (Group)comp;
            this.m_groupComponentList.put(group, new ArrayList<Component>(group.getComponentList()));
        }
    }

    protected boolean _hasSavedObjectState(Component comp) {
        return this.m_cmp2clone.containsKey(comp);
    }

    protected int _numberOfSavedObjectStates() {
        return this.m_cmp2clone.size();
    }

    protected void _saveSelectState(Component comp) {
        if (!this._hasSavedSelectState(comp)) {
            this.__saveSelectState(comp);
        }
    }

    private void __saveSelectState(Component comp) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        if (!selSet.contains(comp)) {
            this.m_ctrlPointMap.put(comp, null);
            return;
        }
        BitSet markers = this.m_ctrlPointMap.get(comp);
        if (markers == null) {
            markers = new BitSet(32);
            this.m_ctrlPointMap.put(comp, markers);
        }
        markers.clear();
        if (mm.hasMarkedPrimitives(comp, 2)) {
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                if (!mm.primitiveMarked(comp, 2, index)) continue;
                markers.set(index, true);
            }
        }
    }

    protected boolean _hasSavedSelectState(Component comp) {
        return this.m_ctrlPointMap.containsKey(comp) || this.m_objectSelectState.containsKey(comp);
    }

    protected int _numberOfSavedSelectStates() {
        return this.m_ctrlPointMap.size() + this.m_objectSelectState.size();
    }

    protected void _clearAllSavedStates() {
        this.m_cmp2clone.clear();
        this.m_groupComponentList.clear();
        this.m_ctrlPointMap.clear();
        this.m_objectSelectState.clear();
    }
}

