/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.interpreter.TokenInterpreter;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.view.Projection2D;

public class NormDigitizeToken
implements CmdLineToken {
    private double m_x = 0.0;
    private double m_y = 0.0;
    private int m_id = 0;

    public NormDigitizeToken() {
    }

    public NormDigitizeToken(double x, double y, int id) {
        this.m_x = x;
        this.m_y = y;
        this.m_id = id;
    }

    @Override
    public void fromString(String token) {
        double[] args = TokenInterpreter.getNormDigitize(token);
        if (args.length != 3) {
            throw new IllegalArgumentException(Messages.getString("kernel.NormDigitizeToken.0"));
        }
        this.m_x = args[0];
        this.m_y = args[1];
        this.m_id = (int)args[2];
    }

    public DigitizeToken getDigitizeToken(GeometryPanel gp) {
        double y;
        double x;
        if (gp == null) {
            throw new IllegalArgumentException(Messages.getString("kernel.NormDigitizeToken.1"));
        }
        double w = ((DrawPanel)gp).getWidth();
        double h = ((DrawPanel)gp).getHeight();
        double D = w / h;
        Projection2D p = gp.getProjection();
        double sb = Math.min(w / p.getViewPort().getWidth(), h / p.getViewPort().getHeight());
        double delta = 10.0 / sb;
        double u = p.getViewPort().getWidth() + delta + delta;
        double v = p.getViewPort().getHeight() + delta + delta;
        double V = u / v;
        double dx = p.getDeviceDX();
        double dy = p.getDeviceDY();
        if (V < 1.0) {
            if (D < 1.0) {
                if (D < V) {
                    x = this.m_x * w / V;
                    y = this.m_y * w / V + dy;
                } else if (D > V) {
                    x = this.m_x * h + dx;
                    y = this.m_y * h;
                } else {
                    x = this.m_x * h;
                    y = this.m_y * h;
                }
            } else {
                x = this.m_x * h + dx;
                y = this.m_y * h;
            }
        } else if (V > 1.0) {
            if (D > 1.0) {
                if (D > V) {
                    x = this.m_x * h * V + dx;
                    y = this.m_y * h * V;
                } else if (D < V) {
                    x = this.m_x * w;
                    y = this.m_y * w + dy;
                } else {
                    x = this.m_x * w;
                    y = this.m_y * w;
                }
            } else {
                x = this.m_x * w;
                y = this.m_y * w + dy;
            }
        } else if (D > 1.0) {
            x = this.m_x * h + dx;
            y = this.m_y * h;
        } else if (D < 1.0) {
            x = this.m_x * w;
            y = this.m_y * w + dy;
        } else {
            x = this.m_x * w;
            y = this.m_y * w;
        }
        return new DigitizeToken((int)Math.round(x), (int)Math.round(y), this.m_id);
    }

    public static NormDigitizeToken getNormDigitizeToken(GeometryPanel gp, DigitizeToken t) {
        double y;
        double x;
        double w = ((DrawPanel)gp).getWidth();
        double h = ((DrawPanel)gp).getHeight();
        double D = w / h;
        Projection2D p = gp.getProjection();
        double sb = Math.min(w / p.getViewPort().getWidth(), h / p.getViewPort().getHeight());
        double delta = 10.0 / sb;
        double u = p.getViewPort().getWidth() + delta + delta;
        double v = p.getViewPort().getHeight() + delta + delta;
        double V = u / v;
        double dx = p.getDeviceDX();
        double dy = p.getDeviceDY();
        if (V < 1.0) {
            if (D < 1.0) {
                if (D < V) {
                    x = (double)t.getX() / w * V;
                    y = ((double)t.getY() - dy) / w * V;
                } else if (D > V) {
                    x = ((double)t.getX() - dx) / h;
                    y = (double)t.getY() / h;
                } else {
                    x = (double)t.getX() / h;
                    y = (double)t.getY() / h;
                }
            } else {
                x = ((double)t.getX() - dx) / h;
                y = (double)t.getY() / h;
            }
        } else if (V > 1.0) {
            if (D > 1.0) {
                if (D > V) {
                    x = ((double)t.getX() - dx) / h / V;
                    y = (double)t.getY() / h / V;
                } else if (D < V) {
                    x = (double)t.getX() / w;
                    y = ((double)t.getY() - dy) / w;
                } else {
                    x = (double)t.getX() / w;
                    y = (double)t.getY() / w;
                }
            } else {
                x = (double)t.getX() / w;
                y = ((double)t.getY() - dy) / w;
            }
        } else if (D > 1.0) {
            x = ((double)t.getX() - dx) / h;
            y = (double)t.getY() / h;
        } else if (D < 1.0) {
            x = (double)t.getX() / w;
            y = ((double)t.getY() - dy) / w;
        } else {
            x = (double)t.getX() / w;
            y = (double)t.getY() / w;
        }
        return new NormDigitizeToken(x, y, t.getWindow());
    }

    public int getWindow() {
        return this.m_id;
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public String toString() {
        return "#normdig(" + this.m_x + " " + this.m_y + " " + this.m_id + ")";
    }
}

