/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.WindowRubberBand;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;

public class UnselectControlPoints
extends UndoableCmd {
    private String m_toString = null;
    private int m_filter = -1;
    private int m_action = -1;
    private DigitizeObject m_dig = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        try {
            do {
                CmdLineDialog dlg = ui.getCmdLineDialog();
                dlg.setUniqueName("ext.mod.UnselectControlPoints-menu0");
                dlg.setPrompt(Messages.getString("ext.mod.UnselectControlPoints.0"));
                int iChoice = dlg.addChoice("Vertex");
                if ((this.m_filter & 2) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Segment");
                if ((this.m_filter & 0xFC) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Point");
                if ((this.m_filter & 1) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                dlg.enableDigitize(-1);
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void choiceSelected(int iChoice) {
                        UnselectControlPoints.this.m_action = iChoice;
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void digitized(int x, int y, GeometryPanel gp) {
                        UnselectControlPoints.this.m_action = -2;
                        UnselectControlPoints.this.m_dig = new DigitizeObject(gp, x, y);
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        UnselectControlPoints.this.m_action = -1;
                        ui.disposeCmdLineDialog();
                    }
                });
                this._setCursor(true);
                ui.showCmdLineDialog(dlg);
                if (this.m_action == 0) {
                    if ((this.m_filter & 2) == 0) {
                        this.m_filter |= 2;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFFFD;
                    continue;
                }
                if (this.m_action == 1) {
                    if ((this.m_filter & 0xFC) == 0) {
                        this.m_filter |= 0xFC;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFF03;
                    continue;
                }
                if (this.m_action == 2) {
                    if ((this.m_filter & 1) == 0) {
                        this.m_filter |= 1;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFFFE;
                    continue;
                }
                if (this.m_action == -1) {
                    throw new CmdAbortedException();
                }
                if (this.m_action != -2 || this.m_filter != 0) continue;
                System.err.println(Messages.getString("ext.mod.UnselectControlPoints.1"));
                this.m_action = -1;
            } while (this.m_action != -2);
        }
        finally {
            this._setCursor(false);
        }
        WindowRubberBand rb = null;
        DigitizeObject d1 = this.m_dig;
        DigitizeObject d2 = null;
        try {
            rb = new WindowRubberBand(krnl, d1);
            while (d2 == null) {
                d2 = krnl.readDigitizeObject(String.valueOf(Messages.getString("ext.mod.UnselectControlPoints.5")) + d1.getGeometryPanel().getId());
                if (d1.getGeometryPanel() == d2.getGeometryPanel()) continue;
                System.err.println(String.valueOf(Messages.getString("ext.mod.UnselectControlPoints.6")) + d1.getGeometryPanel().getId());
                d2 = null;
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
        GeometryPanel geometryPanel = d1.getGeometryPanel();
        Point p1 = d1.getPoint();
        Point p2 = d2.getPoint();
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(p1, p2);
        AffineTransform m2v = geometryPanel.getProjection().getModelToView();
        Database db = krnl.getDatabase();
        MarkerMap mm = db.getMarkerMap();
        Iterator<cib.cad.db.comp.Component> it = geometryPanel.objectIterator(rectangle, true);
        int nUnselected = 0;
        while (it.hasNext()) {
            cib.cad.db.comp.Component c = it.next();
            NamedListIterator<Point2D> lit = c.controlPointIterator();
            while (lit.hasNext()) {
                int index;
                int ctrlType;
                Point2D p = (Point2D)lit.next();
                int name = lit.previousName();
                int n = ctrlType = c instanceof CtrlSegments ? ((CtrlSegments)c).getCtrlType(name) : 1;
                if ((ctrlType & this.m_filter) == 0 || !mm.primitiveMarked(c, 2, index = lit.previousIndex())) continue;
                m2v.transform(p, p);
                if (!rectangle.contains(p)) continue;
                if (!this._hasSavedSelectState(c)) {
                    this._saveSelectState(c);
                }
                mm.markPrimitive(c, 2, index, false);
                this._unmarkChildren(c, mm, name);
                ++nUnselected;
            }
        }
        this.m_toString = String.valueOf(Messages.getString("ext.mod.UnselectControlPoints.7")) + nUnselected + Messages.getString("ext.mod.UnselectControlPoints.8");
        System.out.println(this);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _setCursor(boolean on) {
        Cursor cursor = on ? Cursor.getPredefinedCursor(1) : Cursor.getPredefinedCursor(0);
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    private void _unmarkChildren(cib.cad.db.comp.Component comp, MarkerMap mm, int parentName) {
        int nChildren = comp.getControlPointChildrenCount(parentName);
        if (nChildren != 0) {
            HashSet<Integer> children = new HashSet<Integer>();
            int iChild = 0;
            while (iChild < nChildren) {
                children.add(comp.getControlPointChild(parentName, iChild));
                ++iChild;
            }
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                int name = lit.previousName();
                if (!children.contains(name)) continue;
                mm.markPrimitive(comp, 2, index, false);
            }
        }
    }
}

