/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.bnd.BindingDimCtrlPoints;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.layer.Layer;
import cib.cad.ext.mod.Join;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Smash
implements Cmd {
    private Set<Component> m_srcComps = new HashSet<Component>();
    private Set<Component> m_dstComps = new HashSet<Component>();
    private Set<Join.BindingDoer> m_bindingDoers = new HashSet<Join.BindingDoer>();
    private Set<Join.BindingDimControlPointsDoer> m_bindingDimDoers = new HashSet<Join.BindingDimControlPointsDoer>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (!(comp instanceof ComponentPath2D)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        BindingModel<Component> bindingModel = db.getBindingModel();
        HashMap<Component, HashSet<Binding>> bindingCompsMap = new HashMap<Component, HashSet<Binding>>();
        Set comps = bindingModel.keySet();
        for (Component comp : comps) {
            Binding binding = (Binding)bindingModel.get(comp);
            Set bindingComps = binding.getBindingObjects();
            for (Component bindingComp : bindingComps) {
                if (!(bindingComp instanceof ComponentPath2D) || !selSet.contains(bindingComp)) continue;
                HashSet<Binding> bindings = (HashSet<Binding>)bindingCompsMap.get(bindingComp);
                if (bindings == null) {
                    bindings = new HashSet<Binding>();
                }
                bindings.add(binding);
                bindingCompsMap.put(bindingComp, bindings);
            }
        }
        for (Component component : selSet) {
            if (!(component instanceof ComponentPath2D)) continue;
            Set bindings = (Set)bindingCompsMap.get(component);
            CtrlSegments ctrlSegments = (CtrlSegments)component;
            HashSet<CtrlSegments> dstComps = new HashSet<CtrlSegments>();
            NamedListIterator<Point2D> pit = component.controlPointIterator();
            double[] crds = new double[8];
            double[] moveto = new double[2];
            double[] lastto = new double[2];
            block11: while (pit.hasNext()) {
                pit.next();
                int n = pit.previousName();
                int type = ctrlSegments.getCtrlType(n);
                if ((type & 0xFC) == 0) continue;
                switch (ctrlSegments.getSegmentCrds(n, crds)) {
                    case 4: {
                        moveto[0] = crds[0];
                        moveto[1] = crds[1];
                        lastto[0] = crds[0];
                        lastto[1] = crds[1];
                        break;
                    }
                    case 8: {
                        CtrlSegments newComp = new ComponentLine2D(crds[0], crds[1], crds[2], crds[3]);
                        dstComps.add(newComp);
                        lastto[0] = crds[2];
                        lastto[1] = crds[3];
                        if (bindings == null) continue block11;
                        for (Binding binding : bindings) {
                            this.m_bindingDoers.add(new Join.BindingDoer(binding, component, newComp));
                        }
                        this.addDimBindingUndoer(component, n, newComp, 2, bindings);
                        break;
                    }
                    case 64: {
                        CtrlSegments newComp = new ComponentArc2D(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                        dstComps.add(newComp);
                        lastto[0] = crds[4];
                        lastto[1] = crds[5];
                        if (bindings == null) continue block11;
                        for (Binding binding : bindings) {
                            this.m_bindingDoers.add(new Join.BindingDoer(binding, component, newComp));
                        }
                        this.addDimBindingUndoer(component, n, newComp, 0, bindings);
                        break;
                    }
                    case 16: {
                        ComponentPath2D compPath = new ComponentPath2D();
                        compPath.moveTo(crds[0], crds[1]);
                        int newSegName = compPath.quadTo(crds[2], crds[3], crds[4], crds[5]);
                        dstComps.add(compPath);
                        lastto[0] = crds[4];
                        lastto[1] = crds[5];
                        if (bindings == null) continue block11;
                        for (Binding binding : bindings) {
                            this.m_bindingDoers.add(new Join.BindingDoer(binding, component, compPath));
                        }
                        this.addDimBindingUndoer(component, n, compPath, newSegName, bindings);
                        break;
                    }
                    case 32: {
                        ComponentPath2D compPath = new ComponentPath2D();
                        compPath.moveTo(crds[0], crds[1]);
                        int newSegName = compPath.cubicTo(crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                        dstComps.add(compPath);
                        lastto[0] = crds[6];
                        lastto[1] = crds[7];
                        if (bindings == null) continue block11;
                        for (Binding binding : bindings) {
                            this.m_bindingDoers.add(new Join.BindingDoer(binding, component, compPath));
                        }
                        this.addDimBindingUndoer(component, n, compPath, newSegName, bindings);
                        break;
                    }
                    case 128: {
                        if (Geo2D.equality(lastto[0], lastto[1], moveto[0], moveto[1])) continue block11;
                        crds[0] = lastto[0];
                        crds[1] = lastto[1];
                        crds[2] = moveto[0];
                        crds[3] = moveto[1];
                        dstComps.add(new ComponentLine2D(crds[0], crds[1], crds[2], crds[3]));
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (dstComps.isEmpty()) continue;
            this.m_srcComps.add(component);
            for (Component component2 : dstComps) {
                Attributes attr = component.getAttributes();
                if (attr != null) {
                    component2.setAttributes(attr);
                }
                this.m_dstComps.add(component2);
                cmpSet.add(component2);
                selSet.add(component2);
                Layer layer = (Layer)layerMap.get(component);
                if (layer == null) continue;
                layerMap.put(component2, layer);
            }
        }
        cmpSet.removeAll(this.m_srcComps);
        for (Join.BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.doit();
        }
        for (Join.BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.doit();
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        cmpSet.removeAll(this.m_dstComps);
        cmpSet.addAll(this.m_srcComps);
        selSet.addAll(this.m_srcComps);
        for (Join.BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.undoit();
        }
        for (Join.BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.undoit();
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        cmpSet.addAll(this.m_dstComps);
        selSet.addAll(this.m_dstComps);
        cmpSet.removeAll(this.m_srcComps);
        for (Join.BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.doit();
        }
        for (Join.BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.doit();
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_srcComps.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return String.valueOf(Messages.getString("ext.mod.Smash.0")) + this.m_srcComps.size() + Messages.getString("ext.mod.Smash.1");
    }

    private void addDimBindingUndoer(Component oldComp, int oldSegName, Component newComp, int newSegName, Set<Binding<Component>> bindings) {
        CtrlSegments oldCtrlSegs = (CtrlSegments)oldComp;
        for (Binding<Component> binding : bindings) {
            int i;
            int nPoints;
            if (!(binding instanceof BindingDimCtrlPoints)) continue;
            BindingDimCtrlPoints dimBinding = (BindingDimCtrlPoints)binding;
            CtrlSegments newCtrlSegs = (CtrlSegments)newComp;
            int bndName = dimBinding.getPointName1();
            if (dimBinding.getComponent1() == oldComp && bndName != -1) {
                if (bndName == oldSegName) {
                    this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newSegName, true));
                } else if (bndName == oldCtrlSegs.getSegmentVertex1(oldSegName)) {
                    this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentVertex1(newSegName), true));
                } else if (bndName == oldCtrlSegs.getSegmentVertex2(oldSegName)) {
                    this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentVertex2(newSegName), true));
                } else {
                    nPoints = oldCtrlSegs.getSegmentPointCount(oldSegName);
                    i = 0;
                    while (i < nPoints) {
                        if (bndName == oldCtrlSegs.getSegmentPointAt(oldSegName, i)) {
                            this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentPointAt(newSegName, i), true));
                        }
                        ++i;
                    }
                }
            }
            bndName = dimBinding.getPointName2();
            if (dimBinding.getComponent2() != oldComp || bndName == -1) continue;
            if (bndName == oldSegName) {
                this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newSegName, false));
                continue;
            }
            if (bndName == oldCtrlSegs.getSegmentVertex1(oldSegName)) {
                this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentVertex1(newSegName), false));
                continue;
            }
            if (bndName == oldCtrlSegs.getSegmentVertex2(oldSegName)) {
                this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentVertex2(newSegName), false));
                continue;
            }
            nPoints = oldCtrlSegs.getSegmentPointCount(oldSegName);
            i = 0;
            while (i < nPoints) {
                if (bndName == oldCtrlSegs.getSegmentPointAt(oldSegName, i)) {
                    this.m_bindingDimDoers.add(new Join.BindingDimControlPointsDoer(dimBinding, oldComp, bndName, newComp, newCtrlSegs.getSegmentPointAt(newSegName, i), false));
                }
                ++i;
            }
        }
    }
}

