/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.DragPreferences;
import cib.cad.ext.mod.Mod;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;

public class Offset
implements Cmd {
    private static double s_offsetDist = -1.0;
    private ComponentPath2D m_offsetPath = null;
    private transient Object m_input = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (!(comp instanceof CtrlSegments)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        if (!Offset.isDoable()) {
            System.err.println(Messages.getString("ext.mod.Offset.0"));
            return;
        }
        if (DragPreferences.getDragMode() == 2) {
            s_offsetDist = DragPreferences.getOffsetDistance();
        }
        while (true) {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("ext.mod.Offset-menu0");
            final ConPoint2D conPoint = new ConPoint2D(krnl);
            dlg.setPrompt(Messages.getString("ext.mod.Offset.1"));
            dlg.enableTextInput(true);
            dlg.enableDigitize(-1);
            CoordSpace cs = CoordSpace.getCoordSpace();
            double mmPerNU = cs.getMillimetersPerNaturalUnit();
            long offsetInMM = Math.round(s_offsetDist * mmPerNU);
            int i = dlg.addChoice("Through point");
            if ((double)offsetInMM < Geo2D.getEps()) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, Messages.getString("ext.mod.Offset.3"));
            i = dlg.addChoice("115");
            if (offsetInMM == 115L) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.5")) + Geo2D.formatCoordinate(115.0 / mmPerNU));
            i = dlg.addChoice("175");
            if (offsetInMM == 175L) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.7")) + Geo2D.formatCoordinate(175.0 / mmPerNU));
            i = dlg.addChoice("240");
            if (offsetInMM == 240L) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.9")) + Geo2D.formatCoordinate(240.0 / mmPerNU));
            i = dlg.addChoice("300");
            if (offsetInMM == 300L) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.11")) + Geo2D.formatCoordinate(300.0 / mmPerNU));
            i = dlg.addChoice("365");
            if (offsetInMM == 365L) {
                dlg.setChoiceChecked(i);
            }
            dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.13")) + Geo2D.formatCoordinate(365.0 / mmPerNU));
            i = dlg.addChoice("Distance");
            if (!(dlg.isChoiceChecked(0) || dlg.isChoiceChecked(1) || dlg.isChoiceChecked(2) || dlg.isChoiceChecked(3) || dlg.isChoiceChecked(4) || dlg.isChoiceChecked(5))) {
                dlg.setChoiceChecked(i);
                dlg.setChoiceHints(i, String.valueOf(Messages.getString("ext.mod.Offset.15")) + Geo2D.formatCoordinate(s_offsetDist));
            } else {
                dlg.setChoiceHints(i, Messages.getString("ext.mod.Offset.16"));
            }
            dlg.addSeparator();
            dlg.addChoice("Placement");
            dlg.addListener(new CmdLineDialog.Listener(){
                boolean m_prefsInterrupting = false;

                @Override
                public void choiceSelected(int iChoice) {
                    Offset.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    Offset.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    Offset.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    Offset.this.m_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    this.m_prefsInterrupting = argList.startsWith("prefs");
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    if (this.m_prefsInterrupting) {
                        Offset.this.m_input = new Integer(-1);
                        ui.disposeCmdLineDialog();
                    }
                }
            });
            conPoint.setDigitizeCursor(true);
            ui.showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case -1: {
                        if (DragPreferences.getDragMode() != 2) break;
                        s_offsetDist = DragPreferences.getOffsetDistance();
                        break;
                    }
                    case 0: {
                        s_offsetDist = -1.0;
                        break;
                    }
                    case 1: {
                        s_offsetDist = 115.0 / mmPerNU;
                        break;
                    }
                    case 2: {
                        s_offsetDist = 175.0 / mmPerNU;
                        break;
                    }
                    case 3: {
                        s_offsetDist = 240.0 / mmPerNU;
                        break;
                    }
                    case 4: {
                        s_offsetDist = 300.0 / mmPerNU;
                        break;
                    }
                    case 5: {
                        s_offsetDist = 365.0 / mmPerNU;
                        break;
                    }
                    case 6: {
                        s_offsetDist = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Offset.19"));
                        break;
                    }
                    case 7: {
                        this.offset();
                        return;
                    }
                    default: {
                        System.err.println(Messages.getString("ext.mod.Offset.20"));
                    }
                }
                DragPreferences.setDragMode(2);
                DragPreferences.setOffsetDistance(s_offsetDist);
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (this.m_input instanceof DigitizeToken) {
                krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                this.offset();
                return;
            }
            if (!(this.m_input instanceof TextToken)) continue;
            try {
                s_offsetDist = Double.parseDouble(((TextToken)this.m_input).toString());
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println(Messages.getString("ext.mod.Offset.21"));
                continue;
            }
            break;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_offsetPath);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_offsetPath);
    }

    @Override
    public boolean changesState() {
        return this.m_offsetPath != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("ext.mod.Offset.22");
    }

    private void offset() throws CmdAbortedException {
        double nearestOffset;
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        Point2D pnt = krnl.readPoint(Messages.getString("ext.mod.Offset.23"));
        double nearestDist = Double.POSITIVE_INFINITY;
        Component nearestComp = null;
        int nearestSegName = -1;
        int nearestSubCurveSegName = -1;
        int currentSubCurveSegName = -1;
        double[] crds = new double[8];
        Point2D.Double endPnt = null;
        for (Component comp : selSet) {
            if (!(comp instanceof CtrlSegments)) continue;
            CtrlSegments ctrlSegments = (CtrlSegments)comp;
            NamedListIterator<Point2D> pit = comp.controlPointIterator();
            block27: while (pit.hasNext()) {
                double dist;
                pit.next();
                int name = pit.previousName();
                int type = ctrlSegments.getCtrlType(name);
                if ((type & 0xFC) == 0) continue;
                if (currentSubCurveSegName == -1) {
                    currentSubCurveSegName = name;
                }
                Point2D.Double sp = new Point2D.Double();
                Point2D.Double ep = new Point2D.Double();
                switch (type) {
                    case 8: {
                        ctrlSegments.getSegmentCrds(name, crds);
                        ((Point2D)sp).setLocation(crds[0], crds[1]);
                        ((Point2D)ep).setLocation(crds[2], crds[3]);
                        Line2D.Double line = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                        dist = Geo2D.distance(pnt, line);
                        break;
                    }
                    case 64: {
                        ctrlSegments.getSegmentCrds(name, crds);
                        ((Point2D)sp).setLocation(crds[0], crds[1]);
                        ((Point2D)ep).setLocation(crds[4], crds[5]);
                        Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                        Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                        dist = arc != null ? Geo2D.distance(pnt, arc) : Geo2D.distance(pnt, new Line2D.Double(sp, ep));
                        break;
                    }
                    case 16: {
                        ctrlSegments.getSegmentCrds(name, crds);
                        ((Point2D)sp).setLocation(crds[0], crds[1]);
                        ((Point2D)ep).setLocation(crds[4], crds[5]);
                        QuadCurve2D.Double quad = new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                        dist = Geo2D.distance(pnt, quad);
                        break;
                    }
                    case 32: {
                        ctrlSegments.getSegmentCrds(name, crds);
                        ((Point2D)sp).setLocation(crds[0], crds[1]);
                        ((Point2D)ep).setLocation(crds[6], crds[7]);
                        CubicCurve2D.Double cubic = new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                        dist = Geo2D.distance(pnt, cubic);
                        break;
                    }
                    default: {
                        continue block27;
                    }
                }
                if (endPnt == null) {
                    endPnt = new Point2D.Double();
                } else if (!Geo2D.equality(sp, endPnt)) {
                    currentSubCurveSegName = name;
                }
                endPnt.setLocation(ep);
                if (!(dist < nearestDist)) continue;
                nearestDist = dist;
                nearestComp = comp;
                nearestSegName = name;
                nearestSubCurveSegName = currentSubCurveSegName;
            }
        }
        if (nearestComp == null || nearestSegName == -1) {
            System.err.println(Messages.getString("ext.mod.Offset.24"));
            return;
        }
        CtrlSegments ctrlSegs = (CtrlSegments)nearestComp;
        int type = ctrlSegs.getSegmentCrds(nearestSegName, crds);
        switch (type) {
            case 8: {
                nearestOffset = this.signedOffset(pnt, new Line2D.Double(crds[0], crds[1], crds[2], crds[3]));
                break;
            }
            case 64: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                nearestOffset = arc != null ? this.signedOffset(pnt, arc) : this.signedOffset(pnt, new Line2D.Double(crds[0], crds[1], crds[4], crds[5]));
                break;
            }
            case 16: {
                nearestOffset = this.signedOffset(pnt, new Line2D.Double(crds[0], crds[1], crds[4], crds[5]));
                break;
            }
            case 32: {
                nearestOffset = this.signedOffset(pnt, new Line2D.Double(crds[0], crds[1], crds[6], crds[7]));
                break;
            }
            default: {
                throw new InternalError(Messages.getString("ext.mod.Offset.25"));
            }
        }
        if (s_offsetDist >= Geo2D.getEps()) {
            nearestOffset = Math.signum(nearestOffset) * s_offsetDist;
        }
        ArrayList<Shape> offsetShapes = new ArrayList<Shape>();
        CtrlSegments ctrlSegments = (CtrlSegments)nearestComp;
        NamedListIterator<Point2D> pit = nearestComp.controlPointIterator();
        Point2D orgSubCurveStart = null;
        Point2D.Double orgSubCurveEnd = null;
        boolean subCurveStarted = false;
        boolean subCurveDone = false;
        while (!subCurveDone && pit.hasNext()) {
            pit.next();
            int name = pit.previousName();
            if (name == nearestSubCurveSegName) {
                subCurveStarted = true;
            }
            type = ctrlSegments.getCtrlType(name);
            if (!subCurveStarted || (type & 0xFC) == 0) continue;
            Point2D.Double sp = new Point2D.Double();
            Point2D.Double ep = new Point2D.Double();
            Shape offsetShape = null;
            switch (type) {
                case 8: {
                    ctrlSegments.getSegmentCrds(name, crds);
                    ((Point2D)sp).setLocation(crds[0], crds[1]);
                    ((Point2D)ep).setLocation(crds[2], crds[3]);
                    this.offsetSegment(type, crds, nearestOffset);
                    offsetShape = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                    break;
                }
                case 64: {
                    ctrlSegments.getSegmentCrds(name, crds);
                    ((Point2D)sp).setLocation(crds[0], crds[1]);
                    ((Point2D)ep).setLocation(crds[4], crds[5]);
                    this.offsetSegment(type, crds, nearestOffset);
                    offsetShape = this.crdsToShape(64, crds);
                    break;
                }
                case 16: {
                    ctrlSegments.getSegmentCrds(name, crds);
                    ((Point2D)sp).setLocation(crds[0], crds[1]);
                    ((Point2D)ep).setLocation(crds[4], crds[5]);
                    this.offsetSegment(type, crds, nearestOffset);
                    offsetShape = new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                    break;
                }
                case 32: {
                    ctrlSegments.getSegmentCrds(name, crds);
                    ((Point2D)sp).setLocation(crds[0], crds[1]);
                    ((Point2D)ep).setLocation(crds[6], crds[7]);
                    this.offsetSegment(type, crds, nearestOffset);
                    offsetShape = new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                    break;
                }
                case 128: {
                    if (orgSubCurveStart != null && orgSubCurveEnd != null && !Geo2D.equality(orgSubCurveStart, orgSubCurveEnd)) {
                        orgSubCurveEnd = (Point2D.Double)orgSubCurveStart.clone();
                        crds[0] = ((Point2D)orgSubCurveEnd).getX();
                        crds[1] = ((Point2D)orgSubCurveEnd).getY();
                        crds[2] = orgSubCurveStart.getX();
                        crds[3] = orgSubCurveStart.getY();
                        this.offsetSegment(8, crds, nearestOffset);
                        offsetShapes.add(new Line2D.Double(crds[0], crds[1], crds[2], crds[3]));
                    }
                }
                case 4: {
                    subCurveDone = true;
                }
            }
            if (subCurveDone) continue;
            if (orgSubCurveStart == null) {
                orgSubCurveStart = new Point2D.Double(((Point2D)sp).getX(), ((Point2D)sp).getY());
            } else if (!Geo2D.equality(sp, orgSubCurveEnd)) {
                subCurveDone = true;
            }
            if (subCurveDone) continue;
            orgSubCurveEnd = new Point2D.Double(((Point2D)ep).getX(), ((Point2D)ep).getY());
            offsetShapes.add(offsetShape);
        }
        boolean subCurveClosed = orgSubCurveStart != null && orgSubCurveEnd != null && Geo2D.equality(orgSubCurveStart, orgSubCurveEnd);
        int n = subCurveClosed ? offsetShapes.size() : offsetShapes.size() - 1;
        int i = 0;
        while (i < n) {
            Shape shp1 = (Shape)offsetShapes.get(i);
            int j = (i + 1) % offsetShapes.size();
            Shape shp2 = (Shape)offsetShapes.get(j);
            Shape shpx1 = this.extendEnd(shp1, shp2);
            Shape shpx2 = this.extendStart(shp2, shp1);
            if (shpx1 != null && shpx2 != null) {
                offsetShapes.set(i, shpx1);
                offsetShapes.set(j, shpx2);
            } else {
                offsetShapes.add(i + 1, null);
                ++i;
                ++n;
            }
            ++i;
        }
        this.m_offsetPath = new ComponentPath2D();
        boolean move = true;
        for (Shape shape : offsetShapes) {
            if (shape == null) {
                move = true;
                continue;
            }
            type = this.shapeToCrds(shape, crds);
            if (move) {
                this.m_offsetPath.moveTo(crds[0], crds[1]);
                move = false;
            }
            switch (type) {
                case 8: {
                    this.m_offsetPath.lineTo(crds[2], crds[3]);
                    break;
                }
                case 64: {
                    this.m_offsetPath.arcTo(crds[2], crds[3], crds[4], crds[5]);
                    break;
                }
                case 16: {
                    this.m_offsetPath.quadTo(crds[2], crds[3], crds[4], crds[5]);
                    break;
                }
                case 32: {
                    this.m_offsetPath.cubicTo(crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                    break;
                }
                default: {
                    throw new InternalError(Messages.getString("ext.mod.Offset.26"));
                }
            }
        }
        cmpSet.add(this.m_offsetPath);
    }

    private int shapeToCrds(Shape shp, double[] crds) {
        if (shp instanceof Line2D) {
            Line2D line = (Line2D)shp;
            crds[0] = line.getX1();
            crds[1] = line.getY1();
            crds[2] = line.getX2();
            crds[3] = line.getY2();
            return 8;
        }
        if (shp instanceof Arc2D) {
            Arc2D arc = (Arc2D)shp;
            Point2D sp = arc.getStartPoint();
            Point2D ep = arc.getEndPoint();
            double radius = 0.5 * arc.getWidth();
            double startAngle = -Math.toRadians(arc.getAngleStart());
            double sweepAngle = -Math.toRadians(arc.getAngleExtent());
            Vector2D vap = new Vector2D(startAngle + 0.5 * sweepAngle).scaleBy(radius).add(arc.getCenterX(), arc.getCenterY());
            crds[0] = sp.getX();
            crds[1] = sp.getY();
            crds[2] = vap.getX();
            crds[3] = vap.getY();
            crds[4] = ep.getX();
            crds[5] = ep.getY();
            return 64;
        }
        if (shp instanceof QuadCurve2D) {
            QuadCurve2D quad = (QuadCurve2D)shp;
            crds[0] = quad.getX1();
            crds[1] = quad.getY1();
            crds[2] = quad.getCtrlX();
            crds[3] = quad.getCtrlY();
            crds[4] = quad.getX2();
            crds[5] = quad.getY2();
            return 16;
        }
        if (shp instanceof CubicCurve2D) {
            CubicCurve2D cubic = (CubicCurve2D)shp;
            crds[0] = cubic.getX1();
            crds[1] = cubic.getY1();
            crds[2] = cubic.getCtrlX1();
            crds[3] = cubic.getCtrlY1();
            crds[4] = cubic.getCtrlX2();
            crds[5] = cubic.getCtrlY2();
            crds[6] = cubic.getX2();
            crds[7] = cubic.getY2();
            return 32;
        }
        throw new InternalError(Messages.getString("ext.mod.Offset.27"));
    }

    private Shape crdsToShape(int type, double[] crds) {
        switch (type) {
            case 8: {
                return new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
            }
            case 64: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                return arc == null ? new Line2D.Double(sp, ep) : arc;
            }
            case 16: {
                return new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
            }
            case 32: {
                return new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
            }
        }
        throw new InternalError(Messages.getString("ext.mod.Offset.28"));
    }

    private Shape extendEnd(Shape shp, Shape toShp) {
        double[] crds = new double[8];
        int type = this.shapeToCrds(shp, crds);
        double ext = Double.NaN;
        double trim = Double.NaN;
        if (toShp instanceof Line2D) {
            ext = Offset.calculateEndExtent(type, crds, (Line2D)toShp, true);
            trim = Offset.calculateEndExtent(type, crds, (Line2D)toShp, false);
        } else if (toShp instanceof Arc2D) {
            Arc2D arc = (Arc2D)toShp;
            Ellipse2D.Double ell = new Ellipse2D.Double();
            ell.setFrameFromCenter(arc.getCenterX(), arc.getCenterY(), arc.getX(), arc.getY());
            ext = Offset.calculateEndExtent(type, crds, ell, true);
            trim = Offset.calculateEndExtent(type, crds, ell, false);
        } else {
            if (toShp instanceof QuadCurve2D) {
                QuadCurve2D quad = (QuadCurve2D)toShp;
                Line2D.Double toLine = new Line2D.Double(quad.getP1(), quad.getP2());
                return this.extendEnd(shp, toLine);
            }
            if (toShp instanceof CubicCurve2D) {
                CubicCurve2D cubic = (CubicCurve2D)toShp;
                Line2D.Double toLine = new Line2D.Double(cubic.getP1(), cubic.getP2());
                return this.extendEnd(shp, toLine);
            }
        }
        if (Double.isNaN(ext) && Double.isNaN(trim)) {
            return null;
        }
        if (Double.isNaN(ext)) {
            Mod.extendBy(type, crds, 0.0, trim);
        } else if (Double.isNaN(trim)) {
            Mod.extendBy(type, crds, 0.0, ext);
        } else if (Math.abs(trim) < Math.abs(ext)) {
            Mod.extendBy(type, crds, 0.0, trim);
        } else {
            Mod.extendBy(type, crds, 0.0, ext);
        }
        return this.crdsToShape(type, crds);
    }

    private Shape extendStart(Shape shp, Shape toShp) {
        double[] crds = new double[8];
        int type = this.shapeToCrds(shp, crds);
        double ext = Double.NaN;
        double trim = Double.NaN;
        if (toShp instanceof Line2D) {
            ext = Offset.calculateStartExtent(type, crds, (Line2D)toShp, true);
            trim = Offset.calculateStartExtent(type, crds, (Line2D)toShp, false);
        } else if (toShp instanceof Arc2D) {
            Arc2D arc = (Arc2D)toShp;
            Ellipse2D.Double ell = new Ellipse2D.Double();
            ell.setFrameFromCenter(arc.getCenterX(), arc.getCenterY(), arc.getX(), arc.getY());
            ext = Offset.calculateStartExtent(type, crds, ell, true);
            trim = Offset.calculateStartExtent(type, crds, ell, false);
        } else {
            if (toShp instanceof QuadCurve2D) {
                QuadCurve2D quad = (QuadCurve2D)toShp;
                Line2D.Double toLine = new Line2D.Double(quad.getP1(), quad.getP2());
                return this.extendStart(shp, toLine);
            }
            if (toShp instanceof CubicCurve2D) {
                CubicCurve2D cubic = (CubicCurve2D)toShp;
                Line2D.Double toLine = new Line2D.Double(cubic.getP1(), cubic.getP2());
                return this.extendStart(shp, toLine);
            }
        }
        if (Double.isNaN(ext) && Double.isNaN(trim)) {
            return null;
        }
        if (Double.isNaN(ext)) {
            Mod.extendBy(type, crds, trim, 0.0);
        } else if (Double.isNaN(trim)) {
            Mod.extendBy(type, crds, ext, 0.0);
        } else if (Math.abs(trim) < Math.abs(ext)) {
            Mod.extendBy(type, crds, trim, 0.0);
        } else {
            Mod.extendBy(type, crds, ext, 0.0);
        }
        return this.crdsToShape(type, crds);
    }

    private static double calculateStartExtent(int type, double[] crds, Line2D toLine, boolean ext) {
        Point2D sp = Mod.getStartPoint(type, crds);
        if (Geo2D.equality(sp, toLine.getP1()) || Geo2D.equality(sp, toLine.getP2())) {
            return 0.0;
        }
        return Mod.calculateStartExtent(type, crds, toLine, ext);
    }

    private static double calculateStartExtent(int type, double[] crds, Ellipse2D toEll, boolean ext) {
        Point2D sp = Mod.getStartPoint(type, crds);
        if (Geo2D.containment(toEll, sp)) {
            return 0.0;
        }
        return Mod.calculateStartExtent(type, crds, toEll, ext);
    }

    private static double calculateEndExtent(int type, double[] crds, Line2D toLine, boolean ext) {
        Point2D ep = Mod.getEndPoint(type, crds);
        if (Geo2D.equality(ep, toLine.getP1()) || Geo2D.equality(ep, toLine.getP2())) {
            return 0.0;
        }
        return Mod.calculateEndExtent(type, crds, toLine, ext);
    }

    private static double calculateEndExtent(int type, double[] crds, Ellipse2D toEll, boolean ext) {
        Point2D ep = Mod.getEndPoint(type, crds);
        if (Geo2D.containment(toEll, ep)) {
            return 0.0;
        }
        return Mod.calculateEndExtent(type, crds, toEll, ext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean offsetSegment(int type, double[] crds, double dist) {
        try {
            switch (type) {
                case 8: {
                    Vector2D offVec = new Vector2D(crds[0], crds[1], crds[2], crds[3]).left().normalize().scaleBy(dist);
                    crds[0] = crds[0] + offVec.x;
                    crds[1] = crds[1] + offVec.y;
                    crds[2] = crds[2] + offVec.x;
                    crds[3] = crds[3] + offVec.y;
                    return true;
                }
                case 64: {
                    Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                    Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                    Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                    Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                    if (arc == null) {
                        Vector2D offVec = new Vector2D(crds[0], crds[1], crds[4], crds[5]).left().normalize().scaleBy(dist);
                        crds[0] = crds[0] + offVec.x;
                        crds[1] = crds[1] + offVec.y;
                        crds[2] = crds[2] + offVec.x;
                        crds[3] = crds[3] + offVec.y;
                        crds[4] = crds[4] + offVec.x;
                        crds[5] = crds[5] + offVec.y;
                        return true;
                    }
                    Point2D.Double cp = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
                    double r = 0.5 * arc.getWidth();
                    r = arc.getAngleExtent() < 0.0 ? r - dist : r + dist;
                    Vector2D vsp = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[0], crds[1]).normalize();
                    vsp.scaleBy(r);
                    crds[0] = ((Point2D)cp).getX() + vsp.x;
                    crds[1] = ((Point2D)cp).getY() + vsp.y;
                    Vector2D vap = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[2], crds[3]).normalize();
                    vap.scaleBy(r);
                    crds[2] = ((Point2D)cp).getX() + vap.x;
                    crds[3] = ((Point2D)cp).getY() + vap.y;
                    Vector2D vep = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[4], crds[5]).normalize();
                    vep.scaleBy(r);
                    crds[4] = ((Point2D)cp).getX() + vep.x;
                    crds[5] = ((Point2D)cp).getY() + vep.y;
                    return true;
                }
                case 16: {
                    Vector2D offVec = new Vector2D(crds[0], crds[1], crds[4], crds[5]).left().normalize().scaleBy(dist);
                    crds[0] = crds[0] + offVec.x;
                    crds[1] = crds[1] + offVec.y;
                    crds[2] = crds[2] + offVec.x;
                    crds[3] = crds[3] + offVec.y;
                    crds[4] = crds[4] + offVec.x;
                    crds[5] = crds[5] + offVec.y;
                    return true;
                }
                case 32: {
                    Vector2D offVec = new Vector2D(crds[0], crds[1], crds[6], crds[7]).left().normalize().scaleBy(dist);
                    crds[0] = crds[0] + offVec.x;
                    crds[1] = crds[1] + offVec.y;
                    crds[2] = crds[2] + offVec.x;
                    crds[3] = crds[3] + offVec.y;
                    crds[4] = crds[4] + offVec.x;
                    crds[5] = crds[5] + offVec.y;
                    crds[6] = crds[6] + offVec.x;
                    crds[7] = crds[7] + offVec.y;
                    return true;
                }
            }
            throw new InternalError(Messages.getString("ext.mod.Offset.29"));
        }
        catch (NullVectorException e) {
            return false;
        }
    }

    private double signedOffset(Point2D pnt, Line2D line) {
        Vector2D vec;
        Point2D prjPnt = Geo2D.projection(pnt, line, new Point2D.Double());
        double dist = Geo2D.distance(prjPnt, pnt);
        Vector2D left = new Vector2D(line.getP1(), line.getP2()).left();
        double sign = left.getScalarProduct(vec = new Vector2D(prjPnt, pnt)) > 0.0 ? 1 : -1;
        return sign * dist;
    }

    private double signedOffset(Point2D pnt, Arc2D arc) {
        double r = 0.5 * arc.getWidth();
        double d = Geo2D.distance(arc.getCenterX(), arc.getCenterY(), pnt.getX(), pnt.getY());
        return arc.getAngleExtent() >= 0.0 ? d - r : r - d;
    }
}

