/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.bnd.BindingDimCtrlPoints;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentCircle2D;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Join
implements Cmd {
    private Set<Component> m_srcAccepted = new HashSet<Component>();
    private ComponentPath2D m_dst = null;
    private Set<BindingDoer> m_bindingDoers = new HashSet<BindingDoer>();
    private Set<BindingDimControlPointsDoer> m_bindingDimDoers = new HashSet<BindingDimControlPointsDoer>();
    private transient List<List<Segment>> m_curve = new ArrayList<List<Segment>>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        int nPaths = 0;
        for (Component comp : selSet) {
            if (!(comp instanceof ComponentLine2D) && !(comp instanceof ComponentArc2D) && !(comp instanceof ComponentCircle2D) && (!(comp instanceof ComponentPath2D) || ++nPaths <= 1)) continue;
            return true;
        }
        return false;
    }

    private boolean _accept(Component comp) {
        return comp instanceof CtrlSegments && (comp instanceof ComponentLine2D || comp instanceof ComponentArc2D || comp instanceof ComponentCircle2D || comp instanceof ComponentPath2D);
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        BindingModel<Component> bindingModel = db.getBindingModel();
        if (selSet.size() == 1) {
            for (Component comp : selSet) {
                if (!(comp instanceof ComponentPath2D)) continue;
                return;
            }
        }
        int maxNSegments = -1;
        Attributes attr = null;
        Layer layer = null;
        for (Component comp : selSet) {
            if (!this._accept(comp)) continue;
            this.m_srcAccepted.add(comp);
            CtrlSegments ctrlSegments = (CtrlSegments)comp;
            NamedListIterator<Point2D> namedListIterator = comp.controlPointIterator();
            double[] crds = new double[8];
            double[] moveto = new double[2];
            double[] lastto = new double[2];
            int nSegments = 0;
            block15: while (namedListIterator.hasNext()) {
                namedListIterator.next();
                ++nSegments;
                int name = namedListIterator.previousName();
                int type = ctrlSegments.getCtrlType(name);
                if ((type & 0xFC) == 0) continue;
                switch (ctrlSegments.getSegmentCrds(name, crds)) {
                    case 4: {
                        moveto[0] = crds[0];
                        moveto[1] = crds[1];
                        lastto[0] = crds[0];
                        lastto[1] = crds[1];
                        break;
                    }
                    case 8: {
                        this.addSegment(new Segment(comp, name, type, crds));
                        lastto[0] = crds[2];
                        lastto[1] = crds[3];
                        break;
                    }
                    case 16: 
                    case 64: {
                        this.addSegment(new Segment(comp, name, type, crds));
                        lastto[0] = crds[4];
                        lastto[1] = crds[5];
                        break;
                    }
                    case 32: {
                        this.addSegment(new Segment(comp, name, type, crds));
                        lastto[0] = crds[6];
                        lastto[1] = crds[7];
                        break;
                    }
                    case 128: {
                        if (Geo2D.equality(lastto[0], lastto[1], moveto[0], moveto[1])) continue block15;
                        crds[0] = lastto[0];
                        crds[1] = lastto[1];
                        crds[2] = moveto[0];
                        crds[3] = moveto[1];
                        this.addSegment(new Segment(null, -1, 8, crds));
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (nSegments <= maxNSegments) continue;
            maxNSegments = nSegments;
            attr = comp.getAttributes();
            layer = (Layer)layerMap.get(comp);
        }
        HashMap<Component, HashSet<Binding>> bindingCompsMap = new HashMap<Component, HashSet<Binding>>();
        Set comps = bindingModel.keySet();
        for (Component comp : comps) {
            Binding binding = (Binding)bindingModel.get(comp);
            Set bindingComps = binding.getBindingObjects();
            for (Component bindingComp : bindingComps) {
                if (!this.m_srcAccepted.contains(bindingComp)) continue;
                HashSet<Binding> bindings = (HashSet<Binding>)bindingCompsMap.get(bindingComp);
                if (bindings == null) {
                    bindings = new HashSet<Binding>();
                }
                bindings.add(binding);
                bindingCompsMap.put(bindingComp, bindings);
            }
        }
        ComponentPath2D path = new ComponentPath2D();
        for (List<Segment> list : this.m_curve) {
            if (list.size() == 0) continue;
            Point2D p = list.get(0).startPoint();
            path.moveTo(p.getX(), p.getY());
            double[] crds = new double[8];
            for (Segment seg : list) {
                Component oldComp = seg.getComponent();
                Set bindings = (Set)bindingCompsMap.get(oldComp);
                if (bindings != null) {
                    for (Binding binding : bindings) {
                        this.m_bindingDoers.add(new BindingDoer(binding, oldComp, path));
                    }
                }
                int newSegName = -1;
                seg.getCrds(crds);
                switch (seg.getType()) {
                    case 8: {
                        newSegName = path.lineTo(crds[2], crds[3]);
                        break;
                    }
                    case 64: {
                        newSegName = path.arcTo(crds[2], crds[3], crds[4], crds[5]);
                        break;
                    }
                    case 16: {
                        newSegName = path.quadTo(crds[2], crds[3], crds[4], crds[5]);
                        break;
                    }
                    case 32: {
                        newSegName = path.cubicTo(crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                if (bindings == null || newSegName == -1) continue;
                this.updateBindingDimCtrlPoints(seg, path, newSegName, bindings);
            }
        }
        if (path.isEmpty()) {
            System.out.println(Messages.getString("ext.mod.Join.0"));
            return;
        }
        if (attr != null) {
            path.setAttributes(attr);
        }
        this.m_dst = path;
        cmpSet.add(path);
        selSet.add(path);
        cmpSet.removeAll(this.m_srcAccepted);
        for (BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.doit();
        }
        for (BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.doit();
        }
        if (layer != null) {
            layerMap.put(path, layer);
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        cmpSet.remove(this.m_dst);
        cmpSet.addAll(this.m_srcAccepted);
        selSet.addAll(this.m_srcAccepted);
        for (BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.undoit();
        }
        for (BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.undoit();
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        cmpSet.add(this.m_dst);
        selSet.add(this.m_dst);
        cmpSet.removeAll(this.m_srcAccepted);
        for (BindingDoer bindingDoer : this.m_bindingDoers) {
            bindingDoer.doit();
        }
        for (BindingDimControlPointsDoer bindingDimControlPointsDoer : this.m_bindingDimDoers) {
            bindingDimControlPointsDoer.doit();
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_srcAccepted.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return String.valueOf(Messages.getString("ext.mod.Join.1")) + this.m_srcAccepted.size() + Messages.getString("ext.mod.Join.2");
    }

    private void addSegment(Segment seg) {
        if (seg.isNull()) {
            return;
        }
        Point2D segP1 = seg.startPoint();
        Point2D segP2 = seg.endPoint();
        int i = 0;
        while (i < this.m_curve.size()) {
            int nSegs;
            List<Segment> subcurve = this.m_curve.get(i);
            if (!this.isClosedSubcurve(subcurve) && (nSegs = subcurve.size()) > 0) {
                Point2D subcurveP1 = subcurve.get(0).startPoint();
                Point2D subcurveP2 = subcurve.get(nSegs - 1).endPoint();
                if (Geo2D.equality(segP2, subcurveP1)) {
                    subcurve.add(0, seg);
                    this.mergeSubCurve(i, true);
                    return;
                }
                if (Geo2D.equality(segP1, subcurveP1)) {
                    seg.reverseDirection();
                    subcurve.add(0, seg);
                    this.mergeSubCurve(i, true);
                    return;
                }
                if (Geo2D.equality(subcurveP2, segP1)) {
                    subcurve.add(seg);
                    this.mergeSubCurve(i, false);
                    return;
                }
                if (Geo2D.equality(subcurveP2, segP2)) {
                    seg.reverseDirection();
                    subcurve.add(seg);
                    this.mergeSubCurve(i, false);
                    return;
                }
            }
            ++i;
        }
        ArrayList<Segment> subcurve = new ArrayList<Segment>();
        subcurve.add(seg);
        this.m_curve.add(subcurve);
    }

    private void mergeSubCurve(int iSubCurve, boolean mergeAtStart) {
        Segment seg;
        List<Segment> subCurve = this.m_curve.get(iSubCurve);
        if (this.isClosedSubcurve(subCurve)) {
            return;
        }
        Point2D.Double mergePnt = new Point2D.Double();
        if (mergeAtStart) {
            seg = subCurve.get(0);
            mergePnt.setLocation(seg.startPoint());
        } else {
            seg = subCurve.get(subCurve.size() - 1);
            mergePnt.setLocation(seg.endPoint());
        }
        int i = 0;
        while (i < this.m_curve.size()) {
            if (i != iSubCurve) {
                List<Segment> otherSubCurve = this.m_curve.get(i);
                Segment startSeg = otherSubCurve.get(0);
                if (Geo2D.equality(mergePnt, startSeg.startPoint())) {
                    if (mergeAtStart) {
                        int j = 0;
                        while (j < otherSubCurve.size()) {
                            Segment _seg = otherSubCurve.get(j);
                            _seg.reverseDirection();
                            subCurve.add(0, _seg);
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < otherSubCurve.size()) {
                            subCurve.add(otherSubCurve.get(j));
                            ++j;
                        }
                    }
                    this.m_curve.remove(otherSubCurve);
                    return;
                }
                Segment endSeg = otherSubCurve.get(otherSubCurve.size() - 1);
                if (Geo2D.equality(mergePnt, endSeg.endPoint())) {
                    if (mergeAtStart) {
                        int j = 0;
                        while (j < subCurve.size()) {
                            otherSubCurve.add(subCurve.get(j));
                            ++j;
                        }
                    } else {
                        int j = subCurve.size() - 1;
                        while (j >= 0) {
                            Segment _seg = subCurve.get(j);
                            _seg.reverseDirection();
                            otherSubCurve.add(_seg);
                            --j;
                        }
                    }
                    this.m_curve.remove(subCurve);
                    return;
                }
            }
            ++i;
        }
    }

    private boolean isClosedSubcurve(List<Segment> subcurve) {
        if (subcurve.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Segment seg = subcurve.get(0);
        Point2D sp = seg.startPoint();
        seg = subcurve.get(subcurve.size() - 1);
        Point2D ep = seg.endPoint();
        return Geo2D.equality(sp, ep);
    }

    private void updateBindingDimCtrlPoints(Segment seg, Component newComp, int newSegName, Set<Binding<Component>> bindings) {
        for (Binding<Component> binding : bindings) {
            int i;
            int nPoints;
            CtrlSegments pathCtrlSegments;
            if (!(binding instanceof BindingDimCtrlPoints)) continue;
            BindingDimCtrlPoints dimBinding = (BindingDimCtrlPoints)binding;
            int bndName = dimBinding.getPointName1();
            if (dimBinding.getComponent1() == seg.getComponent() && bndName != -1) {
                pathCtrlSegments = (CtrlSegments)newComp;
                if (bndName == seg.getSegName()) {
                    this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, newSegName, true));
                } else if (bndName == seg.getVertex1Name()) {
                    this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentVertex1(newSegName), true));
                } else if (bndName == seg.getVertex2Name()) {
                    this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentVertex2(newSegName), true));
                } else {
                    nPoints = seg.getPointCount();
                    i = 0;
                    while (i < nPoints) {
                        if (bndName == seg.getPointNameAt(i)) {
                            this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentPointAt(newSegName, i), true));
                        }
                        ++i;
                    }
                }
            }
            bndName = dimBinding.getPointName2();
            if (dimBinding.getComponent2() != seg.getComponent() || bndName == -1) continue;
            pathCtrlSegments = (CtrlSegments)newComp;
            if (bndName == seg.getSegName()) {
                this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, newSegName, false));
                continue;
            }
            if (bndName == seg.getVertex1Name()) {
                this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentVertex1(newSegName), false));
                continue;
            }
            if (bndName == seg.getVertex2Name()) {
                this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentVertex2(newSegName), false));
                continue;
            }
            nPoints = seg.getPointCount();
            i = 0;
            while (i < nPoints) {
                if (bndName == seg.getPointNameAt(i)) {
                    this.m_bindingDimDoers.add(new BindingDimControlPointsDoer(dimBinding, seg.getComponent(), bndName, newComp, pathCtrlSegments.getSegmentPointAt(newSegName, i), false));
                }
                ++i;
            }
        }
    }

    public static class BindingDimControlPointsDoer {
        private BindingDimCtrlPoints m_binding;
        private Component m_src;
        private Component m_dst;
        private int m_srcName;
        private int m_dstName;
        private boolean m_first;

        public BindingDimControlPointsDoer(BindingDimCtrlPoints binding, Component src, int srcName, Component dst, int dstName, boolean first) {
            this.m_binding = binding;
            this.m_src = src;
            this.m_srcName = srcName;
            this.m_dst = dst;
            this.m_dstName = dstName;
            this.m_first = first;
        }

        public void undoit() {
            if (this.m_first) {
                this.m_binding.setBindingControlPoint1(this.m_src, this.m_srcName);
            } else {
                this.m_binding.setBindingControlPoint2(this.m_src, this.m_srcName);
            }
        }

        public void doit() {
            if (this.m_first) {
                this.m_binding.setBindingControlPoint1(this.m_dst, this.m_dstName);
            } else {
                this.m_binding.setBindingControlPoint2(this.m_dst, this.m_dstName);
            }
        }
    }

    public static class BindingDoer {
        private Binding<Component> m_binding;
        private Component m_src;
        private Component m_dst;

        public BindingDoer(Binding<Component> binding, Component src, Component dst) {
            this.m_binding = binding;
            this.m_src = src;
            this.m_dst = dst;
        }

        public void undoit() {
            Kernel krnl = Kernel.getInstance();
            Database db = krnl.getDatabase();
            BindingModel<Component> bindingModel = db.getBindingModel();
            this.m_binding.removeBindingObject(this.m_dst);
            bindingModel.addBindingObject(this.m_binding, this.m_src);
        }

        public void doit() {
            Kernel krnl = Kernel.getInstance();
            Database db = krnl.getDatabase();
            BindingModel<Component> bindingModel = db.getBindingModel();
            this.m_binding.removeBindingObject(this.m_src);
            bindingModel.addBindingObject(this.m_binding, this.m_dst);
        }
    }

    private class Segment {
        private Component m_comp;
        private int m_segName;
        private int m_type;
        private double[] m_crds = new double[8];
        private boolean m_hasReversedDirection = false;

        private Segment(Component comp, int segName, int type, double[] crds) {
            if (type != 8 && type != 16 && type != 32 && type != 64) {
                throw new IllegalArgumentException();
            }
            this.m_comp = comp;
            this.m_segName = segName;
            this.m_type = type;
            this.m_crds = new double[crds.length];
            int i = 0;
            while (i < crds.length) {
                this.m_crds[i] = crds[i];
                ++i;
            }
        }

        private Component getComponent() {
            return this.m_comp;
        }

        private int getSegName() {
            return this.m_segName;
        }

        private int getVertex1Name() {
            if (!(this.m_comp instanceof CtrlSegments)) {
                return -1;
            }
            CtrlSegments ctrlSegs = (CtrlSegments)this.m_comp;
            try {
                return !this.m_hasReversedDirection ? ctrlSegs.getSegmentVertex1(this.m_segName) : ctrlSegs.getSegmentVertex2(this.m_segName);
            }
            catch (UnsupportedOperationException e) {
                return -1;
            }
        }

        private int getVertex2Name() {
            if (!(this.m_comp instanceof CtrlSegments)) {
                return -1;
            }
            CtrlSegments ctrlSegs = (CtrlSegments)this.m_comp;
            try {
                return !this.m_hasReversedDirection ? ctrlSegs.getSegmentVertex2(this.m_segName) : ctrlSegs.getSegmentVertex1(this.m_segName);
            }
            catch (UnsupportedOperationException e) {
                return -1;
            }
        }

        private int getPointCount() {
            if (!(this.m_comp instanceof CtrlSegments)) {
                return -1;
            }
            CtrlSegments ctrlSegs = (CtrlSegments)this.m_comp;
            return ctrlSegs.getSegmentPointCount(this.m_segName);
        }

        private int getPointNameAt(int i) {
            if (!(this.m_comp instanceof CtrlSegments)) {
                return -1;
            }
            CtrlSegments ctrlSegs = (CtrlSegments)this.m_comp;
            return !this.m_hasReversedDirection ? ctrlSegs.getSegmentPointAt(this.m_segName, i) : ctrlSegs.getSegmentPointAt(this.m_segName, this.getPointCount() - 1 - i);
        }

        private int getType() {
            return this.m_type;
        }

        private void getCrds(double[] crds) {
            int i = 0;
            while (i < this.m_crds.length) {
                crds[i] = this.m_crds[i];
                ++i;
            }
        }

        private boolean isNull() {
            switch (this.m_type) {
                case 8: {
                    double dx = this.m_crds[2] - this.m_crds[0];
                    double dy = this.m_crds[3] - this.m_crds[1];
                    return Geo2D.getEpsSqr() > dx * dx + dy * dy;
                }
                case 16: 
                case 64: {
                    double dx = this.m_crds[4] - this.m_crds[0];
                    double dy = this.m_crds[5] - this.m_crds[1];
                    if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                        dx = this.m_crds[2] - this.m_crds[0];
                        dy = this.m_crds[3] - this.m_crds[1];
                        if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                            return true;
                        }
                        dx = this.m_crds[2] - this.m_crds[4];
                        dy = this.m_crds[3] - this.m_crds[5];
                        if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                            return true;
                        }
                    }
                    return false;
                }
                case 32: {
                    double dx = this.m_crds[6] - this.m_crds[0];
                    double dy = this.m_crds[7] - this.m_crds[1];
                    if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                        dx = this.m_crds[2] - this.m_crds[0];
                        dy = this.m_crds[3] - this.m_crds[1];
                        if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                            dx = this.m_crds[2] - this.m_crds[4];
                            dy = this.m_crds[3] - this.m_crds[5];
                            if (Geo2D.getEpsSqr() > dx * dx + dy * dy) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
            }
            throw new InternalError();
        }

        private Point2D startPoint() {
            return new Point2D.Double(this.m_crds[0], this.m_crds[1]);
        }

        private Point2D endPoint() {
            switch (this.m_type) {
                case 8: {
                    return new Point2D.Double(this.m_crds[2], this.m_crds[3]);
                }
                case 16: 
                case 64: {
                    return new Point2D.Double(this.m_crds[4], this.m_crds[5]);
                }
                case 32: {
                    return new Point2D.Double(this.m_crds[6], this.m_crds[7]);
                }
            }
            throw new InternalError();
        }

        private void reverseDirection() {
            this.m_hasReversedDirection = !this.m_hasReversedDirection;
            double[] _crds = new double[this.m_crds.length];
            int i = 0;
            while (i < this.m_crds.length) {
                _crds[i] = this.m_crds[i];
                ++i;
            }
            switch (this.m_type) {
                case 8: {
                    this.m_crds[0] = _crds[2];
                    this.m_crds[1] = _crds[3];
                    this.m_crds[2] = _crds[0];
                    this.m_crds[3] = _crds[1];
                    return;
                }
                case 16: 
                case 64: {
                    this.m_crds[0] = _crds[4];
                    this.m_crds[1] = _crds[5];
                    this.m_crds[4] = _crds[0];
                    this.m_crds[5] = _crds[1];
                    return;
                }
                case 32: {
                    this.m_crds[0] = _crds[6];
                    this.m_crds[1] = _crds[7];
                    this.m_crds[2] = _crds[4];
                    this.m_crds[3] = _crds[5];
                    this.m_crds[4] = _crds[2];
                    this.m_crds[5] = _crds[3];
                    this.m_crds[6] = _crds[0];
                    this.m_crds[7] = _crds[1];
                    return;
                }
            }
            throw new InternalError();
        }
    }
}

