/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.Mod;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import cib.util.geo.Geo2D;
import cib.util.geo.NoIntersectionException;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Fillet
extends UndoableCmd {
    private static double s_radius = 0.0;
    private int m_filletedCorners = 0;
    protected Component m_insertedComponent = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        int nEndVertices = 0;
        int nInnerVertices = 0;
        for (Component comp : selSet) {
            if (!mm.hasMarkedPrimitives(comp, 2) || !(comp instanceof CtrlSegments)) continue;
            CtrlSegments ctrlSeg = (CtrlSegments)comp;
            NamedListIterator<Point2D> pit = comp.controlPointIterator();
            while (pit.hasNext()) {
                pit.next();
                int index = pit.previousIndex();
                int name = pit.previousName();
                if (!mm.primitiveMarked(comp, 2, index) || ctrlSeg.getCtrlType(name) != 2) continue;
                int nSegs = ctrlSeg.getVertexSegmentCount(name);
                if (nSegs == 1) {
                    int segName = ctrlSeg.getVertexSegmentAt(name, 0);
                    int segType = ctrlSeg.getCtrlType(segName);
                    if (segType != 8 && segType != 64) continue;
                    ++nEndVertices;
                    continue;
                }
                if (nSegs != 2) continue;
                int segName0 = ctrlSeg.getVertexSegmentAt(name, 0);
                int segName1 = ctrlSeg.getVertexSegmentAt(name, 1);
                int segType0 = ctrlSeg.getCtrlType(segName0);
                int segType1 = ctrlSeg.getCtrlType(segName1);
                if (!(segType0 != 8 && segType0 != 64 || segType1 != 8 && segType1 != 64)) {
                    ++nInnerVertices;
                    continue;
                }
                if (segType0 == 4 && (segType1 == 8 || segType1 == 64)) {
                    ++nEndVertices;
                    continue;
                }
                if (segType1 != 4 || segType0 != 8 && segType0 != 64) continue;
                ++nEndVertices;
            }
        }
        return nInnerVertices > 0 || nEndVertices > 0 && nEndVertices % 2 == 0;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Point2D.Double pArc;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        double[] crds = new double[8];
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        ArrayList<Vertex> innerVertices = new ArrayList<Vertex>();
        if (!this._analyseSelectedVertices(endVertices, innerVertices, 72)) {
            return;
        }
        s_radius = krnl.getConstruction().distance2D(Messages.getString("ext.mod.Fillet.0"), s_radius);
        int nBadCorners = 0;
        int nUnsupportedCorners = 0;
        int i = 0;
        while (i < endVertices.size()) {
            Vertex vtx1 = (Vertex)endVertices.get(i);
            Vertex vtx2 = (Vertex)endVertices.get(i + 1);
            int seg1 = vtx1.extendableSegments.get(0);
            int seg2 = vtx2.extendableSegments.get(0);
            block0 : switch (vtx1.getCtrlSeg().getCtrlType(seg1)) {
                case 8: {
                    double t1;
                    if (8 != vtx1.getCtrlSeg().getSegmentCrds(seg1, crds)) {
                        throw new InternalError();
                    }
                    Line2D.Double l1 = new Line2D.Double();
                    if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex1(seg1)) {
                        ((Line2D)l1).setLine(crds[0], crds[1], crds[2], crds[3]);
                    } else if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex2(seg1)) {
                        ((Line2D)l1).setLine(crds[2], crds[3], crds[0], crds[1]);
                    } else {
                        throw new InternalError();
                    }
                    switch (vtx2.getCtrlSeg().getCtrlType(seg2)) {
                        case 8: {
                            if (8 != vtx2.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            Line2D.Double l2 = new Line2D.Double();
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex1(seg2)) {
                                ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                            } else if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                            } else {
                                throw new InternalError();
                            }
                            Point2D.Double spArc = new Point2D.Double();
                            pArc = new Point2D.Double();
                            Point2D.Double epArc = new Point2D.Double();
                            if (!this._calculateFilletingArc((Line2D)l1, l2, (Point2D)spArc, (Point2D)pArc, (Point2D)epArc)) {
                                ++nBadCorners;
                                break;
                            }
                            this._saveState(vtx1.comp);
                            vtx1.comp.setControlPointStarts();
                            vtx1.comp.setControlPoint(spArc, vtx1.name);
                            vtx1.comp.setControlPointEnds();
                            this._saveState(vtx2.comp);
                            vtx2.comp.setControlPointStarts();
                            vtx2.comp.setControlPoint(epArc, vtx2.name);
                            vtx2.comp.setControlPointEnds();
                            if (Double.isNaN(((Point2D)pArc).getX())) break block0;
                            ++this.m_filletedCorners;
                            if (vtx1.comp == vtx2.comp && vtx1.subPath == vtx2.subPath) {
                                int segNew = vtx2.getCtrlSeg().split(seg2);
                                vtx2.getCtrlSeg().setCtrlType(64, segNew);
                                crds[0] = ((Point2D)epArc).getX();
                                crds[1] = ((Point2D)epArc).getY();
                                crds[2] = ((Point2D)pArc).getX();
                                crds[3] = ((Point2D)pArc).getY();
                                crds[4] = ((Point2D)spArc).getX();
                                crds[5] = ((Point2D)spArc).getY();
                                vtx2.getCtrlSeg().setSegmentCrds(segNew, crds);
                                mm.clearChain(vtx2.comp, 2);
                                break;
                            }
                            this.m_insertedComponent = new ComponentArc2D(spArc, pArc, epArc);
                            cmpSet.add(this.m_insertedComponent);
                            selSet.add(this.m_insertedComponent);
                            break;
                        }
                        case 64: {
                            if (64 != vtx2.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            double[] a2 = new double[6];
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex1(seg2)) {
                                int j = 0;
                                while (j < a2.length) {
                                    a2[j] = crds[j];
                                    ++j;
                                }
                            } else if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                a2[0] = crds[4];
                                a2[1] = crds[5];
                                a2[2] = crds[2];
                                a2[3] = crds[3];
                                a2[4] = crds[0];
                                a2[5] = crds[1];
                            } else {
                                throw new InternalError();
                            }
                            Point2D.Double spArc = new Point2D.Double();
                            pArc = new Point2D.Double();
                            Point2D.Double epArc = new Point2D.Double();
                            if (!this._calculateFilletingArc((Line2D)l1, a2, (Point2D)spArc, (Point2D)pArc, (Point2D)epArc)) {
                                ++nBadCorners;
                                break;
                            }
                            this._saveState(vtx1.comp);
                            vtx1.comp.setControlPointStarts();
                            vtx1.comp.setControlPoint(spArc, vtx1.name);
                            vtx1.comp.setControlPointEnds();
                            this._saveState(vtx2.comp);
                            vtx2.comp.setControlPointStarts();
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                double t0 = a2[0];
                                t1 = a2[1];
                                a2[0] = a2[4];
                                a2[1] = a2[5];
                                a2[4] = t0;
                                a2[5] = t1;
                            }
                            vtx2.getCtrlSeg().setSegmentCrds(seg2, a2);
                            vtx2.comp.setControlPointEnds();
                            if (Double.isNaN(((Point2D)pArc).getX())) break block0;
                            ++this.m_filletedCorners;
                            if (vtx1.comp == vtx2.comp && vtx1.subPath == vtx2.subPath) {
                                int segNew = vtx2.getCtrlSeg().split(seg2);
                                vtx2.getCtrlSeg().setCtrlType(64, segNew);
                                crds[0] = ((Point2D)epArc).getX();
                                crds[1] = ((Point2D)epArc).getY();
                                crds[2] = ((Point2D)pArc).getX();
                                crds[3] = ((Point2D)pArc).getY();
                                crds[4] = ((Point2D)spArc).getX();
                                crds[5] = ((Point2D)spArc).getY();
                                vtx2.getCtrlSeg().setSegmentCrds(segNew, crds);
                                mm.clearChain(vtx2.comp, 2);
                                break;
                            }
                            this.m_insertedComponent = new ComponentArc2D(spArc, pArc, epArc);
                            cmpSet.add(this.m_insertedComponent);
                            selSet.add(this.m_insertedComponent);
                            break;
                        }
                        default: {
                            ++nUnsupportedCorners;
                            break;
                        }
                    }
                    break;
                }
                case 64: {
                    double t1;
                    if (64 != vtx1.getCtrlSeg().getSegmentCrds(seg1, crds)) {
                        throw new InternalError();
                    }
                    double[] a1 = new double[6];
                    if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex1(seg1)) {
                        int j = 0;
                        while (j < a1.length) {
                            a1[j] = crds[j];
                            ++j;
                        }
                    } else if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex2(seg1)) {
                        a1[0] = crds[4];
                        a1[1] = crds[5];
                        a1[2] = crds[2];
                        a1[3] = crds[3];
                        a1[4] = crds[0];
                        a1[5] = crds[1];
                    } else {
                        throw new InternalError();
                    }
                    switch (vtx2.getCtrlSeg().getCtrlType(seg2)) {
                        case 8: {
                            if (8 != vtx2.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            Line2D.Double l2 = new Line2D.Double();
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex1(seg2)) {
                                ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                            } else if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                            } else {
                                throw new InternalError();
                            }
                            Point2D.Double spArc = new Point2D.Double();
                            Point2D.Double pArc2 = new Point2D.Double();
                            Point2D.Double epArc = new Point2D.Double();
                            if (!this._calculateFilletingArc((Line2D)l2, a1, (Point2D)epArc, (Point2D)pArc2, (Point2D)spArc)) {
                                ++nBadCorners;
                                break;
                            }
                            this._saveState(vtx1.comp);
                            vtx1.comp.setControlPointStarts();
                            if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex2(seg1)) {
                                double t0 = a1[0];
                                t1 = a1[1];
                                a1[0] = a1[4];
                                a1[1] = a1[5];
                                a1[4] = t0;
                                a1[5] = t1;
                            }
                            vtx1.getCtrlSeg().setSegmentCrds(seg1, a1);
                            vtx1.comp.setControlPointEnds();
                            this._saveState(vtx2.comp);
                            vtx2.comp.setControlPointStarts();
                            vtx2.comp.setControlPoint(epArc, vtx2.name);
                            vtx2.comp.setControlPointEnds();
                            if (Double.isNaN(((Point2D)pArc2).getX())) break block0;
                            ++this.m_filletedCorners;
                            if (vtx1.comp == vtx2.comp && vtx1.subPath == vtx2.subPath) {
                                int segNew = vtx2.getCtrlSeg().split(seg2);
                                vtx2.getCtrlSeg().setCtrlType(64, segNew);
                                crds[0] = ((Point2D)epArc).getX();
                                crds[1] = ((Point2D)epArc).getY();
                                crds[2] = ((Point2D)pArc2).getX();
                                crds[3] = ((Point2D)pArc2).getY();
                                crds[4] = ((Point2D)spArc).getX();
                                crds[5] = ((Point2D)spArc).getY();
                                vtx2.getCtrlSeg().setSegmentCrds(segNew, crds);
                                mm.clearChain(vtx2.comp, 2);
                                break;
                            }
                            this.m_insertedComponent = new ComponentArc2D(spArc, pArc2, epArc);
                            cmpSet.add(this.m_insertedComponent);
                            selSet.add(this.m_insertedComponent);
                            break;
                        }
                        case 64: {
                            double t12;
                            if (64 != vtx2.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                throw new InternalError();
                            }
                            double[] a2 = new double[6];
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex1(seg2)) {
                                int j = 0;
                                while (j < a2.length) {
                                    a2[j] = crds[j];
                                    ++j;
                                }
                            } else if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                a2[0] = crds[4];
                                a2[1] = crds[5];
                                a2[2] = crds[2];
                                a2[3] = crds[3];
                                a2[4] = crds[0];
                                a2[5] = crds[1];
                            } else {
                                throw new InternalError();
                            }
                            Point2D.Double spArc = new Point2D.Double();
                            Point2D.Double pArc2 = new Point2D.Double();
                            Point2D.Double epArc = new Point2D.Double();
                            if (!this._calculateFilletingArc(a1, a2, (Point2D)spArc, (Point2D)pArc2, (Point2D)epArc)) {
                                ++nBadCorners;
                                break;
                            }
                            this._saveState(vtx1.comp);
                            vtx1.comp.setControlPointStarts();
                            if (vtx1.name == vtx1.getCtrlSeg().getSegmentVertex2(seg1)) {
                                double t0 = a1[0];
                                t12 = a1[1];
                                a1[0] = a1[4];
                                a1[1] = a1[5];
                                a1[4] = t0;
                                a1[5] = t12;
                            }
                            vtx1.getCtrlSeg().setSegmentCrds(seg1, a1);
                            vtx1.comp.setControlPointEnds();
                            this._saveState(vtx2.comp);
                            vtx2.comp.setControlPointStarts();
                            if (vtx2.name == vtx2.getCtrlSeg().getSegmentVertex2(seg2)) {
                                double t0 = a2[0];
                                t12 = a2[1];
                                a2[0] = a2[4];
                                a2[1] = a2[5];
                                a2[4] = t0;
                                a2[5] = t12;
                            }
                            vtx2.getCtrlSeg().setSegmentCrds(seg2, a2);
                            vtx2.comp.setControlPointEnds();
                            if (Double.isNaN(((Point2D)pArc2).getX())) break block0;
                            ++this.m_filletedCorners;
                            if (vtx1.comp == vtx2.comp && vtx1.subPath == vtx2.subPath) {
                                int segNew = vtx2.getCtrlSeg().split(seg2);
                                vtx2.getCtrlSeg().setCtrlType(64, segNew);
                                crds[0] = ((Point2D)epArc).getX();
                                crds[1] = ((Point2D)epArc).getY();
                                crds[2] = ((Point2D)pArc2).getX();
                                crds[3] = ((Point2D)pArc2).getY();
                                crds[4] = ((Point2D)spArc).getX();
                                crds[5] = ((Point2D)spArc).getY();
                                vtx2.getCtrlSeg().setSegmentCrds(segNew, crds);
                                mm.clearChain(vtx2.comp, 2);
                                break;
                            }
                            this.m_insertedComponent = new ComponentArc2D(spArc, pArc2, epArc);
                            cmpSet.add(this.m_insertedComponent);
                            selSet.add(this.m_insertedComponent);
                            break;
                        }
                        default: {
                            ++nUnsupportedCorners;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    ++nUnsupportedCorners;
                }
            }
            i += 2;
        }
        if (s_radius > Geo2D.getEps()) {
            for (Vertex vtx : innerVertices) {
                if (vtx.extendableSegments.size() != 2) continue;
                int seg1 = vtx.extendableSegments.get(0);
                int seg2 = vtx.extendableSegments.get(1);
                block12 : switch (vtx.getCtrlSeg().getCtrlType(seg1)) {
                    case 8: {
                        if (8 != vtx.getCtrlSeg().getSegmentCrds(seg1, crds)) {
                            throw new InternalError();
                        }
                        Line2D.Double l1 = new Line2D.Double();
                        if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg1)) {
                            ((Line2D)l1).setLine(crds[0], crds[1], crds[2], crds[3]);
                        } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                            ((Line2D)l1).setLine(crds[2], crds[3], crds[0], crds[1]);
                        } else {
                            throw new InternalError();
                        }
                        switch (vtx.getCtrlSeg().getCtrlType(seg2)) {
                            case 8: {
                                int segFillet;
                                if (8 != vtx.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                    throw new InternalError();
                                }
                                Line2D.Double l2 = new Line2D.Double();
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg2)) {
                                    ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg2)) {
                                    ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                                } else {
                                    throw new InternalError();
                                }
                                Point2D.Double spArc = new Point2D.Double();
                                Point2D.Double pArc3 = new Point2D.Double();
                                Point2D.Double epArc = new Point2D.Double();
                                if (!this._calculateFilletingArc((Line2D)l1, l2, (Point2D)spArc, (Point2D)pArc3, (Point2D)epArc)) {
                                    ++nBadCorners;
                                    break block12;
                                }
                                if (Double.isNaN(((Point2D)pArc3).getX())) {
                                    throw new InternalError();
                                }
                                this._saveState(vtx.comp);
                                int segNew = vtx.getCtrlSeg().split(seg1);
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                                    segFillet = seg1;
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(segNew)) {
                                    segFillet = segNew;
                                } else {
                                    throw new InternalError();
                                }
                                vtx.getCtrlSeg().setCtrlType(64, segFillet);
                                crds[0] = ((Point2D)spArc).getX();
                                crds[1] = ((Point2D)spArc).getY();
                                crds[2] = ((Point2D)pArc3).getX();
                                crds[3] = ((Point2D)pArc3).getY();
                                crds[4] = ((Point2D)epArc).getX();
                                crds[5] = ((Point2D)epArc).getY();
                                vtx.getCtrlSeg().setSegmentCrds(segFillet, crds);
                                ++this.m_filletedCorners;
                                mm.clearChain(vtx.comp, 2);
                                break block12;
                            }
                            case 64: {
                                int segFillet;
                                int segFirst;
                                if (64 != vtx.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                    throw new InternalError();
                                }
                                double[] a2 = new double[6];
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg2)) {
                                    int j = 0;
                                    while (j < a2.length) {
                                        a2[j] = crds[j];
                                        ++j;
                                    }
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg2)) {
                                    a2[0] = crds[4];
                                    a2[1] = crds[5];
                                    a2[2] = crds[2];
                                    a2[3] = crds[3];
                                    a2[4] = crds[0];
                                    a2[5] = crds[1];
                                } else {
                                    throw new InternalError();
                                }
                                Point2D.Double spArc = new Point2D.Double();
                                Point2D.Double pArc4 = new Point2D.Double();
                                Point2D.Double epArc = new Point2D.Double();
                                if (!this._calculateFilletingArc((Line2D)l1, a2, (Point2D)spArc, (Point2D)pArc4, (Point2D)epArc)) {
                                    ++nBadCorners;
                                    break block12;
                                }
                                if (Double.isNaN(((Point2D)pArc4).getX())) {
                                    throw new InternalError();
                                }
                                this._saveState(vtx.comp);
                                int segNew = vtx.getCtrlSeg().split(seg1);
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                                    segFirst = segNew;
                                    segFillet = seg1;
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(segNew)) {
                                    segFirst = seg1;
                                    segFillet = segNew;
                                } else {
                                    throw new InternalError();
                                }
                                vtx.comp.setControlPointStarts();
                                crds[0] = ((Line2D)l1).getX2();
                                crds[1] = ((Line2D)l1).getY2();
                                crds[2] = ((Line2D)l1).getX1();
                                crds[3] = ((Line2D)l1).getY1();
                                vtx.getCtrlSeg().setSegmentCrds(segFirst, crds);
                                vtx.getCtrlSeg().setCtrlType(64, segFillet);
                                crds[0] = ((Point2D)spArc).getX();
                                crds[1] = ((Point2D)spArc).getY();
                                crds[2] = ((Point2D)pArc4).getX();
                                crds[3] = ((Point2D)pArc4).getY();
                                crds[4] = ((Point2D)epArc).getX();
                                crds[5] = ((Point2D)epArc).getY();
                                vtx.getCtrlSeg().setSegmentCrds(segFillet, crds);
                                vtx.getCtrlSeg().setSegmentCrds(seg2, a2);
                                vtx.comp.setControlPointEnds();
                                ++this.m_filletedCorners;
                                mm.clearChain(vtx.comp, 2);
                                break block12;
                            }
                        }
                        ++nUnsupportedCorners;
                        break;
                    }
                    case 64: {
                        if (64 != vtx.getCtrlSeg().getSegmentCrds(seg1, crds)) {
                            throw new InternalError();
                        }
                        double[] a1 = new double[6];
                        if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg1)) {
                            int j = 0;
                            while (j < a1.length) {
                                a1[j] = crds[j];
                                ++j;
                            }
                        } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                            a1[0] = crds[4];
                            a1[1] = crds[5];
                            a1[2] = crds[2];
                            a1[3] = crds[3];
                            a1[4] = crds[0];
                            a1[5] = crds[1];
                        } else {
                            throw new InternalError();
                        }
                        switch (vtx.getCtrlSeg().getCtrlType(seg2)) {
                            case 8: {
                                int segFillet;
                                int segFirst;
                                if (8 != vtx.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                    throw new InternalError();
                                }
                                Line2D.Double l2 = new Line2D.Double();
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg2)) {
                                    ((Line2D)l2).setLine(crds[0], crds[1], crds[2], crds[3]);
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg2)) {
                                    ((Line2D)l2).setLine(crds[2], crds[3], crds[0], crds[1]);
                                } else {
                                    throw new InternalError();
                                }
                                Point2D.Double spArc = new Point2D.Double();
                                pArc = new Point2D.Double();
                                Point2D.Double epArc = new Point2D.Double();
                                if (!this._calculateFilletingArc((Line2D)l2, a1, (Point2D)spArc, (Point2D)pArc, (Point2D)epArc)) {
                                    ++nBadCorners;
                                    break block12;
                                }
                                if (Double.isNaN(((Point2D)pArc).getX())) {
                                    throw new InternalError();
                                }
                                this._saveState(vtx.comp);
                                int segNew = vtx.getCtrlSeg().split(seg1);
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                                    segFirst = segNew;
                                    segFillet = seg1;
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(segNew)) {
                                    segFirst = seg1;
                                    segFillet = segNew;
                                } else {
                                    throw new InternalError();
                                }
                                vtx.comp.setControlPointStarts();
                                crds[0] = a1[4];
                                crds[1] = a1[5];
                                crds[2] = a1[2];
                                crds[3] = a1[3];
                                crds[4] = a1[0];
                                crds[5] = a1[1];
                                vtx.getCtrlSeg().setSegmentCrds(segFirst, crds);
                                vtx.getCtrlSeg().setCtrlType(64, segFillet);
                                crds[0] = ((Point2D)epArc).getX();
                                crds[1] = ((Point2D)epArc).getY();
                                crds[2] = ((Point2D)pArc).getX();
                                crds[3] = ((Point2D)pArc).getY();
                                crds[4] = ((Point2D)spArc).getX();
                                crds[5] = ((Point2D)spArc).getY();
                                vtx.getCtrlSeg().setSegmentCrds(segFillet, crds);
                                crds[0] = ((Line2D)l2).getX1();
                                crds[1] = ((Line2D)l2).getY1();
                                crds[2] = ((Line2D)l2).getX2();
                                crds[3] = ((Line2D)l2).getY2();
                                vtx.getCtrlSeg().setSegmentCrds(seg2, crds);
                                vtx.comp.setControlPointEnds();
                                ++this.m_filletedCorners;
                                mm.clearChain(vtx.comp, 2);
                                break block12;
                            }
                            case 64: {
                                int segFillet;
                                int segFirst;
                                if (64 != vtx.getCtrlSeg().getSegmentCrds(seg2, crds)) {
                                    throw new InternalError();
                                }
                                double[] a2 = new double[6];
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex1(seg2)) {
                                    int j = 0;
                                    while (j < a2.length) {
                                        a2[j] = crds[j];
                                        ++j;
                                    }
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg2)) {
                                    a2[0] = crds[4];
                                    a2[1] = crds[5];
                                    a2[2] = crds[2];
                                    a2[3] = crds[3];
                                    a2[4] = crds[0];
                                    a2[5] = crds[1];
                                } else {
                                    throw new InternalError();
                                }
                                Point2D.Double spArc = new Point2D.Double();
                                pArc = new Point2D.Double();
                                Point2D.Double epArc = new Point2D.Double();
                                if (!this._calculateFilletingArc(a1, a2, (Point2D)spArc, (Point2D)pArc, (Point2D)epArc)) {
                                    ++nBadCorners;
                                    break block12;
                                }
                                if (Double.isNaN(((Point2D)pArc).getX())) {
                                    throw new InternalError();
                                }
                                this._saveState(vtx.comp);
                                int segNew = vtx.getCtrlSeg().split(seg1);
                                if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(seg1)) {
                                    segFirst = segNew;
                                    segFillet = seg1;
                                } else if (vtx.name == vtx.getCtrlSeg().getSegmentVertex2(segNew)) {
                                    segFirst = seg1;
                                    segFillet = segNew;
                                } else {
                                    throw new InternalError();
                                }
                                vtx.comp.setControlPointStarts();
                                crds[0] = a1[4];
                                crds[1] = a1[5];
                                crds[2] = a1[2];
                                crds[3] = a1[3];
                                crds[4] = a1[0];
                                crds[5] = a1[1];
                                vtx.getCtrlSeg().setSegmentCrds(segFirst, crds);
                                vtx.getCtrlSeg().setCtrlType(64, segFillet);
                                crds[0] = ((Point2D)spArc).getX();
                                crds[1] = ((Point2D)spArc).getY();
                                crds[2] = ((Point2D)pArc).getX();
                                crds[3] = ((Point2D)pArc).getY();
                                crds[4] = ((Point2D)epArc).getX();
                                crds[5] = ((Point2D)epArc).getY();
                                vtx.getCtrlSeg().setSegmentCrds(segFillet, crds);
                                vtx.getCtrlSeg().setSegmentCrds(seg2, a2);
                                vtx.comp.setControlPointEnds();
                                ++this.m_filletedCorners;
                                mm.clearChain(vtx.comp, 2);
                                break block12;
                            }
                        }
                        ++nUnsupportedCorners;
                        break;
                    }
                    default: {
                        ++nUnsupportedCorners;
                    }
                }
            }
        }
        String errMsg = null;
        if (nBadCorners != 0) {
            errMsg = String.valueOf(Messages.getString("ext.mod.Fillet.1")) + nBadCorners + Messages.getString("ext.mod.Fillet.2");
        }
        if (nUnsupportedCorners != 0) {
            String str = Messages.getString("ext.mod.Fillet.3");
            errMsg = errMsg == null ? str : String.valueOf(errMsg) + "\n" + str;
        }
        if (errMsg != null) {
            System.err.println(errMsg);
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_insertedComponent != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            cmpSet.remove(this.m_insertedComponent);
        }
        super.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_insertedComponent != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            ObservableSet<Component> selSet = db.getSelectSet();
            cmpSet.add(this.m_insertedComponent);
            selSet.add(this.m_insertedComponent);
        }
        super.redoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_insertedComponent != null || super.changesState();
    }

    @Override
    public boolean isUndoable() {
        return super.isUndoable();
    }

    public String toString() {
        return String.valueOf(Messages.getString("ext.mod.Fillet.5")) + this.m_filletedCorners + Messages.getString("ext.mod.Fillet.6");
    }

    protected boolean _analyseSelectedVertices(List<Vertex> endVertices, List<Vertex> innerVertices, int segmentFilter) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        double[] crds = new double[8];
        for (Component comp : cmpList) {
            if (!(comp instanceof CtrlSegments) || !selSet.contains(comp) || !mm.hasMarkedPrimitives(comp, 2)) continue;
            try {
                CtrlSegments ctrlSegments = (CtrlSegments)comp;
                int subPath = 0;
                NamedListIterator<Point2D> pit = comp.controlPointIterator();
                while (pit.hasNext()) {
                    pit.next();
                    int index = pit.previousIndex();
                    int name = pit.previousName();
                    if (ctrlSegments.getCtrlType(name) == 4) {
                        ++subPath;
                    }
                    if (!mm.primitiveMarked(comp, 2, index)) continue;
                    Vertex vtx = new Vertex(comp, name, subPath);
                    int nSegs = ctrlSegments.getVertexSegmentCount(name);
                    int i = 0;
                    while (i < nSegs) {
                        int segName = ctrlSegments.getVertexSegmentAt(name, i);
                        int segType = ctrlSegments.getSegmentCrds(segName, crds);
                        if ((segmentFilter & segType) != 0) {
                            vtx.extendableSegments.add(segName);
                        }
                        ++i;
                    }
                    if (vtx.extendableSegments.size() == 1) {
                        endVertices.add(vtx);
                        continue;
                    }
                    if (vtx.extendableSegments.size() != 2) continue;
                    innerVertices.add(vtx);
                }
            }
            catch (UnsupportedOperationException ctrlSegments) {
                // empty catch block
            }
        }
        if (endVertices.isEmpty() && innerVertices.isEmpty()) {
            System.err.println(Messages.getString("ext.mod.Fillet.7"));
            return false;
        }
        int i = 0;
        while (i < endVertices.size()) {
            Vertex vtx1 = endVertices.get(i);
            if (i + 1 >= endVertices.size()) {
                System.err.println(Messages.getString("ext.mod.Fillet.8"));
                return false;
            }
            Vertex vtx2 = endVertices.get(i + 1);
            if (vtx1.comp != vtx2.comp && vtx1.subPath != vtx2.subPath && i >= endVertices.size() - 1) {
                System.err.println(Messages.getString("ext.mod.Fillet.9"));
                return false;
            }
            i += 2;
        }
        return true;
    }

    private boolean _calculateFilletingArc(Line2D l1, Line2D l2, Point2D spArc, Point2D pArc, Point2D epArc) {
        Point2D.Double _epArc;
        Point2D.Double _pArc;
        Point2D.Double _spArc;
        block6: {
            block5: {
                Point2D iscPnt = Geo2D.intersection(l1, true, l2, true, new Point2D.Double());
                _spArc = new Point2D.Double(iscPnt.getX(), iscPnt.getY());
                _pArc = new Point2D.Double(Double.NaN, Double.NaN);
                _epArc = new Point2D.Double(iscPnt.getX(), iscPnt.getY());
                if (!(s_radius > Geo2D.getEps())) break block5;
                Point2D ep1 = l1.getP2();
                Point2D ep2 = l2.getP2();
                Vector2D iscLeft = new Vector2D(iscPnt, ep1).normalize();
                Vector2D iscRight = new Vector2D(iscPnt, ep2).normalize();
                Vector2D iscCtr = new Vector2D(iscLeft.x + iscRight.x, iscLeft.y + iscRight.y).normalize();
                double angle = iscLeft.getAngleSmallest(iscRight);
                double t = s_radius / Math.sin(0.5 * angle);
                iscCtr.scaleBy(t - s_radius);
                double s = s_radius / Math.tan(0.5 * angle);
                iscLeft.scaleBy(s);
                iscRight.scaleBy(s);
                ((Point2D)_spArc).setLocation(iscPnt.getX() + iscLeft.x, iscPnt.getY() + iscLeft.y);
                ((Point2D)_pArc).setLocation(iscPnt.getX() + iscCtr.x, iscPnt.getY() + iscCtr.y);
                ((Point2D)_epArc).setLocation(iscPnt.getX() + iscRight.x, iscPnt.getY() + iscRight.y);
                if (!Geo2D.equality(_spArc, _epArc)) break block5;
                return false;
            }
            Vector2D v = new Vector2D(l1.getP2(), l1.getP1());
            Vector2D w = new Vector2D(l1.getP1(), _spArc);
            double extent1 = w.length() * Math.signum(v.getScalarProduct(w));
            v = new Vector2D(l2.getP2(), l2.getP1());
            w = new Vector2D(l2.getP1(), _epArc);
            double extent2 = w.length() * Math.signum(v.getScalarProduct(w));
            if (!(Geo2D.length(l1) + extent1 < -Geo2D.getEps()) && !(Geo2D.length(l2) + extent2 < -Geo2D.getEps())) break block6;
            return false;
        }
        try {
            spArc.setLocation(_spArc);
            pArc.setLocation(_pArc);
            epArc.setLocation(_epArc);
            l1.setLine(_spArc, l1.getP2());
            l2.setLine(_epArc, l2.getP2());
            return true;
        }
        catch (NoIntersectionException e) {
            return false;
        }
        catch (NullVectorException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _calculateFilletingArc(Line2D l1, double[] a2, Point2D spArc, Point2D pArc, Point2D epArc) {
        try {
            Point2D.Double sp = new Point2D.Double(a2[0], a2[1]);
            Point2D.Double ap = new Point2D.Double(a2[2], a2[3]);
            Point2D.Double ep = new Point2D.Double(a2[4], a2[5]);
            Arc2D arc2 = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
            if (arc2 == null) {
                return this._calculateFilletingArc(l1, new Line2D.Double(sp, ep), spArc, pArc, epArc);
            }
            Ellipse2D cir2 = Geo2D.calculateEllipse2D(sp, ap, ep, new Ellipse2D.Double());
            if (!Geo2D.equality(l1.getP1(), sp) || !(s_radius > Geo2D.getEps())) {
                double ext;
                double[] dist;
                block27: {
                    Iterator<Point2D> it = Geo2D.intersection(l1, true, cir2);
                    dist = new double[4];
                    int i = 0;
                    while (true) {
                        if (i >= dist.length) {
                            if (it.hasNext()) {
                                Point2D iscPnt = it.next();
                                dist[0] = Fillet.calculateStartExtent(l1, iscPnt);
                                dist[1] = Fillet.calculateStartExtent(sp, ap, ep, iscPnt, true);
                            }
                            if (it.hasNext()) {
                                Point2D iscPnt = it.next();
                                dist[2] = Fillet.calculateStartExtent(l1, iscPnt);
                                dist[3] = Fillet.calculateStartExtent(sp, ap, ep, iscPnt, true);
                            }
                            if (!Double.isNaN(dist[0])) break;
                            dist[1] = Double.NaN;
                            break block27;
                        }
                        dist[i] = Double.NaN;
                        ++i;
                    }
                    if (Double.isNaN(dist[1])) {
                        dist[0] = Double.NaN;
                    }
                }
                if (Double.isNaN(dist[2])) {
                    dist[3] = Double.NaN;
                } else if (Double.isNaN(dist[3])) {
                    dist[2] = Double.NaN;
                }
                if (Math.abs(dist[0]) < Geo2D.getEps() && Math.abs(dist[1]) < Geo2D.getEps()) {
                    dist[0] = Double.NaN;
                    dist[1] = Double.NaN;
                }
                if (Math.abs(dist[2]) < Geo2D.getEps() && Math.abs(dist[3]) < Geo2D.getEps()) {
                    dist[2] = Double.NaN;
                    dist[3] = Double.NaN;
                }
                if (Double.isNaN(dist[0]) && Double.isNaN(dist[2])) {
                    return false;
                }
                if (!Double.isNaN(dist[0]) && !Double.isNaN(dist[2])) {
                    if (Math.abs(dist[0]) + Math.abs(dist[1]) < Math.abs(dist[2]) + Math.abs(dist[3])) {
                        dist[2] = Double.NaN;
                        dist[3] = Double.NaN;
                    } else {
                        dist[0] = Double.NaN;
                        dist[1] = Double.NaN;
                    }
                }
                double d = ext = Double.isNaN(dist[0]) ? dist[2] : dist[0];
                if (!Fillet.extendBy(l1, ext, 0.0)) {
                    return false;
                }
                double d2 = ext = Double.isNaN(dist[1]) ? dist[3] : dist[1];
                if (!Fillet.extendBy(sp, ap, ep, ext, 0.0)) {
                    return false;
                }
                a2[0] = ((Point2D)sp).getX();
                a2[1] = ((Point2D)sp).getY();
                a2[2] = ((Point2D)ap).getX();
                a2[3] = ((Point2D)ap).getY();
                a2[4] = ((Point2D)ep).getX();
                a2[5] = ((Point2D)ep).getY();
                spArc.setLocation(l1.getP1());
                pArc.setLocation(Double.NaN, Double.NaN);
                epArc.setLocation(sp);
            }
            if (!(s_radius > Geo2D.getEps())) return true;
            Point2D iscPnt = l1.getP1();
            Point2D[] ctrs = new Point2D[8];
            int nCircles = Geo2D.calculateTangentCircles(l1, cir2, s_radius, ctrs);
            int iCircle = -1;
            double minExt1 = Double.POSITIVE_INFINITY;
            Line2D l1Ext = null;
            double minExt2 = Double.POSITIVE_INFINITY;
            Point2D spExt = null;
            Point2D apExt = null;
            Point2D epExt = null;
            int i = 0;
            while (true) {
                block28: {
                    if (i >= nCircles) {
                        if (Double.isInfinite(minExt1)) return true;
                        if (!Geo2D.equality(l1.getP1(), spExt)) break;
                        return false;
                    }
                    Ellipse2D.Double tanCir = new Ellipse2D.Double();
                    double xc = ctrs[i].getX();
                    double yc = ctrs[i].getY();
                    tanCir.setFrameFromCenter(xc, yc, xc + s_radius, yc + s_radius);
                    try {
                        Iterator<Point2D> it1 = Geo2D.intersection(l1, (Ellipse2D)tanCir);
                        arc2 = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                        Iterator<Point2D> it2 = Geo2D.intersection((Ellipse2D)tanCir, arc2);
                        if (!it1.hasNext() || !it2.hasNext()) break block28;
                        Point2D p1 = it1.next();
                        Point2D p2 = it2.next();
                        double ext1 = Fillet.calculateStartExtent(l1, p1);
                        double ext2 = Fillet.calculateStartExtent(sp, ap, ep, p2, true);
                        if (Double.isNaN(ext1) || Double.isNaN(ext2) || !(Math.abs(ext1) + Math.abs(ext2) < Math.abs(minExt1) + Math.abs(minExt2))) break block28;
                        Line2D _l1 = (Line2D)l1.clone();
                        Point2D _sp = (Point2D)sp.clone();
                        Point2D _ap = (Point2D)ap.clone();
                        Point2D _ep = (Point2D)ep.clone();
                        if (Fillet.extendBy(_l1, ext1, 0.0) && Fillet.extendBy(_sp, _ap, _ep, ext2, 0.0)) {
                            iCircle = i;
                            minExt1 = ext1;
                            minExt2 = ext2;
                            l1Ext = _l1;
                            spExt = _sp;
                            apExt = _ap;
                            epExt = _ep;
                        }
                    }
                    catch (NoIntersectionException it1) {
                        // empty catch block
                    }
                }
                ++i;
            }
            l1.setLine(l1Ext);
            a2[0] = spExt.getX();
            a2[1] = spExt.getY();
            a2[2] = apExt.getX();
            a2[3] = apExt.getY();
            a2[4] = epExt.getX();
            a2[5] = epExt.getY();
            spArc.setLocation(l1.getP1());
            epArc.setLocation(spExt);
            double xc = ctrs[iCircle].getX();
            double yc = ctrs[iCircle].getY();
            Point2D.Double cp = new Point2D.Double(xc, yc);
            Vector2D cpIscPnt = new Vector2D(cp, iscPnt);
            cpIscPnt.normalize();
            cpIscPnt.scaleBy(s_radius);
            Point2D.Double pArc1 = new Point2D.Double(xc + cpIscPnt.x, yc + cpIscPnt.y);
            Point2D.Double pArc2 = new Point2D.Double(xc - cpIscPnt.x, yc - cpIscPnt.y);
            pArc.setLocation(Geo2D.distance((Point2D)pArc1, iscPnt) < Geo2D.distance((Point2D)pArc2, iscPnt) ? pArc1 : pArc2);
            return true;
        }
        catch (NoIntersectionException e) {
            return false;
        }
        catch (NullVectorException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _calculateFilletingArc(double[] a1, double[] a2, Point2D spArc, Point2D pArc, Point2D epArc) {
        try {
            Point2D.Double sp1 = new Point2D.Double(a1[0], a1[1]);
            Point2D.Double ap1 = new Point2D.Double(a1[2], a1[3]);
            Point2D.Double ep1 = new Point2D.Double(a1[4], a1[5]);
            Arc2D arc1 = Geo2D.calculateArc2D(sp1, ap1, ep1, new Arc2D.Double());
            Point2D.Double sp2 = new Point2D.Double(a2[0], a2[1]);
            Point2D.Double ap2 = new Point2D.Double(a2[2], a2[3]);
            Point2D.Double ep2 = new Point2D.Double(a2[4], a2[5]);
            Arc2D arc2 = Geo2D.calculateArc2D(sp2, ap2, ep2, new Arc2D.Double());
            if (arc1 == null && arc2 == null) {
                return this._calculateFilletingArc((Line2D)new Line2D.Double(sp1, ep1), new Line2D.Double(sp2, ep2), spArc, pArc, epArc);
            }
            if (arc1 == null) {
                return this._calculateFilletingArc((Line2D)new Line2D.Double(sp1, ep1), a2, spArc, pArc, epArc);
            }
            if (arc2 == null) {
                if (!this._calculateFilletingArc((Line2D)new Line2D.Double(sp2, ep2), a1, spArc, pArc, epArc)) return false;
                double tx = spArc.getX();
                double ty = spArc.getY();
                spArc.setLocation(epArc);
                epArc.setLocation(tx, ty);
                return false;
            }
            Ellipse2D cir1 = Geo2D.calculateEllipse2D(sp1, ap1, ep1, new Ellipse2D.Double());
            Ellipse2D cir2 = Geo2D.calculateEllipse2D(sp2, ap2, ep2, new Ellipse2D.Double());
            if (!Geo2D.equality(sp1, sp2) || !(s_radius > Geo2D.getEps())) {
                double ext;
                double[] dist;
                block30: {
                    Iterator<Point2D> it = Geo2D.intersection(cir1, cir2);
                    dist = new double[4];
                    int i = 0;
                    while (true) {
                        if (i >= dist.length) {
                            if (it.hasNext()) {
                                Point2D iscPnt = it.next();
                                dist[0] = Fillet.calculateStartExtent(sp1, ap1, ep1, iscPnt, true);
                                dist[1] = Fillet.calculateStartExtent(sp2, ap2, ep2, iscPnt, true);
                            }
                            if (it.hasNext()) {
                                Point2D iscPnt = it.next();
                                dist[2] = Fillet.calculateStartExtent(sp1, ap1, ep1, iscPnt, true);
                                dist[3] = Fillet.calculateStartExtent(sp2, ap2, ep2, iscPnt, true);
                            }
                            if (!Double.isNaN(dist[0])) break;
                            dist[1] = Double.NaN;
                            break block30;
                        }
                        dist[i] = Double.NaN;
                        ++i;
                    }
                    if (Double.isNaN(dist[1])) {
                        dist[0] = Double.NaN;
                    }
                }
                if (Double.isNaN(dist[2])) {
                    dist[3] = Double.NaN;
                } else if (Double.isNaN(dist[3])) {
                    dist[2] = Double.NaN;
                }
                if (Math.abs(dist[0]) < Geo2D.getEps() && Math.abs(dist[1]) < Geo2D.getEps()) {
                    dist[0] = Double.NaN;
                    dist[1] = Double.NaN;
                }
                if (Math.abs(dist[2]) < Geo2D.getEps() && Math.abs(dist[3]) < Geo2D.getEps()) {
                    dist[2] = Double.NaN;
                    dist[3] = Double.NaN;
                }
                if (Double.isNaN(dist[0]) && Double.isNaN(dist[2])) {
                    return false;
                }
                if (!Double.isNaN(dist[0]) && !Double.isNaN(dist[2])) {
                    if (Math.abs(dist[0]) + Math.abs(dist[1]) < Math.abs(dist[2]) + Math.abs(dist[3])) {
                        dist[2] = Double.NaN;
                        dist[3] = Double.NaN;
                    } else {
                        dist[0] = Double.NaN;
                        dist[1] = Double.NaN;
                    }
                }
                double d = ext = Double.isNaN(dist[0]) ? dist[2] : dist[0];
                if (!Fillet.extendBy(sp1, ap1, ep1, ext, 0.0)) {
                    return false;
                }
                double d2 = ext = Double.isNaN(dist[1]) ? dist[3] : dist[1];
                if (!Fillet.extendBy(sp2, ap2, ep2, ext, 0.0)) {
                    return false;
                }
                a1[0] = ((Point2D)sp1).getX();
                a1[1] = ((Point2D)sp1).getY();
                a1[2] = ((Point2D)ap1).getX();
                a1[3] = ((Point2D)ap1).getY();
                a1[4] = ((Point2D)ep1).getX();
                a1[5] = ((Point2D)ep1).getY();
                a2[0] = ((Point2D)sp2).getX();
                a2[1] = ((Point2D)sp2).getY();
                a2[2] = ((Point2D)ap2).getX();
                a2[3] = ((Point2D)ap2).getY();
                a2[4] = ((Point2D)ep2).getX();
                a2[5] = ((Point2D)ep2).getY();
                spArc.setLocation(sp1);
                pArc.setLocation(Double.NaN, Double.NaN);
                epArc.setLocation(sp2);
            }
            if (!(s_radius > Geo2D.getEps())) return true;
            Point2D.Double iscPnt = new Point2D.Double(((Point2D)sp1).getX(), ((Point2D)sp1).getY());
            Point2D[] ctrs = new Point2D[8];
            int nCircles = Geo2D.calculateTangentCircles(cir1, cir2, s_radius, ctrs);
            int iCircle = -1;
            double minExt1 = Double.POSITIVE_INFINITY;
            Point2D sp1Ext = null;
            Point2D ap1Ext = null;
            Point2D ep1Ext = null;
            double minExt2 = Double.POSITIVE_INFINITY;
            Point2D sp2Ext = null;
            Point2D ap2Ext = null;
            Point2D ep2Ext = null;
            int i = 0;
            while (true) {
                block31: {
                    if (i >= nCircles) {
                        if (Double.isInfinite(minExt1)) return true;
                        if (!Geo2D.equality(sp1Ext, sp2Ext)) break;
                        return false;
                    }
                    Ellipse2D.Double tanCir = new Ellipse2D.Double();
                    double xc = ctrs[i].getX();
                    double yc = ctrs[i].getY();
                    tanCir.setFrameFromCenter(xc, yc, xc + s_radius, yc + s_radius);
                    try {
                        arc1 = Geo2D.calculateArc2D(sp1, ap1, ep1, new Arc2D.Double());
                        Iterator<Point2D> it1 = Geo2D.intersection((Ellipse2D)tanCir, arc1);
                        arc2 = Geo2D.calculateArc2D(sp2, ap2, ep2, new Arc2D.Double());
                        Iterator<Point2D> it2 = Geo2D.intersection((Ellipse2D)tanCir, arc2);
                        if (!it1.hasNext() || !it2.hasNext()) break block31;
                        Point2D p1 = it1.next();
                        Point2D p2 = it2.next();
                        double ext1 = Fillet.calculateStartExtent(sp1, ap1, ep1, p1, true);
                        double ext2 = Fillet.calculateStartExtent(sp2, ap2, ep2, p2, true);
                        if (Double.isNaN(ext1) || Double.isNaN(ext2) || !(Math.abs(ext1) + Math.abs(ext2) < Math.abs(minExt1) + Math.abs(minExt2))) break block31;
                        Point2D _sp1 = (Point2D)sp1.clone();
                        Point2D _ap1 = (Point2D)ap1.clone();
                        Point2D _ep1 = (Point2D)ep1.clone();
                        Point2D _sp2 = (Point2D)sp2.clone();
                        Point2D _ap2 = (Point2D)ap2.clone();
                        Point2D _ep2 = (Point2D)ep2.clone();
                        if (Fillet.extendBy(_sp1, _ap1, _ep1, ext1, 0.0) && Fillet.extendBy(_sp2, _ap2, _ep2, ext2, 0.0)) {
                            iCircle = i;
                            minExt1 = ext1;
                            minExt2 = ext2;
                            sp1Ext = _sp1;
                            ap1Ext = _ap1;
                            ep1Ext = _ep1;
                            sp2Ext = _sp2;
                            ap2Ext = _ap2;
                            ep2Ext = _ep2;
                        }
                    }
                    catch (NoIntersectionException it1) {
                        // empty catch block
                    }
                }
                ++i;
            }
            a1[0] = sp1Ext.getX();
            a1[1] = sp1Ext.getY();
            a1[2] = ap1Ext.getX();
            a1[3] = ap1Ext.getY();
            a1[4] = ep1Ext.getX();
            a1[5] = ep1Ext.getY();
            a2[0] = sp2Ext.getX();
            a2[1] = sp2Ext.getY();
            a2[2] = ap2Ext.getX();
            a2[3] = ap2Ext.getY();
            a2[4] = ep2Ext.getX();
            a2[5] = ep2Ext.getY();
            spArc.setLocation(sp1Ext);
            epArc.setLocation(sp2Ext);
            double xc = ctrs[iCircle].getX();
            double yc = ctrs[iCircle].getY();
            Point2D.Double cp = new Point2D.Double(xc, yc);
            Vector2D cpIscPnt = new Vector2D(cp, iscPnt);
            cpIscPnt.normalize();
            cpIscPnt.scaleBy(s_radius);
            Point2D.Double pArc1 = new Point2D.Double(xc + cpIscPnt.x, yc + cpIscPnt.y);
            Point2D.Double pArc2 = new Point2D.Double(xc - cpIscPnt.x, yc - cpIscPnt.y);
            pArc.setLocation(Geo2D.distance((Point2D)pArc1, iscPnt) < Geo2D.distance((Point2D)pArc2, iscPnt) ? pArc1 : pArc2);
            return true;
        }
        catch (NoIntersectionException e) {
            return false;
        }
        catch (NullVectorException e) {
            return false;
        }
    }

    private static double calculateStartExtent(Line2D seg, Point2D pnt) {
        return Mod.calculateStartExtent(8, new double[]{seg.getX1(), seg.getY1(), seg.getX2(), seg.getY2()}, pnt, true);
    }

    private static double calculateStartExtent(Point2D sp, Point2D ap, Point2D ep, Point2D p, boolean ext) {
        return Mod.calculateStartExtent(64, new double[]{sp.getX(), sp.getY(), ap.getX(), ap.getY(), ep.getX(), ep.getY()}, p, ext);
    }

    private static boolean extendBy(Line2D l, double ext1, double ext2) {
        double[] crds = new double[]{l.getX1(), l.getY1(), l.getX2(), l.getY2()};
        boolean stat = Mod.extendBy(8, crds, ext1, ext2);
        l.setLine(crds[0], crds[1], crds[2], crds[3]);
        return stat;
    }

    private static boolean extendBy(Point2D sp, Point2D ap, Point2D ep, double ext1, double ext2) {
        double[] crds = new double[]{sp.getX(), sp.getY(), ap.getX(), ap.getY(), ep.getX(), ep.getY()};
        boolean stat = Mod.extendBy(64, crds, ext1, ext2);
        sp.setLocation(crds[0], crds[1]);
        ap.setLocation(crds[2], crds[3]);
        ep.setLocation(crds[4], crds[5]);
        return stat;
    }

    protected static class Vertex {
        protected Component comp;
        protected int name;
        protected int subPath;
        protected List<Integer> extendableSegments = new ArrayList<Integer>();

        protected Vertex(Component comp, int vtxName, int subPath) {
            if (!(comp instanceof CtrlSegments)) {
                throw new IllegalArgumentException();
            }
            this.comp = comp;
            this.name = vtxName;
            this.subPath = subPath;
        }

        protected CtrlSegments getCtrlSeg() {
            return (CtrlSegments)this.comp;
        }
    }
}

