/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.ext.mod.CloseGroup;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.util.ArrayList;
import java.util.List;

public class CloseAllGroups
implements Cmd {
    private List<CloseGroup> m_cmds = new ArrayList<CloseGroup>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        return krnl.getOpenGroupCount() > 0;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        while (krnl.getOpenGroupCount() > 0) {
            CloseGroup cmd = new CloseGroup();
            cmd.doCmd(context);
            this.m_cmds.add(cmd);
        }
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        int n = this.m_cmds.size();
        int i = n - 1;
        while (i >= 0) {
            this.m_cmds.get(i).undoCmd(context);
            --i;
        }
    }

    @Override
    public void redoCmd(Object context) {
        int n = this.m_cmds.size();
        int i = 0;
        while (i < n) {
            this.m_cmds.get(i).redoCmd(context);
            ++i;
        }
    }

    @Override
    public boolean changesState() {
        return !this.m_cmds.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public String toString() {
        return Messages.getString("ext.mod.CloseAllGroups.0");
    }
}

