/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentGroup;
import cib.cad.ext.dxf.DXFImporter;
import cib.cad.ext.dxf.ImportDXF;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.util.ComponentPlacementDialog;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.dxf.QuitDXFParserException;
import cib.util.dxf.interpreter.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ImportDXFGroup
implements Cmd {
    private ComponentGroup m_group = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        double mm = ImportDXF.mmPerNaturalUnit();
        File file = ImportDXF.openFileDialog();
        AttributeManager am = AttributeManager.getAttributeManager();
        Attributes defAttributes = am.getDefaultAttributes();
        Attributes groupAttributes = new Attributes();
        groupAttributes.setVisibility(defAttributes.getVisibility());
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        this.m_group = new ComponentGroup(1);
        cmpSet.add(this.m_group);
        this.m_group.setAttributes(groupAttributes);
        krnl.openGroup(this.m_group, true);
        DXFImporter importer = new DXFImporter();
        importer.setMillimetersPerNaturalUnit(mm);
        try {
            importer.importFromFile(file);
        }
        catch (IOException e) {
            krnl.closeGroup();
            cmpSet.remove(this.m_group);
            this.m_group = null;
            System.err.println(e.getLocalizedMessage());
            throw new CmdAbortedException();
        }
        catch (QuitDXFParserException e) {
            krnl.closeGroup();
            cmpSet.remove(this.m_group);
            this.m_group = null;
            System.err.println(e.getLocalizedMessage());
            throw new CmdAbortedException();
        }
        catch (ParseException e) {
            krnl.closeGroup();
            cmpSet.remove(this.m_group);
            this.m_group = null;
            System.err.println(e.getLocalizedMessage());
            throw new CmdAbortedException();
        }
        krnl.closeGroup();
        try {
            ComponentPlacementDialog dlg = new ComponentPlacementDialog(this.m_group);
            dlg.start();
        }
        catch (CmdAbortedException e) {
            cmpSet.remove(this.m_group);
            throw e;
        }
        Map<String, Integer> transferredElements = importer.getImportedInstanceCounts();
        int nTransferred = ImportDXF.entityCount(transferredElements);
        Map<String, Integer> notTransferredElements = importer.getUnimportableInstanceCounts();
        int nNotTransferred = ImportDXF.entityCount(notTransferredElements);
        this.m_toString = String.valueOf(Messages.getString("ext.dxf.ImportDXFGroup.10")) + nTransferred + Messages.getString("ext.dxf.ImportDXFGroup.11") + (nTransferred + nNotTransferred) + Messages.getString("ext.dxf.ImportDXFGroup.12");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_group);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_group);
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString != null ? this.m_toString : super.toString();
    }
}

