/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.util.dxf.ColorNumber;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.awt.Color;
import java.io.IOException;

public class ExportEntityHeader {
    private static final int MAX_LINEWEIGHT_ENUM = (int)Math.pow(2.0, 16.0) - 1;
    private String m_layer = "CADEMIA";
    protected Color m_color = null;
    private String m_linePatternName = null;
    private double m_lineWidthInMM = -1.0;
    private boolean m_isVisible = true;

    public void setLayer(String name) {
        if (name != null) {
            this.m_layer = name;
        }
    }

    public void setColor(Color c) {
        this.m_color = c;
    }

    public void setLineType(String name) {
        this.m_linePatternName = name;
    }

    public void setLineWidthInMM(double mm) {
        this.m_lineWidthInMM = mm;
    }

    public void setVisibility(boolean isVisible) {
        this.m_isVisible = isVisible;
    }

    public boolean commit(DXFWriter writer) throws IOException {
        writer.writeGroup(GroupCode.GC8, this.m_layer);
        if (this.m_color != null) {
            int red = this.m_color.getRed();
            int green = this.m_color.getGreen();
            int blue = this.m_color.getBlue();
            int colorNumber = -1;
            if (red == 0 && green == 0 && blue == 0) {
                colorNumber = 7;
            } else {
                int minDstSqr = 196608;
                int i = 1;
                while (i < 256) {
                    int db;
                    int dg;
                    String name = "COLOR_" + i;
                    Color color = ColorNumber.valueOf(name).toColor();
                    int dr = red - color.getRed();
                    int dstSqr = dr * dr + (dg = green - color.getGreen()) * dg + (db = blue - color.getBlue()) * db;
                    if (dstSqr < minDstSqr) {
                        colorNumber = i;
                        minDstSqr = dstSqr;
                    }
                    ++i;
                }
            }
            if (colorNumber > -1) {
                writer.writeGroup(GroupCode.GC62, colorNumber);
            }
        } else {
            writer.writeGroup(GroupCode.GC62, 0);
        }
        if (this.m_linePatternName != null) {
            writer.writeGroup(GroupCode.GC6, this.m_linePatternName);
        }
        int enumLineWidth = -1;
        if (this.m_lineWidthInMM >= 0.0 && this.m_lineWidthInMM <= (double)MAX_LINEWEIGHT_ENUM) {
            enumLineWidth = (int)(this.m_lineWidthInMM * 100.0);
        }
        writer.writeGroup(GroupCode.GC370, enumLineWidth);
        if (!this.m_isVisible) {
            writer.writeGroup(GroupCode.GC60, "1");
        }
        return true;
    }
}

