/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.coll.ReverseAccessMap;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelLayer {
    private Set<Listener> m_listeners = new HashSet<Listener>();
    private String m_prompt = Messages.getString("db.layer.SelLayer.0");
    protected Kernel m_krnl = null;
    private int m_input = -1;

    public SelLayer(Kernel krnl) {
        this.m_krnl = krnl;
    }

    public void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    public String getPrompt() {
        return this.m_prompt;
    }

    public void show() {
        String DEFAULT = "NULL_LAYER";
        String SYSTEM_NAME = String.valueOf(Messages.getString("db.layer.SelLayer.1")) + ": ";
        LayerManager lm = LayerManager.getLayerManager();
        final CmdLineDialog dlg = this.getUI().getCmdLineDialog();
        this.m_input = -1;
        dlg.setPrompt(this.m_prompt);
        dlg.setPromptHints(Messages.getString("db.layer.SelLayer.2"));
        dlg.enableTextInput();
        dlg.enableDigitize(-1);
        Set<String> layerNames = lm.getLayers();
        final HashMap<String, String> locLayerNameMap = new HashMap<String, String>();
        for (String name : layerNames) {
            if (name.equals("NULL_LAYER")) continue;
            locLayerNameMap.put(lm.getLocalizedLayerName(name), name);
        }
        ArrayList locLayerNames = new ArrayList(locLayerNameMap.keySet());
        Collections.sort(locLayerNames);
        final String locDefault = lm.getLocalizedLayerName("NULL_LAYER");
        dlg.setDefaultChoice(dlg.addChoice(locDefault));
        dlg.setChoiceHints(0, String.valueOf(SYSTEM_NAME) + "NULL_LAYER");
        dlg.setDefaultText(TextToken.stringToLiteral(""));
        if (!locLayerNames.isEmpty()) {
            dlg.addSeparator();
        }
        for (String locName : locLayerNames) {
            int iChoice = dlg.addChoice(locName);
            dlg.setChoiceHints(iChoice, String.valueOf(SYSTEM_NAME) + (String)locLayerNameMap.get(locName));
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String name) {
                if (!SelLayer.this.layerExists(name)) {
                    String locName = name;
                    String string = name = locName.equals(locDefault) ? "NULL_LAYER" : (String)locLayerNameMap.get(locName);
                }
                if (SelLayer.this.layerExists(name)) {
                    SelLayer.this.m_input = 0;
                    SelLayer.this.notifyLayerSelected(name);
                    return;
                }
                System.err.println(String.valueOf(name) + Messages.getString("db.layer.SelLayer.3"));
            }

            @Override
            public void choiceSelected(int iChoice) {
                SelLayer.this.m_input = 0;
                String locName = dlg.getChoiceAt(iChoice);
                String name = locName.equals(locDefault) ? "NULL_LAYER" : (String)locLayerNameMap.get(dlg.getChoiceAt(iChoice));
                SelLayer.this.notifyLayerSelected(name);
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
                Iterator<cib.cad.db.comp.Component> it = gp.objectIterator(pickBox, true);
                if (it.hasNext()) {
                    cib.cad.db.comp.Component c = it.next();
                    String name = SelLayer.this.extractLayerName(c);
                    SelLayer.this.m_input = 0;
                    SelLayer.this.notifyLayerSelected(name);
                    return;
                }
                System.err.println(Messages.getString("db.layer.SelLayer.4"));
            }

            @Override
            public void dialogAborted() {
                SelLayer.this.m_input = -1;
                SelLayer.this.notifyAborted();
            }
        });
        this._setCursor(true);
        this.getUI().showCmdLineDialog(dlg);
        if (this.m_input == 0 || this.m_input == -1) {
            this._setCursor(false);
            return;
        }
        this.show();
    }

    public void dispose() {
        this._setCursor(false);
        this.getUI().disposeCmdLineDialog();
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public Iterator<Listener> listenerIterator() {
        return this.m_listeners.iterator();
    }

    private void _setCursor(boolean on) {
        Cursor cursor = on ? Construction.getPickNearCursor() : Cursor.getPredefinedCursor(0);
        Iterator<GeometryPanel> it = this.getUI().geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    private void notifyLayerSelected(String name) {
        Iterator<Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = it.next();
            l.layerSelected(name);
        }
    }

    private void notifyAborted() {
        Iterator<Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = it.next();
            l.dialogAborted();
        }
    }

    private boolean layerExists(String name) {
        NameSpace nameSpace = this.m_krnl.getDatabase().getNameSpace();
        return nameSpace.getObject(name) instanceof Layer;
    }

    private String extractLayerName(cib.cad.db.comp.Component c) {
        ReverseAccessMap<cib.cad.db.comp.Component, Layer> layerMap = this.m_krnl.getDatabase().getLayerMap();
        Layer layer = (Layer)layerMap.get(c);
        NameSpace nameSpace = this.m_krnl.getDatabase().getNameSpace();
        return nameSpace.getName(layer);
    }

    private UserInterface getUI() {
        return this.m_krnl.getUserInterface();
    }

    public static interface Listener {
        public void layerSelected(String var1);

        public void dialogAborted();
    }
}

