/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.AddDINAttributes;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AddDINLayers
implements Cmd {
    private NameSpace m_nameSpace = null;
    private Set<Layer> m_layerSet = null;
    private boolean m_errors = false;
    private AddDINAttributes m_cmd = null;
    private String m_toString = null;
    private Map<String, Object[]> m_redefined = new HashMap<String, Object[]>();
    final String[] m_names = new String[]{"INTERSECTION", "EDGE_VISIBLE", "INTERSECTION_SMALL", "DIMENSIONING", "LEADER_LINE", "DETAIL", "EDGE_INVISIBLE", "SECTION_PLANE", "AXIS", "EDGE_DOTTED"};

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        this.m_nameSpace = db.getNameSpace();
        this.m_layerSet = db.getLayerSet();
        this.m_cmd = new AddDINAttributes();
        this.m_cmd.doCmd(context);
        this.addLayers();
        if (this.m_errors) {
            System.err.println(Messages.getString("db.layer.AddDINLayers.10"));
            throw new CmdAbortedException();
        }
        this.m_toString = Messages.getString("db.layer.AddDINLayers.11");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        int i = 0;
        while (i < this.m_names.length) {
            String name = this.m_names[i];
            if (this.m_nameSpace.containsName(name)) {
                Object o = this.m_nameSpace.getObject(name);
                if (o instanceof Layer) {
                    if (this.m_redefined.containsKey(name)) {
                        Layer l = (Layer)o;
                        l.setAttributes((Attributes)this.m_redefined.get(name)[1]);
                    } else {
                        this.m_layerSet.remove(o);
                        this.m_nameSpace.remove(o);
                    }
                } else {
                    System.err.println(Messages.getString("db.layer.AddDINLayers.12"));
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        this.m_cmd.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        this.m_cmd.redoCmd(context);
        this.addLayers();
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void addLayers() throws IllegalArgumentException {
        Attributes at1 = new Attributes();
        at1.setLineWidth("WIDTH_50");
        at1.setLinePattern("SOLID");
        at1.setDrawPaint("BLACK");
        at1.setFillPaint("LIGHT_GREY");
        at1.setFontFamily("ISO");
        at1.setTextSize("SIZE_35");
        this.addLayer(this.m_names[0], Messages.getString("db.layer.AddDINLayers.20"), at1);
        Attributes at2a = new Attributes();
        at2a.setLineWidth("WIDTH_35");
        at2a.setLinePattern("SOLID");
        at2a.setDrawPaint("BLACK");
        at2a.setFillPaint("DEFAULT");
        at2a.setFontFamily("ISO");
        at2a.setTextSize("SIZE_35");
        this.addLayer(this.m_names[1], Messages.getString("db.layer.AddDINLayers.26"), at2a);
        Attributes at2b = new Attributes();
        at2b.setLineWidth("WIDTH_35");
        at2b.setLinePattern("SOLID");
        at2b.setDrawPaint("BLACK");
        at2b.setFillPaint("BLACK");
        at2b.setFontFamily("ISO");
        at2b.setTextSize("SIZE_35");
        this.addLayer(this.m_names[2], Messages.getString("db.layer.AddDINLayers.33"), at2b);
        Attributes at3 = new Attributes();
        at3.setLineWidth("WIDTH_25");
        at3.setLinePattern("SOLID");
        at3.setDrawPaint("BLACK");
        at3.setFillPaint("DEFAULT");
        at3.setFontFamily("ISO");
        at3.setTextSize("SIZE_35");
        this.addLayer(this.m_names[3], Messages.getString("db.layer.AddDINLayers.40"), at3);
        this.addLayer(this.m_names[4], Messages.getString("db.layer.AddDINLayers.41"), at3);
        this.addLayer(this.m_names[5], Messages.getString("db.layer.AddDINLayers.42"), at3);
        Attributes at4 = new Attributes();
        at4.setLineWidth("WIDTH_35");
        at4.setLinePattern("DASHED");
        at4.setDrawPaint("BLACK");
        at4.setFillPaint("DEFAULT");
        at4.setFontFamily("ISO");
        at4.setTextSize("SIZE_35");
        this.addLayer(this.m_names[6], Messages.getString("db.layer.AddDINLayers.49"), at4);
        Attributes at5 = new Attributes();
        at5.setLineWidth("WIDTH_50");
        at5.setLinePattern("DOTTED_DASHED");
        at5.setDrawPaint("RED");
        at5.setFillPaint("DEFAULT");
        at5.setFontFamily("ISO");
        at5.setTextSize("SIZE_35");
        this.addLayer(this.m_names[7], Messages.getString("db.layer.AddDINLayers.56"), at5);
        Attributes at6 = new Attributes();
        at6.setLineWidth("WIDTH_25");
        at6.setLinePattern("DOTTED_DASHED");
        at6.setDrawPaint("RED");
        at6.setFillPaint("DEFAULT");
        at6.setFontFamily("ISO");
        at6.setTextSize("SIZE_35");
        this.addLayer(this.m_names[8], Messages.getString("db.layer.AddDINLayers.63"), at6);
        Attributes at7 = new Attributes();
        at7.setLineWidth("WIDTH_35");
        at7.setLinePattern("DOTTED");
        at7.setDrawPaint("BLACK");
        at7.setFillPaint("DEFAULT");
        at7.setFontFamily("ISO");
        at7.setTextSize("SIZE_35");
        this.addLayer(this.m_names[9], Messages.getString("db.layer.AddDINLayers.70"), at7);
    }

    private void addLayer(String name, String semantics, Attributes at) {
        Layer layer = null;
        if (this.m_nameSpace.containsName(name)) {
            Object obj = this.m_nameSpace.getObject(name);
            if (!(obj instanceof Layer)) {
                System.err.println(String.valueOf(Messages.getString("db.layer.AddDINLayers.71")) + name);
                this.m_errors = true;
                return;
            }
            layer = (Layer)obj;
            this.m_redefined.put(name, new Object[]{layer.getAttributes()});
            System.out.println(String.valueOf(Messages.getString("db.layer.AddDINLayers.72")) + name + Messages.getString("db.layer.AddDINLayers.73"));
        } else {
            layer = new Layer();
            this.m_nameSpace.put(layer, name);
        }
        layer.setAttributes(at);
        this.m_layerSet.add(layer);
    }
}

