/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.FeatureAdapter;
import cib.cad.kernel.CmdLineToken;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.util.List;

public class Vector2DFeature
extends FeatureAdapter {
    private static final long serialVersionUID = 1L;

    public Vector2DFeature(String name) {
        this(name, new Vector2D());
    }

    public Vector2DFeature(String name, Vector2D v) {
        super(name);
        this.m_value = v;
    }

    public Vector2D getVector2D() {
        Vector2D vec = (Vector2D)this.m_value;
        return (Vector2D)vec.clone();
    }

    public double getX() {
        Vector2D vec = (Vector2D)this.m_value;
        return vec.getX();
    }

    public double getY() {
        Vector2D vec = (Vector2D)this.m_value;
        return vec.getY();
    }

    public void setVector2D(Vector2D v) {
        Vector2D vec = (Vector2D)this.m_value;
        vec.setLocation(v);
    }

    public void setVector2D(double x, double y) {
        Vector2D vec = (Vector2D)this.m_value;
        vec.setLocation(x, y);
    }

    public void fromString(String value) {
        List<CmdLineToken> tokens = s_tokenizer.getTokens(value);
        if (tokens.size() < 2) {
            throw new IllegalArgumentException();
        }
        String str = tokens.get(0).toString();
        double x = s_interpreter.getNumber(str).doubleValue();
        str = tokens.get(1).toString();
        double y = s_interpreter.getNumber(str).doubleValue();
        this.m_value = new Vector2D(x, y);
    }

    @Override
    public String valueToString() {
        Vector2D v = (Vector2D)this.m_value;
        return String.valueOf(Geo2D.formatCoordinate(v.getX())) + " " + Geo2D.formatCoordinate(v.getY());
    }

    @Override
    public Object clone() {
        Vector2DFeature dst = (Vector2DFeature)super.clone();
        dst.m_value = ((Vector2D)this.m_value).clone();
        return dst;
    }
}

