/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.FeatureAdapter;
import cib.cad.kernel.CmdLineToken;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;
import java.util.List;

public class Point2DFeature
extends FeatureAdapter {
    private static final long serialVersionUID = 1L;

    public Point2DFeature(String name) {
        this(name, new Point2D.Double());
    }

    public Point2DFeature(String name, Point2D p) {
        super(name);
        this.m_value = p.clone();
    }

    public Point2D getPoint2D() {
        Point2D pnt = (Point2D)this.m_value;
        return (Point2D)pnt.clone();
    }

    public double getX() {
        Point2D pnt = (Point2D)this.m_value;
        return pnt.getX();
    }

    public double getY() {
        Point2D pnt = (Point2D)this.m_value;
        return pnt.getY();
    }

    public void setPoint2D(Point2D p) {
        Point2D pnt = (Point2D)this.m_value;
        pnt.setLocation(p);
    }

    public void setPoint2D(double x, double y) {
        Point2D pnt = (Point2D)this.m_value;
        pnt.setLocation(x, y);
    }

    @Override
    public void valueFromString(String value) {
        List<CmdLineToken> tokens = s_tokenizer.getTokens(value);
        if (tokens.size() < 2) {
            throw new IllegalArgumentException();
        }
        String str = tokens.get(0).toString();
        double x = s_interpreter.getNumber(str).doubleValue();
        str = tokens.get(1).toString();
        double y = s_interpreter.getNumber(str).doubleValue();
        this.m_value = new Point2D.Double(x, y);
    }

    @Override
    public String valueToString() {
        Point2D p = (Point2D)this.m_value;
        return String.valueOf(Geo2D.formatCoordinate(p.getX())) + " " + Geo2D.formatCoordinate(p.getY());
    }

    @Override
    public Object clone() {
        Point2DFeature dst = (Point2DFeature)super.clone();
        dst.m_value = ((Point2D)this.m_value).clone();
        return dst;
    }
}

