/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.Feature;
import cib.cad.kernel.interpreter.DefaultArgumentTokenizer;
import cib.cad.kernel.interpreter.DefaultNumberInterpreter;
import cib.util.geo.Geo2D;
import java.io.Serializable;

public class FeatureAdapter
implements Feature,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static DefaultArgumentTokenizer s_tokenizer = new DefaultArgumentTokenizer(System.in);
    protected static DefaultNumberInterpreter s_interpreter = new DefaultNumberInterpreter(System.in);
    private String m_name = null;
    protected Object m_value = null;
    private boolean m_isChangeable = true;

    protected FeatureAdapter(String name) {
        this(name, "");
    }

    protected FeatureAdapter(String name, String value) {
        this.m_name = name;
        this.m_value = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureAdapter)) {
            return false;
        }
        FeatureAdapter fa = (FeatureAdapter)obj;
        return this.m_name.equals(fa.m_name) && this.m_value.equals(fa.m_value);
    }

    public int hashCode() {
        return this.m_name.hashCode() + this.m_value.hashCode();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public String getName() {
        if (this.m_name == null) {
            throw new UnsupportedOperationException();
        }
        return this.m_name;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public void setChangeable(boolean changeable) {
        this.m_isChangeable = changeable;
    }

    @Override
    public boolean isChangeable() {
        return this.m_isChangeable;
    }

    @Override
    public void valueFromString(String value) {
        this.m_value = value;
    }

    @Override
    public String valueToString() {
        if (this.m_value == null) {
            return "null";
        }
        if (this.m_value instanceof Double) {
            double x = (Double)this.m_value;
            return Geo2D.formatDouble(x);
        }
        return this.m_value.toString();
    }

    @Override
    public String localizedValueToString() {
        return this.valueToString();
    }
}

