/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.FeatureAdapter;
import cib.util.geo.Geo2D;

public class AngleFeature
extends FeatureAdapter {
    private static final long serialVersionUID = 1L;

    public AngleFeature(String name) {
        this(name, 0.0);
    }

    public AngleFeature(String name, double angle) {
        super(name);
        this.m_value = new Double(angle);
    }

    public double getAngle() {
        return (Double)this.m_value;
    }

    public void setAngle(double value) {
        this.m_value = new Double(value);
    }

    @Override
    public void valueFromString(String value) {
        double ang = s_interpreter.getNumber(value).doubleValue();
        ang = Math.toRadians(ang);
        this.m_value = new Double(ang);
    }

    @Override
    public String valueToString() {
        double ang = (Double)this.m_value;
        ang = Math.toDegrees(ang);
        String str = Geo2D.formatDegrees(ang);
        return str;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

