/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.geo.Geo2D;
import cib.util.view.FillPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class _AttributeNamespaces
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int UNCHANGED = 0;
    public static final int WAS_ADDED = 1;
    public static final int WAS_REMOVED = 2;
    public static final int WAS_CHANGED = 3;
    private Map<String, Double> ns_lineWidth = new HashMap<String, Double>();
    private Map<String, double[]> ns_linePattern = new HashMap<String, double[]>();
    private Map<String, Paint> ns_drawPaint = new HashMap<String, Paint>();
    private Map<String, Paint> ns_fillPaint = new HashMap<String, Paint>();
    private Map<String, String> ns_fontFamily = new HashMap<String, String>();
    private Map<String, Double> ns_textSize = new HashMap<String, Double>();
    private Map<String, Boolean> ns_visibility = new HashMap<String, Boolean>();
    private Map<String, Boolean> ns_mutability = new HashMap<String, Boolean>();
    private static _AttributeNamespaces m_ns = null;

    private _AttributeNamespaces() {
        this.addLineWidth("DEFAULT", 0.0);
        this.addLinePattern("DEFAULT", null);
        this.addDrawPaint("DEFAULT", Color.BLACK);
        this.addFillPaint("DEFAULT", null);
        this.addFontFamily("DEFAULT", new String("sansserif"));
        this.addTextSize("DEFAULT", 3.5);
        this.addVisibility("DEFAULT", true);
        this.addMutability("DEFAULT", true);
        m_ns = this;
    }

    protected static _AttributeNamespaces getNamespaces() {
        if (m_ns == null) {
            new _AttributeNamespaces();
            return _AttributeNamespaces.getNamespaces();
        }
        return m_ns;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ns_visibility == null) {
            this.ns_visibility = new HashMap<String, Boolean>();
            this.addVisibility("DEFAULT", true);
        }
        if (this.ns_mutability == null) {
            this.ns_mutability = new HashMap<String, Boolean>();
            this.addMutability("DEFAULT", true);
        }
        m_ns = this;
    }

    public int addLineWidth(String name, double lineWidth) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.11"));
        }
        if (lineWidth < -Geo2D.getEps()) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("db.att._AttributeNamespaces.12")) + lineWidth + Messages.getString("db.att._AttributeNamespaces.13"));
        }
        if (this.ns_lineWidth.containsKey(name)) {
            this.ns_lineWidth.put(name, new Double(lineWidth));
            return 3;
        }
        this.ns_lineWidth.put(name, new Double(lineWidth));
        return 1;
    }

    public double getLineWidth(String name) {
        if (name == null) {
            return 0.0;
        }
        if (this.ns_lineWidth.containsKey(name)) {
            return this.ns_lineWidth.get(name);
        }
        return 0.0;
    }

    public Set<String> getLineWidths() {
        return this.ns_lineWidth.keySet();
    }

    public int removeLineWidth(String name) {
        this.ns_lineWidth.remove(name);
        return 2;
    }

    public boolean containsLineWidth(String name) {
        return this.ns_lineWidth.containsKey(name);
    }

    public String getLocalizedLineWidthName(String name) {
        String key = "db.att.Attribute.LineWidth.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public int addLinePattern(String name, double[] linePattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.16"));
        }
        if (this.ns_linePattern.containsKey(name)) {
            this.ns_linePattern.put(name, linePattern);
            return 3;
        }
        this.ns_linePattern.put(name, linePattern);
        return 1;
    }

    public double[] getLinePattern(String name) {
        if (name == null) {
            return null;
        }
        if (this.ns_linePattern.containsKey(name)) {
            return this.ns_linePattern.get(name);
        }
        return null;
    }

    public Set<String> getLinePatterns() {
        return this.ns_linePattern.keySet();
    }

    public int removeLinePattern(String name) {
        this.ns_linePattern.remove(name);
        return 2;
    }

    public boolean containsLinePattern(String name) {
        return this.ns_linePattern.containsKey(name);
    }

    public Stroke getModelStroke(String width, String pattern) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        float paperToModel = (float)(this.getScale() / cs.getMillimetersPerNaturalUnit());
        float lw = (float)this.getLineWidth(width);
        float[] lp = null;
        if (this.getLinePattern(pattern) != null) {
            int l = this.getLinePattern(pattern).length;
            lp = new float[l];
            int i = 0;
            while (i < l) {
                lp[i] = (float)this.getLinePattern(pattern)[i] * paperToModel;
                ++i;
            }
        }
        return new BasicStroke(lw * paperToModel, 1, 1, 0.0f * paperToModel, lp, 0.0f * paperToModel);
    }

    public String getLocalizedLinePatternName(String name) {
        String key = "db.att.Attribute.LinePattern.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public int addDrawPaint(String name, Paint drawPaint) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.19"));
        }
        if (this.ns_drawPaint.containsKey(name)) {
            this.ns_drawPaint.put(name, drawPaint);
            return 3;
        }
        this.ns_drawPaint.put(name, drawPaint);
        return 1;
    }

    public Paint getDrawPaint(String name) {
        if (name == null) {
            return Color.BLACK;
        }
        if (this.ns_drawPaint.containsKey(name)) {
            return this.ns_drawPaint.get(name);
        }
        return Color.BLACK;
    }

    public Set<String> getDrawPaints() {
        return this.ns_drawPaint.keySet();
    }

    public int removeDrawPaint(String name) {
        this.ns_drawPaint.remove(name);
        return 2;
    }

    public boolean containsDrawPaint(String name) {
        return this.ns_drawPaint.containsKey(name);
    }

    public String getLocalizedDrawPaintName(String name) {
        String key = "db.att.Attribute.DrawPaint.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public Paint getModelFillPaint(String paint) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double paperToModel = this.getScale() / cs.getMillimetersPerNaturalUnit();
        Paint fp = this.getFillPaint(paint);
        if (fp instanceof FillPaint) {
            ((FillPaint)fp).setPaperToModel(paperToModel);
        }
        return fp;
    }

    public int addFillPaint(String name, Paint fillPaint) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.22"));
        }
        if (this.ns_fillPaint.containsKey(name)) {
            this.ns_fillPaint.put(name, fillPaint);
            return 3;
        }
        this.ns_fillPaint.put(name, fillPaint);
        return 1;
    }

    public Paint getFillPaint(String name) {
        if (name == null) {
            return null;
        }
        if (this.ns_fillPaint.containsKey(name)) {
            return this.ns_fillPaint.get(name);
        }
        return null;
    }

    public Set<String> getFillPaints() {
        return this.ns_fillPaint.keySet();
    }

    public int removeFillPaint(String name) {
        this.ns_fillPaint.remove(name);
        return 2;
    }

    public boolean containsFillPaint(String name) {
        return this.ns_fillPaint.containsKey(name);
    }

    public String getLocalizedFillPaintName(String name) {
        String key = "db.att.Attribute.FillPaint.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public int addFontFamily(String name, String fontFamily) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.25"));
        }
        if (!this.fontFamilyDefined(fontFamily)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("db.att._AttributeNamespaces.26")) + fontFamily + Messages.getString("db.att._AttributeNamespaces.27"));
        }
        if (this.ns_fontFamily.containsKey(name)) {
            this.ns_fontFamily.put(name, fontFamily);
            return 3;
        }
        this.ns_fontFamily.put(name, fontFamily);
        return 1;
    }

    public boolean fontFamilyDefined(String name) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFontFamily(String name) {
        if (name == null) {
            return "sansserif";
        }
        if (this.ns_fontFamily.containsKey(name)) {
            return this.ns_fontFamily.get(name);
        }
        return "sansserif";
    }

    public Set<String> getFontFamilies() {
        return this.ns_fontFamily.keySet();
    }

    public int removeFontFamily(String name) {
        this.ns_fontFamily.remove(name);
        return 2;
    }

    public boolean containsFontFamily(String name) {
        return this.ns_fontFamily.containsKey(name);
    }

    public String getLocalizedFontFamilyName(String name) {
        String key = "db.att.Attribute.FontFamily.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public double getModelTextSize(String textSize) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double PT_PER_IN = 72.0;
        double IN_PER_M = 39.37;
        double M_TO_PT = 2834.64;
        return this.getTextSize(textSize) * 2834.64 * this.getScale() / cs.getMillimetersPerNaturalUnit();
    }

    public int addTextSize(String name, double textSize) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.31"));
        }
        if (textSize < Geo2D.getEps()) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("db.att._AttributeNamespaces.32")) + textSize + Messages.getString("db.att._AttributeNamespaces.33"));
        }
        if (this.ns_textSize.containsKey(name)) {
            this.ns_textSize.put(name, new Double(textSize));
            return 3;
        }
        this.ns_textSize.put(name, new Double(textSize));
        return 1;
    }

    public double getTextSize(String name) {
        if (name == null) {
            return 3.5;
        }
        if (this.ns_textSize.containsKey(name)) {
            return this.ns_textSize.get(name);
        }
        return 3.5;
    }

    public Set<String> getTextSizes() {
        return this.ns_textSize.keySet();
    }

    public int removeTextSize(String name) {
        this.ns_textSize.remove(name);
        return 2;
    }

    public boolean containsTextSize(String name) {
        return this.ns_textSize.containsKey(name);
    }

    public String getLocalizedTextSizeName(String name) {
        String key = "db.att.Attribute.TextSize.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public int addVisibility(String name, boolean visible) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.36"));
        }
        if (this.ns_visibility.containsKey(name)) {
            this.ns_visibility.put(name, new Boolean(visible));
            return 3;
        }
        this.ns_visibility.put(name, new Boolean(visible));
        return 1;
    }

    public boolean getVisibility(String name) {
        if (name == null) {
            return true;
        }
        if (this.ns_visibility.containsKey(name)) {
            return this.ns_visibility.get(name);
        }
        return true;
    }

    public Set<String> getVisibilities() {
        return this.ns_visibility.keySet();
    }

    public int removeVisibility(String name) {
        this.ns_visibility.remove(name);
        return 2;
    }

    public boolean containsVisibility(String name) {
        return this.ns_visibility.containsKey(name);
    }

    public String getLocalizedVisibilityName(String name) {
        String key = "db.att.Attribute.Visibility.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public int addMutability(String name, boolean modifiable) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(10) > 0) {
            throw new IllegalArgumentException(Messages.getString("db.att._AttributeNamespaces.39"));
        }
        if (this.ns_mutability.containsKey(name)) {
            this.ns_mutability.put(name, new Boolean(modifiable));
            return 3;
        }
        this.ns_mutability.put(name, new Boolean(modifiable));
        return 1;
    }

    public boolean getMutability(String name) {
        if (name == null) {
            return true;
        }
        if (this.ns_mutability.containsKey(name)) {
            return this.ns_mutability.get(name);
        }
        return true;
    }

    public Set<String> getMutabilities() {
        return this.ns_mutability.keySet();
    }

    public int removeMutability(String name) {
        this.ns_mutability.remove(name);
        return 2;
    }

    public boolean containsMutability(String name) {
        return this.ns_mutability.containsKey(name);
    }

    public String getLocalizedMutabilityName(String name) {
        String key = "db.att.Attribute.Mutability.Name." + name;
        String locName = Messages.getString(key);
        return locName.startsWith("!") && !Messages.containsKey(key) ? name : locName;
    }

    public String toString() {
        return String.valueOf(Messages.getString("db.att._AttributeNamespaces.42")) + this.ns_lineWidth.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.43") + Messages.getString("db.att._AttributeNamespaces.44") + this.ns_linePattern.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.45") + Messages.getString("db.att._AttributeNamespaces.46") + this.ns_drawPaint.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.47") + Messages.getString("db.att._AttributeNamespaces.48") + this.ns_fillPaint.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.49") + Messages.getString("db.att._AttributeNamespaces.50") + this.ns_fontFamily.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.51") + Messages.getString("db.att._AttributeNamespaces.52") + this.ns_textSize.keySet().toString() + Messages.getString("db.att._AttributeNamespaces.53") + Messages.getString("db.att._AttributeNamespaces.54") + this.ns_visibility.keySet().toString();
    }

    private double getScale() {
        return CoordSpace.getCoordSpace().getScale();
    }
}

