/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class SelObject {
    private Set<Listener> m_listeners = new HashSet<Listener>();
    private String m_prompt = Messages.getString("db.att.SelObject.0");
    protected Kernel m_krnl = null;
    private int m_input = -1;

    public SelObject(Kernel krnl) {
        this.m_krnl = krnl;
    }

    public void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    public String getPrompt() {
        return this.m_prompt;
    }

    protected abstract Map<String, String> locNameMap();

    protected abstract String locDefaultName();

    protected abstract boolean attributeExists(String var1);

    protected abstract String extractAttribute(cib.cad.db.comp.Component var1);

    public void show() {
        String DEFAULT = "DEFAULT";
        String SYSTEM_NAME = String.valueOf(Messages.getString("db.att.SelObject.2")) + ": ";
        final CmdLineDialog dlg = this.getUI().getCmdLineDialog();
        this.m_input = -1;
        dlg.setPrompt(this.m_prompt);
        dlg.setPromptHints(Messages.getString("db.att.SelObject.4"));
        dlg.enableTextInput();
        dlg.enableDigitize(-1);
        final Map<String, String> locNameMap = this.locNameMap();
        ArrayList<String> locNameList = new ArrayList<String>(locNameMap.keySet());
        Collections.sort(locNameList);
        final String defaultText = this.locDefaultName();
        dlg.setDefaultChoice(dlg.addChoice(defaultText));
        dlg.setChoiceHints(0, String.valueOf(SYSTEM_NAME) + "DEFAULT");
        dlg.setDefaultText(TextToken.stringToLiteral(""));
        if (!locNameList.isEmpty()) {
            dlg.addSeparator();
        }
        for (String locName : locNameList) {
            int iChoice = dlg.addChoice(locName);
            dlg.setChoiceHints(iChoice, String.valueOf(SYSTEM_NAME) + locNameMap.get(locName));
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String name) {
                if (!SelObject.this.attributeExists(name)) {
                    String locName = name;
                    String string = name = locName.equals(defaultText) ? "DEFAULT" : (String)locNameMap.get(locName);
                }
                if (SelObject.this.attributeExists(name)) {
                    SelObject.this.m_input = 0;
                    SelObject.this.notifyAttributeSelected(name);
                    return;
                }
                System.err.println(Messages.getString("db.att.SelObject.6"));
            }

            @Override
            public void choiceSelected(int iChoice) {
                SelObject.this.m_input = 0;
                String name = iChoice == 0 ? "DEFAULT" : (String)locNameMap.get(dlg.getChoiceAt(iChoice));
                SelObject.this.notifyAttributeSelected(name);
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
                Iterator<cib.cad.db.comp.Component> it = gp.objectIterator(pickBox, true);
                if (it.hasNext()) {
                    cib.cad.db.comp.Component c = it.next();
                    String dp = SelObject.this.extractAttribute(c);
                    SelObject.this.m_input = 0;
                    SelObject.this.notifyAttributeSelected(dp);
                    return;
                }
                System.err.println(Messages.getString("db.att.SelObject.7"));
            }

            @Override
            public void dialogAborted() {
                SelObject.this.m_input = -1;
                SelObject.this.notifyAborted();
            }
        });
        this._setCursor(true);
        this.getUI().showCmdLineDialog(dlg);
        if (this.m_input == 0 || this.m_input == -1) {
            this._setCursor(false);
            return;
        }
        this.show();
    }

    public void dispose() {
        this._setCursor(false);
        this.getUI().disposeCmdLineDialog();
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public Iterator<Listener> listenerIterator() {
        return this.m_listeners.iterator();
    }

    protected void _setCursor(boolean on) {
        Cursor cursor = on ? Construction.getPickNearCursor() : Cursor.getPredefinedCursor(0);
        Iterator<GeometryPanel> it = this.getUI().geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    protected void notifyAttributeSelected(String attr) {
        Iterator<Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = it.next();
            l.attributeSelected(attr);
        }
    }

    protected void notifyAborted() {
        Iterator<Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = it.next();
            l.dialogAborted();
        }
    }

    protected UserInterface getUI() {
        return this.m_krnl.getUserInterface();
    }

    public static interface Listener {
        public void attributeSelected(String var1);

        public void dialogAborted();
    }
}

