/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.AttributeSelectors;
import cib.cad.db.att.Attributes;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class ModifyDefaultAttributes
implements Cmd {
    private Attributes m_svDefAttribute = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        AttributeManager atm = db.getAttributeManager();
        this.m_svDefAttribute = atm.getDefaultAttributes();
        AttributeSelectors ats = AttributeSelectors.getSelectors(krnl);
        Attributes at = new Attributes();
        at.setLineWidth(ats.lineWidth());
        at.setLinePattern(ats.linePattern());
        at.setDrawPaint(ats.drawPaint());
        at.setFillPaint(ats.fillPaint());
        at.setFontFamily(ats.fontFamily());
        at.setTextSize(ats.textSize());
        at.setVisibility(ats.visibility());
        atm.setDefaultAttributes(at);
        this.m_toString = String.valueOf(Messages.getString("db.att.ModifyDefaultAttributes.0")) + atm.getDefaultAttributes().toString() + Messages.getString("db.att.ModifyDefaultAttributes.1");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        AttributeManager atm = db.getAttributeManager();
        Attributes att = atm.getDefaultAttributes();
        atm.setDefaultAttributes(this.m_svDefAttribute);
        this.m_svDefAttribute = att;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

