/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.SelDrawPaint;
import cib.cad.db.att.SelFillPaint;
import cib.cad.db.att.SelFontFamily;
import cib.cad.db.att.SelLinePattern;
import cib.cad.db.att.SelLineWidth;
import cib.cad.db.att.SelObject;
import cib.cad.db.att.SelTextSize;
import cib.cad.db.att.SelVisibility;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;

public class AttributeSelectors {
    private static AttributeSelectors s_instance = null;
    private Kernel m_krnl;
    private String m_attr = null;
    private boolean m_aborted = false;

    private AttributeSelectors(Kernel krnl) {
        if (s_instance == null) {
            s_instance = this;
        }
        this.m_krnl = krnl;
    }

    public static AttributeSelectors getSelectors(Kernel krnl) {
        if (s_instance == null) {
            new AttributeSelectors(krnl);
        }
        return s_instance;
    }

    public String drawPaint() throws CmdAbortedException {
        return this.drawPaint(Messages.getString("db.att.AttributeSelectors.0"));
    }

    public String drawPaint(String prompt) throws CmdAbortedException {
        SelDrawPaint selDrawPaint = new SelDrawPaint(this.m_krnl);
        selDrawPaint.setPrompt(prompt);
        return this._getAttribute(selDrawPaint);
    }

    public String fillPaint() throws CmdAbortedException {
        return this.fillPaint(Messages.getString("db.att.AttributeSelectors.1"));
    }

    public String fillPaint(String prompt) throws CmdAbortedException {
        SelFillPaint selFillPaint = new SelFillPaint(this.m_krnl);
        selFillPaint.setPrompt(prompt);
        return this._getAttribute(selFillPaint);
    }

    public String fontFamily() throws CmdAbortedException {
        return this.fontFamily(Messages.getString("db.att.AttributeSelectors.2"));
    }

    public String fontFamily(String prompt) throws CmdAbortedException {
        SelFontFamily selFontFamily = new SelFontFamily(this.m_krnl);
        selFontFamily.setPrompt(prompt);
        return this._getAttribute(selFontFamily);
    }

    public String linePattern() throws CmdAbortedException {
        return this.linePattern(Messages.getString("db.att.AttributeSelectors.3"));
    }

    public String linePattern(String prompt) throws CmdAbortedException {
        SelLinePattern selLinePattern = new SelLinePattern(this.m_krnl);
        selLinePattern.setPrompt(prompt);
        return this._getAttribute(selLinePattern);
    }

    public String lineWidth() throws CmdAbortedException {
        return this.lineWidth(Messages.getString("db.att.AttributeSelectors.4"));
    }

    public String lineWidth(String prompt) throws CmdAbortedException {
        SelLineWidth selLineWidth = new SelLineWidth(this.m_krnl);
        selLineWidth.setPrompt(prompt);
        return this._getAttribute(selLineWidth);
    }

    public String textSize() throws CmdAbortedException {
        return this.textSize(Messages.getString("db.att.AttributeSelectors.5"));
    }

    public String textSize(String prompt) throws CmdAbortedException {
        SelTextSize selTextSize = new SelTextSize(this.m_krnl);
        selTextSize.setPrompt(prompt);
        return this._getAttribute(selTextSize);
    }

    public String visibility() throws CmdAbortedException {
        return this.visibility(Messages.getString("db.att.AttributeSelectors.6"));
    }

    public String visibility(String prompt) throws CmdAbortedException {
        SelVisibility selVisibility = new SelVisibility(this.m_krnl);
        selVisibility.setPrompt(prompt);
        return this._getAttribute(selVisibility);
    }

    private String _getAttribute(final SelObject selObj) throws CmdAbortedException {
        selObj.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                AttributeSelectors.this.m_attr = attr;
                AttributeSelectors.this.m_aborted = false;
                selObj.dispose();
            }

            @Override
            public void dialogAborted() {
                AttributeSelectors.this.m_aborted = true;
                selObj.dispose();
            }
        });
        selObj.show();
        if (this.m_aborted) {
            throw new CmdAbortedException();
        }
        return this.m_attr;
    }
}

