/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db;

import cib.cad.Instance;
import cib.cad.db.BindingManager;
import cib.cad.db.MarkerMap;
import cib.cad.db.UpdateManager;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.bnd.BindingDimCtrlPoints;
import cib.cad.db.cnct.ConnectDimCtrlPoints;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentDimSingle;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.db.layer.LayerSet;
import cib.util.CoordSpace;
import cib.util.Dbg;
import cib.util.NameSpace;
import cib.util.binding.BindingModel;
import cib.util.binding.DefaultBindingModel;
import cib.util.coll.CollUtilities;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.coll.SwappableList;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Database
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String m_version = Instance.VERSION_STRING;
    private NameSpace m_nameSpace;
    private CoordSpace m_coordSpace;
    private ObservableSet<Component> m_componentSet;
    private SwappableList<Component> m_componentListView;
    private ObservableSet<Component> m_selectSet;
    private MarkerMap m_markerMap;
    private UpdateManager m_updateManager = null;
    private LayerSet m_layerSet;
    private ReverseAccessMap<Component, Layer> m_layerMap;
    private AttributeManager m_attributeManager;
    private BindingModel<Component> m_bindingModel;
    private transient BindingManager t_bindingManager;
    private transient Group t_openGroup = null;
    private transient ObservableSet<Component> t_componentSet = null;
    private transient BindingModel<Component> t_bindingModel = null;
    private transient SwappableList<Component> t_componentListView = null;
    private transient ObservableSet<Component> t_selectSet = null;
    private transient MarkerMap t_markerMap = null;
    private transient ComponentSetListener t_componentSetListener = new ComponentSetListener();

    public Database() {
        this.m_nameSpace = new NameSpace();
        this.m_coordSpace = CoordSpace.getCoordSpace();
        this.m_componentSet = CollUtilities.observableSet(CollUtilities.namedElementsSet(new HashSet(), this.m_nameSpace));
        this.m_componentListView = CollUtilities.orderedSet(this.m_componentSet);
        this.m_selectSet = CollUtilities.observableSet(CollUtilities.subSet(new HashSet(), this.m_componentSet));
        this.m_markerMap = new MarkerMap(this.m_componentSet, this.m_selectSet);
        this.m_bindingModel = new DefaultBindingModel<Component>();
        this.m_layerSet = LayerManager.createLayerSet(CollUtilities.observableSet(new HashSet()));
        if (this.m_nameSpace.containsName("NULL_LAYER")) {
            Object obj = this.m_nameSpace.getObject("NULL_LAYER");
            if (obj instanceof Layer) {
                this.m_nameSpace.remove(obj);
            } else {
                throw new IllegalStateException();
            }
        }
        this.m_nameSpace.put(this.m_layerSet.getNullLayer(), "NULL_LAYER");
        this.m_layerMap = LayerManager.createLayerMap(this.m_layerSet, CollUtilities.reverseAccessMap(new HashMap()));
        new LayerManager(this);
        this._init(this.m_componentSet, this.m_bindingModel, this.m_selectSet, this.m_componentListView, this.m_markerMap);
    }

    public void openGroup(Group group) {
        if (this.t_openGroup != null && this.t_componentSet != null) {
            Iterator<ObservableSet.Listener<Component>> it = this.t_componentSet.listenerIterator();
            while (it.hasNext()) {
                ObservableSet.Listener<Component> l = it.next();
                String className = l.getClass().getName();
                if (!className.startsWith("cib.cad.db.Database$") && !className.startsWith("cib.cad.db.MarkerMap$") && !className.startsWith("cib.util.coll._SubSet$")) continue;
                it.remove();
            }
        }
        this.t_openGroup = group;
        if (group == null) {
            this._init(this.m_componentSet, this.m_bindingModel, this.m_selectSet, this.m_componentListView, this.m_markerMap);
        } else {
            ObservableSet<Component> cmpSet = group.getComponentSet();
            BindingModel<Component> bindingModel = group.getBindingModel();
            SwappableList<Component> cmpList = group.getComponentList();
            ObservableSet<Component> selSet = CollUtilities.observableSet(CollUtilities.subSet(new HashSet(), cmpSet));
            MarkerMap markerMap = new MarkerMap(cmpSet, selSet);
            this._init(cmpSet, bindingModel, selSet, cmpList, markerMap);
        }
    }

    private void _init(ObservableSet<Component> cmpSet, BindingModel<Component> bindingModel, ObservableSet<Component> selSet, SwappableList<Component> componentListView, MarkerMap markerMap) {
        ObservableSet.Listener<Component> l;
        Iterator<ObservableSet.Listener<Component>> it;
        if (this.t_componentSet != null) {
            it = this.t_componentSet.listenerIterator();
            while (it.hasNext()) {
                l = it.next();
                if (!(l instanceof ComponentSetListener)) continue;
                it.remove();
            }
        }
        it = cmpSet.listenerIterator();
        while (it.hasNext()) {
            l = it.next();
            if (!(l instanceof ComponentSetListener)) continue;
            it.remove();
        }
        this.t_componentSet = cmpSet;
        this.t_componentSet.addListener(this.t_componentSetListener);
        this.t_componentListView = componentListView;
        this.t_selectSet = selSet;
        this.t_markerMap = markerMap;
        this.t_bindingModel = bindingModel;
        this.t_bindingManager = new BindingManager(cmpSet, bindingModel);
        this.m_attributeManager = AttributeManager.getAttributeManager();
        this.m_attributeManager.setComponentSet(this.t_componentSet);
        if (Dbg.on()) {
            System.out.println("Database.init(): component set listeners");
            it = this.t_componentSet.listenerIterator();
            int i = 0;
            while (it.hasNext()) {
                ObservableSet.Listener<Component> l2 = it.next();
                System.out.println("\t" + i++ + ": " + l2.getClass().getName());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_componentSet.getObservedSet() == null) {
            System.out.println("Nested database encountered in readObject()...");
            return;
        }
        this.t_componentSetListener = new ComponentSetListener();
        Iterator<ObservableSet.Listener<Component>> it = this.m_componentSet.listenerIterator();
        while (it.hasNext()) {
            ObservableSet.Listener<Component> l = it.next();
            String clsName = l.getClass().getName();
            if (!clsName.startsWith("cib.cad.db.UpdateManager")) continue;
            it.remove();
        }
        this.m_updateManager = null;
        if (this.m_bindingModel == null) {
            this.m_bindingModel = new DefaultBindingModel<Component>();
        }
        HashSet<ObservableSet.Listener<Component>> OSLSet = new HashSet<ObservableSet.Listener<Component>>();
        Iterator<ObservableSet.Listener<Component>> itOSL = this.m_componentSet.listenerIterator();
        while (itOSL.hasNext()) {
            OSLSet.add(itOSL.next());
        }
        this.m_componentSet.clearListeners();
        boolean containsObsoleteObjects = false;
        Iterator itObj = this.m_componentSet.iterator();
        while (itObj.hasNext()) {
            Object obj = itObj.next();
            if (obj instanceof Component) continue;
            itObj.remove();
            containsObsoleteObjects = true;
            if (!(obj instanceof ConnectDimCtrlPoints)) continue;
            ConnectDimCtrlPoints cnct = (ConnectDimCtrlPoints)obj;
            ComponentDimSingle dim = cnct.getDim();
            Component comp1 = cnct.getComponent1();
            int pntName1 = cnct.getPointName1();
            Point2D pnt1 = cnct.getPoint1();
            Component comp2 = cnct.getComponent2();
            int pntName2 = cnct.getPointName2();
            Point2D pnt2 = cnct.getPoint2();
            if (comp1 instanceof ComponentPath2D || comp2 instanceof ComponentPath2D) continue;
            BindingDimCtrlPoints binding = new BindingDimCtrlPoints();
            this.m_bindingModel.put(dim, binding);
            if (comp1 != null && pntName1 >= 0) {
                this.m_bindingModel.addBindingObject(binding, comp1);
                binding.setBindingControlPoint1(comp1, pntName1);
            } else {
                binding.setLocation1(pnt1);
            }
            if (comp2 != null && pntName2 >= 0) {
                this.m_bindingModel.addBindingObject(binding, comp2);
                binding.setBindingControlPoint2(comp2, pntName2);
                continue;
            }
            binding.setLocation2(pnt2);
        }
        itOSL = OSLSet.iterator();
        while (itOSL.hasNext()) {
            this.m_componentSet.addListener(itOSL.next());
        }
        if (containsObsoleteObjects) {
            itOSL = this.m_componentSet.listenerIterator();
            while (itOSL.hasNext()) {
                ObservableSet.Listener<Component> l = itOSL.next();
                String className = l.getClass().getName();
                if (!className.startsWith("cib.cad.db.MarkerMap$") && !className.startsWith("cib.util.coll._SubSet$") && !className.startsWith("cib.util.coll._OrderedSet$")) continue;
                itOSL.remove();
            }
            this.m_componentListView = CollUtilities.orderedSet(this.m_componentSet);
            this.m_selectSet = CollUtilities.observableSet(CollUtilities.subSet(new HashSet(), this.m_componentSet));
            this.m_markerMap = new MarkerMap(this.m_componentSet, this.m_selectSet);
        }
        if (this.m_componentListView == null) {
            this.m_componentListView = CollUtilities.orderedSet(this.m_componentSet);
        }
        this._init(this.m_componentSet, this.m_bindingModel, this.m_selectSet, this.m_componentListView, this.m_markerMap);
    }

    public String getVersion() {
        return this.m_version;
    }

    public NameSpace getNameSpace() {
        return this.m_nameSpace;
    }

    public CoordSpace getCoordSpace() {
        return this.m_coordSpace;
    }

    public ObservableSet<Component> getComponentSet() {
        return this.t_componentSet;
    }

    public SwappableList<Component> getComponentList() {
        return this.t_componentListView;
    }

    public ObservableSet<Component> getSelectSet() {
        return this.t_selectSet;
    }

    public MarkerMap getMarkerMap() {
        return this.t_markerMap;
    }

    public BindingModel<Component> getBindingModel() {
        return this.t_bindingModel;
    }

    public void updateDatabase() {
        if (this.t_bindingManager != null) {
            this.t_bindingManager.update();
        }
    }

    public LayerSet getLayerSet() {
        return this.m_layerSet;
    }

    public ReverseAccessMap<Component, Layer> getLayerMap() {
        return this.m_layerMap;
    }

    public AttributeManager getAttributeManager() {
        return this.m_attributeManager;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setAttributeManager(AttributeManager attributeManager) {
        this.m_attributeManager = attributeManager;
    }

    public void setComponentSet(ObservableSet<Component> componentSet) {
        this.m_componentSet = componentSet;
        this.m_componentListView = CollUtilities.orderedSet(componentSet);
    }

    public void setCoordSpace(CoordSpace coordSpace) {
        this.m_coordSpace = coordSpace;
    }

    public void setLayerMap(ReverseAccessMap<Component, Layer> layerMap) {
        this.m_layerMap = layerMap;
    }

    public void setLayerSet(LayerSet layerSet) {
        this.m_layerSet = layerSet;
    }

    public void setMarkerMap(MarkerMap markerMap) {
        this.m_markerMap = markerMap;
    }

    public void setNameSpace(NameSpace nameSpace) {
        this.m_nameSpace = nameSpace;
    }

    public void setSelectSet(ObservableSet<Component> selectSet) {
        this.m_selectSet = selectSet;
    }

    private class ComponentSetListener
    extends ObservableSet.Listener<Component> {
        private static final long serialVersionUID = 1L;

        private ComponentSetListener() {
        }

        @Override
        public void wasAdded(Component comp) {
            LayerManager layerManager = LayerManager.getLayerManager();
            if (layerManager.getComponentLayer(comp) == null) {
                Layer layer = Database.this.m_layerSet.getDefaultLayer();
                layerManager.setComponentLayer(comp, layer);
            }
        }
    }
}

