/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db;

import cib.cad.db.ComponentBindingContext;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.binding.BindingUtils;
import cib.util.coll.ObservableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BindingManager {
    private static final long serialVersionUID = 0L;
    private BindingModel<Component> m_bindingModel;
    private ObservableSet<Component> m_componentSet;
    private Set<Component> m_changedElements = new HashSet<Component>();
    private Set<Component> m_removedElements = new HashSet<Component>();
    private Map<Component, List<Component>> m_clonedElements = new HashMap<Component, List<Component>>();
    private transient boolean m_isUpdating = false;

    public BindingManager(final ObservableSet<Component> cmpSet, BindingModel<Component> bindingModel) {
        this.m_componentSet = cmpSet;
        this.m_bindingModel = bindingModel;
        Iterator<ObservableSet.Listener<Component>> it = cmpSet.listenerIterator();
        while (it.hasNext()) {
            ObservableSet.Listener<Component> l = it.next();
            if (!l.getClass().getName().startsWith("cib.cad.db.BindingManager$")) continue;
            it.remove();
        }
        final ObservableSet.Listener<Component> csl = new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(Component o) {
                if (!BindingManager.this.m_isUpdating) {
                    BindingManager.this.m_changedElements.add(o);
                }
            }

            @Override
            public void wasChanged(Component o) {
                if (!BindingManager.this.m_isUpdating) {
                    BindingManager.this.m_changedElements.add(o);
                }
            }

            @Override
            public void wasRemoved(Component o) {
                if (!BindingManager.this.m_isUpdating) {
                    BindingManager.this.m_removedElements.add(o);
                }
            }

            @Override
            public void wasCloned(Component src, Component dst) {
                ArrayList<Component> clones = (ArrayList<Component>)BindingManager.this.m_clonedElements.get(src);
                if (clones == null) {
                    clones = new ArrayList<Component>();
                    BindingManager.this.m_clonedElements.put(src, clones);
                }
                clones.add(dst);
            }
        };
        cmpSet.addListener(csl);
        Kernel krnl = Kernel.getInstance();
        krnl.addListener(new Kernel.Listener(){

            @Override
            public void storeStarts() {
                cmpSet.removeListener(csl);
            }

            @Override
            public void storeEnds() {
                cmpSet.addListener(csl);
            }
        });
    }

    public void update() {
        ComponentBindingContext context = new ComponentBindingContext(){

            @Override
            public boolean contains(Component c) {
                return BindingManager.this.m_componentSet.contains(c);
            }
        };
        this._update(context);
    }

    private void _update(ComponentBindingContext context) {
        this.m_isUpdating = true;
        this.m_changedElements.addAll(this.m_removedElements);
        Collection<List<Component>> cloneLists = this.m_clonedElements.values();
        for (List<Component> clones : cloneLists) {
            this.m_changedElements.addAll(clones);
        }
        BindingUtils.updateBindings(this.m_bindingModel, this.m_changedElements, context);
        for (Component comp : this.m_removedElements) {
            if (!this.m_bindingModel.containsKey(comp)) continue;
            this.m_bindingModel.remove(comp);
        }
        Set boundSet = this.m_bindingModel.keySet();
        Iterator boundIt = boundSet.iterator();
        while (boundIt.hasNext()) {
            Component bound = (Component)boundIt.next();
            Binding b = (Binding)this.m_bindingModel.get(bound);
            if (this.m_removedElements.contains(bound)) {
                boundIt.remove();
                continue;
            }
            Set bindingComponentSet = b.getBindingObjects();
            Iterator cit = bindingComponentSet.iterator();
            while (cit.hasNext()) {
                Component bindingComponent = (Component)cit.next();
                if (!this.m_removedElements.contains(bindingComponent)) continue;
                cit.remove();
            }
            if (!bindingComponentSet.isEmpty()) continue;
            boundIt.remove();
        }
        this.m_changedElements.clear();
        this.m_removedElements.clear();
        this.m_clonedElements.clear();
        this.m_isUpdating = false;
    }
}

