//---------------------------------------------------------------------------
//
// %FILE     wdtest.c
// %VSS-REV  $Revision: 15 $
// %CREATED  1996.02.28
// %REVISED  $Date: 4/18/97 4:30p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  Watchdog Timer test code
//
// %VSS      $Author: Miked $ $Date: 4/18/97 4:30p $ $Revision: 15 $
//
// DESCRIPTION
//
//   Example code using WatchDog functions.
//
// HISTORY
//
/*
 *
 * $History: wdtest.c $ 
 * 
 * *****************  Version 15  *****************
 * User: Miked        Date: 4/18/97    Time: 4:30p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 8/05/96    Time: 6:05p
 * Updated in $/nsdemo
 * Added RTTarget support (hooking of IRQ, #ifdef ONTIME).  Also
 * eliminated Watcom differences by using __cdecl for ISR functions.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 7/23/96    Time: 2:26p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 7/23/96    Time: 11:53a
 * Updated in $/nsdemo
 * Modified to work with ISR THUNK routines in CPU.ASM.  Interrupts now
 * vector to ISR Thunk routines, which in turn call the C ISRs.  This is a
 * more stable and consistent way to handle interrupts (vs. trying to
 * force C functions to properly
 * save and restore registers and do an IRETD).
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 7/12/96    Time: 3:47p
 * Updated in $/nsdemo
 * Changed printed output slightly to fit with rest of NSDEMO.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 6/28/96    Time: 1:45p
 * Updated in $/nsdemo
 * Modified to call external assembly function for IRETD.  Also SSI and
 * Pharlap
 * now use same code.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 4/18/96    Time: 11:06a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/17/96    Time: 12:02p
 * Updated in $/nsdemo
 * Modified to support interrupts with Pharlap.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/17/96    Time: 11:33a
 * Updated in $/nsdemo
 * Renamed PITf_Delay call to PIT_Delay call as per pit.c change.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 3:07p
 * Branched in $/nsdemo
 * NS Demo
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/04/96    Time: 3:13p
 * Updated in $/board test
 * changed headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
// NOTES
//
//   We may or may not get a dummy IRQ after enabling the
//   watchdog, due to the way the PIC works.  The first time this code
//   is ran we will get one, but probably not after that.  So this code
//   allows for either case.  In the future this code might force a
//   dummy interrupt and then run the WD test.
//
//---------------------------------------------------------------------------

#include "wdtest.h"

//---------------------------------------------------------------------------

PRIVATE volatile long isr_count_wd;

//---------------------------------------------------------------------------

void __cdecl ISR_PIT_WD_THUNK(void); // assembly ISR hooked to interrupt

//---------------------------------------------------------------------------

USHORT WD_Test()
{

  USHORT retval = SUCCESS;
  
  #ifdef PHARLAP
    USHORT irqvec;
    FARPTR old_handler;
    FARPTR new_handler;
  #endif

// Test #1

  dprintf("Watchdog Test:\r\n");
  dprintf("  Note: This test may cause the CPU to reset if it does\r\n");
  dprintf("    not operate correctly.  In this case, the Watchdog\r\n");
  dprintf("    test has failed!\r\n");

  isr_count_wd = 0;
  
  // Hook the PIT 1 interrupt
  #ifdef PHARLAP
    if ( IRQ_WD < 8 )
      irqvec = IRQIV_Controller1 + IRQ_WD;
    else
      irqvec = IRQIV_Controller2 + IRQ_WD - 8;
    FP_SET(new_handler, ISR_PIT_WD_THUNK, 0x18); // set up the "far pointer"
    _dx_pmiv_get(irqvec, &old_handler);          // get the old handler
    _dx_pmiv_set(irqvec, new_handler);           // set the new handler
  #endif
  
  #ifdef ONTIME
     RTSetVector(RTIRQ0Vector+IRQ_WD, (void (*)(void)) ISR_PIT_WD_THUNK);
  #endif

  // set up watchdog to generate IRQ

  WD_Set( 50, WD_IRQ );               // 50ms
  PIC_Enable(IRQ_WD);

  // Wait long enough for interrupt

  PIT_Delay( 1, 70 );                   // 70ms

  // If interrupt hasn't happened,  bail out

  if ( isr_count_wd == 0 )  // no interrupt
  {
    WD_Cancel();
    dprintf("  WD interrupt didn't occur - **FAIL**\r\n");
    retval = FAIL;
  }
  else if ( isr_count_wd > 2 )   // more than two interrupts
  {
    WD_Cancel();
    dprintf("  too many WD interrupts - **FAIL**\r\n");
    retval = FAIL;
  }
  else  // either one or two (allows for dummy interrupt)
  {
    
    // reset isr_count_wd to 0

    isr_count_wd = 0;

    // retrigger

    WD_Retrigger();
  
    // Wait long enough for interrupt

    PIT_Delay( 1, 70 );                   // 70ms
    
    // if new int didn't happen, bail out

    if ( isr_count_wd < 1 )
    {
      WD_Cancel();
      dprintf("  retriggered WD interrupt didn't occur - **FAIL**\r\n");
      retval = FAIL;
    }
    else
    {
      
      // Cancel WD

      WD_Cancel();
  
      // Print Message

      dprintf("  Watchdog interrupt test - PASSED\r\n");
      
      // allow extra IRQ from timer

      PIT_Delay( 1, 70 );                   // 70ms
      
      if ( isr_count_wd < 2 )
      {
        dprintf("  extra WD interrupt didn't occur - **FAIL**\r\n");
        retval = FAIL;
      }

    }

  }

  // disable IRQ

  PIC_Disable( IRQ_WD );

  // Restore the old handler
  
  #ifdef PHARLAP
    _dx_pmiv_set(irqvec, old_handler);
  #endif
  
  // print blank line
  dprintf("\r\n");
  
  // we are done

  return retval;

}
  
//---------------------------------------------------------------------------

// This is the ISR for the WD interrupt.  The assembly function 
// ISR_PIT_WD_THUNK is the actual function pointed to by the IDT.  That
// function calls this function.

void __cdecl ISR_PIT_WD(void)
{

  // Increment count global
  isr_count_wd++;
    
  // Issue EOI
  // Note in Pharlap ETS lite, using Borland, we might not have a stack  
  // here.  Not yet tested.  If so, issue EOI directly instead of
  // calling PIC_EOI.

  PIC_EOI(IRQ_WD);

}

//---------------------------------------------------------------------------
// END       wdtest.c
//---------------------------------------------------------------------------
