//---------------------------------------------------------------------------
//
// %FILE     pittest.c
// %VSS-REV  $Revision: 18 $
// %CREATED  1995.12.14
// %REVISED  $Date: 4/18/97 4:18p $ 
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  Programmable Interval Timer test module 
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:18p $ $Revision: 18 $
//
// DESCRIPTION
//
//   Uses the PIT module to perform a few basic tests of the PIT, including
//   interrupts.
//
// HISTORY
//
/*
 *
 * $History: pittest.c $
 * 
 * *****************  Version 18  *****************
 * User: Miked        Date: 4/18/97    Time: 4:18p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 17  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 16  *****************
 * User: Miked        Date: 8/05/96    Time: 6:05p
 * Updated in $/nsdemo
 * Added RTTarget support (hooking of IRQ, #ifdef ONTIME).  Also
 * eliminated Watcom differences by using __cdecl for ISR functions.
 * 
 * *****************  Version 15  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 7/23/96    Time: 11:53a
 * Updated in $/nsdemo
 * Modified to work with ISR THUNK routines in CPU.ASM.  Interrupts now
 * vector to ISR Thunk routines, which in turn call the C ISRs.  This is a
 * more stable and consistent way to handle interrupts (vs. trying to
 * force C functions to properly
 * save and restore registers and do an IRETD).
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 6/28/96    Time: 1:44p
 * Updated in $/nsdemo
 * Modified to call external assembly function for IRETD.  Also SSI and
 * Pharlap
 * now use same code.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 6/27/96    Time: 11:41a
 * Updated in $/nsdemo
 * Made PIT delay_ms function non specific and used larger delay
 * calls to avoid errors with config. setups.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 4/18/96    Time: 10:40a
 * Updated in $/nsdemo
 * Fixed release comment.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 4/18/96    Time: 10:35a
 * Updated in $/nsdemo
 * Cleanup for release.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 4/17/96    Time: 12:02p
 * Updated in $/nsdemo
 * Moved restoring of PIT Clock and Gates (for Pharlap) to main so that
 * the PIT_Delay function would work in other modules.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 4/17/96    Time: 11:49a
 * Updated in $/nsdemo
 * Fixed dump printf I had left in on accident.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/17/96    Time: 11:46a
 * Updated in $/nsdemo
 * Modified to allow Interrupts in Pharlap.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/12/96    Time: 3:53p
 * Updated in $/nsdemo
 * Uses only PIT channel 1 so it doesn't step on ETS interrupt.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 3:07p
 * Branched in $/nsdemo
 * NS Demo
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/04/96    Time: 3:13p
 * Updated in $/board test
 * changed header for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#include "pittest.h"

//---------------------------------------------------------------------------

PRIVATE volatile long isr_count_pit1;

//---------------------------------------------------------------------------

void __cdecl ISR_PIT1_THUNK(void); // assembly ISR hooked to interrupt

//---------------------------------------------------------------------------

// This function is not accurate.  It was calibrated for a certain
// environment, but this proved un-necessary, and there were too many
// variables.  Instead, this function is more or less arbitrary.
// It is only used in this module to do delays without using the PIT,
// for the purpose of testing the pit.  It should be called with
// a big margin for error.  For example, if the timer should go off in
// 50ms, calling this with 500ms should be plenty of time given any
// errors in accuracy.

PRIVATE void delay_ms ( long time )
{

  long i, j;
  
  for ( j=0; j < time; j++ )
    for ( i=0; i < 1025; i++ );

}

//---------------------------------------------------------------------------

USHORT PIT_Test( void )
{

  PIT_STATUS Status1;
  PIT_STATUS Status2;
  PIT_SET Set;
  USHORT tretval;
  USHORT retval = SUCCESS;
    
  #ifdef PHARLAP
    USHORT irqvec;
    FARPTR old_handler;
    FARPTR new_handler;
  #endif
  
  // Start of test message

  dprintf("Programmable Interval Timer Test:\r\n");

  // Initialize

  if ( PIT_Initialize() != SUCCESS )
  {
    dprintf("  Initialization - **FAILED**\r\n\n");
    return FAIL;
  }

  // Hook the PIT 1 interrupt
  #ifdef PHARLAP
    if ( IRQ_PIT1 < 8 )
      irqvec = IRQIV_Controller1 + IRQ_PIT1;
    else
      irqvec = IRQIV_Controller2 + IRQ_PIT1 - 8;
    FP_SET(new_handler, ISR_PIT1_THUNK, 0x18); // set up the "far pointer"
    _dx_pmiv_get(irqvec, &old_handler);        // get the old handler
    _dx_pmiv_set(irqvec, new_handler);         // set the new handler
  #endif

  #ifdef ONTIME
     RTSetVector(RTIRQ0Vector+IRQ_PIT1, (void (*)(void)) ISR_PIT1_THUNK);
  #endif

// Test #1 - PIT channel 1 in single shot mode

  // Set ISR count to 0  

  isr_count_pit1 = 0;
  
  // Set up PIT

  Set.Timer = 1;            // channel 1
  Set.Mode = 0;             // mode 0
  Set.Time = 50;            // 50ms
  Set.Gate = PIT_GateClear; // clear

  PIT_Set( & Set );
  
  // Enable PIT Interrupt

  PIC_Enable(IRQ_PIT1);

  // Enable Counting
  
  PIT_Gate( 1, PIT_GateSet );

  // delay 500ms

  delay_ms( 500 );

  // Disable PIT Interrupt

  PIC_Disable(IRQ_PIT1);
  
  // Cancel PIT

  PIT_Cancel ( 1 );

  // See if interrupt happened

  if ( isr_count_pit1 == 0 )  
  {
    // interrupt didn't happen
    dprintf("  channel 1 mode 0 (one shot) - no interrupt - **FAILED**\r\n");
    retval = FAIL;
  }
  else if ( isr_count_pit1 >= 2 )
  {
    // got extra interrupts
    dprintf("  channel 1 mode 0 (one shot) - extra interrupts - **FAILED**\r\n");
    retval = FAIL;
  }
  else
  {
    // success
    dprintf("  channel 1 mode 0 (one shot) - PASSED\r\n");
  }

// Test #2 - PIT channel 1 in rate generator mode

  // Set ISR count to 0  

  isr_count_pit1 = 0;
  
  // Set up PIT

  Set.Timer = 1;            // channel 1
  Set.Mode = 2;             // mode 0
  Set.Time = 50;            // 50ms
  Set.Gate = PIT_GateClear; // clear

  PIT_Set( & Set );
  
  // Enable PIT Interrupt

  PIC_Enable(IRQ_PIT1);

  // Enable Counting
  
  PIT_Gate( 1, PIT_GateSet );

  // delay 2000ms

  delay_ms( 2000 );

  // Disable PIT Interrupt

  PIC_Disable(IRQ_PIT1);
  
  // Cancel PIT

  PIT_Cancel ( 1 );

  // See if interrupt happened

  if ( isr_count_pit1 == 0 )  
  {
    // interrupt didn't happen
    dprintf(
      "  channel 1 mode 2 (rate generator) - no interrupt - **FAILED**\r\n");
    retval = FAIL;
  }
  else if ( isr_count_pit1 == 1 )
  {
    // only one interrupt
    dprintf("  channel 1 mode 2 (rate generator) - only one interrupt - **FAILED**\r\n");
    retval = FAIL;
  }
  else
  {
    // success
    dprintf("  channel 1 mode 2 (rate generator) - PASSED\r\n");
  }

// Test #3 - PIT channel 1 in single shot mode - to test readback

  // Set up PIT

  Set.Timer = 1;             // channel 1
  Set.Mode =  0;             // mode 0
  Set.Time =  10;            // 10ms
  Set.Gate =  PIT_GateClear; // clear

  PIT_Set( & Set );
  
  // Get Status

  PIT_Status( 1, & Status1 );

  // Check Status

  tretval = SUCCESS;

  if ( Status1.Mode != 0 )
  {
    dprintf(
      "    Readback test 1 - mode returned incorrectly - **FAILED**\r\n");
    tretval = FAIL;
  }
  if ( Status1.Gate != PIT_GateClear )
  {
    dprintf(
      "    Readback test 1 - gate returned incorrectly - **FAILED**\r\n");
    tretval = FAIL;
  }
  if ( Status1.Output != FALSE )
  {
    dprintf(
      "    Readback test 1 - output is incorrect (high) - **FAILED**\r\n");
    tretval = FAIL;
  }

  if ( tretval != SUCCESS )
    retval = FAIL;
  else
    dprintf("  Readback test 1 - PASSED\r\n");

  // Enable Counting
  
  PIT_Gate( 1, PIT_GateSet );

  // delay 500ms

  delay_ms( 500 );

  // Get Status

  PIT_Status( 1, &Status2 );

  // Check Status
  
  tretval = SUCCESS;

  if ( Status2.Mode != 0 )
  {
    dprintf(
      "    Readback test 2 - mode returned incorrectly - **FAILED**\r\n");
    tretval = FAIL;
  }
  if ( Status2.Gate != PIT_GateSet )
  {
    dprintf(
      "    Readback test 2 - gate returned incorrectly - **FAILED**\r\n");
    tretval = FAIL;
  }
  if ( Status2.Output != TRUE )
  {
    dprintf(
      "    Readback test 2 - output not set - **FAILED**\r\n");
    tretval = FAIL;
  }

  if ( tretval != SUCCESS )
    retval = FAIL;
  else
    dprintf("  Readback test 2 - PASSED\r\n");

  // Cancel PIT

  PIT_Cancel ( 1 );

  // Restore the old handler
  #ifdef PHARLAP
    _dx_pmiv_set(irqvec, old_handler);
  #endif

// Done with PIT tests

  // return

  dprintf("\n");

  return retval;

}

//---------------------------------------------------------------------------

// This is the ISR for the PIT interrupt.  The assembly function 
// ISR_PIT1_THUNK is the actual function pointed to by the IDT.  That
// function calls this function.

void __cdecl ISR_PIT1(void)
{

  // Increment count global
  isr_count_pit1++;
    
  // Issue EOI
  // Note in Pharlap ETS lite, using Borland, we might not have a stack  
  // here.  Not yet tested.  If so, issue EOI directly instead of
  // calling PIC_EOI.

  PIC_EOI(IRQ_PIT1);

}

//---------------------------------------------------------------------------
// END       pittest.c
//---------------------------------------------------------------------------
