title Set memory block

name setblock

dgroup group data
data segment word public 'DATA'
	extrn _psp: word			;prog seg prefix ptr
data ends


pgroup group prog
prog segment byte public 'prog'
assume cs:pgroup

public setblock

include macro186.inc

;--------------------------------------------------------------------------
;
;	setblock - called from c - does dos setblock to 128 k for program
;
;	as called from c:
;		intvar = setblock();
;
;	returned value = 0 if failed, 1 if successful.
;
;--------------------------------------------------------------------------
assume ds:dgroup

setblock proc near

	push	es

	mov	bx, 8192		;64k code + 64k data
	mov	ax, _psp + 2		;c stored the pointer for returning.
	mov	es, ax			;es = block segment
	mov	ax, 4a00h		;function = set block
	int	21h
	jc	failed

	mov	ax, 1			;success.
	pop	es
	ret

failed:
	xor	ax, ax			;failure.
	pop	es
	ret

setblock endp

prog ends
end
