/* @(#)NLchar.h	7.1 - 87/06/15 - 23:42:31 */

#ifndef _h_NLCHAR
#define _h_NLCHAR

/*  BASIC DEFINITIONS FOR USING NLCHARS.
 */

/*  The big type itself.
 */
typedef unsigned short NLchar;

/*  Number of distinct NLchars.
 */
#define NLCHARMAX	768

#ifdef lint
extern NLchar NCdechr();
#else

/*  Single-shift character definition (both NLchar and char representation).
 */
#define	NCisshift(c)	(((c) & ~3) == 0x1c)

/*  SINGLE-CHARACTER CONVERSION MACROS.
 */

/*  Internal macro to test for multi-byte NLS code point.
 */
#define _NCis2(c0, c1)	(NCisshift(c0) && (c1) & 0x80)

/*  Internal macro to convert multi-byte NLS code point to NLchar.
 */
#define _NCd2(c0, c1)	(0x21 - (c0) << 7 | (c1) & 0x7f)

/*  Internal macro to convert NLchar to NLS code point.
 */
#define _NCe2(nlc, c0, c1)	((0xff < (nlc)) ? \
					((c0) = 0x21 - ((nlc) >> 7), \
						(c1) = (nlc) | 0x80, 2) : \
					((c0) = (nlc), 1))

/*  Convert 1 or 2 chars to an NLchar and return it.
 */
#define NCdechr(c)	((_NCis2((c)[0], (c)[1])) ? \
				_NCd2((c)[0], (c)[1]) : (c)[0])

/*  Convert c0 (and c1, if need be) into NLchar nlc; return # chars used.
 *  This is the only conversion macro that accepts an NLchar, rather than
 *  a pointer to one, as an argument.
 */
#define _NCdec2(c0, c1, nlc) ((_NCis2((c0), (c1))) ? \
				((nlc) = _NCd2((c0), (c1)), 2) : \
				((nlc) = (c0), 1))

/*  Convert 1 or 2 chars and store into an NLchar pointed to by nlc;
 *  return # chars converted.
 */
#define NCdec(c, nlc)	(_NCdec2((c)[0], (c)[1], (nlc)[0]))

/*  Convert an NLchar and store into 1 or 2 chars; return # chars produced.
 */
#define NCenc(nlc, c)	(_NCe2((nlc)[0], (c)[0], (c)[1]))

/*  CODE POINT UTILITY MACROS.
 */

/*  Return length of NLchar nlc if encoded into char(s).
 */
#define NCchrlen(nlc)	(((nlc) <= 0xff) ? 1 : 2)

/*  Indicate if c points to an NLS code point; return length if so.
 */
#define NLisNLcp(c)	(((c)[0] & 0x80) ? 1 : (_NCis2((c)[0], (c)[1])) ? 2 : 0)

/*  Return length of "character" at c.
 */
#define NLchrlen(c)	((_NCis2((c)[0], (c)[1])) ? 2 : 1)
#endif

/*  CHARACTER COLLATING/CLASSIFICATION INFO.
 */

/*  Struct for character collating/classification tables.
 */
#define NLCTMAG0	(unsigned char)0x01
#define NLCTMAG1	(unsigned char)0x05

#define NLCTABMAX	(NLCHARMAX+1)	/* allow for EOF as input value */
#define NLCTBITMX	((NLCTABMAX+7)/8) /* bytes for NLCTABMAX-sized bitmap */
struct NLctab {
	char	ct_mag0, ct_mag1; 	/* magic number for ctab output */
	short	ct_version;		/* producer version number */
	char	ct_ctype[NLCTABMAX];	/* equivalent of old _ctype */
	NLchar	ct_caseconv[NLCTABMAX];	/* alphabetic case conversion */
	short	ct_collate[NLCTABMAX];	/* collating sequence order */
	short	ct_coluniq[NLCTABMAX];	/* unique collating values */
	char	ct_eqvmap[NLCTBITMX];	/* equivalence class bitmap */
};

/*  Struct for extended collating descriptors.
 */
struct NLcoldesc {
	short	cd_stroff;	/* offset to special string */
	short	cd_cval;	/* special collating value */
};

#ifndef lint
/*  Defs for accessing collating data.
 */
#define NCcollate(nlc)	((_NLctab->ct_collate+1)[(nlc)])
#define NCcoluniq(nlc)	((_NLctab->ct_coluniq+1)[(nlc)])
#define NCeqvmap(ucval)	((_NLctab->ct_eqvmap)[(ucval) + 1 >> 3] & \
				(1 << ((ucval) + 1 & 7)))
#endif

extern struct NLctab *_NLctab;
extern struct NLcoldesc *_NLcoldesc;
extern void NLgetctab();
extern int NLgetfile();

/*  MISCELLANY.
 */

/*  Internal defs for string(3) macros using charsets.
 */
#define NLCSETMAX	33	/* malloc charsets over this length - 1 */

#ifdef lint
extern NLchar *_NCbufstr();
extern void _NCfreebuf();
#else

/*  Decode a string into an NLchar array big enough to hold it.  Use array
 *  s if possible, else malloc one with _NLgetbuf.  First element flags
 *  whether malloc was used.
 */
#define _NCbufstr(s, d, l)	((d)[0] = 0, ((l) - 1 <= \
					NCdecstr((s), &(d)[1], (l) - 1)) ? \
					_NCgetbuf((s), (l)) : &(d)[1])

/*  Free a buffer filled by _NCbufstr, if it was malloc'd originally.
 */
#define _NCfreebuf(s)		if (*((s) - 1)) free((s) - 1);
#endif

extern NLchar *_NCgetbuf();
/*extern void free();*/
#endif
