


          XMH(1)                         AIX                         XMH(1)



          NAME
               xmh - X interface to the MH message handling system

          SYNOPSIS
               xmh [-path mailpath] [-initial foldername] [-flag] [-
               toolkitoption ...]

          DESCRIPTION
               The xmh program provides a window-oriented user interface to
               the Rand MH Message Handling System.  To actually do things
               with your mail, it makes calls to the MH package.  Elec-
               tronic mail messages may be composed, sent, received,
               replied to, forwarded, sorted, and stored in folders.

               To specify an alternate collection of mail folders in which
               to process mail, use -path followed by the pathname of the
               alternate mail directory.  The default mail path is the
               value of the Path component in $HOME/.mh_profile, or
               $HOME/Mail if the MH Path is not given. To specify an alter-
               nate folder which may receive new mail and is initially
               opened by xmh, use the -initial flag. The default initial
               folder is `inbox'. The option -flag will cause xmh to
               attempt to change the appearance of its icon when new mail
               has arrived. These three options have corresponding
               application-specific resources, named MailPath, Initial-
               Folder, and MailWaitingFlag, which can be used in a resource
               file. The standard toolkit command line options are given in
               X(1).

               Please don't be misled by the size of this document.  It
               introduces many aspects of the Athena Widget Set, and pro-
               vides extensive mechanism for customization of the user
               interface.  xmh really is easy to use.


          INSTALLATION
               The current version of xmh requires that the user is already
               set up to use MH, version 6.  To do so, see if there is a
               file called .mh_profile in your home directory.  If it
               exists, check to see if it contains a line that starts with
               ``Current-Folder''.  If it does, you've been using version 4
               or earlier of MH; to convert to version 6, you must remove
               that line.  (Failure to do so causes spurious output to
               stderr, which can hang xmh depending on your setup.)

               If you do not already have a .mh_profile, you can create one
               (and everything else you need) by typing ``inc'' to the
               shell.  You should do this before using xmh to incorporate
               new mail.

               For more information, refer to the mh(1) documentation.




          Rev. Release 4                                             Page 1






          XMH(1)                         AIX                         XMH(1)



          BASIC SCREEN LAYOUT
               xmh starts out with a single window, divided into four main
               areas:


               -   Six buttons with pull-down command menus.

               -   A collection of buttons, one for each top level folder.
                   New users of mh will have two folders, ``drafts'' and
                   ``inbox''.

               -   A listing, or Table of Contents, of the messages in the
                   open folder.  Initially, this will show the messages in
                   ``inbox''.

               -   A view of one of your messages.  Initially this is
                   blank.


          XMH AND THE ATHENA WIDGET SET
               xmh uses the X Toolkit Intrinsics and the Athena Widget Set.
               Many of the features described below (scrollbars, button-
               boxes, etc.) are actually part of the Athena Widget Set, and
               are described here only for completeness.  For more informa-
               tion, see the Athena Widget Set documentation.


             SCROLLBARS
               Some parts of the main window will have a vertical area on
               the left containing a grey bar.  This area is a scrollbar.
               They are used whenever the data in a window takes up more
               space than can be displayed.  The grey bar indicates what
               portion of your data is visible. Thus, if the entire length
               of the area is grey, then you are looking at all your data.
               If only the first half is grey, then you are looking at the
               top half of your data. The message viewing area will have a
               horizontal scrollbar if the text of the message is wider
               than the viewing area.

               You can use the pointer in the scrollbar to change what part
               of the data is visible.  If you click with the middle but-
               ton, then the top of the grey area will move to where the
               pointer is, and the corresponding portion of data will be
               displayed.  If you hold down the middle button, you can drag
               around the grey area.  This makes it easy to get to the top
               of the data: just press with the middle, drag off the top of
               the scrollbar, and release.

               If you click with button 1, then the data to the right of
               the pointer will scroll to the top of the window.  If you
               click with pointer button 3, then the data at the top of the
               window will scroll down to where the pointer is.



          Rev. Release 4                                             Page 2






          XMH(1)                         AIX                         XMH(1)



             BUTTONBOXES, BUTTONS, AND MENUS
               Any area containing many words or short phrases, each
               enclosed in a rectangle or rounded boundary, is called a
               buttonbox. Each rectangle or rounded area is actually a but-
               ton that you can press by moving the pointer onto it and
               pressing pointer button 1.  If a given buttonbox has more
               buttons in it than can fit, it will be displayed with a
               scrollbar, so you can always scroll to the button you want.

               Some buttons have pull-down menus. Pressing the pointer but-
               ton while the pointer is over one of these buttons will pull
               down a menu.  Holding the button down while moving the
               pointer over the menu, called dragging the pointer, will
               highlight each selectable item on the menu as the pointer
               passes over it.  To select an item in the menu, release the
               pointer button while the item is highlighted.


             ADJUSTING THE RELATIVE SIZES OF AREAS
               If you're not satisfied with the sizes of the various areas
               of the main window, they can easily be changed.  Near the
               right edge of the border between each region is a black box,
               called a grip.  Simply point to that grip with the pointer,
               press a pointer button, drag up or down, and release.
               Exactly what happens depends on which pointer button you
               press.

               If you drag with the middle button, then only that border
               will move.  This mode is simplest to understand, but is the
               least useful.

               If you drag with pointer button 1, then you are adjusting
               the size of the window above.  xmh will attempt to compen-
               sate by adjusting some window below it.

               If you drag with pointer button 3, then you are adjusting
               the size of the window below.  xmh will attempt to compen-
               sate by adjusting some window above it.

               All windows have a minimum and maximum size; you will never
               be allowed to move a border past the point where it would
               make a window have an invalid size.


          PROCESSING YOUR MAIL
               This section will define the concepts of the selected
               folder, current folder, selected message(s), current mes-
               sage, selected sequence, and current sequence.  Each xmh
               command is introduced.

               For use in customization, action procedures corresponding to
               each command are given; these action procedures can be used
               to customize the user interface, particularly the keyboard


          Rev. Release 4                                             Page 3






          XMH(1)                         AIX                         XMH(1)



               accelerators and the functionality of the buttons in the
               optional button box created by the application resource Com-
               mandButtonCount.


             SELECTED FOLDER
               A folder contains a collection of mail messages, or is
               empty.

               The selected folder is whichever foldername appears in the
               bar above the folder buttons.  Note that this is not neces-
               sarily the same folder that is being viewed. To change the
               selected folder, just press on the desired folder button; if
               that folder has subfolders, select a folder from the pull
               down menu.

               The Table of Contents, or toc, lists the messages in the
               viewed folder.  The title bar above the Table of Contents
               displays the name of the viewed folder.

               The toc title bar also displays the name of the viewed
               sequence of messages within the viewed folder.  Every folder
               has an ``all'' sequence, which contains all the messages in
               the folder, and initially the toc title bar will show
               ``inbox:all''.


             FOLDER COMMANDS
               The folder command menu contains commands of a global
               nature:


               Open Folder
                       Display the data in the selected folder.  Thus, the
                       selected folder also becomes the viewed folder. The
                       action procedure corresponding to this command is
                       XmhOpenFolder([foldername]).  It takes an optional
                       argument as the name of a folder to select and open;
                       if no folder is specified, the selected folder is
                       opened.  It may be specified as part of an event
                       translation from a folder menu button or from a
                       folder menu, or as a binding of a keyboard accelera-
                       tor to any widget other than the folder menu buttons
                       or the folder menus.

               Open Folder in New Window
                       Displays the selected folder in an additional main
                       window.  Note, however, that you may not reliably
                       display the same folder in more than one window at a
                       time, although xmh will not prevent you from trying.
                       The corresponding action is XmhOpenFolderInNewWin-
                       dow().



          Rev. Release 4                                             Page 4






          XMH(1)                         AIX                         XMH(1)



               Create Folder
                       Create a new folder.  You will be prompted for a
                       name for the new folder; to enter the name, move the
                       pointer to the blank box provided and type.  Sub-
                       folders are created by specifying the parent folder,
                       a slash, and the subfolder name.  For example, to
                       create a folder named ``xmh'' which is a subfolder
                       of an existing folder named ``clients'', type
                       ``clients/xmh''.  Click on the Okay button when fin-
                       ished, or just type Return; click on Cancel to can-
                       cel this operation. The action corresponding to
                       Create Folder is XmhCreateFolder().

               Delete Folder
                       Destroy the selected folder.  You will be asked to
                       confirm this action (see CONFIRMATION WINDOWS).
                       Destroying a folder will also destroy any subfolders
                       of that folder.  The corresponding action is
                       XmhDeleteFolder().

               Close Window
                       Exits xmh, after first confirming that you won't
                       lose any changes; or, if selected from any addi-
                       tional xmh window, simply closes that window.  The
                       corresponding action is XmhClose().


             HIGHLIGHTED MESSAGES, SELECTED MESSAGES
             AND THE CURRENT MESSAGE
               It is possible to highlight a set of adjacent messages in
               the area of the Table of Contents.  To highlight a message,
               click on it with pointer button 1.  To highlight a range of
               messages, click on the first one with pointer button 1 and
               on the last one with pointer button 3; or press pointer but-
               ton 1, drag, and release.  To extend a range of selected
               messages, use pointer button 3. To highlight all messages in
               the table of contents, click rapidly three times with
               pointer button 1. To cancel any selection in the table of
               contents, click rapidly twice.

               The selected messages are the same as the highlighted mes-
               sages, if any.  If no messages are highlighted, then the
               selected messages are considered the same as the current
               message.

               The current message is indicated by a '+' next to the mes-
               sage number.  It usually corresponds to the message
               currently being viewed. When a message is viewed, the title
               bar above the view will identify the message.


             TABLE OF CONTENTS COMMANDS
               The Table of Contents command menu contains commands which


          Rev. Release 4                                             Page 5






          XMH(1)                         AIX                         XMH(1)



               operate on the open, or viewed folder.


               Incorporate New Mail
                                 Add any new mail received to your inbox
                                 folder, and set the current message to be
                                 the first new message.  (This command is
                                 selectable only if ``inbox'' is the folder
                                 being viewed.)  The corresponding action
                                 is XmhIncorporateNewMail().

               Commit Changes    Execute all deletions, moves, and copies
                                 that have been marked in this folder.  The
                                 corresponding action is XmhCom-
                                 mitChanges().

               Pack Folder       Renumber the messages in this folder so
                                 they start with 1 and increment by 1.  The
                                 corresponding action is XmhPackFolder().

               Sort Folder       Sort the messages in this folder in chro-
                                 nological order.  As a side effect, this
                                 also packs the folder.  The corresponding
                                 action is XmhSortFolder().

               Rescan Folder     Rebuild the list of messages.  This can be
                                 used whenever you suspect that xmh's idea
                                 of what messages you have is wrong.  (In
                                 particular, this is necessary if you
                                 change things using straight MH commands
                                 without using xmh.)  The corresponding
                                 action is XmhForceRescan().


             MESSAGE COMMANDS
               The Message command menu contains commands which operate on
               the selected message(s), or if there are no selected mes-
               sages, the current message.


               Compose Message   Composes a new message.  A new window will
                                 be brought up for composition; a descrip-
                                 tion of it is given in the COMPOSITION
                                 WINDOWS section below.  This command does
                                 not affect the current message.  The
                                 corresponding action is XmhComposeMes-
                                 sage().

               View Next Message View the first selected message.  If no
                                 messages are highlighted, view the current
                                 message.  If current message is already
                                 being viewed, view the first unmarked mes-
                                 sage after the current message.  The


          Rev. Release 4                                             Page 6






          XMH(1)                         AIX                         XMH(1)



                                 corresponding action is XmhViewNextMes-
                                 sage().

               View Previous     View the last selected message.  If no
                                 messages are highlighted, view the current
                                 message.  If current message is already
                                 being viewed, view the first unmarked mes-
                                 sage before the current message.  The
                                 corresponding action is XmhViewPrevious().

               Mark Deleted      Mark the selected messages for deletion.
                                 If no messages are highlighted, then this
                                 mark the current message for deletion and
                                 automatically display the next unmarked
                                 message.  The corresponding action is
                                 XmhMarkDeleted().

               Mark Move         Mark the selected messages to be moved
                                 into the current (selected) folder.  (If
                                 the current folder is the same as the
                                 viewed folder, this command will just
                                 beep.)  If no messages are highlighted,
                                 this will mark the current message to be
                                 moved and display the next unmarked mes-
                                 sage.  The corresponding action is
                                 XmhMarkMove().

               Mark Copy         Mark the selected messages to be copied
                                 into the current folder.  (If the current
                                 folder is the same as the viewed folder,
                                 this command will just beep.)  If no mes-
                                 sages are highlighted, mark the current
                                 message to be copied.  The corresponding
                                 action is XmhMarkCopy().

               Unmark            Remove any of the above three marks from
                                 the selected messages, or the current mes-
                                 sage, if none are highlighted.  The
                                 corresponding action is XmhUnmark().

               View in New Window
                                 Create a new window containing only a view
                                 of the first selected message, or the
                                 current message, if none are highlighted.
                                 The corresponding action is XmhViewIn-
                                 NewWindow().

               Reply             Create a composition window in reply to
                                 the first selected message, or the current
                                 message, if none are highlighted.  The
                                 corresponding action is XmhReply().

               Forward           Create a composition window whose body is


          Rev. Release 4                                             Page 7






          XMH(1)                         AIX                         XMH(1)



                                 initialized to be the contents of the
                                 selected messages, or the current message
                                 if none are highlighted.  The correspond-
                                 ing action is XmhForward().

               Use as Composition
                                 Create a composition window whose body is
                                 initialized to be the contents of the
                                 first selected message, or the current
                                 message if none are selected.  Any changes
                                 you make in the composition will be saved
                                 in a new message in the ``drafts'' folder,
                                 and will not change the original message.
                                 However, this command was designed to be
                                 used within the ``drafts'' folder to com-
                                 pose message drafts, and there is an
                                 exception to this rule.  If the message to
                                 be used as composition was selected from
                                 the ``drafts'' folder, the changes will be
                                 reflected in the original message (see
                                 COMPOSITION WINDOWS).  The action pro-
                                 cedure corresponding to this command is
                                 XmhUseAsComposition().

               Print             Print the selected messages, or the
                                 current message if none are selected.  xmh
                                 normally prints by invoking the
                                 enscript(1) command, but this can be cus-
                                 tomized with the application-specific
                                 resource PrintCommand.  The action pro-
                                 cedure corresponding to this command is
                                 XmhPrint().


             SEQUENCE COMMANDS
               The Sequence command menu contains commands pertaining to
               message sequences (See MESSAGE-SEQUENCES), and a list of the
               message-sequences defined for the currently viewed folder.
               The selected message-sequence is indicated by a check mark
               in its entry in the margin of the menu.  To change the
               selected message-sequence, select a new message-sequence
               from the sequence menu.


               Pick Messages     Define a new message-sequence. The
                                 corresponding action is XmhPickMessages().

               The following menu entries will be sensitive only if the
               current folder has any message-sequences other than the
               ``all'' message-sequence.

               Open Sequence     Change the viewed sequence to be the same
                                 as the selected sequence.  The


          Rev. Release 4                                             Page 8






          XMH(1)                         AIX                         XMH(1)



                                 corresponding action is XmhOpenSequence().

               Add to Sequence   Add the selected messages to the selected
                                 sequence.  The corresponding action is
                                 XmhAddToSequence().

               Remove from Sequence
                                 Remove the selected messages from the
                                 selected sequence.  The corresponding
                                 action is XmhRemoveFromSequence().

               Delete Sequence   Remove the selected sequence entirely.
                                 The messages themselves are not affected;
                                 they simply are no longer grouped together
                                 to define a message-sequence.  The
                                 corresponding action is XmhDeleteSe-
                                 quence().


             VIEW COMMANDS
               Commands in the View menu and in the buttonboxes of view
               windows (which result from the Message command ``View In
               New'') correspond in functionality to commands of the same
               name in the Message menu, but they operate on the viewed
               message rather than the selected messages or current mes-
               sage.


               Close Window      When the viewed message is in a separate
                                 view window, this command will close the
                                 view, after confirming the status of any
                                 unsaved edits.  The corresponding action
                                 procedure is XmhCloseView().

               Reply             Create a composition window in reply to
                                 the viewed message.  The related action
                                 procedure is XmhViewReply().

               Forward           Create a composition window whose body is
                                 initialized to be the contents of the
                                 viewed message.  The corresponding action
                                 is XmhViewForward().

               Use As Composition
                                 Create a composition window whose body is
                                 initialized to be the contents of the
                                 viewed message.  Any changes made in the
                                 composition window will be saved in a new
                                 message in the ``drafts'' folder, and will
                                 not change the original message.  An
                                 exception: if the viewed message was
                                 selected from the ``drafts'' folder, the
                                 original message is edited.  The action


          Rev. Release 4                                             Page 9






          XMH(1)                         AIX                         XMH(1)



                                 procedure corresponding to this command is
                                 XmhViewUseAsComposition().

               Edit Message      This command enables the direct editing of
                                 the viewed message.  The action procedure
                                 is XmhEditView().

               Save Message      This command is insensitive until the mes-
                                 sage has been edited; when activated,
                                 edits will be saved to the original mes-
                                 sage in the view.  The corresponding
                                 action is XmhSaveView().

               Print             Print the viewed message.  xmh prints by
                                 invoking the enscript(1) command, but this
                                 can be customized with the application-
                                 specific resource PrintCommand.  The
                                 corresponding action procedure is
                                 XmhPrintView().


          OPTIONS
               The Options menu contains one entry.


               Read in Reverse
                    When selected, a check mark appears in the margin of
                    this menu entry.  Read in Reverse will switch the mean-
                    ing of the next and previous messages, and will incre-
                    ment in the opposite direction.  This is useful if you
                    want to read your messages in the order of most recent
                    first.  The option acts as a toggle; select it from the
                    menu a second time to undo the effect.  The check mark
                    appears when the option is selected.


          COMPOSITION WINDOWS
               Aside from the normal text editing functions, there are six
               command buttons associated with composition windows:

               Close Window      Close this composition window.  If changes
                                 have been made since the most recent Save
                                 or Send, you will be asked to confirm los-
                                 ing them.  The corresponding action is
                                 XmhCloseView().

               Send              Send this composition.  The corresponding
                                 action is XmhSend().

               New Headers       Replace the current composition with an
                                 empty message.  If changes have been made
                                 since the most recent Send or Save, you
                                 will be asked to confirm losing them. The


          Rev. Release 4                                            Page 10






          XMH(1)                         AIX                         XMH(1)



                                 corresponding action is XmhResetCompose().

               Compose Message   Bring up another new composition window.
                                 The corresponding action is XmhComposeMes-
                                 sage().

               Save Message      Save this composition in your drafts
                                 folder.  Then you can safely close the
                                 composition.  At some future date, you can
                                 continue working on the composition by
                                 opening the drafts folder, selecting the
                                 message, and using the ``Use as Composi-
                                 tion'' command. The corresponding action
                                 is XmhSave().

               Insert            Insert a related message into the composi-
                                 tion.  If the composition window was
                                 created with a ``Reply'' command, the
                                 related message is the message being
                                 replied to, otherwise no related message
                                 is defined and this button is insensitive.
                                 The message may be filtered before being
                                 inserted; see ReplyInsertFilter under
                                 APPLICATION RESOURCES for more informa-
                                 tion.  The corresponding action is XmhIn-
                                 sert().


          ACCELERATORS
               Accelerators are shortcuts.  They allow you to invoke com-
               mands without using the menus, either from the keyboard or
               by using the pointer.

               xmh defines pointer accelerators for common actions: To
               select and view a message with a single click, use pointer
               button 2 on the message's entry in the table of contents.
               To select and open a folder or a sequence in a single
               action, make the folder or sequence selection with pointer
               button 2.

               To mark the highlighted messages to be moved in a single
               action, or current message if none have been highlighted,
               use pointer button 3 to select the target folder.  Simi-
               larly, selecting a sequence with pointer button 3 will add
               the highlighted or current message(s) to that sequence.  In
               both of these operations, the selected folder or sequence
               and the viewed folder or sequence are not changed.

               xmh defines the following keyboard accelerators over the
               surface of the main window, except in the view area while
               editing a message:
                    Meta-I         Incorporate New Mail
                    Meta-C         Commit Changes


          Rev. Release 4                                            Page 11






          XMH(1)                         AIX                         XMH(1)



                    Meta-R         Rescan Folder
                    Meta-P         Pack Folder
                    Meta-S         Sort Folder

                    Meta-space     View Next Message
                    Meta-c         Mark Copy
                    Meta-d         Mark Deleted
                    Meta-f         Forward the selected or current message
                    Meta-m         Mark Move
                    Meta-n         View Next Message
                    Meta-p         View Previous Message
                    Meta-r         Reply to the selected or current message
                    Meta-u         Unmark

                    Ctrl-V         Scroll the table of contents forward
                    Meta-V         Scroll the table of contents backward
                    Ctrl-v         Scroll the view forward
                    Meta-v         Scroll the view backward


          TEXT EDITING COMMANDS
               All of the text editing commands are actually defined by the
               Text widget in the Athena Widget Set.  The commands may be
               bound to different keys than the defaults described below
               through the X Toolkit Intrinsics key re-binding mechanisms.
               See the X Toolkit Intrinsics and the Athena Widget Set docu-
               mentation for more details.

               Whenever you are asked to enter any text, you will be using
               a standard text editing interface.  Various control and meta
               keystroke combinations are bound to a somewhat Emacs-like
               set of commands.  In addition, the pointer buttons may be
               used to select a portion of text or to move the insertion
               point in the text. Pressing pointer button 1 causes the
               insertion point to move to the pointer.  Double-clicking
               button 1 selects a word, triple-clicking selects a line,
               quadruple-clicking selects a paragraph, and clicking rapidly
               five times selects everything.  Any selection may be
               extended in either direction by using pointer button 3.

               In the following, a line refers to one displayed row of
               characters in the window.  A paragraph refers to the text
               between carriage returns.  Text within a paragraph is broken
               into lines for display based on the current width of the
               window.  When a message is sent, text is broken into lines
               based upon the values of the SendBreakWidth and SendWidth
               application-specific resources.

               The following keystroke combinations are defined:

               Ctrl-a    Beginning Of Line   Meta-b         Backward Word
               Ctrl-b    Backward Character  Meta-f         Forward Word
               Ctrl-d    Delete Next Character              Meta-iInsert File


          Rev. Release 4                                            Page 12






          XMH(1)                         AIX                         XMH(1)



               Ctrl-e    End Of Line         Meta-k         Kill To End Of Paragraph
               Ctrl-f    Forward Character   Meta-q         Form Paragraph
               Ctrl-g    Multiply Reset      Meta-v         Previous Page
               Ctrl-h    Delete Previous Character          Meta-yInsert Current Selection
               Ctrl-j    Newline And Indent  Meta-z         Scroll One Line Down
               Ctrl-k    Kill To End Of Line Meta-d         Delete Next Word
               Ctrl-l    Redraw Display      Meta-D         Kill Word
               Ctrl-m    Newline             Meta-h         Delete Previous Word
               Ctrl-n    Next Line           Meta-H         Backward Kill Word
               Ctrl-o    Newline And Backup  Meta-<         Beginning Of File
               Ctrl-p    Previous Line       Meta->         End Of File
               Ctrl-r    Search/Replace Backward            Meta-]Forward Paragraph
               Ctrl-s    Search/Replace Forward             Meta-[Backward Paragraph
               Ctrl-t    Transpose Characters
               Ctrl-u    Multiply by 4       Meta-Delete    Delete Previous Word
               Ctrl-v    Next Page           Meta-Shift DeleteKill Previous Word
               Ctrl-w    Kill Selection      Meta-Backspace Delete Previous Word
               Ctrl-y    Unkill              Meta-Shift BackspaceKill Previous Word
               Ctrl-z    Scroll One Line Up

               In addition, the pointer may be used to cut and paste text:
                    Button 1 Down  Start Selection
                    Button 1 MotionAdjust Selection
                    Button 1 Up    End Selection (cut)

                    Button 2 Down  Insert Current Selection (paste)

                    Button 3 Down  Extend Current Selection
                    Button 3 MotionAdjust Selection
                    Button 3 Up    End Selection (cut)


          CONFIRMATION DIALOG BOXES
               Whenever you press a button that may cause you to lose some
               work or is otherwise dangerous, a popup dialog box will
               appear asking you to confirm the action.  This window will
               contain an ``Abort'' or ``No'' button and a ``Confirm'' or
               ``Yes'' button.  Pressing the ``No'' button cancels the
               operation, and pressing the ``Yes'' will proceed with the
               operation.

               Some dialog boxes contain messages from MH.  Clicking on the
               message field will cause the dialog box to resize so that
               you can read the entire message.


          MESSAGE-SEQUENCES
               An MH message sequence is just a set of messages associated
               with some name.  They are local to a particular folder; two
               different folders can have sequences with the same name.  In
               all folders, the sequence ``all'' is predefined; it consists
               of the set of all messages in that folder.  As many as nine
               sequences may be defined for each folder, including the


          Rev. Release 4                                            Page 13






          XMH(1)                         AIX                         XMH(1)



               predefined ``all'' sequence.  (The sequence ``cur'' is also
               usually defined for every folder; it consists of only the
               current message.  xmh hides ``cur'' from the user, instead
               placing a ``+'' by the current message.  Also, xmh does not
               support the ``unseen'' sequence, so that one is also hidden
               from the user.)

               The message sequences for a folder (including one for
               ``all'') are displayed in the ``Sequence'' menu, below the
               sequence commands.  The table of contents (also known as the
               ``toc'') is at any one time displaying one message sequence.
               This is called the ``viewed sequence'', and its name will be
               displayed in the toc title bar just after the folder name.
               Also, at any time one of the sequences in the menu will have
               a check mark next to it.  This is called the ``selected
               sequence''.  Note that the viewed sequence and the selected
               sequence are not necessarily the same.  (This all pretty
               much corresponds to the way the folders work.)

               The Open Sequence, Add to Sequence, Remove from Sequence,
               and Delete Sequence commands are active only if the viewed
               folder contains message-sequences.

               Note that none of the above actually affect whether a mes-
               sage is in the folder.  Remember that a sequence is a set of
               messages within the folder; the above operations just affect
               what messages are in that set.

               To create a new sequence, select the ``Pick'' menu entry.  A
               new window will appear, with lots of places to enter text.
               Basically, you can describe the sequence's initial set of
               messages based on characteristics of the message.  Thus, you
               can define a sequence to be all the messages that were from
               a particular person, or with a particular subject, and so
               on.  You can also connect things up with boolean operators,
               so you can select all things from ``weissman'' with the sub-
               ject ``xmh''.

               Hopefully, the layout is fairly obvious.  The simplest cases
               are the easiest: just point to the proper field and type.
               If you enter in more than one field, it will only select
               messages which match all non-empty fields.

               The more complicated cases arise when you want things that
               match one field or another one, but not necessarily both.
               That's what all the ``or'' buttons are for.  If you want all
               things with the subject ``xmh'' or ``xterm'', just press the
               ``or'' button next to the ``Subject:'' field.  Another box
               will appear where you can enter another subject.

               If you want all things either from ``weissman'' or with sub-
               ject ``xmh'', but not necessarily both, select the ``-Or-''
               button.  This will essentially double the size of the form.


          Rev. Release 4                                            Page 14






          XMH(1)                         AIX                         XMH(1)



               You can then enter ``weissman'' in a from: box on the top
               half, and ``xmh'' in a subject: box on the lower part.

               If you select the ``Skip'' button, then only those messages
               that don't match the fields on that row are included.

               Finally, in the bottom part of the window will appear
               several more boxes.  One is the name of the sequence you're
               defining.  (It defaults to the name of the selected sequence
               when ``Pick'' was pressed, or to ``temp'' if ``all'' was the
               selected sequence.)  Another box defines which sequence to
               look through for potential members of this sequence; it
               defaults to the viewed sequence when ``Pick'' was pressed.

               Two more boxes define a date range; only messages within
               that date range will be considered.  These dates must be
               entered in 822-style format: each date is of the form ``dd
               mmm yy hh:mm:ss zzz'', where dd is a one or two digit day of
               the month, mmm is the three-letter abbreviation for a month,
               and yy is a year.  The remaining fields are optional: hh,
               mm, and ss specify a time of day, and zzz selects a time
               zone.  Note that if the time is left out, it defaults to
               midnight; thus if you select a range of ``7 nov 86'' - ``8
               nov 86'', you will only get messages from the 7th, as all
               messages on the 8th will have arrived after midnight.

               ``Date field'' specifies which date field in the header to
               look at for this date range; it probably won't be useful to
               anyone.  If the sequence you're defining already exists, you
               can optionally merge the old set with the new; that's what
               the ``Yes'' and ``No'' buttons are all about.  Finally, you
               can ``OK'' the whole thing, or ``Cancel'' it.

               In general, most people will rarely use these features.
               However, it's nice to occasionally use ``Pick'' to find some
               messages, look through them, and then hit ``Delete
               Sequence'' to put things back in their original state.


          WIDGET HIERARCHY
               In order to specify resources, it is useful to know the
               hierarchy of widgets which compose xmh.  In the notation
               below, indentation indicates hierarchical structure.  The
               widget class name is given first, followed by the widget
               instance name.  The application class name is Xmh.

               The hierarchy of the main toc and view window is identical
               for additional toc and view windows, except that a topLevel-
               Shell widget is inserted in the hierarchy between the appli-
               cation shell and the Paned widget.

               Xmh xmh
                    Paned xmh


          Rev. Release 4                                            Page 15






          XMH(1)                         AIX                         XMH(1)



                         SimpleMenu  folderMenu
                              SmeBSB  open
                              SmeBSB  openInNew
                              SmeBSB  create
                              SmeBSB  delete
                              SmeLine  line
                              SmeBSB  close
                         SimpleMenu  tocMenu
                              SmeBSB  inc
                              SmeBSB  commit
                              SmeBSB  pack
                              SmeBSB  sort
                              SmeBSB  rescan
                         SimpleMenu  messageMenu
                              SmeBSB  compose
                              SmeBSB  next
                              SmeBSB  prev
                              SmeBSB  delete
                              SmeBSB  move
                              SmeBSB  copy
                              SmeBSB  unmark
                              SmeBSB  viewNew
                              SmeBSB  reply
                              SmeBSB  forward
                              SmeBSB  useAsComp
                              SmeBSB  print
                         SimpleMenu  sequenceMenu
                              SmeBSB  pick
                              SmeBSB  openSeq
                              SmeBSB  addToSeq
                              SmeBSB  removeFromSeq
                              SmeBSB  deleteSeq
                              SmeLine  line
                              SmeBSB  all
                         SimpleMenu  viewMenu
                              SmeBSB  reply
                              SmeBSB  forward
                              SmeBSB  useAsComp
                              SmeBSB  edit
                              SmeBSB  save
                              SmeBSB  print
                         SimpleMenu  optionMenu
                              SmeBSB  reverse
                         Viewport.Core  menuBox.clip
                              Box  menuBox
                                   MenuButton  folderButton
                                   MenuButton  tocButton
                                   MenuButton  messageButton
                                   MenuButton  sequenceButton
                                   MenuButton  viewButton
                                   MenuButton  optionButton
                         Grip  grip
                         Label folderTitlebar


          Rev. Release 4                                            Page 16






          XMH(1)                         AIX                         XMH(1)



                         Grip  grip
                         Viewport.Core  folders.clip
                              Box  folders
                                   MenuButton  inbox
                                   MenuButton  drafts
                                        SimpleMenu  menu
                                             SmeBSB <folder_name>
                                                  .
                                                  .
                                                  .

                         Grip  grip
                         Label  tocTitlebar
                         Grip  grip
                         Text toc
                              Scrollbar  vScrollbar
                         Grip  grip
                         Label  viewTitlebar
                         Grip  grip
                         Text  view
                              Scrollbar  vScrollbar
                              Scrollbar  hScrollbar

               The hierarchy of the Create Folder popup dialog box:

                    transientShell  prompt
                         Dialog  dialog
                              Label  label
                              Text  value
                              Command  okay
                              Command  cancel

               The hierarchy of the Notice dialog box, which reports messages from MH:

                    transientShell  notice
                         Dialog  dialog
                              Label  label
                              Text  value
                              Command  confirm

               The hierarchy of the Confirmation dialog box:

                    transientShell  confirm
                         Dialog  dialog
                              Label  label
                              Command  yes
                              Command  no

               The hierarchy of the dialog box which reports errors:

                    transientShell  error
                         Dialog  dialog
                              Label  label


          Rev. Release 4                                            Page 17






          XMH(1)                         AIX                         XMH(1)



                              Command  OK

               The hierarchy of the composition window:

                    topLevelShell  xmh
                         Paned  xmh
                              Label  composeTitlebar
                              Text  comp
                              Viewport.Core  compButtons.clip
                                   Box  compButtons
                                        Command  close
                                        Command  send
                                        Command  reset
                                        Command  compose
                                        Command  save
                                        Command  insert

               The hierarchy of the view window:

                    topLevelShell  xmh
                         Paned  xmh
                              Label  viewTitlebar
                              Text  view
                              Viewport.Core  viewButtons.clip
                                   Box  viewButtons
                                        Command  close
                                        Command  reply
                                        Command  forward
                                        Command  useAsComp
                                        Command  edit
                                        Command  save
                                        Command  print

               The hierarchy of the pick window:
               (Unnamed widgets have no name.)

                    topLevelShell  xmh
                         Paned  xmh
                              Label  pickTitlebar
                              Viewport.core  pick.clip
                                   Form  form
                                        Form
               The first 6 rows of the pick window have identical structure:
                                             Form
                                                  Toggle
                                                  Toggle
                                                  Label
                                                  Text
                                                  Command

                                             Form
                                                  Toggle
                                                  Toggle


          Rev. Release 4                                            Page 18






          XMH(1)                         AIX                         XMH(1)



                                                  Text
                                                  Text
                                                  Command
                                             Form
                                                  Command
                              Viewport.core  pick.clip
                                   Form  form
                                        From
                                             Form
                                                  Label
                                                  Text
                                                  Label
                                                  Text
                                             Form
                                                  Label
                                                  Text
                                                  Label
                                                  Text
                                                  Label
                                                  Text
                                             Form
                                                  Label
                                                  Toggle
                                                  Toggle
                                             Form
                                                  Command
                                                  Command


          APPLICATION-SPECIFIC RESOURCES
               Resource instance names begin with a lower case letter but
               are otherwise identical to the class name.

               If TocGeometry, ViewGeometry, CompGeometry, or PickGeometry
               are not specified, then the value of Geometry is used
               instead.  If the resulting height is not specified (e.g.,
               "", "=500", "+0-0"), then the default height of windows is
               calculated from fonts and line counts. If the width is not
               specified (e.g., "", "=x300", "-0+0), then half of the
               display width is used.  If unspecified, the height of a pick
               window defaults to half the height of the display.

               Any of these options may also be specified on the command
               line by using the X Toolkit Intrinsics resource specifica-
               tion mechanism.  Thus, to run xmh showing all message
               headers,

               % xmh -xrm '*HideBoringHeaders:off'

               The following resources are defined:

               Banner  A short string that is the default label of the
                       folder, Table of Contents, and view.  The default is


          Rev. Release 4                                            Page 19






          XMH(1)                         AIX                         XMH(1)



                       "xmh    MIT X Consortium    R4".

               BlockEventsOnBusy
                       Whether to disallow user input and show a busy cur-
                       sor while xmh is busy processing a command.  Default
                       is true.

               BusyCursor
                       The name of the symbol used to represent the posi-
                       tion of the pointer, displayed if BlockEventsOnBusy
                       is true, when xmh is processing a time-consuming
                       command.  The default is "watch".

               BusyPointerColor
                       The foreground color of the busy cursor.  Default is
                       XtDefaultForeground.

               CheckFrequency
                       How often to check for new mail, make checkpoints,
                       and rescan the Table of Contents, in minutes.  If
                       CheckNewMail is true, xmh checks to see if you have
                       new mail each interval.  If MakeCheckpoints is true,
                       checkpoints are made every fifth interval.  Also
                       every fifth interval, the Table of Contents is
                       checked for inconsistencies with the file system,
                       and rescanned.  To prevent all of these checks from
                       occurring, set CheckFrequency to 0.  The default is
                       1.

               CheckNewMail
                       If true, xmh will check at regular intervals to see
                       if new mail has arrived for any of the folders.  A
                       visual indication will be given if new mail is wait-
                       ing to be retrieved.  Default is True. (See BUGS).
                       The interval can be adjusted with the CheckFre-
                       quency.

               CommandButtonCount
                       The number of command buttons to create in a button
                       box in between the toc and the view areas of the
                       main window.  xmh will create these buttons with the
                       names button1, button2 and so on, in a box with the
                       name commandBox.  The user can specify labels and
                       actions for the buttons in a private resource file;
                       see the section on Actions.  The default is 0.

               CompGeometry
                       Initial geometry for windows containing composi-
                       tions.

               Cursor  The name of the symbol used to represent the
                       pointer.  Default is ``left_ptr''.



          Rev. Release 4                                            Page 20






          XMH(1)                         AIX                         XMH(1)



               DraftsFolder
                       The folder used for message drafts.  Default is
                       ``drafts''.

               Geometry
                       Default geometry to use.  Default is none.

               HideBoringHeaders
                       If ``on'', then xmh will attempt to skip uninterest-
                       ing header lines within messages by scrolling them
                       off.  Default is ``on''.

               InitialFolder
                       Which folder to display on startup.  May also be set
                       with the command-line option -initial.  Default is
                       ``inbox''.

               InitialIncFile
                       The file name of your incoming mail drop.  xmh tries
                       to construct a filename for the ``inc -file'' com-
                       mand, but in some installations (e.g. those using
                       the Post Office Protocol) no file is appropriate.
                       In this case, InitialIncFile should be specified as
                       the empty string, and inc will be invoked without a
                       -file argument.  The default is to use the value of
                       the environment variable MAIL, or if that is not
                       set, to append the value of the environment variable
                       USER to /usr/spool/mail/.

               MailPath
                       The full path prefix for locating your mail folders.
                       May also be set with the command-line option, -path.
                       The default is the Path component in
                       $HOME/.mh_profile, or ``$HOME/Mail'' if none.

               MailWaitingFlag
                       If true, xmh will attempt to set an indication in
                       its icon when new mail is waiting to be retrieved.
                       If this option is true, then CheckNewMail is assumed
                       to be true as well.  The -flag command line option
                       is a quick way to turn MailWaitingFlag on.

               MakeCheckpoints
                       If true, xmh will attempt to save checkpoints of
                       volatile information.  The frequency of checkpoint-
                       ing is controlled by the resource CheckFrequency.

               MhPath  What directory in which to find the MH commands.  If
                       a command isn't found here, then the directories in
                       the user's path are searched.  Default is
                       ``/usr/local/mh6''.

               PickGeometry


          Rev. Release 4                                            Page 21






          XMH(1)                         AIX                         XMH(1)



                       Initial geometry for pick windows.

               PointerColor
                       The foreground color of the pointer.  Default is
                       XtDefaultForeground.

               PrefixWmAndIconName
                       Whether to prefix the window and icon name with
                       "xmh: ".  Default is true.

               PrintCommand
                       What sh command to execute to print a message.  Note
                       that stdout and stderr must be specifically
                       redirected!  If a message or range of messages is
                       selected for printing, the full file paths of each
                       message file is appended to the specified print com-
                       mand.  The default is ``enscript >/dev/null
                       2>/dev/null''.

               ReplyInsertFilter
                       A shell command to be executed when the Insert but-
                       ton is activated in a composition window.  The full
                       path and filename of the source message is added to
                       the end of the command before being passed to sh(1).
                       The default filter is cat; i.e. it inserts the
                       entire message into the composition.  Interesting
                       filters are: awk -e '{print "    " $0}' or <mh
                       directory>/lib/mhl -form mhl.body.

               ReverseReadOrder
                       When true, the next message will be the message
                       prior to the current message in the table of con-
                       tents, and the previous message will be the message
                       after the current message in the table of contents.
                       The default is false.

               SendBreakWidth
                       When a message is sent from xmh, lines longer than
                       this value will be split into multiple lines, each
                       of which is no longer than SendWidth.  This value
                       may be overridden for a single message by inserting
                       an additional line in the message header of the form
                       SendBreakWidth: value.  This line will be removed
                       from the header before the message is sent.  The
                       default is 85.

               SendWidth
                       When a message is sent from xmh, lines longer than
                       SendBreakWidth characters will be split into multi-
                       ple lines, each of which is no longer than this
                       value.  This value may be overridden for a single
                       message by inserting an additional line in the mes-
                       sage header of the form SendWidth: value.  This line


          Rev. Release 4                                            Page 22






          XMH(1)                         AIX                         XMH(1)



                       will be removed from the header before the message
                       is sent.  The default is 72.

               SkipCopied
                       Whether to skip over messages marked for copying
                       when using ``View Next Message'' and ``View Previous
                       Message''.  Default is true.

               SkipDeleted
                       Whether to skip over messages marked for deletion
                       when using ``View Next Message'' and ``View Previous
                       Message''.  Default is true.

               SkipMoved
                       Whether to skip over messages marked for moving to
                       other folders when using ``View Next Message'' and
                       ``View Previous Message''.  Default is true.

               StickyMenu
                       If true, when popup command menus are used, the most
                       recently selected entry will be under the cursor
                       when the menu pops up.  Default is false.  See the
                       file clients/xmh/Xmh.sample for an example of how to
                       specify resources for pop up command menus.

               TempDir Directory for xmh to store temporary directories.
                       For privacy, a user might want to change this to a
                       private directory.  Default is ``/tmp''.

               TocGeometry
                       Initial geometry for master xmh windows.

               TocPercentage
                       The percentage of the main window that is used to
                       display the Table of Contents.  Default is 33.

               TocWidth
                       How many characters to generate for each message in
                       a folder's table of contents.  Default is 100.  Use
                       80 if you plan to use mhl a lot, because it will be
                       faster, and the extra 20 characters may not be use-
                       ful.

               ViewGeometry
                       Initial geometry for windows showing only a view of
                       a message.


          ACTIONS
               Because xmh provides action procedures which correspond to
               command functionality and installs accelerators, users can
               customize accelerators in a private resource file.  xmh pro-
               vides action procedures which correspond to entries in the


          Rev. Release 4                                            Page 23






          XMH(1)                         AIX                         XMH(1)



               command menus; these are given in the sections describing
               menu commmands.  For examples of specifying customized
               resources, see the file clients/xmh/Xmh.sample.  Unpredict-
               able results can occur if actions are bound to events or
               widgets for which they were not designed.

               In addition to the actions corresponding to commands, these
               action routines are defined:

               XmhPushFolder([foldername, ...])
                                 This action pushes each of its argument(s)
                                 onto a stack of foldernames.  If no argu-
                                 ments are given, the selected folder is
                                 pushed onto the stack.

               XmhPopFolder()    This action pops one foldername from the
                                 stack and sets the selected folder.

               XmhPopupFolderMenu()
                                 This action should always be taken when
                                 the user selects a folder button.  A
                                 folder button represents a folder and zero
                                 or more subfolders.  The menu of subfold-
                                 ers is built upon the first reference, by
                                 this routine.  If there are no subfolders,
                                 this routine will mark the folder as hav-
                                 ing no subfolders, and no menu will be
                                 built.  In that case the menu button emu-
                                 lates a toggle button.  When subfolders
                                 exist, the menu will popup, using the menu
                                 button action PopupMenu().

               XmhSetCurrentFolder()
                                 This action allows menu buttons to emulate
                                 toggle buttons in the function of select-
                                 ing a folder.  This action is for menu
                                 button widgets only, and sets the selected
                                 folder.

               XmhLeaveFolderButton()
                                 This action insures that the menu button
                                 behaves properly when the user moves the
                                 pointer out of the menu button window.

               XmhPushSequence([sequencename, ...])
                                 This action pushes each of its arguments
                                 onto the stack of sequence names.  If no
                                 arguments are given, the selected sequence
                                 is pushed onto the stack.

               XmhPopSequence()  This action pops one sequence name from
                                 the stack of sequence names, which then
                                 becomes the selected sequence.


          Rev. Release 4                                            Page 24






          XMH(1)                         AIX                         XMH(1)



               XmhPromptOkayAction()
                                 This action is equivalent to pressing the
                                 okay button in the Create Folder popup.

               XmhCancelPick()   This action is equivalent to pressing the
                                 cancel button in the pick window.


          CUSTOMIZATION USING MH
               The initial text displayed in a composition window is gen-
               erated by executing the corresponding MH command; i.e. comp,
               repl, or forw, and therefore message components may be cus-
               tomized as specified for those commands.  Comp is executed
               only once per invocation of xmh and the message template is
               re-used for each successive new composition.

          FILES
               ~/Mail
               ~/.mh_profile - MH profile
               /usr/local/mh6 - MH commands
               ~/Mail/<folder>/.xmhcache - scan folder
               ~/Mail/<folder>/.mh_sequences - sequence definitions
               /tmp - temporary files

          SEE ALSO
               X(1), xrdb(1), X Toolkit Intrinsics, Athena Widget Set,
               mh(1), enscript(1)

          BUGS
               - Printing support is minimal.
               - Should handle the ``unseen'' message-sequence.
               - Should determine by itself if the user hasn't used MH
               before, and offer to create the .mh_profile, instead of
               hanging on inc.
               - Still a few commands missing (rename folder, remail mes-
               sage).
               - A bug in MH limits the the number of characters in
               .mh_sequences to BUFSIZ.  When the limit is reached, the
               .mh_sequences file often becomes corrupted, and sequence
               definitions may be lost.
               - Except for the icon, there isn't an indication that you
               have new mail.
               - There should be a resource, ShowOnInc, which when true,
               would show the current message in the view after incorporat-
               ing new mail.
               - The CheckFrequency resource should be split into two
               separate resources.
               - WM_SAVE_YOURSELF protocol is ignored.
               - WM_DELETE_WINDOW protocol doesn't work right when request-
               ing deletion of the first toc and view, while trying to keep
               other xmh windows around.
               - Doesn't support annotations when replying to messages.



          Rev. Release 4                                            Page 25






          XMH(1)                         AIX                         XMH(1)



          COPYRIGHT
               Copyright 1988, 1989, Digital Equipment Corporation.
               Copyright 1989, Massachusetts Institute of Technology
               See X(1) for a full statement of rights and permissions.

          AUTHOR
               Terry Weissman, Digital Western Research Laboratory
               modified by Donna Converse, MIT X Consortium















































          Rev. Release 4                                            Page 26



