


          XHOST(1)                       AIX                       XHOST(1)



          NAME
               xhost - server access control program for X

          SYNOPSIS
               xhost [[+-]hostname ...]

          DESCRIPTION
               The xhost program is used to add and delete hosts to the
               list of machines that are allowed to make connections to the
               X server.  This provides a rudimentary form of privacy con-
               trol and security.  It is only sufficient for a workstation
               (single user) environment, although it does limit the worst
               abuses.  Environments which require more sophisticated meas-
               ures should use the hooks in the protocol for passing
               authentication data to the server.

               The server initially allows network connections only from
               programs running on the same machine or from machines listed
               in the file /etc/X*.hosts (where * is the display number of
               the server).  The xhost program is usually run either from a
               startup file or interactively to give access to other users.

               Hostnames that are followed by two colons (::) are used in
               checking DECnet connections; all other hostnames are used
               for TCP/IP connections.

          OPTIONS
               Xhost accepts the following command line options described
               below.  For security, the options that effect access control
               may only be run from the same machine as the server.

               [+]hostname
                       The given hostname (the plus sign is optional) is
                       added to the list of machines that are allowed to
                       connect to the X server.

               -hostname
                       The given hostname is removed from the list of
                       machines that are allowed to connect to the server.
                       Existing connections are not broken, but new connec-
                       tion attempts will be denied.  Note that the current
                       machine is allowed to be removed; however, further
                       connections (including attempts to add it back) will
                       not be permitted.  Resetting the server (thereby
                       breaking all connections) is the only way to allow
                       local connections again.

               +       Access is granted to everyone, even if they aren't
                       on the list of allowed hosts (i.e. access control is
                       turned off).

               -       Access is restricted to only those machines on the
                       list of allowed hosts (i.e. access control is turned


          Rev. Release 4                                             Page 1






          XHOST(1)                       AIX                       XHOST(1)



                       on).

               nothing If no command line arguments are given, the list of
                       hosts that are allowed to connect is printed on the
                       standard output along with a message indicating
                       whether or not access control is currently enabled.
                       This is the only option that may be used from
                       machines other than the one on which the server is
                       running.

          FILES
               /etc/X*.hosts

          SEE ALSO
               X(1), Xserver(1)

          ENVIRONMENT
               DISPLAY to get the default host and display to use.

          BUGS
               You can't specify a display on the command line because
               -display is a valid command line argument (indicating that
               you want to remove the machine named ``display'' from the
               access list).

          COPYRIGHT
               Copyright 1988, Massachusetts Institute of Technology.
               See X(1) for a full statement of rights and permissions.

          AUTHORS
               Bob Scheifler, MIT Laboratory for Computer Science,
               Jim Gettys, MIT Project Athena (DEC).























          Rev. Release 4                                             Page 2



