


          XDM(1)                         AIX                         XDM(1)



          NAME
               xdm - X Display Manager

          SYNOPSIS
               xdm [-config configuration_file] [-daemon] [-debug
               debug_level] [-error error_log_file] [-nodaemon] [-resources
               resource_file] [-server server_entry] [-session
               session_program] [-xrm resource_specification]

          DESCRIPTION
               Xdm manages a collection of X displays, both local and pos-
               sibly remote - the emergence of X terminals guided the
               design of several parts of this system, along with the
               development of the X Consortium standard XDMCP, the X
               Display Manager Control Protocol).  It is designed to pro-
               vide services similar to that provided by init, getty and
               login on character terminals:  prompting for login/password,
               authenticating the user and running a ``session''.

               A ``session'' is defined by the lifetime of a particular
               process; in the traditional character-based terminal world,
               it is the user's login shell process.  In the xdm context,
               it is an arbitrary session manager.  This is because in a
               windowing environment, a user's login shell process would
               not necessarily have any terminal-like interface with which
               to connect.

               Until real session managers become widely available, the
               typical xdm substitute would be either a window manager with
               an exit option, or a terminal emulator running a shell -
               with the condition that the lifetime of the terminal emula-
               tor is the lifetime of the shell process that it is running
               - thus degenerating the X session to an emulation of the
               character-based terminal session.

               When the session is terminated, xdm resets the X server and
               (optionally) restarts the whole process.

               Because xdm provides the first interface that users will
               see, it is designed to be simple to use and easy to custom-
               ize to the needs of a particular site.  Xdm has many
               options, most of which have reasonable defaults.  Browse
               through the various sections, picking and choosing the
               things you want to change.  Pay particular attention to the
               Xsession section, which will describe how to set up the
               style of session desired.

          OPTIONS
               First, note that all of these options, except -config,
               specify values which can also be specified in the configura-
               tion file as resources.

               -config configuration_file


          Rev. Release 4                                             Page 1






          XDM(1)                         AIX                         XDM(1)



                    Specifies a resource file which specifies the remaining
                    configuration parameters.  If no file is specified and
                    the file /usr/lib/X11/xdm/xdm-config exists, xdm will
                    use it.

               -daemon
                    Specifies ``true'' as the value for the
                    DisplayManager.daemonMode resource.  This makes xdm
                    close all file descriptors, disassociate the control-
                    ling terminal and put itself in the background when it
                    first starts up (just like the host of other daemons).
                    It is the default behavior.

               -debug debug_level
                    Specifies the numeric value for the
                    DisplayManager.debugLevel resource.  A non-zero value
                    causes xdm to print piles of debugging statements to
                    the terminal; it also disables the
                    DisplayManager.daemonMode resource, forcing xdm to run
                    synchronously.  To interpret these debugging messages,
                    a copy of the source code for xdm is almost a neces-
                    sity.  No attempt has been made to rationalize or
                    standardize the output.

               -error error_log_file
                    Specifies the value for the DisplayManager.errorLogFile
                    resource.  This file contains errors from xdm as well
                    as anything written to stderr by the various scripts
                    and programs run during the progress of the session.

               -nodaemon
                    Specifies ``false'' as the value for the
                    DisplayManager.daemonMode resource.

               -resources resource_file
                    Specifies the value for the DisplayManager*resources
                    resource.  This file is loaded using xrdb (1) to
                    specify configuration parameters for the authentication
                    widget.

               -server server_entry
                    Specifies the value for the DisplayManager.servers
                    resource.  See the section below which describes this
                    resource in depth.

               -udpPort port_number
                    Specifies the value for the DisplayManager.requestPort
                    resource.  This sets the port-number which XDM will
                    monitor for XDMCP requests.  As XDMCP uses the
                    registered well-known udp port 177, this resource
                    should probably not be changed except for debugging.

               -session session_program


          Rev. Release 4                                             Page 2






          XDM(1)                         AIX                         XDM(1)



                    Specifies the value for the DisplayManager*session
                    resource.  This indicates the program to run when the
                    user has logged in as the session.

               -xrm resource_specification
                    This allows an arbitrary resource to be specified, just
                    as most toolkit applications.

          RESOURCES
               At many stages the actions of xdm can be controlled through
               the use of the configuration file, which is in the familiar
               X resource format.  See Jim Fulton's article on resource
               files (doc/tutorials/resources.txt) for a description of the
               format.  Some resources modify the behavior of xdm on all
               displays, while others modify its behavior on one single
               display.  Where actions relate to a specific display, the
               display name is inserted into the resource name between
               ``DisplayManager'' and the final resource name segment.  For
               example, DisplayManager.expo_0.startup is the name of the
               resource which defines the startup shell file on the
               ``expo:0'' display.  Because the resource manager uses
               colons to separate the name of the resource from its value
               and dots to separate resource name parts, xdm substitutes
               underscores for the dots and colons when generating the
               resource name.

               DisplayManager.servers
                    This resource either specifies a file name full of
                    server entries, one per line (if the value starts with
                    a slash), or a single server entry.  Each entry indi-
                    cates a displays which should constantly be managed and
                    which is not using XDMCP.  Each entry consists of at
                    least three parts:  a display name, a display class, a
                    display type, and (for local servers) a command line to
                    start the server.  A typical entry for local display
                    number 0 would be:

                      :0 Digital-QV local /usr/bin/X11/X :0

                    The display types are:

                    local          a local display, i.e. one which has a server program to run
                    foreign        a remote display, i.e. one which has no server program to run


                    The display name must be something that can be passed
                    in the -display option to any X program.  This string
                    is used in the display-specific resources to specify
                    the particular display, so be careful to match the
                    names (e.g. use ":0 local /usr/bin/X11/X :0" instead of
                    "localhost:0 local /usr/bin/X11/X :0" if your other
                    resources are specified as
                    "DisplayManager._0.session").  The display class


          Rev. Release 4                                             Page 3






          XDM(1)                         AIX                         XDM(1)



                    portion is also used in the display-specific resources,
                    as the class portion of the resource.  This is useful
                    if you have a large collection of similar displays
                    (like a corral of X terminals) and would like to set
                    resources for groups of them.  When using XDMCP, the
                    display is required to specify the display class, so
                    perhaps your X terminal documentation describes a rea-
                    sonably standard display class string for your device.

               DisplayManager.requestPort
                    This indicates the UDP port number which xdm uses to
                    listen for incoming XDMCP requests.  Unless you need to
                    debug the system, leave this with it's default value of
                    177.

               DisplayManager.errorLogFile
                    Error output is normally directed at the system con-
                    sole.  To redirect it simply set this resource to any
                    file name.  A method to send these messages to syslog
                    should be developed for systems which support it; how-
                    ever the wide variety of "standard" interfaces pre-
                    cludes any system-independent implementation.  This
                    file also contains any output directed to stderr by
                    Xstartup, Xsession and Xreset, so it will contain
                    descriptions of problems in those scripts as well.

               DisplayManager.debugLevel
                    A non-zero value specified for this integer resource
                    will enable reams of debugging information to be
                    printed.  It also disables daemon mode which would
                    redirect the information into the bit-bucket.  Specify-
                    ing a non-zero debug level also allows non-root users
                    to run xdm which would normally not be useful.

               DisplayManager.daemonMode
                    Normally, xdm attempts to make itself into an unassoci-
                    ated daemon process.  This is accomplished by forking
                    and leaving the parent process to exit, then closing
                    file descriptors and mangling the controlling terminal.
                    When attempting to debug xdm , this is quite bother-
                    some.  Setting this resource to "false" will disable
                    this feature.

               DisplayManager.pidFile
                    The filename specified will be created to contain an
                    ascii representation of the process-id of the main xdm
                    process.  This is quite useful when reinitializing the
                    system.  Xdm also uses file locking to attempt to elim-
                    inate multiple daemons running on the same machine,
                    which would cause quite a bit of havoc.

               DisplayManager.lockPidFile
                    This is the resource which controls whether xdm uses


          Rev. Release 4                                             Page 4






          XDM(1)                         AIX                         XDM(1)



                    file locking to keep multiple xdms from running amok.
                    On SYSV, this uses the lockf library call, while on BSD
                    it uses flock.  The default value is "true".

               DisplayManager.remoteAuthDir
                    This is a directory name which xdm uses to temporarily
                    store authorization files for displays using XDMCP.
                    The default value is /usr/lib/X11/xdm.

               DisplayManager.autoRescan"
                    This boolean controls whether xdm rescans the confi-
                    guration file and servers file after a session ter-
                    minates and the files have changed.  By default it is
                    "true".  You can force xdm to reread these files by
                    sending a SIGHUP to the main process.

               DisplayManager.removeDomainname
                    When computing the display name for XDMCP clients, the
                    resolver will typically create a fully qualified host
                    name for the terminal.  As this is sometimes confusing,
                    xdm will remove the domain name portion of the host
                    name if it is the same as the domain name for the local
                    host when this variable is set.  By default the value
                    is "true".

               DisplayManager.keyFile
                    XDM-AUTHENTICATION-1 style XDMCP authentication
                    requires that a private key be shared between xdm and
                    the terminal.  This resource specifies the file con-
                    taining those values.  Each entry in the file consists
                    of a display name and the shared key.  By default, xdm
                    does not include support for XDM-AUTHENTICATION-1 as it
                    requires DES which is not generally distributable.

               DisplayManager.DISPLAY.resources
                    This resource specifies the name of the file to be
                    loaded by xrdb (1) as the resource data-base onto the
                    root window of screen 0 of the display.  This resource
                    data base is loaded just before the authentication pro-
                    cedure is started, so it can control the appearance of
                    the "login" window.  See the section below on the
                    authentication widget which describes the various
                    resources which are appropriate to place in this file.
                    There is no default value for this resource, but the
                    conventional name is /usr/lib/X11/xdm/Xresources.

               DisplayManager.DISPLAY.xrdb
                    Specifies the program used to load the resources.  By
                    default, xdm uses /usr/bin/X11/xrdb.

               DisplayManager.DISPLAY.cpp
                    This specifies the name of the C preprocessor which is
                    used by xrdb.


          Rev. Release 4                                             Page 5






          XDM(1)                         AIX                         XDM(1)



               DisplayManager.DISPLAY.startup
                    This specifies a program which is run (as root) after
                    the authentication process succeeds.  By default, no
                    program is run.  The conventional name for a file used
                    here is Xstartup.  See the Xstartup section below.

               DisplayManager.DISPLAY.session
                    This specifies the session to be executed (not running
                    as root).  By default, /usr/bin/X11/xterm is run.  The
                    conventional name is Xsession.  See the Xsession ses-
                    sion below.

               DisplayManager.DISPLAY.reset
                    This specifies a program which is run (as root) after
                    the session terminates.  Again, by default no program
                    is run.  The conventional name is Xreset.  See the
                    Xreset section further on in this document.

               DisplayManager.DISPLAY.openDelay

               DisplayManager.DISPLAY.openRepeat

               DisplayManager.DISPLAY.openTimeout

               DisplayManager.DISPLAY.startAttempts
                    These numeric resources control the behavior of xdm
                    when attempting to open intransigent servers.  openDe-
                    lay is the length of the pause (in seconds) between
                    successive attempts, openRepeat is the number of
                    attempts to make, openTimeout is the amount of time to
                    wait while actually attempting the open (i.e. the max-
                    imum time spent in the connect (2) syscall) and star-
                    tAttempts is the number of times this entire process is
                    done before giving up on the server.  After openRepeat
                    attempts have been made, or if openTimeout seconds
                    elapse in any particular attempt, xdm terminates and
                    restarts the server, attempting to connect again, this
                    process is repeated startAttempts time, at which point
                    the display is declared dead and disabled.  Although
                    this behavior may seem arbitrary, it has been empiri-
                    cally developed and works quite well on most systems.
                    The default values are 5 for openDelay, 5 for open-
                    Repeat, 30 for openTimeout and 4 for startAttempts.

               DisplayManager.DISPLAY.pingInterval

               DisplayManager.DISPLAY.pingTimeout
                    To discover when remote displays disappear, xdm occa-
                    sionally "pings" them, using an X connection and send-
                    ing XSync requests.  pingInterval specifies the time
                    (in minutes) between each ping attempt, pingTimeout
                    specifies the maximum amount of time (in minutes) to
                    wait for the terminal to respond to the request.  If


          Rev. Release 4                                             Page 6






          XDM(1)                         AIX                         XDM(1)



                    the terminal does not respond, the session is declared
                    dead and terminated.  By default, both are set to 5
                    minutes.  xdm will not ping local displays.  Although
                    it would seem harmless, it is unpleasant when the
                    workstation session is terminated as a result of the
                    server hanging for NFS service and not responding to
                    the ping.

               DisplayManager.DISPLAY.terminateServer
                    This boolean resource specifies whether the X server
                    should be terminated when a session terminates (instead
                    of resetting it).  This option can be used when the
                    server tends to grow without bound over time in order
                    to limit the amount of time the server is run.  The
                    default value is "FALSE".

               DisplayManager.DISPLAY.userPath
                    Xdm sets the PATH environment variable for the session
                    to this value.  It should be a colon separated list of
                    directories, see sh(1) for a full description.  The
                    default value can be specified in the X system confi-
                    guration file with DefUserPath, frequently it is set to
                    ":/bin:/usr/bin:/usr/bin/X11:/usr/ucb".

               DisplayManager.DISPLAY.systemPath
                    Xdm sets the PATH environment variable for the startup
                    and reset scripts to the value of this resource.  The
                    default for this resource is specified with the
                    DefaultSystemPath entry in the system configuration
                    file, but it is frequently
                    "/etc:/bin:/usr/bin:/usr/bin/X11:/usr/ucb".  Note the
                    conspicuous absence of "." from this entry.  This is a
                    good practise to follow for root; it avoids many common
                    trojan horse system penetration schemes.

               DisplayManager.DISPLAY.systemShell
                    Xdm sets the SHELL environment variable for the startup
                    and reset scripts to the value of this resource.  By
                    default, it is "/bin/sh".

               DisplayManager.DISPLAY.failsafeClient
                    If the default session fails to execute, xdm will fall
                    back to this program.  This program is executed with no
                    arguments, but executes using the same environment
                    variables as the session would have had (see the sec-
                    tion "Xsession" below).  By default, /usr/bin/X11/xterm
                    is used.

               DisplayManager.DISPLAY.grabServer

               DisplayManager.DISPLAY.grabTimeout
                    To eliminate obvious security shortcomings in the X
                    protocol, xdm grabs the server and keyboard while


          Rev. Release 4                                             Page 7






          XDM(1)                         AIX                         XDM(1)



                    reading the name/password.  The grabServer resource
                    specifies if the server should be held for the duration
                    of the name/password reading, when FALSE, the server is
                    ungrabbed after the keyboard grab succeeds, otherwise
                    the server is grabbed until just before the session
                    begins.  The grabTimeout resource specifies the maximum
                    time xdm will wait for the grab to succeed.  The grab
                    may fail if some other client has the server grabbed,
                    or possibly if the network latencies are very high.
                    This resource has a default value of 3 seconds; you
                    should be cautious when raising it as a user can be
                    spoofed by a look-alike window on the display.  If the
                    grab fails, xdm kills and restarts the server (if pos-
                    sible) and session.

               DisplayManager.DISPLAY.authorize

               DisplayManager.DISPLAY.authName
                    authorize is a boolean resource which controls whether
                    xdm generates and uses authorization for the server
                    connections.  If authorization is used, authName speci-
                    fies the type to use.  Currently, xdm supports only
                    MIT-MAGIC-COOKIE-1 authorization, XDM-AUTHORIZATION-1
                    could be supported as well, but DES is not generally
                    distributable.  XDMCP connections specify which author-
                    ization types are supported dynamically, so authName is
                    ignored in this case.  When authorize is set for a
                    display and authorization is not available, the user is
                    informed by having a different message displayed in the
                    login widget.  By default, authorize is "true"; auth-
                    Name is "MIT-MAGIC-COOKIE-1".

               DisplayManager.DISPLAY.authFile"
                    This file is used to communicate the authorization data
                    from xdm to the server, using the -auth server command
                    line option.  It should be kept in a directory which is
                    not world-writable as it could easily be removed, disa-
                    bling the authorization mechanism in the server.

               DisplayManager.DISPLAY.resetForAuth
                    The original implementation of authorization in the
                    sample server reread the authorization file at server
                    reset time, instead of when checking the initial con-
                    nection.  As xdm generates the authorization informa-
                    tion just before connecting to the display, an old
                    server would not get up-to-date authorization informa-
                    tion.  This resource causes xdm to send SIGHUP to the
                    server after setting up the file, causing an additional
                    server reset to occur, during which time the new
                    authorization information will be read

               DisplayManager.DISPLAY.userAuthDir
                    When xdm is unable to write to the usual user


          Rev. Release 4                                             Page 8






          XDM(1)                         AIX                         XDM(1)



                    authorization file ($HOME/.Xauthority), it creates a
                    unique file name in this directory and points the
                    environment variable XAUTHORITY at the created file.
                    By default it uses "/tmp".

          CONTROLLING THE SERVER
               Xdm controls local servers using POSIX signals.  SIGHUP is
               expected to reset the server, closing all client connections
               and performing other clean up duties.  SIGTERM is expected
               to terminate the server.  If these signals do not perform
               the expected actions, xdm will not perform properly.

               To control remote servers not using XDMCP, xdm searches the
               window hierarchy on the display and uses the protocol
               request KillClient in an attempt to clean up the terminal
               for the next session.  This may not actually kill all of the
               clients, as only those which have created windows will be
               noticed.  XDMCP provides a more sure mechanism; when xdm
               closes it's initial connection, the session is over and the
               terminal is required to close all other connections.

          CONTROLLING XDM
               Xdm responds to two signals: SIGHUP and SIGTERM.  When sent
               a SIGHUP, xdm rereads the configuration file and the 1file
               specified by the DisplayManager.servers resource and notices
               if entries have been added or removed.  If a new entry has
               been added, xdm starts a session on the associated display.
               Entries which have been removed are disabled immediately,
               meaning that any session in progress will be terminated
               without notice, and no new session will be started.

               When sent a SIGTERM, xdm terminates all sessions in progress
               and exits.  This can be used when shutting down the system.

               Xdm attempts to mark the various sub-processes for ps(1) by
               editing the command line argument list in place.  Because
               xdm can't allocate additional space for this task, it is
               useful to start xdm with a reasonably long command line (15
               to 20 characters should be enough).  Each process which is
               servicing a display is marked "-<Display-Name>".

          AUTHENTICATION WIDGET
               The authentication widget is an application which reads a
               name/password pair from the keyboard.  As this is a toolkit
               client, nearly every imaginable parameter can be controlled
               with a resource.  Resources for this widget should be put
               into the file named by DisplayManager.DISPLAY.resources.
               All of these have reasonable default values, so it is not
               necessary to specify any of them.

          xlogin.Login.y
               xlogin.Login.width, xlogin.Login.height, xlogin.Login.x,
                    The geometry of the login widget is normally computed


          Rev. Release 4                                             Page 9






          XDM(1)                         AIX                         XDM(1)



                    automatically.  If you wish to position it elsewhere,
                    specify each of these resources.

               xlogin.Login.foreground
                    The color used to display the typed-in user name.

               xlogin.Login.font
                    The font used to display the typed-in user name.

               xlogin.Login.greeting
                    A string which identifies this window.  The default is
                    "Welcome to the X Window System".

               xlogin.Login.unsecureGreeting
                    When X authorization is requested in the configuration
                    file for this display and none is in use, this greeting
                    replaces the standard greeting.  It's default value is
                    "This is an unsecure session"

               xlogin.Login.greetFont
                    The font used to display the greeting.

               xlogin.Login.greetColor
                    The color used to display the greeting.

               xlogin.Login.namePrompt
                    The string displayed to prompt for a user name.  Xrdb
                    strips trailing white space from resource values, so to
                    add spaces at the end of the prompt (usually a nice
                    thing), add spaces escaped with backslashes.  The
                    default is "Login:  "

               xlogin.Login.passwdPrompt
                    The string displayed to prompt for a password.  The
                    default is "Password:  ".

               xlogin.Login.promptFont
                    The font used to display both prompts.

               xlogin.Login.promptColor
                    The color used to display both prompts.

               xlogin.Login.fail
                    A message which is displayed when the authentication
                    fails.  The default is "Login Failed, please try
                    again".

               xlogin.Login.failFont
                    The font used to display the failure message.

               xlogin.Login.failColor
                    The color used to display the failure message.



          Rev. Release 4                                            Page 10






          XDM(1)                         AIX                         XDM(1)



               xlogin.Login.failTimeout
                    The time (in seconds) that the fail message is
                    displayed.  The default is 30 seconds.

               xlogin.Login.translations
                    This specifies the translations used for the login
                    widget.  Refer to the X Toolkit documentation for a
                    complete discussion on translations.  The default
                    translation table is:

                         Ctrl<Key>H:    delete-previous-character() \n\
                         Ctrl<Key>D:    delete-character() \n\
                         Ctrl<Key>B:    move-backward-character() \n\
                         Ctrl<Key>F:    move-forward-character() \n\
                         Ctrl<Key>A:    move-to-begining() \n\
                         Ctrl<Key>E:    move-to-end() \n\
                         Ctrl<Key>K:    erase-to-end-of-line() \n\
                         Ctrl<Key>U:    erase-line() \n\
                         Ctrl<Key>X:    erase-line() \n\
                         Ctrl<Key>C:    restart-session() \n\
                         Ctrl<Key>\\:   abort-session() \n\
                         <Key>BackSpace:delete-previous-character() \n\
                         <Key>Delete:   delete-previous-character() \n\
                         <Key>Return:   finish-field() \n\
                         <Key>:         insert-char() \


               The actions which are supported by the widget are:

               delete-previous-character
                    Erases the character before the cursor.

               delete-character
                    Erases the character after the cursor.

               move-backward-character
                    Moves the cursor backward.

               move-forward-character
                    Moves the cursor forward.

               move-to-begining
                    (Apologies about the spelling error.) Moves the cursor
                    to the beginning of the editable text.

               move-to-end
                    Moves the cursor to the end of the editable text.

               erase-to-end-of-line
                    Erases all text after the cursor.

               erase-line
                    Erases the entire text.


          Rev. Release 4                                            Page 11






          XDM(1)                         AIX                         XDM(1)



               finish-field
                    If the cursor is in the name field, proceeds to the
                    password field; if the cursor is in the password field,
                    check the current name/password pair.  If the
                    name/password pair are valid, xdm starts the session.
                    Otherwise the failure message is displayed and the user
                    is prompted to try again.

               abort-session
                    Terminates and restarts the server.

               abort-display
                    Terminates the server, disabling it.  This is a rash
                    action and is not accessible in the default configura-
                    tion.  It can be used to stop xdm when shutting the
                    system down, or when using xdmshell.

               restart-session
                    Resets the X server and starts a new session.  This can
                    be used when the resources have been changed and you
                    want to test them, or when the screen has been
                    overwritten with system messages.

               insert-char
                    Inserts the character typed.

               set-session-argument
                    Specifies a single word argument which is passed to the
                    session at startup.  See the sections on Xsession and
                    Typical usage.

               allow-all-access
                    Disables access control in the server, this can be used
                    when the .Xauthority file cannot be created by xdm.  Be
                    very careful using this, it might be better to discon-
                    nect the machine from the network before doing this.

          The Xstartup file
               This file is typically a shell script.  It is run as "root"
               and should be very careful about security.  This is the
               place to put commands which make fake entries in /etc/utmp,
               mount users' home directories from file servers, display the
               message of the day, or abort the session if logins are not
               allowed.  Various environment variables are set for the use
               of this script:

                    DISPLAY        is set to the associated display name
                    HOME           is set to the home directory of the user
                    USER           is set to the user name
                    PATH           is set to the value of DisplayManager.DISPLAY.systemPath
                    SHELL          is set to the value of DisplayManager.DISPLAY.systemShell
                    XAUTHORITY     may be set to an authority file



          Rev. Release 4                                            Page 12






          XDM(1)                         AIX                         XDM(1)



               No arguments of any kind are passed to the script.  Xdm
               waits until this script exits before starting the user ses-
               sion.  If the exit value of this script is non-zero, xdm
               discontinues the session immediately and starts another
               authentication cycle.

          The Xsession program
               This is the command which is run as the user's session.  It
               is run with the permissions of the authorized user, and has
               several environment variables specified:

                    DISPLAY        is set to the associated display name
                    HOME           is set to the home directory of the user
                    USER           is set to the user name
                    PATH           is set to the value of DisplayManager.DISPLAY.userPath
                    SHELL          is set to the user's default shell (from /etc/passwd)
                    XAUTHORITY     may be set to a non-standard authority file


               At most installations, Xsession should look in $HOME for a
               file .xsession which would contain commands that each user
               would like to use as a session.  This would replace the sys-
               tem default session.  Xsession should also implement the
               system default session if no user-specified session exists.
               See the section Typical Usage below.

               An argument may be passed to this program from the authenti-
               cation widget using the `set-session-argument' action.  This
               can be used to select different styles of session.  One very
               good use of this feature is to allow the user to escape from
               the ordinary session when it fails.  This would allow users
               to repair their own .xsession if it fails, without requiring
               administrative intervention.  The section on typical usage
               demonstrates this feature.

          The Xreset file
               Symmetrical with Xstartup, this script is run after the user
               session has terminated.  Run as root, it should probably
               contain commands that undo the effects of commands in
               Xstartup, removing fake entries from /etc/utmp or unmounting
               directories from file servers.  The collection of environ-
               ment variables that were passed to Xstartup are also given
               to Xreset.

          Typical Usage
               Actually, xdm is designed to operate in such a wide variety
               of environments that "typical" is probably a misnomer.  How-
               ever, this section will focus on making xdm a superior solu-
               tion to traditional means of starting X from /etc/ttys or
               manually.

               First off, the xdm configuration file should be set up.  A
               good thing to do is to make a directory (/usr/lib/X11/xdm


          Rev. Release 4                                            Page 13






          XDM(1)                         AIX                         XDM(1)



               comes immediately to mind) which will contain all of the
               relevant files.  Here is a reasonable configuration file,
               which could be named xdm-config :


                    DisplayManager.servers:            /usr/lib/X11/xdm/Xservers
                    DisplayManager.errorLogFile:       /usr/lib/X11/xdm/xdm-errors
                    DisplayManager.pidFile:            /usr/lib/X11/xdm/xdm-pid
                    DisplayManager*resources:          /usr/lib/X11/xdm/Xresources
                    DisplayManager*session:            /usr/lib/X11/xdm/Xsession
                    DisplayManager._0.authorize:       true
                    DisplayManager*authorize:          false


               As you can see, this file simply contains references to
               other files.  Note that some of the resources are specified
               with ``*'' separating the components.  These resources can
               be made unique for each different display, by replacing the
               ``*'' with the display-name, but normally this is not very
               useful.  See the Resources section for a complete discus-
               sion.

               The first file /usr/lib/X11/xdm/Xservers contains the list
               of displays to manage.  Most workstations have only one
               display, numbered 0, so the file will look like this:

                    :0 Local local /usr/bin/X11/X :0


               This will keep /usr/bin/X11/X running on this display and
               manage a continuous cycle of sessions.

               The file /usr/lib/X11/xdm/xdm-errors will contain error mes-
               sages from xdm and anything output to stderr by Xstartup,
               Xsession or Xreset.  When you have trouble getting xdm work-
               ing, check this file to see if xdm has any clues to the
               trouble.

               The next configuration entry, /usr/lib/X11/xdm/Xresources,
               is loaded onto the display as a resource database using xrdb
               (1).  As the authentication widget reads this database
               before starting up, it usually contains parameters for that
               widget:

                    xlogin*login.translations: #override\
                         <Key>F1: set-session-argument(failsafe) finish-field()\n\
                         <Key>Return: set-session-argument() finish-field()
                    xlogin*borderWidth: 3
                    #ifdef COLOR
                    xlogin*greetColor: #f63
                    xlogin*failColor: red
                    xlogin*Foreground: black
                    xlogin*Background: #fdc


          Rev. Release 4                                            Page 14






          XDM(1)                         AIX                         XDM(1)



                    #else
                    xlogin*Foreground: black
                    xlogin*Background: white
                    #endif


               The various colors specified here look reasonable on several
               of the displays we have, but may look awful on other moni-
               tors.  As X does not currently have any standard color nam-
               ing scheme, you might need to tune these entries to avoid
               disgusting results.  Please note the translations entry; it
               specifies a few new translations for the widget which allow
               users to escape from the default session (and avoid troubles
               that may occur in it).  Note that if #override is not speci-
               fied, the default translations are removed and replaced by
               the new value, not a very useful result as some of the
               default translations are quite useful (like "<Key>: insert-
               char ()" which responds to normal typing).

               The Xstartup file used here simply prevents login while the
               file /etc/nologin exists.  As there is no provision for
               displaying any messages here (there isn't any core X client
               which displays files), the user will probably be baffled by
               this behavior.  I don't offer this as a complete example,
               but simply a demonstration of the available functionality.

               Here is a sample Xstartup script:

                    #!/bin/sh
                    #
                    # Xstartup
                    #
                    # This program is run as root after the user is verified
                    #
                    if [ -f /etc/nologin ]; then
                         exit 1
                    fi
                    exit 0

               The most interesting script is Xsession.  This version
               recognizes the special "failsafe" mode, specified in the
               translations in the Xresources file above, to provide an
               escape from the ordinary session:

                    #!/bin/sh
                    #
                    # Xsession
                    #
                    # This is the program that is run as the client
                    # for the display manager.  This example is
                    # quite friendly as it attempts to run a per-user
                    # .xsession file instead of forcing a particular
                    # session layout


          Rev. Release 4                                            Page 15






          XDM(1)                         AIX                         XDM(1)



                    #

                    case $# in
                    1)
                         case $1 in
                         failsafe)
                              exec xterm -geometry 80x24-0-0 -ls
                              ;;
                         esac
                    esac

                    startup=$HOME/.xsession
                    resources=$HOME/.Xresources

                    if [ -f $startup ]; then
                         exec $startup
                         exec /bin/sh $startup
                    else
                         if [ -f $resources ]; then
                              xrdb -load $resources
                         fi
                         twm &
                         exec xterm -geometry 80x24+10+10 -ls
                    fi


               No Xreset script is necessary, so none is provided.


          SOME OTHER POSSIBILITIES
               You can also use xdm to run a single session at a time,
               using the 4.3 init options or other suitable daemon by
               specifying the server on the command line:

                    xdm -server ":0 SUN-3/60CG4 local /usr/bin/X :0"


               Or, you might have a file server and a collection of X ter-
               minals.  The configuration for this could look identical to
               the sample above, except the Xservers file might look like:

                    extol:0 VISUAL-19 foreign
                    exalt:0 NCD-19 foreign
                    explode:0 NCR-TOWERVIEW3000 foreign


               This would direct xdm to manage sessions on all three of
               these terminals.  See the section "Controlling Xdm" above
               for a description of using signals to enable and disable
               these terminals in a manner reminiscent of init(8).

               One thing that xdm isn't very good at doing is coexisting
               with other window systems.  To use multiple window systems


          Rev. Release 4                                            Page 16






          XDM(1)                         AIX                         XDM(1)



               on the same hardware, you'll probably be more interested in
               xinit .

          SEE ALSO
               X(1), xinit(1) and XDMCP

          BUGS
          COPYRIGHT
               Copyright 1988, Massachusetts Institute of Technology.
               See X(1) for a full statement of rights and permissions.

          AUTHOR
               Keith Packard, MIT X Consortium










































          Rev. Release 4                                            Page 17



