


          TWM(1)                         AIX                         TWM(1)



          NAME
               twm - Tab Window Manager for the X Window System

          SYNTAX
               twm [-display dpy] [-s] [-f initfile] [-v]

          DESCRIPTION
               Twm is a window manager for the X Window System.  It pro-
               vides titlebars, shaped windows, several forms of icon
               management, user-defined macro functions, click-to-type and
               pointer-driven keyboard focus, and user-specified key and
               pointer button bindings.

               This program is usually started by the user's session
               manager or startup script.  When used from xdm(1) or
               xinit(1) without a session manager, twm is frequently exe-
               cuted in the foreground as the last client.  When run this
               way, exiting twm causes the session to be terminated (i.e.
               logged out).

               By default, application windows are surrounded by a
               ``frame'' with a titlebar at the top and a special border
               around the window.  The titlebar contains the window's name,
               a rectangle that is lit when the window is receiving key-
               board input, and function boxes known as ``titlebuttons'' at
               the left and right edges of the titlebar.

               Pressing pointer Button1 (usually the left-most button
               unless it has been changed with xmodmap) on a titlebutton
               will invoke the function associated with the button.  In the
               default interface, windows are iconified by clicking (press-
               ing and then immediately releasing) the left titlebutton
               (which looks like a small X).  Conversely, windows are
               deiconified by clicking in the associated icon or entry in
               the icon manager (see description of the variable ShowIcon-
               Manager and of the function f.showiconmgr).

               Windows are resized by pressing the right titlebutton (which
               resembles group of nested squares), dragging the pointer
               over edge that is to be moved, and releasing the pointer
               when the outline of the window is the desired size.  Simi-
               larly, windows are moved by pressing in the title or
               highlight region, dragging a window outline to the new loca-
               tion, and then releasing when the outline is in the desired
               position.  Just clicking in the title or highlight region
               raises the window without moving it.

               When new windows are created, twm will honor any size and
               location information requested by the user (usually through
               -geometry command line argument or resources for the indivi-
               dual applications). Otherwise, an outline of the window's
               default size, its titlebar, and lines dividing the window
               into a 3x3 grid that track the pointer are displayed.


          Rev. Release 4                                             Page 1






          TWM(1)                         AIX                         TWM(1)



               Clicking pointer Button1 will position the window at the
               current position and give it the default size.  Pressing
               pointer Button2 (usually the middle pointer button) and
               dragging the outline will give the window its current posi-
               tion but allow the sides to be resized as described above.
               Clicking pointer Button3 (usually the right pointer button)
               will give the window its current position but attempt to
               make it long enough to touch the bottom the screen.

          OPTIONS
               Twm accepts the following command line options:

               -display dpy
                       This option specifies the X server to use.

               -s      This option indicates that only the default screen
                       (as specified by -display or by the DISPLAY environ-
                       ment variable) should be managed.  By default, twm
                       will attempt to manage all screens on the display.

               -f filename
                       This option specifies the name of the startup file
                       to use.  By default, twm will look in the user's
                       home directory for files named .twmrc.num (where num
                       is a screen number) or .twmrc.

               -v      This option indicates that twm should print error
                       messages whenever an unexpected X Error event is
                       received.  This can be useful when debugging appli-
                       cations but can be distracting in regular use.

          CUSTOMIZATION
               Much of twm's appearance and behavior can be controlled by
               providing a startup file in one of the following locations
               (searched in order for each screen being managed when twm
               begins):

               $HOME/.twmrc.screennumber
                       The screennumber is a small positive number (e.g. 0,
                       1, etc.) representing the screen number (e.g. the
                       last number in the DISPLAY environment variable
                       host:displaynum.screennum) that would be used to
                       contact that screen of the display.  This is
                       intended for displays with multiple screens of
                       differing visual types.

               $HOME/.twmrc
                       This is the usual name for an individual user's
                       startup file.

               /usr/lib/X11/twm/system.twmrc
                       If neither of the preceding files are found, twm
                       will look in this file for a default configuration.


          Rev. Release 4                                             Page 2






          TWM(1)                         AIX                         TWM(1)



                       This is often tailored by the site administrator to
                       provide convenient menus or familiar bindings for
                       novice users.

               If no startup files are found, twm will use the built-in
               defaults described above.  The only resource used by twm is
               bitmapFilePath for a colon-separated list of directories to
               search when looking for bitmap files (for more information,
               see the Athena Widgets manual and xrdb(1)).

               Twm startup files are logically broken up into three types
               of specifications:  Variables, Bindings, Menus.  The Vari-
               ables section must come first and is used to describe the
               fonts, colors, cursors, border widths, icon and window
               placement, highlighting, autoraising, layout of titles,
               warping, use of the icon manager.  The Bindings section usu-
               ally comes second and is used to specify the functions that
               should be to be invoked when keyboard and pointer buttons
               are pressed in windows, icons, titles, and frames.  The
               Menus section gives any user-defined menus (containing func-
               tions to be invoked or commands to be executed).

               Variable names and keywords are case-insensitive.  Strings
               must be surrounded by double quote characters (e.g. "blue")
               and are case-sensitive.  A pound sign (#) outside of a
               string causes the remainder of the line in which the charac-
               ter appears to be treated as a comment.

          VARIABLES
               Many of the aspects of twm's user interface are controlled
               by variables that may be set in the user's startup file.
               Some of the options are enabled or disabled simply by the
               presence of a particular keyword.  Other options require
               keywords, numbers, strings, or lists of all of these.

               Lists are surrounded by braces and are usually separated by
               whitespace or a newline.  For example:

                    AutoRaise { "emacs" "XTerm" "Xmh" }

               or

                    AutoRaise
                    {
                         "emacs"
                         "XTerm"
                         "Xmh"
                    }

               When a variable containing a list of strings representing
               windows is searched (e.g. to determine whether or not to
               enable autoraise as shown above), a string is considered to
               match a window if it is a case-sensitive prefix for the


          Rev. Release 4                                             Page 3






          TWM(1)                         AIX                         TWM(1)



               window's name name (given by the WM_NAME window property),
               resource name or class name (both given by the WM_CLASS win-
               dow property).  The preceding example would enable autoraise
               on windows named ``emacs'' as well as any xterm (since they
               are of class ``XTerm'') or xmh windows (which are of class
               ``Xmh'').

               String arguments that are interpreted as filenames (see the
               Pixmaps, Cursors, and IconDirectory below) will prepend the
               user's directory (specified by the HOME environment vari-
               able) if the first character is a tilde (~).  If, instead,
               the first character is a colon (:), the name is assumed to
               refer to one of the internal bitmaps that are used to create
               the default titlebars symbols:  :xlogo or :iconify (both
               refer to the X used for the iconify button), :resize (the
               nested squares used by the resize button), and :question
               (the question mark used for non-existent bitmap files).

               The following variables may be specified at the top of a twm
               startup file.  Lists of Window name prefix strings are indi-
               cated by win-list.  Optional arguments are shown in square
               brackets:

               AutoRaise { win-list }
                       This variable specifies a list of windows that
                       should automatically be raised whenever the pointer
                       enters the window.  This action can be interactively
                       enabled or disabled on individual windows using the
                       function f.autoraise.

               AutoRelativeResize
                       This variable indicates that dragging out a window
                       size (either when initially sizing the window with
                       pointer Button2 or when resizing it) should not wait
                       until the pointer has crossed the window edges.
                       Instead, moving the pointer automatically causes the
                       nearest edge or edges to move by the same amount.
                       This allows allows the resizing windows that extend
                       off the edge of the screen.  If the pointer is in
                       the center of the window, or if the resize is begun
                       by pressing a titlebutton, twm will still wait for
                       the pointer to cross a window edge (to prevent
                       accidents).  This option is particularly useful for
                       people who like the press-drag-release method of
                       sweeping out window sizes.

               BorderColor string [{ wincolorlist }]
                       This variable specifies the default color of the
                       border to be placed around all non-iconified win-
                       dows, and may only be given within a Color or Mono-
                       chrome list.  The optional wincolorlist specifies a
                       list of window and color name pairs for specifying
                       particular border colors for different types of


          Rev. Release 4                                             Page 4






          TWM(1)                         AIX                         TWM(1)



                       windows.  For example:

                            BorderColor "gray50"
                            {
                                 "XTerm"   "red"
                                 "xmh"     "green"
                            }

                       The default is "black".

               BorderTileBackground string [{ wincolorlist }]
                       This variable specifies the default background color
                       in the gray pattern used in unhighlighted borders
                       (only if NoHighlight hasn't been set), and may only
                       be given within a Color or Monochrome list.  The
                       optional wincolorlist allows per-window colors to be
                       specified.  The default  is "black".

               BorderTileForeground string [{ wincolorlist }]
                       This variable specifies the default foreground color
                       in the gray pattern used in unhighlighted borders
                       (only if NoHighlight hasn't been set), and may only
                       be given within a Color or Monochrome list.  The
                       optional wincolorlist allows per-window colors to be
                       specified.  The default is "white".

               BorderWidth pixels
                       This variable specifies the width in pixels of the
                       border surrounding all client window frames if
                       ClientBorderWidth has not been specified.  This
                       value is also used to set the border size of windows
                       created by twm (such as the icon manager).  The
                       default is 2.

               ButtonIndent pixels
                       This variable specifies the amount by which
                       titlebuttons should be indented on all sides.  Posi-
                       tive values cause the buttons to be smaller than the
                       window text and highlight area so that they stand
                       out.  Setting this and the TitleButtonBorderWidth
                       variables to 0 makes titlebuttons be as tall and
                       wide as possible.  The default is 1.

               ClientBorderWidth
                       This variable indicates that border width of a
                       window's frame should be set to the initial border
                       width of the window, rather than to the value of
                       BorderWidth.

               Color { colors-list }
                       This variable specifies a list of color assignments
                       to be made if the default display is capable of
                       displaying more than simple black and white.  The


          Rev. Release 4                                             Page 5






          TWM(1)                         AIX                         TWM(1)



                       colors-list is made up of the following color vari-
                       ables and their values: DefaultBackground, Default-
                       Foreground, MenuBackground, MenuForeground, Menu-
                       TitleBackground, MenuTitleForeground, and MenuSha-
                       dowColor.  The following color variables may also be
                       given a list of window and color name pairs to allow
                       per-window colors to be specified (see BorderColor
                       for details): BorderColor, IconManagerHighlight,
                       BorderTitleBackground, BorderTitleForeground,
                       TitleBackground, TitleForeground, IconBackground,
                       IconForeground, IconBorderColor, IconManagerBack-
                       ground, and IconManagerForeground.  For example:

                            Color
                            {
                                 MenuBackground      "gray50"
                                 MenuForeground      "blue"
                                 BorderColor              "red" { "XTerm" "yellow" }
                                 TitleForeground          "yellow"
                                 TitleBackground          "blue"
                            }

                       All of these color variables may also be specified
                       for the Monochrome variable, allowing the same ini-
                       tialization file to be used on both color and mono-
                       chrome displays.

               ConstrainedMoveTime milliseconds
                       This variable specifies the length of time between
                       button clicks needed to begin a constrained move
                       operation.  Double clicking within this amount of
                       time when invoking f.move will cause the window only
                       be moved in a horizontal or vertical direction.
                       Setting this value to 0 will disable constrained
                       moves.  The default is 400 milliseconds.

               Cursors { cursor-list }
                       This variable specifies the glyphs that twm should
                       use for various pointer cursors.  Each cursor may be
                       defined either from the cursor font or from two bit-
                       map files.  Shapes from the cursor font may be
                       specified directly as:

                                 cursorname     "string"

                       where cursorname is one of the cursor names listed
                       below, and string is the name of a glyph as found in
                       the file /usr/include/X11/cursorfont.h (without the
                       ``XC_'' prefix).  If the cursor is to be defined
                       from bitmap files, the following syntax is used





          Rev. Release 4                                             Page 6






          TWM(1)                         AIX                         TWM(1)



                       instead:

                                 cursorname     "image"   "mask"

                       The image and mask strings specify the names of
                       files containing the glyph image and mask in bit-
                       map(1) form.  The bitmap files are located in the
                       same manner as icon bitmap files.  The following
                       example shows the default cursor definitions:

                            Cursors
                            {
                                 Frame          "top_left_arrow"
                                 Title          "top_left_arrow"
                                 Icon      "top_left_arrow"
                                 IconMgr   "top_left_arrow"
                                 Move      "fleur"
                                 Resize         "fleur"
                                 Menu      "sb_left_arrow"
                                 Button         "hand2"
                                 Wait      "watch"
                                 Select         "dot"
                                 Destroy   "pirate"
                            }


               DecorateTransients
                       This variable indicates that transient windows
                       (those containing a WM_TRANSIENT_FOR property)
                       should have titlebars.  By default, transients are
                       not reparented.

               DefaultBackground string
                       This variable specifies the background color to be
                       used for sizing and information windows.  The
                       default is "white".

               DefaultForeground string
                       This variable specifies the foreground color to be
                       used for sizing and information windows.  The
                       default is "black".

               DontIconifyByUnmapping { win-list }
                       This variable specifies a list of windows that
                       should not be iconified by simply unmapping the win-
                       dow (as would be the case if IconifyByUnmapping had
                       been set).  This is frequently used to force some
                       windows to be treated as icons while other windows
                       are handled by the icon manager.

               DontMoveOff
                       This variable indicates that windows should not be
                       allowed to be moved off the screen.  It can be


          Rev. Release 4                                             Page 7






          TWM(1)                         AIX                         TWM(1)



                       overridden by the f.forcemove function.

               DontSqueezeTitle [{ win-list }]
                       This variable indicates that titlebars should not be
                       squeezed to their minimum size as described under
                       SqueezeTitle below.  If the optional window list is
                       supplied, only those windows will be prevented from
                       being squeezed.

               ForceIcons
                       This variable indicates that icon pixmaps specified
                       in the Icons variable should override any client-
                       supplied pixmaps.

               FramePadding pixels
                       This variable specifies the distance between the
                       titlebar decorations (the button and text) and the
                       window frame.  The default is 2 pixels.

               IconBackground string [{ win-list }]
                       This variable specifies the background color of
                       icons, and may only be specified inside of a Color
                       or Monochrome list.  The optional win-list is a list
                       of window names and colors so that per-window colors
                       may be specified.  See the BorderColor variable for
                       a complete description of the win-list.  The default
                       is "white".

               IconBorderColor string [{ win-list }]
                       This variable specifies the color of the border used
                       for icon windows, and may only be specified inside
                       of a Color or Monochrome list.  The optional win-
                       list is a list of window names and colors so that
                       per-window colors may be specified.  See the Border-
                       Color variable for a complete description of the
                       win-list. The default is "black".

               IconBorderWidth pixels
                       This variable specifies the width in pixels of the
                       border surrounding icon windows.  The default is 2.

               IconDirectory string
                       This variable specifies the directory that should be
                       searched if if a bitmap file cannot be found in any
                       of the directories in the bitmapFilePath resource.

               IconFont string
                       This variable specifies the font to be used to
                       display icon names within icons.  The default is
                       "8x13".

               IconForeground string [{ win-list }]
                       This variable specifies the foreground color to be


          Rev. Release 4                                             Page 8






          TWM(1)                         AIX                         TWM(1)



                       used when displaying icons, and may only be speci-
                       fied inside of a Color or Monochrome list.  The
                       optional win-list is a list of window names and
                       colors so that per-window colors may be specified.
                       See the BorderColor variable for a complete descrip-
                       tion of the win-list.  The default is "black".

               IconifyByUnmapping [{ win-list }]
                       This variable indicates that windows should be icon-
                       ified by being unmapped without trying to map any
                       icons.  This assumes that the user is will remap the
                       window through the icon manager, the f.warpto func-
                       tion, or the TwmWindows menu.  If the optional win-
                       list is provided, only those windows will be iconi-
                       fied by simply unmapping.  Windows that have both
                       this and the IconManagerDontShow options set may not
                       be accessible if no binding to the TwmWindows menu
                       is set in the user's startup file.

               IconManagerBackground string [{ win-list }]
                       This variable specifies the background color to use
                       for icon manager entries, and may only be specified
                       inside of a Color or Monochrome list.  The optional
                       win-list is a list of window names and colors so
                       that per-window colors may be specified.  See the
                       BorderColor variable for a complete description of
                       the win-list.  The default is "white".

               IconManagerDontShow [{ win-list }]
                       This variable indicates that the icon manager should
                       not display any windows.  If the optional win-list
                       is given, only those windows will not be displayed.
                       This variable is used to prevent windows that are
                       rarely iconified (such as xclock or xload) from tak-
                       ing up space in the icon manager.

               IconManagerFont string
                       This variable specifies the font to be used when
                       displaying icon manager entries.  The default is
                       "8x13".

               IconManagerForeground string [{ win-list }]
                       This variable specifies the foreground color to be
                       used when displaying icon manager entries, and may
                       only be specified inside of a Color or Monochrome
                       list.  The optional win-list is a list of window
                       names and colors so that per-window colors may be
                       specified.  See the BorderColor variable for a com-
                       plete description of the win-list.  The default is
                       "black".

               IconManagerGeometry string [ columns ]
                       This variable specifies the geometry of the icon


          Rev. Release 4                                             Page 9






          TWM(1)                         AIX                         TWM(1)



                       manager window.  The string argument is standard
                       geometry specification that indicates the initial
                       full size of the icon manager.  The icon manager
                       window is then broken into columns pieces and scaled
                       according to the number of entries in the icon
                       manager.  Extra entries are wrapped to form addi-
                       tional rows.  The default number of columns is 1.

               IconManagerHighlight string [{ win-list }]
                       This variable specifies the border color to be used
                       when highlighting the icon manager entry that
                       currently has the focus, and can only be specified
                       inside of a Color or Monochrome list.  The optional
                       win-list is a list of window names and colors so
                       that per-window colors may be specified.  See the
                       BorderColor variable for a complete description of
                       the win-list.  The default is "black".

               IconManagers { iconmgr-list }
                       This variable specifies a list of icon managers to
                       create.  Each item in the iconmgr-list has the fol-
                       lowing format:

                                 "winname" ["iconname"]   "geometry" columns

                       where winname is the name of the windows that should
                       be put into this icon manager, iconname is the name
                       of that icon manager window's icon, geometry is a
                       standard geometry specification, and columns is the
                       number of columns in this icon manager as described
                       in IconManagerGeometry.  For example:

                            IconManagers
                            {
                                 "XTerm"   "=300x5+800+5" 5
                                 "myhost"  "=400x5+100+5" 2
                            }

                       Clients whose name or class is ``XTerm'' will have
                       an entry created in the ``XTerm'' icon manager.
                       Clients whose name was ``myhost'' would be put into
                       the ``myhost'' icon manager.

               IconManagerShow { win-list }
                       This variable specifies a list of windows that
                       should appear in the icon manager.  When used in
                       conjunction with the IconManagerDontShow variable,
                       only the windows in this list will be shown in the
                       icon manager.

               IconRegion geomstring vgrav hgrav gridwidth gridheight
                       This variable specifies an area on the root window
                       in which icons are placed if no specific icon


          Rev. Release 4                                            Page 10






          TWM(1)                         AIX                         TWM(1)



                       location is provided by the client.  The geomstring
                       is a quoted string containing a standard geometry
                       specification.  If more than one IconRegion lines
                       are given, icons will be put into the succeeding
                       icon regions when the first is full.  The vgrav
                       argument should be either North or South and control
                       and is used to control whether icons are first
                       filled in from the top or bottom of the icon region.
                       Similarly, the hgrav argument should be either East
                       or West and is used to control whether icons should
                       be filled in from left from the right.  Icons are
                       laid out within the region in a grid with cells
                       gridwidth pixels wide and gridheight pixels high.

               Icons { win-list }
                       This variable specifies a list of window names and
                       the bitmap filenames that should be used as their
                       icons.  For example:

                            Icons
                            {
                                 "XTerm"   "xterm.icon"
                                 "xfd"          "xfd_icon"
                            }

                       Windows that match ``XTerm'' and would not be iconi-
                       fied by unmapping, and would try to use the icon
                       bitmap in the file ``xterm.icon''.  If ForceIcons is
                       specified, this bitmap will be used even if the
                       client has requested its own icon pixmap.

               InterpolateMenuColors
                       This variable indicates that menu entry colors
                       should be interpolated between entry specified
                       colors.  In the example below:

                            Menu "mymenu"
                            {
                                 "Title"        ("black":"red")          f.title
                                 "entry1"                 f.nop
                                 "entry2"                 f.nop
                                 "entry3"  ("white":"green")   f.nop
                                 "entry4"                 f.nop
                                 "entry5"  ("red":"white")          f.nop
                            }

                       the foreground colors for ``entry1'' and ``entry2''
                       will be interpolated between black and white, and
                       the background colors between red and green.  Simi-
                       larly, the foreground for ``entry4'' will be half-
                       way between white and red, and the background will
                       be half-way between green and white.



          Rev. Release 4                                            Page 11






          TWM(1)                         AIX                         TWM(1)



               MakeTitle { win-list }
                       This variable specifies a list of windows on which a
                       titlebar should be placed and is used to request
                       titles on specific windows when NoTitle has been
                       set.

               MaxWindowSize string
                       This variable specifies a geometry in which the
                       width and height give the maximum size for a given
                       window.  This is typically used to restrict windows
                       to the size of the screen.  The default is
                       "30000x30000".

               MenuBackground string
                       This variable specifies the background color used
                       for menus, and can only be specified inside of a
                       Color or Monochrome list.  The default is "white".

               MenuFont string
                       This variable specifies the font to use when
                       displaying menus.  The default is "8x13".

               MenuForeground string
                       This variable specifies the foreground color used
                       for menus, and can only be specified inside of a
                       Color or Monochrome list.  The default is "black".

               MenuShadowColor string
                       This variable specifies the color of the shadow
                       behind pull-down menus and can only be specified
                       inside of a Color or Monochrome list.  The default
                       is "black".

               MenuTitleBackground string
                       This variable specifies the background color for
                       f.title entries in menus, and can only be specified
                       inside of a Color or Monochrome list.  The default
                       is "white".

               MenuTitleForeground string
                       This variable specifies the foreground color for
                       f.title entries in menus and can only be specified
                       inside of a Color or Monochrome list.  The default
                       is "black".

               Monochrome { colors }
                       This variable specifies a list of color assignments
                       that should be made if the screen has a depth of 1.
                       See the description of Colors.

               MoveDelta pixels
                       This variable specifies the number of pixels the
                       pointer must move before the f.move function starts


          Rev. Release 4                                            Page 12






          TWM(1)                         AIX                         TWM(1)



                       working.  Also see the f.deltastop function.  The
                       default is zero pixels.

               NoBackingStore
                       This variable indicates that twm's menus should not
                       request backing store to minimize repainting of
                       menus.  This is typically used with servers that can
                       repaint faster than they can handle backing store.

               NoCaseSensitive
                       This variable indicates that case should be ignored
                       when sorting icon names in an icon manager.  This
                       option is typically used with applications that cap-
                       italize the first letter of their icon name.

               NoDefaults
                       This variable indicates that twm should not supply
                       the default titlebuttons and bindings.  This option
                       should only be used if the startup file contains a
                       completely new set of bindings and definitions.

               NoGrabServer
                       This variable indicates that twm should not grab the
                       server when popping up menus and moving opaque win-
                       dows.

               NoHighlight [{ win-list }]
                       This variable indicates that borders should not be
                       highlighted to track the location of the pointer.
                       If the optional win-list is given, highlighting will
                       only be disabled for those windows.  When the border
                       is highlighted, it will be drawn in the current Bor-
                       derColor.  When the border is not highlighted, it
                       will be stippled with an gray pattern using the
                       current BorderTileForeground and BorderTileBack-
                       ground colors.

               NoIconManagers
                       This variable indicates that no icon manager should
                       be created.

               NoMenuShadows
                       This variable indicates that menus should not have
                       drop shadows drawn behind them.  This is typically
                       used with slower servers since it speeds up menu
                       drawing at the expense of making the menu slightly
                       harder to read.

               NoRaiseOnDeiconify
                       This variable indicates that windows that are
                       deiconified should not be raised.

               NoRaiseOnMove


          Rev. Release 4                                            Page 13






          TWM(1)                         AIX                         TWM(1)



                       This variable indicates that windows should not be
                       raised when moved.  This is typically used to allow
                       windows to slide underneath each other.

               NoRaiseOnResize
                       This variable indicates that windows should not be
                       raised when resized.  This is typically used to
                       allow windows to be resized underneath each other.

               NoRaiseOnWarp
                       This variable indicates that windows should not be
                       raised when the pointer is warped into them with the
                       f.warpto function.  If this option is set, warping
                       to an occluded window may result in the pointer end-
                       ing up in the occluding window instead the desired
                       window (which causes unexpected behavior with
                       f.warpring).

               NoSaveUnders
                       This variable indicates that menus should not
                       request save-unders to minimize window repainting
                       following menu selection.  It is typically used with
                       displays that can repaint faster than they can han-
                       dle save-unders.

               NoStackMode [{ win-list }]
                       This variable indicates that client window requests
                       to change stacking order should be ignored.  If the
                       optional win-list is given, only requests on those
                       windows will be ignored.  This is typically used to
                       prevent applications from relentlessly popping them-
                       selves to the front of the window stack.

               NoTitle [{ win-list }]
                       This variable indicates that windows should not have
                       titlebars.  If the optional win-list is given, only
                       those windows will not have titlebars.  MakeTitle
                       may be used with this option to force titlebars to
                       be put on specific windows.

               NoTitleFocus
                       This variable indicates that twm should not set key-
                       board input focus to each window as it is entered.
                       Normally, twm sets the focus so that focus and key
                       events from the titlebar and icon managers are
                       delivered to the application.  If the pointer is
                       moved quickly and twm is slow to respond, input can
                       be directed to the old window instead of the new.
                       This option is typically used to prevent this
                       ``input lag'' and to work around bugs in older
                       applications that have problems with focus events.

               NoTitleHighlight [{ win-list }]


          Rev. Release 4                                            Page 14






          TWM(1)                         AIX                         TWM(1)



                       This variable indicates that the highlight area of
                       the titlebar, which is used to indicate the window
                       that currently has the input focus, should not be
                       displayed.  If the optional win-list is given, only
                       those windows will not have highlight areas.  This
                       and the SqueezeTitle options can be set to substan-
                       tially reduce the amount of screen space required by
                       titlebars.

               OpaqueMove
                       This variable indicates that the f.move function
                       should actually move the window instead of just an
                       outline so that the user can immediately see what
                       the window will look like in the new position.  This
                       option is typically used on fast displays (particu-
                       larly if NoGrabServer is set).

               Pixmaps { pixmaps }
                       This variable specifies a list of pixmaps that
                       define the appearance of various images.  Each entry
                       is a keyword indicating the pixmap to set, followed
                       by a string giving the name of the bitmap file.  The
                       following pixmaps may be specified:

                            Pixmaps
                            {
                                 TitleHighlight "gray1"
                            }

                       The default for TitleHighlight is to use an even
                       stipple pattern.

               RandomPlacement
                       This variable indicates that windows with no speci-
                       fied geometry should should be placed in a pseudo-
                       random location instead of having the user drag out
                       an outline.

               ResizeFont string
                       This variable specifies the font to be used for in
                       the dimensions window when resizing windows.  The
                       default is "fixed".

               RestartPreviousState
                       This variable indicates that twm should attempt to
                       use the WM_STATE property on client windows to tell
                       which windows should be iconified and which should
                       be left visible.  This is typically used to make try
                       to regenerate the state that the screen was in
                       before the previous window manager was shutdown.

               ShowIconManager
                       This variable indicates that the icon manager window


          Rev. Release 4                                            Page 15






          TWM(1)                         AIX                         TWM(1)



                       should be displayed when twm is started.  It can
                       always be brought up using the f.showiconmgr func-
                       tion.

               SortIconManager
                       This variable indicates that entries in the icon
                       manager should be sorted alphabetically rather than
                       by simply appending new windows to the end.

               SqueezeTitle [{ squeeze-list }]
                       This variable indicates that twm should attempt to
                       use the SHAPE extension to make titlebars occupy
                       only as much screen space as they need, rather than
                       extending all the way across the top of the window.
                       The optional squeeze-list may be used to control the
                       location of the squeezed titlebar along the top of
                       the window.  It contains entries of the form:

                                 "name"         justification  num  denom

                       where name is a window name, justification is either
                       left, center, or right, and num and denom are
                       numbers specifying a ratio giving the relative posi-
                       tion about which the titlebar is justified.  The
                       ratio is measured from left to right if the numera-
                       tor is positive, and right to left if negative.  A
                       denominator of 0 indicates that the numerator should
                       be measured in pixels.  For convenience, the ratio
                       0/0 is the same as 1/2 for center and -1/1 for
                       right.  For example:

                            SqueezeTitle
                            {
                                 "XTerm"   left      0    0
                                 "xterm1"  left      1    3
                                 "xterm2"  left      2    3
                                 "oclock"  center         0    0
                                 "emacs"   right          0    0
                            }

                       The DontSqueezeTitle list can be used to turn off
                       squeezing on certain titles.

               StartIconified [{ win-list }]
                       This variable indicates that client windows should
                       initially be left as icons until explicitly deiconi-
                       fied by the user.  If the optional win-list is
                       given, only those windows will be started iconic.
                       This is useful for programs that do not support an
                       -iconic command line option or resource.

               TitleBackground string [{ win-list }]
                       This variable specifies the background color used in


          Rev. Release 4                                            Page 16






          TWM(1)                         AIX                         TWM(1)



                       titlebars, and may only be specified inside of a
                       Color or Monochrome list.  The optional win-list is
                       a list of window names and colors so that per-window
                       colors may be specified.  The default is "white".

               TitleButtonBorderWidth pixels
                       This variable specifies the width in pixels of the
                       border surrounding titlebuttons.  This is typically
                       set to 0 to allow titlebuttons to take up as much
                       space as possible and to not have a border.  The
                       default is 1.

               TitleFont string
                       This variable specifies the font to used for
                       displaying window names in titlebars.  The default
                       is "8x13".

               TitleForeground string [{ win-list }]
                       This variable specifies the foreground color used in
                       titlebars, and may only be specified inside of a
                       Color or Monochrome list.  The optional win-list is
                       a list of window names and colors so that per-window
                       colors may be specified.  The default is "black".

               TitlePadding pixels
                       This variable specifies the distance between the
                       various buttons, text, and highlight areas in the
                       titlebar.  The default is 8 pixels.

               UnknownIcon string
                       This variable specifies the filename of a bitmap
                       file to be used as the default icon.  This bitmap
                       will be used as the icon of all clients which do not
                       provide an icon bitmap and are not listed in the
                       Icons list.

               UsePPosition string
                       This variable specifies whether or not twm should
                       honor program-requested locations (given by the PPo-
                       sition flag in the WM_NORMAL_HINTS property) in the
                       absence of a user-specified position.  The argument
                       string may have one of three values:  "off" (the
                       default) indicating that twm should ignore the
                       program-supplied position, "on" indicating that the
                       position should be used, and "non-zero" indicating
                       that the position should used if it is other than
                       (0,0).  The latter option is for working around a
                       bug in older toolkits.

               WarpCursor [{ win-list }]
                       This variable indicates that the pointer should be
                       warped into windows when they are deiconified.  If
                       the optional win-list is given, the pointer will


          Rev. Release 4                                            Page 17






          TWM(1)                         AIX                         TWM(1)



                       only be warped when those windows are deiconified.

               WindowRing { win-list }
                       This variable specifies a list of windows along
                       which the f.warpring function cycles.

               WarpUnmapped
                       This variable indicates that that the f.warpto func-
                       tion should deiconify any iconified windows it
                       encounters.  This is typically used to make a key
                       binding that will pop a particular window (such as
                       xmh), no matter where it is.  The default is for
                       f.warpto to ignore iconified windows.

               XorValue number
                       This variable specifies the value to use when draw-
                       ing window outlines for moving and resizing.  This
                       should be set to a value that will result in a
                       variety of of distinguishable colors when
                       exclusive-or'ed with the contents of the user's typ-
                       ical screen.  Setting this variable to 1 often gives
                       nice results if adjacent colors in the default
                       colormap are distinct.  By default, twm will attempt
                       to cause temporary lines to appear at the opposite
                       end of the colormap from the graphics.

               Zoom [ count ]
                       This variable indicates that outlines suggesting
                       movement of a window to and from its iconified state
                       should be displayed whenever a window is iconified
                       or deiconified.  The optional count argument speci-
                       fies the number of outlines to be drawn.  The
                       default count is 8.

               The following variables must be set after the fonts have
               been assigned, so it is usually best to put them at the end
               of the variables or beginning of the bindings sections:

               DefaultFunction function
                       This variable specifies the function to be executed
                       when a key or button event is received for which no
                       binding is provided.  This is typically bound to
                       f.nop, f.beep, or a menu containing window opera-
                       tions.

               WindowFunction function
                       This variable specifies the function to execute when
                       a window is selected from the TwmWindows menu.  If
                       this variable is not set, the window will be deicon-
                       ified and raised.

          BINDINGS
               After the desired variables have been set, functions may be


          Rev. Release 4                                            Page 18






          TWM(1)                         AIX                         TWM(1)



               attached titlebuttons and key and pointer buttons.
               Titlebuttons may be added from the left or right side and
               appear in the titlebar from left-to-right according to the
               order in which they are specified.  Key and pointer button
               bindings may be given in any order.

               Titlebuttons specifications must include the name of the
               pixmap to use in the button box and the function to be
               invoked when a pointer button is pressed within them:

                    LeftTitleButton "bitmapname"  = function

               or

                    RightTitleButton "bitmapname" = function

               The bitmapname may refer to one of the  built-in bitmaps
               (which are scaled to match TitleFont) by using the appropri-
               ate colon-prefixed name described above.

               Key and pointer button specifications must give the modif-
               iers that must be pressed, over which parts of the screen
               the pointer must be, and what function is to be invoked.
               Keys are given as strings containing the appropriate keysym
               name; buttons are given as the keywords Button1-Button5:

                    "FP1"          = modlist : context : function
                    Button1   = modlist : context : function

               The modlist is any combination of the modifier names shift,
               control, lock, meta, mod1, mod2, mod3, mod4, or mod1 (which
               may be abbreviated as s, c, l, m, m1, m2, m3, m4, m5,
               respectively) separated by a vertical bar (|).  Similarly,
               the context is any combination of window, title, icon, root,
               frame, iconmgr, their first letters (iconmgr abbreviation is
               m), or all, separated by a vertical bar.  The function is
               any of the f. keywords described below.  For example, the
               default startup file contains the following bindings:

                    Button1   =    : root         : f.menu "TwmWindows"
                    Button1   = m  : window | icon     : f.function "move-or-lower"
                    Button2   = m  : window | icon     : f.iconify
                    Button3   = m  : window | icon     : f.function "move-or-raise"
                    Button1   =    : title        : f.function "move-or-raise"
                    Button2   =    : title        : f.raiselower
                    Button1   =    : icon         : f.function "move-or-iconify"
                    Button2   =    : icon         : f.iconify
                    Button1   =    : iconmgr : f.iconify
                    Button2   =    : iconmgr : f.iconify

               A user who wanted to be able to manipulate windows from the




          Rev. Release 4                                            Page 19






          TWM(1)                         AIX                         TWM(1)



               keyboard could use the following bindings:

                    "F1"      =    : all          : f.iconify
                    "F2"      =    : all          : f.raiselower
                    "F3"      =    : all          : f.warpring "next"
                    "F4"      =    : all          : f.warpto "xmh"
                    "F5"      =    : all          : f.warpto "emacs"
                    "F6"      =    : all          : f.colormap "next"
                    "F7"      =    : all          : f.colormap "default"
                    "F20"          =    : all          : f.warptoscreen "next"
                    "Left"         = m  : all          : f.backiconmgr
                    "Right"   = m | s   : all          : f.forwiconmgr
                    "Up"      = m  : all          : f.upiconmgr
                    "Down"    = m | s   : all          : f.downiconmgr

               Twm provides many more window manipulation primitives than
               can be conveniently stored in a titlebar, menu, or set of
               key bindings.  Although a small set of defaults are supplied
               (unless the NoDefaults is specified), most users will want
               to have their most common operations bound to key and button
               strokes.  To do this, twm associates names with each of the
               primitives and provides user-defined functions for building
               higher level primitives and menus for interactively select-
               ing among groups of functions.

               User-defined functions contain the name by which they are
               referenced in calls to f.function and a list of other func-
               tions to execute.  For example:

                    Function "move-or-lower" { f.move f.deltastop f.lower }
                    Function "move-or-raise" { f.move f.deltastop f.raise }
                    Function "move-or-iconify"    { f.move f.deltastop f.iconify }
                    Function "restore-colormap"   { f.colormap "default" f.lower }

               The function name must be used in f.function exactly as it
               appears in the function specification.

               In the descriptions below, if the function is said to
               operate on the selected window, but is invoked from a root
               menu, the cursor will be changed to the Select cursor and
               the next window to receive a button press will be chosen:

               ! string
                       This is an abbreviation for f.exec string.

               f.autoraise
                       This function toggles whether or not the selected
                       window is raised whenever entered by the pointer.
                       See the description of the variable AutoRaise.

               f.backiconmgr
                       This function warps the pointer to the previous
                       column in the current icon manager, wrapping back to


          Rev. Release 4                                            Page 20






          TWM(1)                         AIX                         TWM(1)



                       the previous row if necessary.

               f.beep  This function sounds the keyboard bell.

               f.bottomzoom
                       This function is similar to the f.fullzoom function,
                       but resizes the window to fill only the bottom half
                       of the screen.

               f.circledown
                       This function lowers the top-most window that
                       occludes another window.

               f.circleup
                       This function raises the bottom-most window that is
                       occluded by another window.

               f.colormap string
                       This function rotates the colormaps (obtained from
                       the WM_COLORMAP_WINDOWS property on the window) that
                       twm will display when the pointer is in this window.
                       The argument string may have one of the following
                       values: "next", "prev", and "default".

               f.deiconify
                       This function deiconifies the selected window.  If
                       the window is not an icon, this function does noth-
                       ing.

               f.delete
                       This function sends the WM_DELETE_WINDOW message to
                       the selected window if the client application has
                       requested it through the WM_PROTOCOLS window pro-
                       perty.  The application is supposed to respond to
                       the message by removing the indicated window.  If
                       the window has not requested WM_DELETE_WINDOW mes-
                       sages, the keyboard bell will be rung indicating
                       that the user should choose an alternative method.

               f.deltastop
                       This function allows a user-defined function to be
                       aborted if the pointer has been moved more than
                       MoveDelta pixels.  See the example definition given
                       for Function "move-or-raise" at the beginning of the
                       section.

               f.destroy
                       This function instructs the X server to close the
                       display connection of the client that created the
                       selected window.  This should only be used as a last
                       resort for shutting down runaway clients.

               f.downiconmgr


          Rev. Release 4                                            Page 21






          TWM(1)                         AIX                         TWM(1)



                       This function warps the pointer to the next row in
                       the current icon manger, wrapping to the beginning
                       of the next column if necessary.

               f.exec string
                       This function passes the argument string to /bin/sh
                       for execution.  In multiscreen mode, if string
                       starts a new X client without giving a display argu-
                       ment, the client will appear on the screen from
                       which this function was invoked.

               f.focus This function toggles the keyboard focus of the
                       server to the selected window, changing the focus
                       rule from pointer-driven if necessary.  If the
                       selected window already was focused, this function
                       executes an f.unfocus.

               f.forcemove
                       This function is like f.move except that it ignores
                       the DontMoveOff variable.

               f.forwiconmgr
                       This function warps the pointer to the next column
                       in the current icon manager, wrapping to the begin-
                       ning of the next row if necessary.

               f.fullzoom
                       This function resizes the selected window to the
                       full size of the display or else restores the origi-
                       nal size if the window was already zoomed.

               f.function string
                       This function executes the user-defined function
                       whose name is specified by the argument string.

               f.hbzoom
                       This function is a synonym for f.bottomzoom.

               f.hideiconmgr
                       This function unmaps the current icon manager.

               f.horizoom
                       This variable is similar to the f.zoom function
                       except that the selected window is resized to the
                       full width of the display.

               f.htzoom
                       This function is a synonym for f.topzoom.

               f.hzoom This function is a synonym for f.horizoom.

               f.iconify
                       This function iconifies or deiconifies the selected


          Rev. Release 4                                            Page 22






          TWM(1)                         AIX                         TWM(1)



                       window or icon, respectively.

               f.identify
                       This function displays a summary of the name and
                       geometry of the selected window.  Clicking the
                       pointer or pressing a key in the window will dismiss
                       it.

               f.lefticonmgr
                       This function similar to f.backiconmgr except that
                       wrapping does not change rows.

               f.leftzoom
                       This variable is similar to the f.bottomzoom func-
                       tion but causes the selected window is only resized
                       to the left half of the display.

               f.lower This function lowers the selected window.

               f.menu string
                       This function invokes the menu specified by the
                       argument string.  Cascaded menus may be built by
                       nesting calls to f.menu.

               f.move  This function drags an outline of the selected win-
                       dow (or the window itself if the OpaqueMove variable
                       is set) until the invoking pointer button is
                       released.  Double clicking within the number of mil-
                       liseconds given by ConstrainedMoveTime warps the
                       pointer to the center of the window and constrains
                       the move to be either horizontal or vertical depend-
                       ing on which grid line is crossed.  To abort a move,
                       press another button before releasing the first but-
                       ton.

               f.nexticonmgr
                       This function warps the pointer to the next icon
                       manager containing any windows on the current or any
                       succeeding screen.

               f.nop   This function does nothing and is typically used
                       with the DefaultFunction or WindowFunction variables
                       or to introduce blank lines in menus.

               f.previconmgr
                       This function warps the pointer to the previous icon
                       manager containing any windows on the current or
                       preceding screens.

               f.quit  This function causes twm to restore the window's
                       borders and exit.  If twm is the first client
                       invoked from xdm, this will result in a server
                       reset.


          Rev. Release 4                                            Page 23






          TWM(1)                         AIX                         TWM(1)



               f.raise This function raises the selected window.

               f.raiselower
                       This function raises the selected window to the top
                       of the stacking order if it is occluded by any win-
                       dows, otherwise the window will be lowered.

               f.refresh
                       This function causes all windows to be refreshed.

               f.resize
                       This function displays an outline of the selected
                       window.  Crossing a border (or setting AutoRela-
                       tiveResize) will cause the outline to begin to
                       rubber band until the invoking button is released.
                       To abort a resize, press another button before
                       releasing the first button.

               f.restart
                       This function kills and restarts twm.

               f.righticonmgr
                       This function is similar to f.nexticonmgr except
                       that wrapping does not change rows.

               f.rightzoom
                       This variable is similar to the f.bottomzoom func-
                       tion except that the selected window is only resized
                       to the right half of the display.

               f.saveyourself
                       This function sends a WM_SAVEYOURSELF message to the
                       selected window if it has requested the message in
                       its WM_PROTOCOLS window property.  Clients that
                       accept this message are supposed to checkpoint all
                       state associated with the window and update the
                       WM_COMMAND property as specified in the ICCCM.  If
                       the selected window has not selected for this mes-
                       sage, the keyboard bell will be rung.

               f.showiconmgr
                       This function maps the current icon manager.

               f.sorticonmgr
                       This function sorts the entries in the current icon
                       manager alphabetically.  See the variable SortIcon-
                       Manager.

               f.title This function provides a centered, unselectable item
                       in a menu definition.  It should not be used in any
                       other context.

               f.topzoom


          Rev. Release 4                                            Page 24






          TWM(1)                         AIX                         TWM(1)



                       This variable is similar to the f.bottomzoom func-
                       tion except that the selected window is only resized
                       to the top half of the display.

               f.unfocus
                       This function resets the focus back to pointer-
                       driven.  This should be used when a focused window
                       is no longer desired.

               f.upiconmgr
                       This function warps the pointer to the previous row
                       in the current icon manager, wrapping to the last
                       row in the same column if necessary.

               f.vlzoom
                       This function is a synonym for f.leftzoom.

               f.vrzoom
                       This function is a synonym for f.rightzoom.

               f.warpring string
                       This function warps the pointer to the next or pre-
                       vious window (as indicated by the argument string,
                       which may be "next" or "prev") specified in the Win-
                       dowRing variable.

               f.warpto string
                       This function warps the pointer to the window which
                       has a name or class that matches string.  If the
                       window is iconified, it will be deiconified if the
                       variable WarpUnmapped is set or else ignored.

               f.warptoiconmgr string
                       This function warps the pointer to the icon manager
                       entry associated with the window containing the
                       pointer in the icon manager specified by the argu-
                       ment string.  If string is empty (i.e. ""), the
                       current icon manager is chosen.

               f.warptoscreen string
                       This function warps the pointer to the screen speci-
                       fied by the argument string.  String may be a number
                       (e.g. "0" or "1"), the word "next" (indicating the
                       current screen plus 1, skipping over any unmanaged
                       screens), the word "back" (indicating the current
                       screen minus 1, skipping over any unmanaged
                       screens), or the word "prev" (indicating the last
                       screen visited.

               f.winrefresh
                       This function is similar to the f.refresh function
                       except that only the selected window is refreshed.



          Rev. Release 4                                            Page 25






          TWM(1)                         AIX                         TWM(1)



               f.zoom  This function is similar to the f.fullzoom function,
                       except that the only the height of the selected win-
                       dow is changed.

          MENUS
               Functions may be grouped and interactively selected using
               pop-up (when bound to a pointer button) or pull-down (when
               associated with a titlebutton) menus.  Each menu specifica-
               tion contains the name of the menu as it will be referred to
               by f.menu, optional default foreground and background
               colors, the list of item names and the functions they should
               invoke, and optional foreground and background colors for
               individual items:

                    Menu "menuname" [ ("deffore":"defback") ]
                    {
                         string1   [ ("fore1":"backn")]     function1
                         string2   [ ("fore2":"backn")]     function2
                              .
                              .
                              .
                         stringN   [ ("foreN":"backN")]     functionN
                    }


               The menuname is case-sensitive.  The optional deffore and
               defback arguments specify the foreground and background
               colors used on a color display to highlight menu entries.
               The string portion of each menu entry will be the text which
               will appear in the menu.  The optional fore and back argu-
               ments specify the foreground and background colors of the
               menu entry when the pointer is not in the entry.  These
               colors will only be used on a color display.  The default is
               to use the colors specified by the MenuForeground and Menu-
               Background variables.  The function portion of the menu
               entry is one of the functions, including any user-defined
               functions, or additional menus.

               There is a special menu named TwmWindows which contains the
               names of all of the client and twm-supplied windows.
               Selecting an entry will cause the WindowFunction to be exe-
               cuted on that window.  If WindowFunction hasn't been set,
               the window will be deiconified and raised.

          ICONS
               Twm supports several different ways of manipulating iconi-
               fied windows.  The common pixmap-and-text style may be laid
               out by hand or automatically arranged as described by the
               IconRegion variable.  In addition, a terse grid of icon
               names, called an icon manager, provides a more efficient use
               of screen space as well as the ability to navigate among
               windows from the keyboard.



          Rev. Release 4                                            Page 26






          TWM(1)                         AIX                         TWM(1)



               An icon manager is a window that contains names of selected
               or all windows currently on the display.  In addition to the
               window name, a small button using the default iconify symbol
               will be displayed to the left of the name when the window is
               iconified.  By default, clicking on an entry in the icon
               manager performs f.iconify.  To change the actions taken in
               the icon manager, use the the iconmgr context when specify-
               ing button and keyboard bindings.

               Moving the pointer into the icon manager also directs key-
               board focus to the indicated window (setting the focus
               explicitly or else sending synthetic events NoTitleFocus is
               set).  Using the f.upiconmgr, f.downiconmgr f.lefticonmgr,
               and f.righticonmgr functions, the input focus can be changed
               between windows directly from the keyboard.

          BUGS
               The resource manager should have been used instead of all of
               the window lists.

               The IconRegion variable should take a list.

               Double clicking very fast to get the constrained move func-
               tion will sometimes cause the window to move, even though
               the pointer is not moved.

               If IconifyByUnmapping is on and windows are listed in Icon-
               ManagerDontShow but not in DontIconifyByUnmapping, they may
               be lost if they are iconified and no bindings to f.menu
               "TwmWindows" or f.warpto are setup.

          FILES
                $HOME/.twmrc.<screen number>
                $HOME/.twmrc
                /usr/lib/X11/twm/system.twmrc

          ENVIRONMENT VARIABLES
               DISPLAY This variable is used to determine which X server to
                       use.  It is also set during f.exec so that programs
                       come up on the proper screen.

               HOME    This variable is used as the prefix for files that
                       begin with a tilde and for locating the twm startup
                       file.

          SEE ALSO
               X(1), Xserver(1), xdm(1), xrdb(1)

          COPYRIGHT
               Portions copyright 1988 Evans & Sutherland Computer Corpora-
               tion; portions copyright 1989 Hewlett-Packard Company and
               the Massachusetts Institute of Technology,  See X(1) for a
               full statement of rights and permissions.


          Rev. Release 4                                            Page 27






          TWM(1)                         AIX                         TWM(1)



          AUTHORS
               Tom LaStrange, Solbourne Computer; Jim Fulton, MIT X Consor-
               tium; Steve Pitschke, Stardent Computer; Keith Packard, MIT
               X Consortium; Dave Payne, Apple Computer.



















































          Rev. Release 4                                            Page 28



