.TH MONITOR 1 "15 September 1988" "X Version 11"                               
.SH NAME                                                                       
monitor - graphically displays system utilization information in an X window   
.SH SYNOPSIS                                                                   
.B "monitor"                                                                   
[-help] [host:display] [=geometry] [-bg color] [-fg color]                     
[-show (cpu | i/o | lio | pio | pag | pspace | rmtio)]
[-interval seconds] [-label string] [-ars] [-netdev string]                    
.SH DESCRIPTION                                                                
.PP                                                                            
.I Monitor                                                                     
is  a  utility  for  graphically displaying  resource utilization for a        
variety of RT system resources in an X window. Resource utilization for        
each interval is represented by a vertical bar, added at the left (orgin)      
of the utilization graph.  For some resources, components of the resource      
utilization are represented by grey and solid components of the bar.           
For most resources, the utilization is in terms of events per second           
(e.g., page faults / sec.).  Monitor windows rescale and iconify in the        
X tradition.  Monitor is terminated by pressing the MIDDLE button while        
in the window.  Monitor detaches itself from the calling computation           
and does not die when the shell which initiates it dies.  This allows one      
to initiate a monitor to display remotely and then logoff and means that       
one does not need to type "&" at the end of the command line.                  
.PP                                                                            
Monitor obtains its data by snooping about in /dev/mem and /dev/kmem.          
Therefore, the user must be authorized to open these pseudo devices.           
Usually being in the system group is sufficient.  The data used to construct   
the monitor displays is generated by the kernal and monitor cannot vouch       
for their accuracy nor precisely explain their meaning.  Monitor maintains     
data for 500 intervals and displays as much as will fit into the current       
window.                                                                        
.SH OPTIONS                                                                    
.PP                                                                            
.TP 8                                                                          
.B "-help"                                                                     
Print out the 'Usage:' command syntax summary.  Any unrecognized option        
also causes the 'Usage:' summary to be printed.                                
.PP                                                                            
.TP 8                                                                          
.B "host:display"                                                              
A monitor started on one machine can display on another machine.  One must     
execute the 'xhost' command on the target X server to enable remote display.   
.PP                                                                            
.TP 8                                                                          
.B "=geometry"                                                                 
Specifies the location and size of the monitor window using the standard       
X geometry syntax.  Geometry can be specified in the .Xdefaults file           
(e.g.,"monitor.Geometry:=200x80+100+200").                                     
.PP                                                                            
.TP 8                                                                          
.B "-show"                                                                     
Selects the resource class to be displayed.  The default resource is           
CPU utilization.  Show can be specified in the .Xdefaults file (e.g.,          
"monitor.Show:i/o").
.PP                                                                            
.TP 8                                                                          
.B "-show cpu"                                                                 
Shows percent CPU utilization for 1) wait time, 2) system time, and            
3) user time.                                                                  
.PP                                                                            
.TP 8                                                                          
.B "-show i/o"                                                                 
Shows logical and physical I/O per second.                                     
.PP                                                                            
.TP 8                                                                          
.B "-show lio"                                                                 
Shows logical reads and writes per second.                                     
.PP                                                                            
.TP 8                                                                          
.B "-show pio"                                                                 
Shows physical reads and writes per second.                                    
.PP                                                                            
.TP 8                                                                          
.B "-show pag"                                                                 
Shows page faults per second.                                                  
.PP                                                                            
.TP 8                                                                          
.B "-show pspace"                                                              
Shows free page slots.                                                         
.PP                                                                            
.TP 8                                                                          
.B "-show rmtio"                                                               
Shows remote reads and writes per second.                                      
.PP                                                                            
.TP 8                                                                          
.B "-netdev string"                                                            
If more than one network adaptor is installed, the -netdev option can be       
used to select which device is to be monitored.  Usually the network           
adaptors have names like "net0" or "token0".  It is not necessary to           
use this option if only one network adaptor is installed.                      
.PP                                                                            
.TP 8                                                                          
.B "-bg color"                                                                 
Selects the background color. Background color can be specified in the         
.Xdefaults file (e.g., "monitor.Background:green").                            
.PP                                                                            
.TP 8                                                                          
.B "-fg color"                                                                 
Selects the foreground color. Foreground color can be specified in the         
.Xdefaults file (e.g., "monitor.Foreground:red").                              
.PP                                                                            
.TP 8                                                                          
.B "-interval seconds"                                                         
Selects the update interval for the display. The default interval              
is 5 seconds. The interval can be specified in the .Xdefaults file             
(e.g., "monitor.Interval:10").                                                 
.PP                                                                            
.TP 8                                                                          
.B "-label string"                                                             
Sets the label displayed in the monitor window.  The label, as well as the     
fonts used to display the label and the vertical scale can be set in the       
.Xdefaults file (e.g., "monitor.Label:Jim_CPU", "monitor.LabelFont:Rom10.500"  
or "monitor.RangeFont:6x10").                                                  
.PP                                                                            
.TP 8                                                                          
.B "-ars"                                                                      
Specifies automatic rescaling of the vertical axis.  Normally, the vertical    
axis scale is adjusted to accomodate the maximal value of resource usage       
encountered since the monitor was STARTED.  The -ars option causes the         
vertical scale to be automatically adjusted downward to the maximal value      
currently IN THE WINDOW (but not below the minimum defined for the resource    
type).  When -ars is not selected, the vertical scale can be adjusted to       
the maximun in the window by using the left or right button.                   
.SH COPYRIGHT                                                                  
Copyright Bruce Lindsay 1988.                                                  
.SH AUTHOR                                                                     
Bruce Lindsay, IBM Almaden Research Center                                     
