...
... $Header: /tmp_mnt/home/kreskin/u0/barnett/Src/Ease/ease/doc/RCS/cfc.man,v 3.3 1991/09/09 16:36:05 barnett Exp $
... 
... $Log: cfc.man,v $
... Revision 3.3  1991/09/09  16:36:05  barnett
... minor bug fixes
...
... Revision 1.2  1990/04/04  15:42:51  jeff
... Reformatted somewhat for readability.  Added some bugs
... described by Bruce Barnett.
...
... Version 1.1  90/04/04  14:57:38  jeff
... Initial version
... 
... Revision 2.0  88/06/15  15:17:36  arnold
... Baseline release for net posting. ADR.
... 
... Revision 1.3  88/01/21  16:23:21  arnold
... Some typo fixes.
... 
... Revision 1.2  87/04/08  10:21:47  arnold
... Small bug fixes, compatibility option added, also warnings for
... unrecognized flags and options. ADR.
... 
... Revision 1.1  87/02/16  15:25:32  arnold
... Initial revision
... 
...
.TH CFC local
.SH NAME
cfc \- Sendmail cf file compiler
.SH SYNOPSIS
.B cfc
[
.B \-s
] [
.B \-i
] [
.B \-d
] [
.B \-c
] [
.B \-u
] [
.B \-C \fICLASSES\fP
] <
.I sendmail.cf-file
>
.I ease-source-file
.SH DESCRIPTION
.I Cfc
is a filter that reads a raw
.IR sendmail (8)
configuration file on its standard input, and produces almost useable
.IR ease (1)
source on its standard output.
.P
It is designed as a conversion tool, to translate an existing
.B sendmail.cf
file into
.I ease
with the idea that all future work will be done in
.IR ease .
.P
.I Cfc
passes all comments through to the output, and converts all predefined
.I sendmail
macros, options, option values, and mailer flags into the names used by
.IR ease .
.P
It is suggested you use
.I cfc
to convert a 
.I sendmail.cf
file into 
.I ease
format, and then convert the
.I ease
file back into
.I sendmail
format.
You may have to experiment with the right options and the right combinations
before
.I ease
will generate an output file with no errors.
Then use the
.I cfdiff
script to compare the original
.I sendmail.cf
file to the output of
.IR ease .
You should see some differences in formatting, as some 
.I sendmail
lines can be on one or two lines, and some options have more than one form.
Once it is determined that these are the only difference, you should feel
very comfortable using 
.I ease
as a high level langauge for 
.I sendmail 
files.
If you are unable to make the two files identical, you may need to modify the 
.I ease
input file so the output is correct.
If necessary, you can use the
.IR asm ()
function in
.I ease
to pass the characters, unchanged, to the output.
.P
.I Cfc
isn't perfect. 
You may wish to modify the 
.I ease
file for cosmetic reasons:
.IP
.I Cfc
introduces tabs on its own, as well as often passing through tabs
>from the
.I sendmail
input.
It will also print a header for each different type of line, e.g. if the
input had seven
.B O
(option) lines, there will be seven option blocks.
These are usually succesive, and can therefore be merged.
.IP
Move some comments.
The block close on rulesets often comes after the comments that
precede the next ruleset or mailer specification.

.RE
.P
In short,
.I cfc
does over 99% of the tedious work of translating a
.B sendmail.cf
into
.I ease
format.
Suprisingly, the combination of
.I cfc
and
.I ease
can find bugs in a current
.B sendmail.cf
file!
.P
.I Cfc
takes five options.
.RS
.TP
.B \-c
Indicates that
.I cfc
should run in 4.2BSD compatibility mode.
In this case, options and mailer flags which are new in the 4.3BSD
version of
.I sendmail
will not be recognized.
.TP
.B \-u
.I Cfc
will warn about the use of any undocumented options or mailer flags in
the 4.3BSD
.IR sendmail .
The correct
.I ease
output will still be produced.
.TP
.B \-s
.I Cfc
will assume the input file is for Sun's sendmail.
It will produce a ruleset definition for rule number 30, which Sun uses
in their standard configuration file, and older implementations
complain about. It also adds some declarations that match Sun's
additions to sendmail, so errors won't occur.
.TP
.B \-d
.I Cfc
will cause some definitions to be added that will convert the Ultrix
.i sendmail.cf
file with fewer errors.
.TP
.B \-i
.I Cfc
will add some declarations that the IDA version of 
.I sendmail
likes to see.
.TP
.B \-C
<LETTER><LETTER>...
.I Cfc
will add an additional header of the form
.I any_in_<LETTER>
and
.I any_not_in_<LETTER>
where
.I <LETTER>
is a single character that specifes a class used in the sendmail file,
but not defined.
This prevents 
.I ease
>from complaining about undefined classes.
.RE
.P
With the right compination of options and class definitions, it is
easy to convert a 
.I sendmail
file into 
.I ease ,
edit the file, and run 
.I ease
on the file, and install the output.
.\" .SH FILES
.SH SEE ALSO
.I "Sendmail Installation and Operation Guide"
by Eric Allman
(SMM:7 in the 4.3 BSD UNIX System Manager's Manual),
.I "Ease: A Configuration Language for Sendmail"
by James S. Schoner, amended by Jeff P. Stearns, Arnold D. Robbins, and Bruce G. Barnett.
.IR sendmail (8),
.IR ease (1).
.SH DIAGNOSTICS
``\c
.IR Routine :
malformed input line
.IR line :
fatal error''
for input it doesn't understand.
.I Routine
is the name of the routine in
.I cfc
which choked, and
.I line
is the line number in the input.
.SH BUGS
Only recognizes continuation lines (lines that begin with a \s-1TAB\s+1)
for header (H) and mailer (M) definitions.
.P
Should read from files on the command line, instead of being a pure filter.
.P
Should be a two pass program, and learn the classes which need
defining automatically. The
.B \-C
option is really a kludge.
.PP
In some cases, you can use the
\fIasm(".......")\fP
command to work around problems.
.SH AUTHOR
.nf
Arnold Robbins
Emory University Computing Center
arnold@emory.edu

Modifications by Bruce G. Barnett
General Electric, Corporate Research and Development
barnett@crdgw1.ge.com

.fi
