.ds RP Release 4.0 Patchlevel 19
.rn '' }`
''' $Header: a2p.man,v 4.0 91/03/20 01:57:11 lwall Locked $
''' 
''' $Log:	a2p.man,v $
''' Revision 4.0  91/03/20  01:57:11  lwall
''' 4.0 baseline.
''' 
''' Revision 3.0  89/10/18  15:34:22  lwall
''' 3.0 baseline
''' 
''' Revision 2.0.1.1  88/07/11  23:16:25  root
''' patch2: changes related to 1985 awk
''' 
''' Revision 2.0  88/06/05  00:15:36  root
''' Baseline version 2.0.
''' 
''' 
.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
'br\}
.TH A2P 1 LOCAL
.SH NAME
a2p - Awk to Perl translator
.SH SYNOPSIS
.B a2p [options] filename
.SH DESCRIPTION
.I A2p
takes an awk script specified on the command line (or from standard input)
and produces a comparable
.I perl
script on the standard output.
.Sh "Options"
Options include:
.TP 5
.B \-D<number>
sets debugging flags.
.TP 5
.B \-F<character>
tells a2p that this awk script is always invoked with this -F switch.
.TP 5
.B \-n<fieldlist>
specifies the names of the input fields if input does not have to be split into
an array.
If you were translating an awk script that processes the password file, you
might say:
.sp
	a2p -7 -nlogin.password.uid.gid.gcos.shell.home
.sp
Any delimiter can be used to separate the field names.
.TP 5
.B \-<number>
causes a2p to assume that input will always have that many fields.
.Sh "Considerations"
A2p cannot do as good a job translating as a human would, but it usually
does pretty well.
There are some areas where you may want to examine the perl script produced
and tweak it some.
Here are some of them, in no particular order.
.PP
There is an awk idiom of putting int() around a string expression to force
numeric interpretation, even though the argument is always integer anyway.
This is generally unneeded in perl, but a2p can't tell if the argument
is always going to be integer, so it leaves it in.
You may wish to remove it.
.PP
Perl differentiates numeric comparison from string comparison.
Awk has one operator for both that decides at run time which comparison
to do.
A2p does not try to do a complete job of awk emulation at this point.
Instead it guesses which one you want.
It's almost always right, but it can be spoofed.
All such guesses are marked with the comment \*(L"#???\*(R".
You should go through and check them.
You might want to run at least once with the \-w switch to perl, which
will warn you if you use == where you should have used eq.
.PP
Perl does not attempt to emulate the behavior of awk in which nonexistent
array elements spring into existence simply by being referenced.
If somehow you are relying on this mechanism to create null entries for
a subsequent for...in, they won't be there in perl.
.PP
If a2p makes a split line that assigns to a list of variables that looks
like (Fld1, Fld2, Fld3...) you may want
to rerun a2p using the \-n option mentioned above.
This will let you name the fields throughout the script.
If it splits to an array instead, the script is probably referring to the number
of fields somewhere.
.PP
The exit statement in awk doesn't necessarily exit; it goes to the END
block if there is one.
Awk scripts that do contortions within the END block to bypass the block under
such circumstances can be simplified by removing the conditional
in the END block and just exiting directly from the perl script.
.PP
Perl has two kinds of array, numerically-indexed and associative.
Awk arrays are usually translated to associative arrays, but if you happen
to know that the index is always going to be numeric you could change
the {...} to [...].
Iteration over an associative array is done using the keys() function, but
iteration over a numeric array is NOT.
You might need to modify any loop that is iterating over the array in question.
.PP
Awk starts by assuming OFMT has the value %.6g.
Perl starts by assuming its equivalent, $#, to have the value %.20g.
You'll want to set $# explicitly if you use the default value of OFMT.
.PP
Near the top of the line loop will be the split operation that is implicit in
the awk script.
There are times when you can move this down past some conditionals that
test the entire record so that the split is not done as often.
.PP
For aesthetic reasons you may wish to change the array base $[ from 1 back
to perl's default of 0, but remember to change all array subscripts AND
all substr() and index() operations to match.
.PP
Cute comments that say "# Here is a workaround because awk is dumb" are passed
through unmodified.
.PP
Awk scripts are often embedded in a shell script that pipes stuff into and
out of awk.
Often the shell script wrapper can be incorporated into the perl script, since
perl can start up pipes into and out of itself, and can do other things that
awk can't do by itself.
.PP
Scripts that refer to the special variables RSTART and RLENGTH can often
be simplified by referring to the variables $`, $& and $', as long as they
are within the scope of the pattern match that sets them.
.PP
The produced perl script may have subroutines defined to deal with awk's
semantics regarding getline and print.
Since a2p usually picks correctness over efficiency.
it is almost always possible to rewrite such code to be more efficient by
discarding the semantic sugar.
.PP
For efficiency, you may wish to remove the keyword from any return statement
that is the last statement executed in a subroutine.
A2p catches the most common case, but doesn't analyze embedded blocks for
subtler cases.
.PP
ARGV[0] translates to $ARGV0, but ARGV[n] translates to $ARGV[$n].
A loop that tries to iterate over ARGV[0] won't find it.
.SH ENVIRONMENT
A2p uses no environment variables.
.SH AUTHOR
Larry Wall <lwall@jpl-devvax.Jpl.Nasa.Gov>
.SH FILES
.SH SEE ALSO
perl	The perl compiler/interpreter
.br
s2p	sed to perl translator
.SH DIAGNOSTICS
.SH BUGS
It would be possible to emulate awk's behavior in selecting string versus
numeric operations at run time by inspection of the operands, but it would
be gross and inefficient.
Besides, a2p almost always guesses right.
.PP
Storage for the awk syntax tree is currently static, and can run out.
.rn }` ''
