


          XSERVER(1)                     AIX                     XSERVER(1)



          NAME
               X - X Window System server

          SYNOPSIS
               X [:displaynumber] [-option ...] [ttyname]

          DESCRIPTION
               X is the generic name for the X Window System server.  It is
               frequently a link or a copy of the appropriate server binary
               for driving the most frequently used server on a given
               machine.  The sample server from MIT supports the following
               platforms:

                   Xqvss       Digital monochrome vaxstationII or II
                   Xqdss       Digital color vaxstationII or II
                   Xsun        Sun monochrome or color Sun 2, 3, or 4
                   Xibm        IBM AED, APA and megapel PC/RT, 8514 and VGA PS/2 model 80
                   Xapollo     Apollo monochrome or color (Domain/OS SR10.1 or SR10.2)
                   Xhp         HP Topcat 9000s300
                   XmacII      Apple monochrome Macintosh II
                   Xcfbpmax    Digital color DECstation 3100
                   Xmfbpmax    Digital monochrome DECstation 3100
                   Xtek        Tektronix 4319 (this is the only tested configuration)

          STARTING THE SERVER
               The server is usually started from the X Display Manager
               program xdm.  This utility is run from the system boot files
               and takes care of keeping the server running, prompting for
               usernames and passwords, and starting up the user sessions.
               It is easily configured for sites that wish to provide nice,
               consistent interfaces for novice users (loading convenient
               sets of resources, starting up a window manager, clock, and
               nice selection of terminal emulator windows).

               Since xdm now handles automatic starting of the server in a
               portable way, the -L option to xterm is now considered
               obsolete.  Support for starting a login window from 4.3bsd-
               derived /etc/ttys files is no longer included.

               Installations that run more than one window system will
               still need to use the xinit utility.  However, xinit is to
               be considered a tool for building startup scripts and is not
               intended for use by end users.  Site administrators are
               strongly urged to build nicer interfaces for novice users.

               When the sample server starts up, it takes over the display.
               If you are running on a workstation whose console is the
               display, you cannot log into the console while the server is
               running.

          NETWORK CONNECTIONS
               The sample server supports connections made using the fol-
               lowing reliable byte-streams:


          Rev. Release 4                                             Page 1






          XSERVER(1)                     AIX                     XSERVER(1)



               TCP/IP
                   The server listens on port htons(6000+n), where n is the
                   display number.

               Unix Domain
                   The sample server uses /tmp/.X11-unix/Xn as the filename
                   for the socket, where n is the display number.

               DECnet
                   The server responds to connections to object X$Xn, where
                   n is the display number.  This is not supported in all
                   environments.

          OPTIONS
               All of the sample servers accept the following command line
               options:

               -a number
                       sets pointer acceleration (i.e. the ratio of how
                       much is reported to how much the user actually moved
                       the pointer).

               -auth authorization-file
                       Specifies a file which contains a collection of
                       authorization records used to authenticate access.

               bc      disables certain kinds of error checking, for bug
                       compatibility with previous releases (e.g., to work
                       around bugs in R2 and R3 xterms and toolkits).
                       Deprecated.

               -bs     disables backing store support on all screens.

               -c      turns off key-click.

               c volume
                       sets key-click volume (allowable range: 0-100).

               -cc class
                       sets the visual class for the root window of color
                       screens.  The class numbers are as specified in the
                       X protocol.  Not obeyed by all servers.

               -co filename
                       sets name of RGB color database.

               -dpi resolution
                       sets the resolution of the screen, in dots per inch.
                       To be used when the server cannot determine the
                       screen size from the hardware.

               -f volume
                       sets feep (bell) volume (allowable range: 0-100).


          Rev. Release 4                                             Page 2






          XSERVER(1)                     AIX                     XSERVER(1)



               -fc cursorFont
                       sets default cursor font.

               -fn font
                       sets the default font.

               -fp fontPath
                       sets the search path for fonts.  This path is a
                       comma separated list of directories which the sample
                       server searches for font databases.

               -help   prints a usage message.

               -I      causes all remaining command line arguments to be
                       ignored.

               -ld kilobytes
                       sets the data space limit of the server to the
                       specified number of kilobytes.  The default value is
                       zero, making the data size as large as possible.  A
                       value of -1 leaves the data space limit unchanged.
                       This option is not available in all operating sys-
                       tems.

               -ls kilobytes
                       sets the stack space limit of the server to the
                       specified number of kilobytes.  The default value is
                       zero, making the stack size as large as possible.  A
                       value of -1 leaves the stack space limit unchanged.
                       This option is not available in all operating sys-
                       tems.

               -logo   turns on the X Window System logo display in the
                       screen-saver.  There is currently no way to change
                       this from a client.

               nologo  turns off the X Window System logo display in the
                       screen-saver.  There is currently no way to change
                       this from a client.

               -p minutes
                       sets screen-saver pattern cycle time in minutes.

               -r      turns off auto-repeat.

               r       turns on auto-repeat.

               -s minutes
                       sets screen-saver timeout time in minutes.

               -su     disables save under support on all screens.

               -t number


          Rev. Release 4                                             Page 3






          XSERVER(1)                     AIX                     XSERVER(1)



                       sets pointer acceleration threshold in pixels (i.e.
                       after how many pixels pointer acceleration should
                       take effect).

               -to seconds
                       sets default connection timeout in seconds.

               ttyxx   ignored, for servers started the ancient way (from
                       init).

               v       sets video-on screen-saver preference.

               -v      sets video-off screen-saver preference.

               -wm     forces the default backing-store of all windows to
                       be WhenMapped; a cheap trick way of getting
                       backing-store to apply to all windows.

               -x extension
                       loads the specified extension at init.  Not sup-
                       ported in most implementations.

               You can also have the X server connect to xdm using XDMCP.
               Although this is not typically useful as it doesn't allow
               xdm to manage the server process, it can be used to debug
               XDMCP implementations, and servers as a sample implementa-
               tion of the server side of XDMCP.  For more information on
               this protocol, see the XDMCP specification in
               docs/XDMCP/xdmcp.ms.  The following options control the
               behavior of XDMCP.

               -query host-name
                       Enable XDMCP and send Query packets to the specified
                       host.

               -broadcast
                       Enable XDMCP and broadcast BroadcastQuery packets to
                       the network.  The first responding display manager
                       will be chosen for the session.

               -indirect host-name
                       Enable XDMCP and send IndirectQuery packets to the
                       specified host.

               -port port-num
                       Use an alternate port number for XDMCP packets.
                       Must be specified before any -query, -broadcast or
                       -indirect options.

               -once   Normally, the server keeps starting sessions, one
                       after the other.  This option makes the server exit
                       after the first session is over.



          Rev. Release 4                                             Page 4






          XSERVER(1)                     AIX                     XSERVER(1)



               -class display-class
                       XDMCP has an additional display qualifier used in
                       resource lookup for display-specific options.  This
                       option sets that value, by default it is "MIT-
                       Unspecified" (not a very useful value).

               -cookie xdm-auth-bits
                       When testing XDM-AUTHENTICATION-1, a private key is
                       shared between the server and the manager.  This
                       option sets the value of that private data (not that
                       it's very private, being on the command line and
                       all...).

               -displayID display-id
                       Yet another XDMCP specific value, this one allows
                       the display manager to identify each display so that
                       it can locate the shared key.

               Many servers also have device-specific command line options.
               See the manual pages for the individual servers for more
               details.

          SECURITY
               The sample server implements a simplistic authorization pro-
               tocol, MIT-MAGIC-COOKIE-1 which uses data private to author-
               ized clients and the server.  This is a rather trivial
               scheme; if the client passes authorization data which is the
               same as the server has, it is allowed access.  This scheme
               is worse than the host-based access control mechanisms in
               environments with unsecure networks as it allows any host to
               connect, given that it has discovered the private key.  But
               in many environments, this level of security is better than
               the host-based scheme as it allows access control per-user
               instead of per-host.

               In addition, the server provides support for a DES-based
               authorization scheme, XDM-AUTHORIZATION-1, which is more
               secure (given a secure key distribution mechanism), but as
               DES is not generally distributable, the implementation is
               missing routines to encrypt and decrypt the authorization
               data.  This authorization scheme can be used in conjunction
               with XDMCP's authentication scheme, XDM-AUTHENTICATION-1 or
               in isolation.

               The authorization data is passed to the server in a private
               file named with the -auth command line option.  Each time
               the server is about to accept the first connection after a
               reset (or when the server is starting), it reads this file.
               If this file contains any authorization records, the local
               host is not automatically allowed access to the server, and
               only clients which send one of the authorization records
               contained in the file in the connection setup information
               will be allowed access.  See the Xau manual page for a


          Rev. Release 4                                             Page 5






          XSERVER(1)                     AIX                     XSERVER(1)



               description of the binary format of this file.  Maintenance
               of this file, and distribution of its contents to remote
               sites for use there is left as an exercise for the reader.

               The sample server also uses a host-based access control list
               for deciding whether or not to accept connections from
               clients on a particular machine.  This list initially con-
               sists of the host on which the server is running as well as
               any machines listed in the file /etc/Xn.hosts, where n is
               the display number of the server.  Each line of the file
               should contain either an Internet hostname (e.g.
               expo.lcs.mit.edu) or a DECnet hostname in double colon for-
               mat (e.g. hydra::).  There should be no leading or trailing
               spaces on any lines.  For example:

                       joesworkstation
                       corporate.company.com
                       star::
                       bigcpu::

               Users can add or remove hosts from this list and enable or
               disable access control using the xhost command from the same
               machine as the server.  For example:

                       %  xhost +janesworkstation
                       janesworkstation being added to access control list
                       %  xhost -star::
                       public:: being removed from access control list
                       %  xhost +
                       all hosts being allowed (access control disabled)
                       %  xhost -
                       all hosts being restricted (access control enabled)
                       %  xhost
                       access control enabled (only the following hosts are allowed)
                       joesworkstation
                       janesworkstation
                       corporate.company.com
                       bigcpu::

               Unlike some window systems, X does not have any notion of
               window operation permissions or place any restrictions on
               what a client can do; if a program can connect to a display,
               it has full run of the screen.  Sites that have better
               authentication and authorization systems (such as Kerberos)
               might wish to make use of the hooks in the libraries and the
               server to provide additional security models.

          SIGNALS
               The sample server attaches special meaning to the following
               signals:

               SIGHUP  This signal causes the server to close all existing
                       connections, free all resources, and restore all


          Rev. Release 4                                             Page 6






          XSERVER(1)                     AIX                     XSERVER(1)



                       defaults.  It is sent by the display manager when-
                       ever the main user's main application (usually an
                       xterm or window manager) exits to force the server
                       to clean up and prepare for the next user.

               SIGTERM This signal causes the server to exit cleanly.

               SIGUSR1 This signal is used quite differently from either of
                       the above.  When the server starts, it checks to see
                       if it has inherited SIGUSR1 as SIG_IGN instead of
                       the usual SIG_DFL.  In this case, the server sends a
                       SIGUSR1 to it's parent process after it has set up
                       the various connection schemes.  Xdm uses this
                       feature to recognize when connecting to the server
                       is possible.

          FONTS
               Fonts are usually stored as individual files in directories.
               The list of directories in which the server looks when try-
               ing to open a font is controlled by the font path.  Although
               most sites will choose to have the server start up with the
               appropriate font path (using the -fp option mentioned
               above), it can be overridden using the xset program.

               The default font path for the sample server contains three
               directories:

               /usr/lib/X11/fonts/misc
                       This directory contains several miscellaneous fonts
                       that are useful on all systems.  It contains a very
                       small family of fixed-width fonts (6x10, 6x12, 6x13,
                       8x13, 8x13bold, and 9x15) and the cursor font.  It
                       also has font name aliases for the commonly used
                       fonts fixed and variable.

               /usr/lib/X11/fonts/75dpi
                       This directory contains fonts contributed by Adobe
                       Systems, Inc. and Digital Equipment Corporation and
                       by Bitstream, Inc.  for 75 dots per inch displays.
                       An integrated selection of sizes, styles, and
                       weights are provided for each family.

               /usr/lib/X11/fonts/100dpi
                       This directory contains versions of the fonts in the
                       75dpi directory for 100 dots per inch displays.

               Font databases are created by running the mkfontdir program
               in the directory containing the compiled versions of the
               fonts (the .snf files).  Whenever fonts are added to a
               directory, mkfontdir should be rerun so that the server can
               find the new fonts.  If mkfontdir is not run, the server
               will not be able to find any fonts in the directory.



          Rev. Release 4                                             Page 7






          XSERVER(1)                     AIX                     XSERVER(1)



          DIAGNOSTICS
               Too numerous to list them all.  If run from init(8), errors
               are logged in the file /usr/adm/X*msgs,

          FILES
               /etc/X*.hosts                 Initial access control list

          /usr/lib/X11/fonts/100dpi
               /usr/lib/X11/fonts/misc, /usr/lib/X11/fonts/75dpi,
                                             Font directories

               /usr/lib/X11/rgb.txt          Color database

               /tmp/.X11-unix/X*             Unix domain socket

               /usr/adm/X*msgs               Error log file

          SEE ALSO
               X(1), xdm(1), mkfontdir(1), xinit(1), xterm(1), twm(1),
               xhost(1), xset(1), xsetroot(1), ttys(5), init(8), Xqdss(1),
               Xqvss(1), Xsun(1), Xapollo(1), XmacII(1) X Window System
               Protocol, Definition of the Porting Layer for the X v11 Sam-
               ple Server, Strategies for Porting the X v11 Sample Server,
               Godzilla's Guide to Porting the X V11 Sample Server

          BUGS
               The option syntax is inconsistent with itself and xset(1).

               The acceleration option should take a numerator and a denom-
               inator like the protocol.

               If X dies before its clients, new clients won't be able to
               connect until all existing connections have their TCP
               TIME_WAIT timers expire.

               The color database is missing a large number of colors.
               However, there doesn't seem to be a better one available
               that can generate RGB values tailorable to particular
               displays.

          COPYRIGHT
               Copyright 1984, 1985, 1986, 1987, 1988, 1989, Massachusetts
               Institute of Technology.
               See X(1) for a full statement of rights and permissions.

          AUTHORS
               The sample server was originally written by Susan Ange-
               branndt, Raymond Drewry, Philip Karlton, and Todd Newman,
               from Digital Equipment Corporation, with support from a
               large cast.  It has since been extensively rewritten by
               Keith Packard and Bob Scheifler, from MIT.




          Rev. Release 4                                             Page 8



