


          XAUTH(1)                       AIX                       XAUTH(1)



          NAME
               XauFileName, XauReadAuth, XauLockAuth, XauUnlockAuth,
               XauWriteAuth, XauGetAuthByAddr - X authority database rou-
               tines

          SYNOPSIS
               #include <X11/Xauth.h>

               typedef struct xauth {
                    unsigned short family;
                    unsigned short address_length;
                    char           *address;
                    unsigned short number_length;
                    char           *number;
                    unsigned short name_length;
                    char           *name;
                    unsigned short data_length;
                    char           *data;
               } Xauth;

               char *XauFileName ()

               Xauth *XauReadAuth (auth_file)
                    FILE *auth_file;

               int XauWriteAuth (auth_file, auth)
                    FILE *auth_file;
                    Xauth *auth;

               Xauth *XauGetAuthByAddr (family,
                                        address_length, address,
                                        number_length, number)
                    unsigned short family;
                    unsigned short address_length;
                    char *address;
                    unsigned short number_length;
                    char *number;

               int XauLockAuth (file_name, retries, timeout, dead)
                    char *file_name;
                    int retries;
                    int timeout;
                    long dead;

               int XauUnlockAuth (file_name)
                    char *file_name;

               XauDisposeAuth (auth)
                    Xauth *auth;


          DESCRIPTION
               XauFileName generates the default authorization file name by


          Rev. Release 4                                             Page 1






          XAUTH(1)                       AIX                       XAUTH(1)



               first checking the XAUTHROTIY environment variable if set,
               else it returns $HOME/.Xauthority.  This name is statically
               allocated and should not be freed.

               XauReadAuth reads the next entry from auth_file.  The entry
               is not statically allocated and should be freed by calling
               XauDisposeAuth.

               XuWriteAuth writes an authorization entry to auth_file.  It
               returns 1 on success, 0 on failure.

               XauGetAuthByAddr searches for an entry which matches the
               given network address/display number pair.  The entry is not
               statically allocated and should be freed by calling Xau-
               DisposeAuth

               XauLockAuth does the work necessary to synchronously update
               an authorization file.  First it makes to file names, one
               with ``-c'' appended to file_name, the other with ``-l''
               appended.  If the ``-c'' file already exists and is more
               than dead seconds old, XauLockAuth removes it and the asso-
               ciated ``-l'' file.  To prevent possible synchronization
               troubles with NFS, a dead value of zero forces the files to
               be removed.  XauLockAuth makes retries attempts to create
               and link the file names, pausing timeout seconds between
               each attempt.  XauLockAuth returns a collection of values
               depending on the results:

                    LOCK_ERROR     A system error occurred, either a file_name
                                   which is too long, or an unexpected failure from
                                   a system call.  errno may prove useful.

                    LOCK_TIMEOUT   retries attempts failed

                    LOCK_SUCCESS   The lock succeeded.


               XauUnlockAuth undoes the work of XauLockAuth by unlinking
               both the ``-c'' and ``-l'' file names.

               XauDisposeAuth frees storage allocated to hold an authoriza-
               tion entry.

          SEE ALSO
               xauth(1), xdm(1)

          COPYRIGHT
               Copyright 1988, Massachusetts Institute of Technology.
               See X(1) for a full statement of rights and permissions.

          AUTHOR
               Keith Packard, MIT X Consortium



          Rev. Release 4                                             Page 2



